<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <title>Patient</title>
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>

    <?php require_once(APPPATH . "views/admin/header.php"); ?>

</head>

<body class="<?= $this->config->item('theme'); ?> fixed">
    <!-- Site wrapper -->

    <!-- Header Navbar: style can be found in header.less -->
    <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

    <!-- =============================================== -->

    <!-- Left side column. contains the sidebar -->
    <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

    <!-- =============================================== -->

    <!-- Right side column. Contains the navbar and content of the page -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1>Edit Ophthalmology</h1>
            <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
        </section>

        <!-- Main content -->
        <section class="content">

            <div class="row mb-2">
                <div class="col-md-12">
                    <div class="box margin-bottom-5px" style="border: none;">
                        <div class="box-body">
                            <div class="d-flex justify-content-start">
                                <a href="<?= base_url('index.php/admin/Patients/PatientsController/medical_book/') . encrypt_and_url_encode($patient_id, $this) ?>" class="btn btn-dark btn-sm"><i class="fa fa-chevron-circle-left" aria-hidden="true"></i> Go Back</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <?php print_header($this); ?>

            <div class="box  box-info">
                <div class="box-body">

                    <form role="form" action="<?= base_url('index.php/admin/Modules/Ophthalmology/OphthalmologyController/insert_opthalmology'); ?>" method="post" enctype="multipart/form-data">
                        <div class="row">
                            <div class="col-12">

                                <div class="row">
                                    <div class="col-md-2">
                                        <b>Date:</b>
                                        <input type="text" class="form-control app_date treatment_date" name="treatment_date" id="treatment_date" value="<?= $treatment->treat_date; ?>" required>
                                    </div>
                                    <div class="col-md-2">
                                        <b>Time:</b>
                                        <input type="time" class="form-control" name="treatment_time" id="treatment_time" value="<?= $treatment->treat_time; ?>" required>
                                    </div>
                                </div>

                                <?php $opt = empty($opthamolgy->data) ? [] : json_decode($opthamolgy->data); ?>

                                <div class="row pt-5">
                                    <div class="col-md-12">
                                        <table class="exam-eye w-100" width="100%" border="1" cellpadding="10" cellspacing="10" id="exam-eye">
                                            <tr>
                                                <th width="30%" class="middle"></th>
                                                <th width="30%" class="middle">RT</th>
                                                <th width="30%" class="middle">LT</th>
                                            </tr>
                                            <tr>
                                                <td class="middle-md"><strong>BCVA</strong></td>
                                                <td><input class="form-control" type="text" name="bcva_rt" value="<?= $opt->bcva_rt ?>"></td>
                                                <td><input class="form-control" type="text" name="bcva_lt" value="<?= $opt->bcva_lt ?>"></td>
                                            </tr>
                                            <tr>
                                                <td class="middle-md"><strong>IOP</strong></td>
                                                <td><input class="form-control" type="text" name="iop_rt" value="<?= isset($opt->iop_rt) ? $opt->iop_rt : '' ?>"></td>
                                                <td><input class="form-control" type="text" name="iop_lt" value="<?= isset($opt->iop_lt) ? $opt->iop_lt : '' ?>"></td>
                                            </tr>
                                            <tr>
                                                <td class="middle-md"><strong>Orbit/Ext. appear</strong>.</td>
                                                <td>
                                                    <input class="form-control" type="text" name="orbit_rt" value="<?= isset($opt->orbit_rt) ? $opt->orbit_rt : '' ?>">
                                                </td>
                                                <td>
                                                    <input class="form-control" type="text" name="orbit_lt" value="<?= isset($opt->orbit_lt) ? $opt->orbit_lt : '' ?>">
                                                </td>
                                            </tr>

                                            <tr>
                                                <td class="middle-md"><strong>Lids</strong></td>
                                                <td>
                                                    <input class="form-control" type="text" name="lids_rt" value="<?= isset($opt->lids_rt) ? $opt->lids_rt : '' ?>">
                                                </td>
                                                <td>
                                                    <input class="form-control" type="text" name="lids_lt" value="<?= isset($opt->lids_lt) ? $opt->lids_lt : '' ?>">
                                                </td>
                                            </tr>

                                            <tr>
                                                <td class="middle-md"><strong>Lacrimal</strong></td>
                                                <td>
                                                    <input class="form-control" type="text" name="lacrimal_rt" id="refraction_re" value="<?= isset($opt->lacrimal_rt) ? $opt->lacrimal_rt : '' ?>">
                                                </td>
                                                <td><input class="form-control" type="text" name="lacrimal_lt" id="refraction_re" value="<?= isset($opt->lacrimal_lt) ? $opt->lacrimal_lt : '' ?>">
                                                </td>
                                            </tr>

                                            <tr>
                                                <td class="middle-md"><strong>Conj</strong>.</td>
                                                <td><input type="text" name="conj_rt" id="conj_rt" class="form-control" value="<?= isset($opt->conj_rt) ? $opt->conj_rt : '' ?>">
                                                </td>
                                                <td>
                                                    <input type="text" name="conj_lt" id="conj_lt" class="form-control" value="<?= isset($opt->conj_lt) ? $opt->conj_lt : '' ?>">
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="middle-md"><strong>Cornea</strong></td>
                                                <td>
                                                    <input type="text" name="cornea_rt" id="cornea_rt" class="form-control" value="<?= isset($opt->cornea_rt) ? $opt->cornea_rt : '' ?>">
                                                </td>
                                                <td>
                                                    <input type="text" name="cornea_lt" id="cornea_lt" class="form-control" value="<?= isset($opt->cornea_lt) ? $opt->cornea_lt : '' ?>">
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="middle-md"><strong>AC</strong></td>
                                                <td>
                                                    <input type="text" name="ac_rt" id="ac_rt" class="form-control" value="<?= isset($opt->ac_rt) ? $opt->ac_rt : '' ?>">
                                                </td>
                                                <td>
                                                    <input type="text" name="ac_lt" id="ac_lt" class="form-control" value="<?= isset($opt->ac_lt) ? $opt->ac_lt : '' ?>">
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="middle-md"><strong>Pupil</strong></td>
                                                <td>
                                                    <input type="text" name="pupil_rt" id="pupil_rt" class="form-control" value="<?= isset($opt->pupil_rt) ? $opt->pupil_rt : '' ?>">
                                                </td>
                                                <td>
                                                    <input type="text" name="pupil_lt" id="pupil_lt" class="form-control" value="<?= isset($opt->pupil_lt) ? $opt->pupil_lt : '' ?>">
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="middle-md"><strong>Lens</strong></td>
                                                <td>
                                                    <input type="text" name="lens_rt" id="lens_rt" class="form-control" value="<?= isset($opt->lens_rt) ? $opt->lens_rt : '' ?>">
                                                </td>
                                                <td>
                                                    <input type="text" name="lens_lt" id="lens_lt" class="form-control" value="<?= isset($opt->lens_lt) ? $opt->lens_lt : '' ?>">
                                                </td>
                                            </tr>
                                            </tr>
                                            <td class="middle-md"><strong>Angle</strong></td>
                                            <td>
                                                <input type="text" name="angle_rt" id="angle_rt" class="form-control" value="<?= isset($opt->angle_rt) ? $opt->angle_rt : '' ?>">
                                            </td>
                                            <td>
                                                <input type="text" name="angle_lt" id="angle_lt" class="form-control" value="<?= isset($opt->angle_lt) ? $opt->angle_lt : '' ?>">
                                            </td>
                                            </tr>
                                            <tr>
                                                <td class="middle-md"><strong>Ocular motility</strong></td>
                                                <td>
                                                    <input type="text" name="ocular_rt" id="ocular_rt" class="form-control" value="<?= isset($opt->ocular_rt) ? $opt->ocular_rt : '' ?>">
                                                </td>
                                                <td>
                                                    <input type="text" name="ocular_lt" id="ocular_lt" class="form-control" value="<?= isset($opt->ocular_lt) ? $opt->ocular_lt : '' ?>">
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="middle-md"><strong>Muscle balance</strong></td>
                                                <td>
                                                    <input type="text" name="muscle_rt" id="muscle_rt" class="form-control" value="<?= isset($opt->muscle_rt) ? $opt->muscle_rt : '' ?>">
                                                </td>
                                                <td>
                                                    <input type="text" name="muscle_lt" id="muscle_lt" class="form-control" value="<?= isset($opt->muscle_lt) ? $opt->muscle_lt : '' ?>">
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="middle-md"><strong>Fundus</strong></td>
                                                <td>
                                                    <input type="text" name="fundus_rt" id="fundus_rt" class="form-control" value="<?= isset($opt->fundus_rt) ? $opt->fundus_rt : '' ?>">
                                                </td>
                                                <td>
                                                    <input type="text" name="fundus_lt" id="fundus_lt" class="form-control" value="<?= isset($opt->fundus_lt) ? $opt->fundus_lt : '' ?>">
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="middle-md"><strong>1ry diagnosis</strong></td>
                                                <td>
                                                    <input type="text" name="diagnosis_rt" id="diagnosis_rt" class="form-control" value="<?= isset($opt->diagnosis_rt) ? $opt->diagnosis_rt : '' ?>">
                                                </td>
                                                <td>
                                                    <input type="text" name="diagnosis_lt" id="diagnosis_lt" class="form-control" value="<?= isset($opt->diagnosis_lt) ? $opt->diagnosis_lt : '' ?>">
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="middle-md"><strong>Plan</strong></td>
                                                <td>
                                                    <input type="text" name="plan_rt" id="plan_rt" class="form-control" value="<?= isset($opt->plan_rt) ? $opt->plan_rt : '' ?>">
                                                </td>
                                                <td>
                                                    <input type="text" name="plan_lt" id="plan_lt" class="form-control" value="<?= isset($opt->plan_lt) ? $opt->plan_lt : '' ?>">
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label for="procedure">Select Procedure</label>
                                            <select class="ui-procedure" name="procedures_optho" id="procedures_optho">
                                                <?php if ($ophthalmology_procedures != FALSE) : ?>
                                                    <?php foreach ($ophthalmology_procedures as $value) : ?>
                                                        <option value="<?= $value->id . " | " . $value->treatment_name . " | " . $value->lqdc_gross; ?>"><?= $value->treatment_id . " | " . $value->treatment_name . " | " . $value->lqdc_gross; ?></option>
                                                    <?php endforeach; ?>
                                                <?php else : ?>
                                                    <option>Records Not Found</option>
                                                <?php endif; ?>
                                            </select>
                                            <!-- <select class="procedure" data-department="9"></select> -->
                                        </div>

                                        <button type="button" class="btn btn-sm btn-dark" id="addRow_optho"><i class="fa fa-plus-circle"></i> Add Procedure</button>
                                    </div>
                                </div>

                                <div class="row mt-2">
                                    <div class="col-md-12">
                                        <div class="panel panel-primary">
                                            <div class="panel-heading">
                                                <h4>Procedure List</h4>
                                            </div>
                                            <table class="table table-hover display table-striped" id="treatemnts_examination">
                                                <thead>
                                                    <tr>
                                                        <th>#</th>
                                                        <th>Procedure</th>
                                                        <th>Discount(QR)</th>
                                                        <th>Discount(%)</th>
                                                        <th>Fees</th>
                                                        <th class="text-center">Actions</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php foreach ($episodes as $ctr => $episode) : ?>
                                                        <tr class="odd">
                                                            <td>
                                                                <?= ++$ctr; ?>
                                                            </td>
                                                            <td>
                                                                <input type="hidden" name="gen_opth_name[]" value="<?= $episode['aditional_diagnostise_name']; ?>">
                                                                <input type="hidden" name="gen_opth_treatment_id[]" value="<?= $episode['procedure_id']; ?>">
                                                                <?= $episode['aditional_diagnostise_name']; ?>
                                                            </td>
                                                            <td>
                                                                <input type="hidden" name="orig_price_opth[]" value="<?= $episode['fees']; ?>">
                                                                <input class="form-control discount_opth" type="text" size="7" name="discount_opth[]" value="<?= $episode['discount_qr']; ?>">
                                                            </td>
                                                            <td>
                                                                <input class="form-control discount_per_opth" type="text" size="7" name="discount_per_opth[]" value="<?= $episode['discount_per']; ?>">
                                                            </td>
                                                            <td>
                                                                <input class="form-control fees_opth" type="text" name="fees_opth[]" size="7" value="<?= $episode['fees']; ?>">
                                                            </td>
                                                            <td class="text-center">
                                                                <button type="button" class="btn btn-light deleteRow_opth">
                                                                    <i class="fa fa-trash" aria-hidden="true"></i>
                                                                </button>
                                                            </td>
                                                        </tr>
                                                    <?php endforeach; ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>

                                <div class="row mt-2">
                                    <div class="col-md-12">
                                        <h4 class="text-center">Treatments</h4>
                                        <table class="table table-bordered exam-eye w-100" width="100%" cellpadding="10" cellspacing="10" id="treat">
                                            <thead>
                                                <th></th>
                                                <th></th>
                                                <th class="middle"><b>RT</b></th>
                                                <th class="middle"><b>LT</b></th>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td><strong>Medical:</strong></td>
                                                    <td><input type="text" name="medical" id="medical" class="form-control form-control-sm" value="<?= isset($opt->medical) ? $opt->medical : '' ?>"></td>
                                                    <td><input type="text" name="medical_rt" id="medical_rt" class="form-control form-control-sm" value="<?= isset($opt->medical_rt) ? $opt->medical_rt : '' ?>"></td>
                                                    <td><input type="text" name="medical_lt" id="medical_lt" class="form-control form-control-sm" value="<?= isset($opt->medical_lt) ? $opt->medical_lt : '' ?>"></td>
                                                </tr>
                                                <tr>
                                                    <td><strong>Surgical plan:</strong></td>
                                                    <td><input type="text" name="surgical" id="surgical" class="form-control form-control-sm" value="<?= isset($opt->surgical) ? $opt->surgical : '' ?>"></td>
                                                    <td><input type="text" name="surgical_rt" id="surgical_rt" class="form-control form-control-sm" value="<?= isset($opt->surgical_rt) ? $opt->surgical_rt : '' ?>"></td>
                                                    <td><input type="text" name="surgical_lt" id="surgical_lt" class="form-control form-control-sm" value="<?= isset($opt->surgical_lt) ? $opt->surgical_lt : '' ?>"></td>
                                                </tr>
                                                <tr>
                                                    <td><strong>Consultation referral:</strong></td>
                                                    <td><input type="text" name="consultaion" id="consultaion" class="form-control form-control-sm" value="<?= isset($opt->consultaion) ? $opt->consultaion : '' ?>"></td>
                                                    <td><input type="text" name="consultaion_rt" id="consultaion_rt" class="form-control form-control-sm" value="<?= isset($opt->consultaion_rt) ? $opt->consultaion_rt : '' ?>"></td>
                                                    <td><input type="text" name="consultaion_lt" id="consultaion_lt" class="form-control form-control-sm" value="<?= isset($opt->consultaion_lt) ? $opt->consultaion_lt : '' ?>"></td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-4">
                                        <label for="attachment">Add New Attachments</label>
                                        <div class="input-group hide-input">
                                            <span class="input-group-btn">
                                                <span class="btn btn-default btn-file">
                                                    <label for="attach_opthalmology" style="margin: 0px;">Browse</label>&hellip;<input type="file" multiple id="attach_opthalmology" name="attach_opthalmology[]">
                                                </span>
                                            </span>
                                            <input type="text" class="form-control" readonly>
                                        </div>
                                    </div>
                                </div>

                                <div class="row mt-2">
                                    <div class="col-md-12">
                                        <span id="attach" class="hide-text hidden-print">
                                            <?php if ($attachment != FALSE) : ?>
                                                <h4>Attachments</h4>
                                                <table class="table table-bordered">
                                                    <thead>
                                                        <th>#</th>
                                                        <th>Attachment</th>
                                                        <th class="text-center">Actions</th>
                                                    </thead>
                                                    <tbody>
                                                        <tr>
                                                            <?php foreach ($attachment as $index => $val_attach) : ?>
                                                                <td><?= ++$index; ?></td>
                                                                <td><?= $val_attach['document']; ?></td>
                                                                <td>
                                                                    <div class="d-flex flex-row justify-content-center">
                                                                        <a class="btn btn-sm btn-light mr-1" href="<?= base_url(''.UPLOAD_PATH.'opth/' . $val_attach['document']); ?>" id="single_1" title="View">
                                                                            <i class="fa fa-eye" aria-hidden="true"></i>

                                                                        </a>
                                                                        <a class="btn btn-sm btn-light mr-1" href="<?= base_url(''.UPLOAD_PATH.'opth/' . $val_attach['document']); ?>" download title="Download">
                                                                            <i class="fa fa-cloud-download" aria-hidden="true"></i>
                                                                        </a>
                                                                        <a class="btn btn-sm btn-light" href="javascript:void(0);" onclick="confirmDeleteGenral('<?= base_url('index.php/admin/Modules/Ophthalmology/OphthalmologyController/delete_optho_attachment/' . encrypt_and_url_encode($val_attach['id'], $this)) ?>');" title="Delete">
                                                                            <i class="fa fa-trash" aria-hidden="true"></i>
                                                                        </a>
                                                                    </div>
                                                                </td>
                                                            <?php endforeach; ?>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            <?php endif; ?>
                                        </span>
                                    </div>
                                </div>

                                <div class="row mt-2">
                                    <div class="col-md-12">
                                        <input type="hidden" name="treatement_payment_id" value="<?= $treatment_payment_id; ?>">
                                        <input type="hidden" name="patient_id" value="<?= encrypt_and_url_encode($patient_id, $this); ?>">

                                        <button type="submit" class="btn btn-sm btn-light" id="private_submit"><i class="fa fa-check-circle" aria-hidden="true"></i> Save</button>
                                        <button type="reset" class="btn btn-sm btn-light" id="clear"><i class="fa fa-times-circle" aria-hidden="true"></i> Clear</button>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </form>
                </div>
            </div>


        </section>
    </div>
    <?php require_once(APPPATH . "views/admin/footer.php"); ?>


</body>

</html>

<script>
    var procedures_optho = null;
    
    $(function() {
        var treatemnts_examination = $('#treatemnts_examination').DataTable({
            "bFilter": false,
            "paging": false,
            "info": false
        });

        $('#addRow_optho').on('click', function() {
            var split_treatment = $('#procedures_optho').val().split(' | ');
            console.log($('#procedures_optho').val());

            var treat_gen_surg = split_treatment[1] + '<input type="hidden" name="gen_opth_name[]" value="' + split_treatment[1] + '"><input type="hidden" name="gen_opth_treatment_id[]" value="' + split_treatment[0] + '">';

            treatemnts_examination.row.add([
                treatemnts_examination.rows().count() + 1,
                treat_gen_surg,
                '<input type="hidden" name="orig_price_opth[]" value="' + split_treatment[2] + '"><input class="form-control discount_opth" type="text" size="7" name="discount_opth[]" value="0">',
                '<input class="form-control discount_per_opth" type="text" size="7" name="discount_per_opth[]" value="0">',
                '<input class="form-control fees_opth" type="text" name="fees_opth[]" size="7" value="' + split_treatment[2] + '">',
                '<div class="text-center"><button type="button" class="btn btn-light deleteRow_opth"><i class="fa fa-trash" aria-hidden="true"></i></button></div>',
            ]).draw();
        });

        $('body').on("click", ".deleteRow_opth", function(e) {
            treatemnts_examination.row($(this).parents('tr')).remove().draw();
            return false;
        });

        $('body').on("click", ".deleteRow_gen_surg", function(e) {
            a.row($(this).parents('tr')).remove().draw();
            return false;
        });
        var limit_discount= Number("<?php echo get_discount_limt($this) ?>");

        $('body').on('keyup', '.discount_opth', function() {
            this_td = $(this).closest('td'),
                orig_price = $(this).prev('input').val(),
                dis_per_td = this_td.next('td');
            discount_per = $(dis_per_td).find('input').val(),
                fees_td = dis_per_td.next('td');
            fees = $(fees_td).find('input').val(),
                discount = Number($(this).val()).toFixed(2);

             var dis_per =Number((discount * 100 / orig_price).toFixed(2));
                if(limit_discount !=''){
                if(dis_per > limit_discount){
                    
                    showdialog('Authorization Error' ,'Discount percentage exceeds the allowed limit of ' + limit_discount + '%.')
                    dis_per = limit_discount
                    discount =((dis_per * orig_price) / 100).toFixed(2);

                    $(this).val(discount);
                }
            }


    dis_per_td.find('input').val(dis_per); //discount_per //discount_per
            fees_td.find('input').val(Number(orig_price - discount).toFixed(2)); //fees
        });

        $('body').on('keyup', '.discount_per_opth', function() {
            this_td = $(this).closest('td'),
                dis_td = this_td.prev('td'),
                orig_price = $(dis_td).find('input').val(),
                discount = $(dis_td).find('input').next().val(),
                fees_td = this_td.next('td');
            fees = $(fees_td).find('input').val(),
                discount_per = Number($(this).val()).toFixed(2);

                if(limit_discount !=''){
                if (discount_per > limit_discount) {
                    showdialog('Authorization Error' ,'Discount percentage exceeds the allowed limit of ' + limit_discount + '%.')
            $(this).val(limit_discount); // Optionally, reset the value to the limit
            discount_per = limit_discount; // Update discount_per to the limit value
            }
        }

            dis_td.find('input').next().val(Number((discount_per * orig_price) / 100).toFixed(2)); //discount
            fees_td.find('input').val(Number(orig_price - (discount_per * orig_price / 100)).toFixed(2));
        });

        $('body').on('keyup', '.fees_opth', function() {
            this_td = $(this).closest('td'),
                dis_per_td = this_td.prev('td');
            discount_per = $(dis_per_td).find('input').val(),
                dis_td = dis_per_td.prev('td'),
                orig_price = $(dis_td).find('input').val(),
                discount = $(dis_td).find('input').next().val(),
                fees = Number($(this).val()).toFixed(2);

            dis_td.find('input').next().val(Number(orig_price - fees).toFixed(2)); //discount
            dis_per_td.find('input').val(Number((1 - (fees / orig_price)) * 100).toFixed(2)); //discount_per
        });

        procedures_optho = new TomSelect('#procedures_optho', {});

    });
</script>