<form role="form" action="<?php echo site_url('admin/Modules/Surgical/SurgicalController/save'); ?>" method="post" enctype="multipart/form-data" id="surg_submit">
  <?php
  date_default_timezone_set('Asia/Kuwait');
  $date_string = '%Y-%m-%d';
  $curr_date = mdate($date_string);
  ?>
  <!-- <input type="hidden" class="form-control" name="treatmsurg_date" id="treatmsurg_date" value=<?php echo $curr_date; ?>>  -->
  <input type="hidden" class="form-control" name="patient_id" id="patient_id" value="<?php echo encrypt_and_url_encode($patient_id, $this); ?>">
  <!-- <input type="hidden" class="form-control" style="z-index: 0 !important;" name="treatmsurg_time" id="treatmsurg_time" class="diag-time" value="<?php echo date('H:s'); ?>"> -->


  <div class="form-group p-3">
    <div class="row">
      <div class="col-12">
        <h4><b>Surgical</b></h4>
        <hr>
      </div>
      <div class="col-12">
        <div class="row">
          <div class="col-6">
            <div class="form-group">
              <div class="form-group <?php echo (form_error('operation_note') == '') ? '' : ' has-error'; ?>">
                <label for="app_date">Operation Note</label>
                <textarea class="form-control" id="operation_note" name="operation_note"></textarea>
                <?php echo form_error('operation_note', '<div style="color:red"><em>* ', '</em></div>'); ?>
              </div>
            </div>
          </div>
          <div class="col-3">
            <div class="form-group">
              <div class="form-group <?php echo (form_error('operation_date') == '') ? '' : ' has-error'; ?>">
                <label for="app_date">Operation Date</label>
                <input type="text" class="form-control select_date" name="operation_date" id="operation_date" value="<?php echo date("Y-m-d"); ?>">
                <?php echo form_error('operation_date', '<div style="color:red"><em>* ', '</em></div>'); ?>
              </div>
            </div>
          </div>
          <div class="col-3">
            <div class="form-group <?php echo (form_error('operation_time') == '') ? '' : ' has-error'; ?>">
              <label for="app_date">Operation Time</label>
              <input type="time" class="form-control " name="operation_time" id="operation_time" value="<?php echo date("H:i") ?>">
              <?php echo form_error('operation_time', '<div style="color:red"><em>* ', '</em></div>'); ?>
            </div>
          </div>
          <div class="col-3">
            <div class="form-group <?php echo (form_error('operation_status') == '') ? '' : ' has-error'; ?>">
              <label for="app_date">Operation Status</label>
              <select class="form-control" name="operation_status" id="operation_status">
                <option value="1">In PreOp</option>
                <option value="2">OK Transfer</option>
                <option value="3">In OR</option>
                <option value="4">In Facility</option>
              </select>
              <?php echo form_error('operation_status', '<div style="color:red"><em>* ', '</em></div>'); ?>
            </div>
          </div>
          <div class="col-3">
            <div class="form-group <?php echo (form_error('room') == '') ? '' : ' has-error'; ?>">
              <label for="app_date">Room</label>
              <select class="form-control" name="room" id="room">
                <?php foreach ($rooms as $key => $value) { ?>
                  <option value="<?php echo $value["id"]; ?>" <?php echo $surgery_details->room == $value["id"] ? 'selected' : '' ?>><?php echo $value["room_name"]; ?></option>
                <?php } ?>
              </select>
              <?php echo form_error('room', '<div style="color:red"><em>* ', '</em></div>'); ?>
            </div>
          </div>
          <div class="col-3">
            <div class="form-group <?php echo (form_error('duration') == '') ? '' : ' has-error'; ?>">
              <label for="app_date">Expected Duration</label>
              <input type="text" class="form-control" name="duration" id="duration">
              <?php echo form_error('duration', '<div style="color:red"><em>* ', '</em></div>'); ?>
            </div>
          </div>
          <div class="col-3">
            <div class="form-group <?php echo (form_error('stay') == '') ? '' : ' has-error'; ?>">
              <label for="app_date">Expected Stay</label>
              <input type="text" class="form-control" name="stay" id="stay">
              <?php echo form_error('stay', '<div style="color:red"><em>* ', '</em></div>'); ?>
            </div>
          </div>
          <div class="col-3">
            <div class="form-group <?php echo (form_error('admission_time') == '') ? '' : ' has-error'; ?>">
              <label for="app_date">Admission Time</label>
              <input type="time" class="form-control" name="admission_time" id="admission_time" value="<?php echo date("H:i") ?>">
              <?php echo form_error('admission_time', '<div style="color:red"><em>* ', '</em></div>'); ?>
            </div>
          </div>
          <div class="col-3">
            <div class="form-group <?php echo (form_error('anesthisia_type') == '') ? '' : ' has-error'; ?>">
              <label for="app_date">Anesthisia Type</label>
              <select class="form-control" name="anesthisia_type" id="anesthisia_type">
                <option value="1">General</option>
                <option value="2">Sedation</option>
                <option value="3">Regional</option>
                <option value="4">Local</option>
              </select>
              <?php echo form_error('anesthisia_type', '<div style="color:red"><em>* ', '</em></div>'); ?>
            </div>
          </div>
          <div class="col-3">
            <div class="form-group <?php echo (form_error('start_time') == '') ? '' : ' has-error'; ?>">
              <label for="app_date">Start Time</label>
              <input type="time" class="form-control" name="start_time" id="start_time" value="<?php echo date("H:i") ?>">
              <?php echo form_error('start_time', '<div style="color:red"><em>* ', '</em></div>'); ?>
            </div>
          </div>
          <div class="col-3">
            <div class="form-group <?php echo (form_error('end_time') == '') ? '' : ' has-error'; ?>">
              <label for="app_date">End Time</label>
              <input type="time" class="form-control" name="end_time" id="end_time" value="<?php echo date("H:i") ?>">
              <?php echo form_error('end_time', '<div style="color:red"><em>* ', '</em></div>'); ?>
            </div>
          </div>
          <div class="col-3">
            <div class="form-group <?php echo (form_error('operation') == '') ? '' : ' has-error'; ?>">
              <label for="app_date">Operation Duration</label>
              <input type="text" class="form-control" name="operation" id="operation">
              <?php echo form_error('operation', '<div style="color:red"><em>* ', '</em></div>'); ?>
            </div>
          </div>
          <div class="col-3">
            <div class="form-group <?php echo (form_error('asistant') == '') ? '' : ' has-error'; ?>">
              <label for="app_date">Asistant</label>
              <select class="form-control" name="asistant">
                <?php foreach ($nurses as $key => $value) { ?>
                  <option value="<?php echo $value["user_id"]; ?>"><?php echo $value["full_name"]; ?></option>
                <?php } ?>
              </select>
              <?php echo form_error('asistant', '<div style="color:red"><em>* ', '</em></div>'); ?>
            </div>
          </div>
          <div class="col-3">
            <div class="form-group <?php echo (form_error('discharge_date') == '') ? '' : ' has-error'; ?>">
              <label for="app_date">Discharge Date</label>
              <input type="date" class="form-control" name="discharge_date" id="discharge_date" value="<?php echo date("H:i") ?>">
              <?php echo form_error('discharge_date', '<div style="color:red"><em>* ', '</em></div>'); ?>
            </div>
          </div>
          <div class="col-3">
            <div class="form-group <?php echo (form_error('discharge_time') == '') ? '' : ' has-error'; ?>">
              <label for="app_date">Discharge Time</label>
              <input type="time" class="form-control" name="discharge_time" id="discharge_time" value="<?php echo date("H:i") ?>">
              <?php echo form_error('discharge_time', '<div style="color:red"><em>* ', '</em></div>'); ?>
            </div>
          </div>
          <div class="col-12 pt-3">
            <div class="form-group">
              <h5><b>Patient Vitals</b></h5>
              <hr>
            </div>
          </div>
          <div class="col-1">
            <div class="form-group">
              <label>B.P</label>
            </div>
          </div>
          <div class="col-1">
            <input type="text" class="form-control vitals" id="bp_1" name="bp_1">
          </div>
          <div class="col-1">
            <input type="text" class="form-control vitals" id="bp_2" name="bp_2">
          </div>
          <div class="col-1">
            <label>Pulse</label>
          </div>
          <div class="col-1">
            <input type="text" class="form-control vitals" id="pulse" name="pulse">
          </div>
          <div class="col-1">
            <label>Temp.</label>
          </div>
          <div class="col-1">
            <input type="text" class="form-control vitals" placeholder="ºC" id="tempc" name="tempc">
          </div>
          <div class="col-1">
            <input type="text" class="form-control vitals" placeholder="ºF" id="tempf" name="tempf">
          </div>
          <div class="col-1">
            <label>G.R.B.S</label>
          </div>
          <div class="col-1">
            <input type="text" class="form-control vitals" placeholder="mg/dl" id="grbs" name="grbs">
          </div>
          <div class="col-1">
            <label>R.R</label>
          </div>
          <div class="col-1">
            <input type="text" class="form-control vitals" id="rr" name="rr">
          </div>
          <div class="col-1">
            <label>Height</label>
          </div>
          <div class="col-1">
            <input type="text" class="form-control vitals" id="height" name="height">
          </div>
          <div class="col-1">
            <div style="width:100%"></div>
          </div>
          <div class="col-1">
            <label>Weight</label>
          </div>
          <div class="col-1">
            <input type="text" class="form-control vitals" id="weight" name="weight">
          </div>
          <div class="col-1">
            <label>O<sub>2</sub> Saturation</label>
          </div>
          <div class="col-1">
            <input type="text" class="form-control vitals" id="saturation" name="saturation">
          </div>
        </div>
      </div>
    </div>

    <div class="row pt-2">
      <div class="col-6">
        <div class="form-group">
          <div class="form-group <?php echo (form_error('bmi') == '') ? '' : ' has-error'; ?>">
            <label for="app_date">BMI</label>
            <input type="text" class="form-control " name="bmi" id="bmi">
            <?php echo form_error('bmi', '<div style="color:red"><em>* ', '</em></div>'); ?>
          </div>
        </div>
      </div>
     
      <div class="col-12">
        <div class="form-group">
          <label for="drugs">Select Allergies</label>
          <input type="text" class="multi_diagnosis" name="diagnosis_vitals_surg" id="diagnosis_vitals_surg">
        </div>
      </div>
    </div>

    <div class="row pt-3">
      <div class="col-12">
        <button type="button" class="btn btn-sm btn-dark" id="addRow_vitals_surgical"><i class="fa fa-plus-circle"></i> Add Vital</button>
      </div>
    </div>
  </div>

  <div class="row p-3">
    <div class="col-12">
      <div class="panel panel-primary">
        <div class="panel-heading">
          <h5>
            Patient Vitals List
          </h5>
        </div>
        <table class="table table-hover display table-striped w-100" id="vitals_surg">
          <thead>
            <tr>
              <th>Time</th>
              <th>B.P</th>
              <th>Pulse</th>
              <th>Tempeture</th>
              <th>G.R.B.S</th>
              <th>R.R</th>
              <th>Height</th>
              <th>Weight</th>
              <th>O<sub>2</sub> Saturation</th>
              <th>BMI</th>
              <th>Allergies</th>
              <th>Notes</th>
              <th class="text-center">Actions</th>
            </tr>
          </thead>
        </table>
        <input type="hidden" name="vitals" id="vitals">
      </div>
    </div>
  </div>

  <div class="form-group p-3">
    <div class="row">
      <div class="col-12">
        <div class="form-group">
          <h5><b>Procedures</b></h5>
          <hr>
        </div>
      </div>
    </div>
    <div class="row">
      <div class="col-12">
        <div class="form-group">
          <label for="drugs">Select Diagnosis</label>
          <input type="text" class="multi_diagnosis" name="diagnosis_surgical" id="diagnosis_surgical">
        </div>
      </div>
    </div>
    <div class="row">
      <div class="col-12">
        <div class="form-group">
          <label for="procedure">Select Procedure</label>
          <select class="procedure" data-department="8" name="procedure_surgical" id="procedure_surgical">
          </select>
        </div>
      </div>
    </div>
    <div class="row pt-3">
      <div class="col-12">
        <button type="button" class="btn btn-sm btn-dark" id="addRow_surgical"><i class="fa fa-plus-circle"></i> Add Procedure</button>
      </div>
    </div>
  </div>

  <div class="row mt-2 p-3">
    <div class="col-12">
      <div class="panel panel-primary">
        <div class="panel-heading">
          <h5>
            Procedures List
          </h5>
        </div>
        <table class="table table-hover display table-striped w-100" id="treatemnts_surg">
          <thead>
            <tr>
              <th>Diagnosis</th>
              <th>Procedure</th>
              <th>Discount(QR)</th>
              <th>Discount(%)</th>
              <th>Fees</th>
              <th class="text-center">Actions</th>
            </tr>
          </thead>
        </table>
        <input type="hidden" name="tretments" id="tretments">
      </div>
    </div>
  </div>


  <div class="row p-3">
    <div class="col-12">
      <div class="form-group">
        <label for="drugs">Procedures Note</label>
        <textarea type="text" class="form-control note" name="note" id="note"></textarea>
      </div>
    </div>
  </div>

  <div class="row">
    <div class="col-md-4">
      <label for="attachment">Attachment</label>
      <div class="input-group hide-input">
        <span class="input-group-btn">
          <span class="btn btn-default btn-file">
            <label for="attach_surgical" style="margin: 0px;">Browse</label>&hellip;<input type="file" multiple id="attach_surgical" name="attach_surgical[]">
          </span>
        </span>
        <input type="text" class="form-control" readonly>
      </div>
    </div>
  </div>

  <div class="row p-3">
    <div class="col-12">
      <div class="panel panel-success">
        <div class="panel-heading">
          <h5><b>
              Prescriptions
            </b></h5>
        </div><br>
        <div class="row">
          <div class="col-md-3">
            <div class="form-group">
              <label for="drugs">Select Drugs</label>
              <input type="text" class="form-control drugs" name="drugs_surg" id="drugs_surg">
            </div>
          </div>
          <div class="col-md-3">
            <div class="form-group">
              <label for="drugs">Doses</label>
              <input type="text" class="form-control surg_doses_auto" name="drug_qty_surg" id="drug_qty_surg">
            </div>
          </div>
          <div class="col-md-3">
            <div class="form-group">
              <label for="meal">Frequency</label><br>
              <input type="text" class="form-control surg_frequency_auto" name="drug_meal_surg" id="drug_meal_surg">
            </div>
          </div>
          <div class="col-md-3">
            <div class="form-group">
              <label for="drugs">Duration(Days)</label>
              <div class="input-group">
                <input type="text" class="form-control surg_duration_auto" name="drug_note_surg" id="drug_note_surg">
                <span class="input-group-addon">
                  <button type="button" class="btn btn-light btn-xs add_field_button_surg" id="add_drug_surg">+</button>
                  <button type="button" class="btn btn-danger btn-xs clear_field_surg" id="clear_field_surg">x</button>
                </span>
              </div>
            </div>
          </div>
        </div>
        <div class="input_fields_wrap_surg"></div>
      </div>
    </div>
  </div>

 
      <div class="col-6">
     
        <div class="form-group">
          <div class="form-group <?php echo (form_error('notes') == '') ? '' : ' has-error'; ?>">
            <label for="app_date">Notes</label>
            <input type="text" class="form-control " name="notes" id="notes" value="">
            <?php echo form_error('notes', '<div style="color:red"><em>* ', '</em></div>'); ?>
          </div>
        </div>
      </div>

  <div class="form-group p-3">
    <label for="note">Prescription Note</label>
    <textarea class="form-control" name="note_con" id="note_con" rows="3"></textarea>
  </div>
  <div class="form-group">
                    <label for="condition">Treatmen Type</label><br>
                    <div class="followup_div">

                        <label class="radio-inline">
                            <input type="radio" required name="followup" id="followup_0" value="0" class="jq_followup"> New Treatment
                        </label>
                        <br>
                        <label class="radio-inline">
                            <input type="radio" required name="followup" id="followup_1" value="1" class="jq_followup"> FOC
                        </label>
                        <br>
                        <?php if($is_package==1){
                            $desired_module_id=8;
                            include(APPPATH . "views/admin/Modules/packages.php");
                             
                             } ?>
                                

                            
                    </div>
                </div>

  <div class="row mt-2 p-3">
    <div class="col-12">
      <div class="form-group">
        <button type="submit" class="btn btn-light btn-sm"><i class="fa fa-check-circle"></i> Save</button>
        <button type="reset" class="btn btn-light btn-sm" id="clear"><i class="fa fa-times-circle" aria-hidden="true"></i> Clear</button>
      </div>
    </div>
  </div>



</form>
<script>
  $(document).ready(function() {
    jQuery(function() {
      weight = $('#weight');
      height = $('#height');
      bmi = $('#bmi');

      weight.on('input', function() {
        bmi.val((weight.val() / (height.val() * 2)).toFixed(2));
      })

      height.on('input', function() {
        bmi.val((weight.val() / (height.val() * 2)).toFixed(2));
      })
    });
  });
</script>

<script src="<?php echo base_url('js/Modules/surgical.js') ?>" type="text/javascript"></script>