  <form role="form" action="<?php $this->load->helper('url');
                            echo site_url('admin/Patients/PatientsController/saveTriage'); ?>" method="post" enctype="multipart/form-data">

    <div class="form-group">
      <div class="col-md-12">
        <div class="row">
          <div class="col-md-2">
            <label>Weight (KG)</label>
          </div>
          <div class="col-md-2">
            <input type="number" class="form-control calculate_bmi triage_weight" id="triage_weight" name="triage_weight" value="<?=$triage[0]['weight']?>" placeholder="In kilogram">
          </div>
          <div class="col-md-2">
            <label>Height (Meters)</label>
          </div>
          <div class="col-md-2">
            <input type="number" class="form-control calculate_bmi triage_height" id="triage_height" step="any" name="triage_height" value="<?=$triage[0]['height']?>" placeholder="In meters">
          </div>
          <div class="col-md-2">
            <label>BMI</label>
          </div>
          <div class="col-md-2">
            <input type="text" class="form-control triage_bmi" id="triage_bmi" name="triage_bmi" value="<?=$triage[0]['bmi']?>">
            <span class="bmi_status badge"></span>
          </div>
        </div>
        <br>
        <div class="row">
          <div class="col-md-2">
            <label>BP</label>
          </div>
          <div class="col-md-2">
            <input type="number" class="form-control" id="triage_bp" name="triage_bp" value="<?=$triage[0]['bp']?>">
          </div>
          <div class="col-md-2">
            <label>Temperature</label>
          </div>
          <div class="col-md-2">
            <input type="number" class="form-control" id="triage_temperature" name="triage_temperature" value="<?=$triage[0]['temperature']?>">
          </div>
          <div class="col-md-2">
            <label>Pulse</label>
          </div>
          <div class="col-md-2">
            <input type="number" class="form-control" id="triage_pulse" name="triage_pulse" value="<?=$triage[0]['pulse']?>">
          </div>
        </div>
        <br>
        <div class="row">
          <div class="col-md-2">
            <label>RR</label>
          </div>
          <div class="col-md-2">
            <input type="text" class="form-control" id="triage_rr" name="triage_rr" value="<?=$triage[0]['rr']?>">
          </div>
        </div><br>

        <div class="row">
          <div class="col-md-2">
            <label>Nurse Notes</label>
          </div>
          <div class="col-md-10">
            <textarea class="form-control" name="triage_notes" id="triage_notes" rows="4"><?=$triage[0]['notes']?></textarea>
          </div>
        </div>
      </div>
    </div><br><br><br><br><br><br><br><br><br>

    <input name="patient_id" id="patient_id" type="hidden" value="<?php echo encrypt_and_url_encode($patient_id, $this); ?>">
    <input name="traige_id" id="traige_id" type="hidden" value="<?php echo  encrypt_and_url_encode($triage[0]['triage_id'], $this); ; ?>">
    <!-- <input name="insurance_current_id" id="insurance_current_id" type="hidden" value="<?php echo $insurance_id; ?>"> -->
    <div class="row">
      <div class="col-md-12">
        <div class="form-group">
          <button type="submit" class="btn btn-light btn-sm"><i class="fa fa-check-circle" aria-hidden="true"></i> Save</button>
          <!-- <button type="button" class="btn btn-default btn-success" disabled="disabled">Update</button> -->
          <button type="reset" class="btn btn-light btn-sm" id="clear"><i class="fa fa-times-circle"></i> Clear</button>
        </div>
      </div>
    </div>

  </form>

  <script>
   var bmiElement= $('.bmi_status');
   var bmi=$('.triage_bmi').val()
   if (bmi < 18.5) {
        status = 'Underweight';
        bmiElement.addClass('badge-warning')
    } else if (bmi >= 18.5 && bmi < 24.9) {
        status = 'Normal weight';
        bmiElement.addClass('badge-success')
    } else if (bmi >= 25 && bmi < 29.9) {
        status = 'Overweight';
        bmiElement.addClass('badge-warning')
    } else if (bmi >= 30) {
        status = 'Obesity';
        bmiElement.addClass('badge-danger')
    }
    $('.bmi_status').text(status);

    $('body').on('keyup', '.calculate_bmi', function() {

var h = $('.triage_height').val();
var w = $('.triage_weight').val();
var bmiElement= $('.bmi_status');
bmiElement.removeClass('badge-warning badge-success badge-danger');

var bmi = w / (h * h);

if ((h != "") && (w != "")) {
  var status = '';

// Determine BMI status based on standard categories
    if (bmi < 18.5) {
        status = 'Underweight';
        bmiElement.addClass('badge-warning')
    } else if (bmi >= 18.5 && bmi < 24.9) {
        status = 'Normal weight';
        bmiElement.addClass('badge-success')
    } else if (bmi >= 25 && bmi < 29.9) {
        status = 'Overweight';
        bmiElement.addClass('badge-warning')
    } else if (bmi >= 30) {
        status = 'Obesity';
        bmiElement.addClass('badge-danger')
    }
    $('.bmi_status').text(status);
    $('.triage_bmi').val(bmi.toFixed(1));
}
});

  </script>