<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

class CouponController extends MY_Controller {

    function __construct() {
        parent::__construct();

        $this->load->model('admin/Coupon/CouponModel');
        $this->load->model('admin/CommonModel');
        $this->load->library('upload');
        $this->load->helper(array('form', 'url'));

        // load form_validation library
        $this->load->library('form_validation');
    }

    public function create_coupon() {
        // Validate form input
        $users = $this->input->post('users'); // Retrieve the array of users

        if (is_array($users) && count($users) > 0) {
            $users = json_encode($users); // Encode to JSON if the array is not empty
        } else {
            $users = null; // Set to null if the array is empty or not valid
        }
            // Prepare the data to be saved
            $data = array(
                'code' => $this->input->post('code'),
                'description' => $this->input->post('description'),
                'discount_type' => $this->input->post('discount_type'),
                'discount_value' => $this->input->post('discount_value'),
                'valid_from' => $this->input->post('valid_from'),
                'valid_until' => $this->input->post('valid_until'),
                'min_purchase' => $this->input->post('min_purchase') ? $this->input->post('min_purchase') : 0.00,
                'max_discount_value' => $this->input->post('max_discount_value') ? $this->input->post('max_discount_value') : NULL,
                'applicable_to' => $this->input->post('applicable_to'),
                'is_active' => $this->input->post('is_active'),
                'notification_type' => $this->input->post('notification_type'),
                'users' => $users,
            );
           
          
        

            // Save the data using the model
            if ($this->CouponModel->save_coupon($data)) {
                // Redirect or show success message
                echo json_encode(array(
                    'success' => true,
                    'message' => 'Coupon created successfully!'
                ));
            } else {
                // Handle error and reload form
                echo json_encode(array(
                    'success' => false,
                    'message' => 'Failed to create coupon. Please try again.'
                ));
            }
        }

        public function get_all(){
            $templates = $this->CouponModel->retrieve_data_order('coupons','id','DESC');
  

            $this->output
                ->set_content_type('application/json')
                ->set_output(json_encode($templates));
        }
      
    
        public function delete_item() {
            // Load the model
         
            
            // Get the ID from the POST request
            $id = $this->input->post('id');
            
            // Check if the ID is provided
            if($id) {
                // Call the model function to delete the item
                $result = $this->CouponModel->delete_item($id);
                
                // Check if the deletion was successful
                if($result) {
                    // Return success response
                    echo json_encode(['status' => 'success', 'message' => 'Item deleted successfully']);
                } else {
                    // Return failure response
                    echo json_encode(['status' => 'error', 'message' => 'Failed to delete item']);
                }
            } else {
                // If no ID was passed, return an error response
                echo json_encode(['status' => 'error', 'message' => 'Invalid request']);
            }
        }


        public function updateCouponStatus() {
            $id = $this->input->post('id');
            $status = $this->input->post('status');
        
            // Update the reminder's active status in the database
            $this->db->where('id', $id);
            $this->db->update('coupons', ['is_active' => $status]);
        
           
            if ($this->db->affected_rows() > 0) {
                echo json_encode(['status' => 'success']);
            } else {
                echo json_encode(['status' => 'error']);
            }
        }

        public function updateLoyaltyStatus() {
            $id = $this->input->post('id');
            $status = $this->input->post('status');
        
            // Update the reminder's active status in the database
            $this->db->where('id', $id);
            $this->db->update('loyalty_programs', ['is_active' => $status]);
        
           
            if ($this->db->affected_rows() > 0) {
                echo json_encode(['status' => 'success']);
            } else {
                echo json_encode(['status' => 'error']);
            }
        }


        public function validate_coupon(){
            $coupon_code = $this->input->post('coupon_code');
            $patient_id = $this->input->post('patient_id');
            $amount = $this->input->post('amount');

            // Validate the coupon code (this is a simplified example)
            $coupon = $this->CouponModel->validate_coupon($coupon_code,$patient_id,$amount);
            
            if ($coupon && $coupon['valid']) {
                $data= array(
                    'discount_value'=>$coupon['discount_value'],
                    'coupon_id'=>$coupon['id'],
                    'discount_type'=>$coupon['discount_type'],
                );
               
                // Respond with the new total and valid status
                echo json_encode(['valid' => true, 'data' => $data]);
            } else {
                // Respond with invalid status
                echo json_encode(['valid' => false, 'message' => $coupon['message']]);
            }
        }


        //Loyalty Program

        public function get_all_programs(){
            $templates = $this->CouponModel->retrieve_data_order('loyalty_programs','id','DESC');
  

            $this->output
                ->set_content_type('application/json')
                ->set_output(json_encode($templates));
        }

        public function save_loyalty_program() {
           
                // Prepare the data to be saved
                $data = array(
                    'name' => $this->input->post('programName'),
                    'points_per_dollar' => $this->input->post('pointsPerDollar'),
                    'min_points_to_redeem' => $this->input->post('minPointsToRedeem'),
                    'discount_per_point' => $this->input->post('discountPerPoint'),
                    'is_active' => $this->input->post('programStatus'),
                    'expired_after' => $this->input->post('expiredAfter'),
                    
                    
                );
               
              
            
    
                // Save the data using the model
                if ($this->CouponModel->save_loyalty($data)) {
                    // Redirect or show success message
                    echo json_encode(array(
                        'success' => true,
                        'message' => 'Loyalty Program created successfully!'
                    ));
                } else {
                    // Handle error and reload form
                    echo json_encode(array(
                        'success' => false,
                        'message' => 'Failed to create Loyalty program. Please try again.'
                    ));
                }
            }


            public function delete_loyalty_program() {
                // Load the model
             
                
                // Get the ID from the POST request
                $id = $this->input->post('id');
                
                // Check if the ID is provided
                if($id) {
                    // Call the model function to delete the item
                    $result = $this->CouponModel->delete_loyalty($id);
                    
                    // Check if the deletion was successful
                    if($result) {
                        // Return success response
                        echo json_encode(['status' => 'success', 'message' => 'Item deleted successfully']);
                    } else {
                        // Return failure response
                        echo json_encode(['status' => 'error', 'message' => 'Failed to delete item']);
                    }
                } else {
                    // If no ID was passed, return an error response
                    echo json_encode(['status' => 'error', 'message' => 'Invalid request']);
                }
            }


            public function redeem_points(){
                $points = $this->input->post('points');
                $patient_id = $this->input->post('patient_id');
                $amount = $this->input->post('amount');
                $loyalty_program = $this->input->post('loyalty_program');
    
                // Validate the coupon code (this is a simplified example)
                $points_data = $this->CouponModel->redeem_points($points,$patient_id,$amount,$loyalty_program);
               
                if ($points_data && $points_data['valid']) {

                    $discount_per_point= $points_data['discount_per_point'];
                    $total_discount = (float)$points * (float)$discount_per_point;
                    $total_discount = round($total_discount);
                    $data= array(
                        'total_points'=>$total_discount,
                       
                    );
                   
                    // Respond with the new total and valid status
                    echo json_encode(['valid' => true, 'data' => $data]);
                } else {
                    // Respond with invalid status
                    echo json_encode(['valid' => false, 'message' => $points_data['message']]);
                }
            }

}
