<?php

class DocumentsController extends MY_Controller {

    function __construct() {
        parent::__construct();

        //Commen -------------------------------------
        $this->load->model('admin/CommonModel');
        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');

        $this->load->model('admin/Documents/DocumentsModel');
    }

    public function index() {
		
        if ($this->session->userdata('user_Id') != '') {

            //Commen -------------------------------------
            $loginId = $this->session->userdata('user_Id');
            $data['active_menu'] = 40;
            $data['active_submenu'] = 30;
            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);

            $data['document_list'] = $this->DocumentsModel->get_document_list();
			
            $this->load->view('admin/Documents/DocumentsList', $data);
			
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
		
    }

     public function createnew() {
        
        if ($this->session->userdata('user_Id') != '') {

            //Commen -------------------------------------
            $loginId = $this->session->userdata('user_Id');
            $data['active_menu'] = 40;
            $data['active_submenu'] = 30;
            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);
            
            $_id = 0;
            $document_type_id = 0;
            $created_datetime =  date('Y-m-d H:i:s');
            $is_active = '';
            $document_content = '';
            
            $data['_id'] = $_id;
            $data['document_type_id'] = $document_type_id;
            $data['created_datetime'] = $created_datetime;
            $data['is_active'] = $is_active;
            $data['document_content'] = $document_content;

            $data['document_typs'] = $this->DocumentsModel->get_document_typs();
            
            $this->load->view('admin/Documents/Documents', $data);
            
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
        
    }

    public function save() {
        
        if ($this->session->userdata('user_Id') != '') {

            //Commen -------------------------------------
            $loginId = $this->session->userdata('user_Id');
            $data['active_menu'] = 40;
            $data['active_submenu'] = 30;
            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);
			
			
            
            $_id = $this->input->post('_id');
            $document_type_id = $this->input->post('document_type_id');
            $created_datetime = $this->input->post('created_datetime');
            $is_active = $this->input->post('is_active');
            $document_content = $this->input->post('document_content');
            
            $data['_id'] = $_id;
            $data['document_type_id'] = $document_type_id;
            $data['created_datetime'] = $created_datetime;
            $data['is_active'] = $is_active;
            $data['document_content'] = $document_content;

            $data['document_typs'] = $this->DocumentsModel->get_document_typs();
            
            //print_r($data['brand_name']);die;
            $this->form_validation->set_rules('document_type_id', 'Document Type', 'callback_document_type_check');
           
            
            
            if ($this->form_validation->run() == FALSE) {
                
                $this->load->view('admin/Documents/Documents', $data);
                return;
                
            }
            
            $data_save = array (

                'document_type_id' => $document_type_id,              
                'document_content' => $document_content,               
                'is_active' =>  $is_active == 'active' ? 1 : 0              
            );
            
            //print_r($data_save);die;
            
            if($_id > 0 ) {
                                
                $this->DocumentsModel->update($_id,$data_save);
                
            } else {
                
                $this->DocumentsModel->save($data_save);
                
            }
            
            
            redirect('admin/Documents/DocumentsController', 'refresh');

            
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
        
    }

    public function edit() {
        
        if ($this->session->userdata('user_Id') != '') {

            //Commen -------------------------------------
            $loginId = $this->session->userdata('user_Id');
            $data['active_menu'] = 40;
            $data['active_submenu'] = 30;
            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);
            
            $_id = base64_decode(urldecode($this->input->post('selected_id')));
            
            
            if($_id != null && $_id != ''){
            
                $details = $this->DocumentsModel->get_details_by_id($_id);
                foreach ($details->result() as $row) {

                    $document_type_id = $row->document_type_id;
                    $document_content = $row->document_content;
                    $is_active = $row->is_active == 1 ? 'active' : '';
                    
                }

                $data['_id'] = $_id;
                $data['document_type_id'] = $document_type_id;
                $data['document_content'] = $document_content;
                $data['is_active'] = $is_active;
                
                $data['document_typs'] = $this->DocumentsModel->get_document_typs();
                
                $this->load->view('admin/Documents/Documents', $data);
                
            } else {
                
                redirect('admin/CommenController/page_not_found', 'refresh');
                
            }
            
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
        
    }

    public function document_type_check() {
        
        if($this->input->post('document_type_id') == 0){
            $this->form_validation->set_message('document_type_check', 'Please select Document Type.');
            return FALSE;
        } else {
            return TRUE;
        }
    }

}
