<?php

class GetInTouchController extends CI_Controller {

    function __construct() {
        parent::__construct();

        //Commen -------------------------------------
        $this->load->model('admin/CommonModel');
        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');

        $this->load->model('admin/GetInTouch/GetInTouchModel');
    }

    public function index($page=0) {
		
        if ($this->session->userdata('user_Id') != '') {

            //Commen -------------------------------------
            $loginId = $this->session->userdata('user_Id');
            $data['active_menu'] = 15;
            $data['active_submenu'] = 1;
            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);
			
			$data['page_count'] = $this->config->item('page_count');
			$data['page'] = $page;
			$data['search_url'] = 'GetInTouch/GetInTouchController/index/';
			$data['form'] = 'submitForm';
			
			$data['get_in_touch_list'] = $this->GetInTouchModel->get_in_touch_list($data);
			
			$data['paginationData'] = $data['get_in_touch_list'];

            $this->load->view('admin/GetInTouch/GetInTouchList', $data);
			
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
		
    }
	
	public function createnew() {
		
        if ($this->session->userdata('user_Id') != '') {

            //Commen -------------------------------------
            $loginId = $this->session->userdata('user_Id');
            $data['active_menu'] = 15;
            $data['active_submenu'] = 1;
            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);
			
			$_id = 0;
			$name = '';
			$website = '';
			$email = '';
			$phone = '';
			$message = '';
			$datetime = '';
			$status = '';
			$accepted_datetime = date( 'Y-m-d H:i:s' );
			$note = '';
			
			$data['_id'] = $_id;
			$data['name'] = $name;
			$data['website'] = $website;
			$data['email'] = $email;
			$data['phone'] = $phone;
			$data['message'] = $message;
			$data['datetime'] = $datetime;
			$data['status'] = $status;
			$data['accepted_datetime'] = $accepted_datetime;
			$data['note'] = $note;
			
			$is_edit = 0;
			$data['is_edit'] = $is_edit;

            $this->load->view('admin/GetInTouch/GetInTouch', $data);
			
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
		
    }
	
	public function save() {
		
        if ($this->session->userdata('user_Id') != '') {

            //Commen -------------------------------------
            $loginId = $this->session->userdata('user_Id');
            $data['active_menu'] = 15;
            $data['active_submenu'] = 1;
            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);
			
			$_id = $this->input->post('_id');
			$name = $this->input->post('name');
			$website = $this->input->post('website');
			$email = $this->input->post('email');
			$phone = $this->input->post('phone');
			$message = $this->input->post('message');
			$datetime = $this->input->post('datetime');
			$status = $this->input->post('status');
			$accepted_datetime = $this->input->post('accepted_datetime');
			$note = $this->input->post('note');
			
			$data['_id'] = $_id;
			$data['name'] = $name;
			$data['website'] = $website;
			$data['email'] = $email;
			$data['phone'] = $phone;
			$data['message'] = $message;
			$data['datetime'] = $datetime;
			$data['status'] = $status;
			$data['accepted_datetime'] = $accepted_datetime;
			$data['note'] = $note;
			
			$is_edit = 0;
			$data['is_edit'] = $is_edit;
			
			//print_r($data['brand_name']);die;
			$this->form_validation->set_rules('note', 'Note', 'trim|required');
			//$this->form_validation->set_rules('status', 'Status', 'trim|required');
			
			
			if ($this->form_validation->run() == FALSE) {
				
                $this->load->view('admin/GetInTouch/GetInTouch', $data);
                return;
				
            }
			
			
			$data_save = array (

				'name' => $name,				
				'website' => $website,				
				'email' => $email,				
				'phone' =>  $phone,				
				'message' =>  $message,				
				'datetime' =>  $datetime,				
				'status' =>  $status,				
				'accepted_datetime' =>  $accepted_datetime,				
				'note' =>  $note				
			);
			
			//print_r($data_save);die;
			
			if($_id > 0 ) {
								
				$this->GetInTouchModel->update($_id,$data_save);
				
			} else {
				
				$this->GetInTouchModel->save($data_save);
				
			}
			
			
			redirect('admin/GetInTouch/GetInTouchController', 'refresh');

			
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
		
    }
	
	public function edit() {
		
        if ($this->session->userdata('user_Id') != '') {

            //Commen -------------------------------------
            $loginId = $this->session->userdata('user_Id');
            $data['active_menu'] = 15;
            $data['active_submenu'] = 1;
            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);
			
			$_id = base64_decode(urldecode($this->input->post('selected_id')));
			//print($this->input->post('selected_id'));die;
			
			if($_id != null && $_id != ''){
			
				$details = $this->GetInTouchModel->get_details_by_id($_id);
				foreach ($details->result() as $row) {

					$name = $row->name;
					$website = $row->website;
					$email = $row->email;
					$phone = $row->phone;
					$message = $row->message;
					$datetime = $row->datetime;
					$status = $row->status;
					$accepted_datetime = $row->accepted_datetime;
					$note = $row->note;
					
				}

				
				
				$data['_id'] = $_id;
				$data['name'] = $name;
				$data['website'] = $website;
				$data['email'] = $email;
				$data['phone'] = $phone;
				$data['message'] = $message;
				$data['datetime'] = $datetime;
				$data['status'] = $status;
				if ($status == 'New' || 'NULL') {
					$data['accepted_datetime'] = date( 'Y-m-d H:i:s' );
				} else {
					$data['accepted_datetime'] = $accepted_datetime;
				}
				
				$data['note'] = $note;
				
				$is_edit = 1;
				$data['is_edit'] = $is_edit;
				
				
				
				$this->load->view('admin/GetInTouch/GetInTouch', $data);
				
			} else {
				
				redirect('admin/CommenController/page_not_found', 'refresh');
				
			}
			
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
		
    }

}
