<?php 
class NotificationController extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        
        //is_cli() or die("Failed: Please run Jobs using cronjobs");
 
        $this->load->model('admin/Job/NotificationJob');
        $this->load->library('TwilioWhatsApp');
		$this->load->library('SMSAPI');
        $this->load->model('admin/NotificationServices/NotificationServicesModel');
    }

public function sendEvents(){
    $pendingJobs = $this->NotificationJob->retrieve_data_unique('tbl_jobs','is_sent',0);
    $channels = $this->NotificationJob->retrieve_data_unique('notification_reminders','reminder_type',2);

    if(!empty($pendingJobs)){
    foreach ($pendingJobs as $job) {
        // Get the event name from the job (e.g., 'create_appointment')
        $eventName = $job['event']; // Assuming you have an 'event_name' field in 'tbl_jobs'

        // Find the corresponding channel for the event
        $channelType = ''; // Initialize empty

        foreach ($channels as $channel) {
            if ($channel['reminder'] == $eventName) {
                $channelType = $channel['type']; // Get the type (SMS or WhatsApp)
                break; // Break the loop once we find the channel for this event
            }
        }
        if($channelType !='none'){
            $data= json_decode($job['payload']);
       
            // Check the channel type and send the appropriate message
            if ($channelType == 'sms') {
                // Send SMS 
                
               $sms= $this->sendSMS($data->phone, $data->message);
               
            } elseif ($channelType == 'whatsapp') {
                // Send WhatsApp message
                $templates= $this->NotificationJob->get_whatsapp_template($eventName);

                $this->sendWhatsApp($data, $templates->template_id,$eventName);
            }
    
            // After sending, mark the job as sent (is_sent = 1)
           
            
        }
        // $this->NotificationJob->update_data_where('tbl_jobs','id',$job['id'],['is_sent' => 1]);
        $this->NotificationJob->delete_data_where('tbl_jobs', 'id', $job['id']);

       
    }
}else{
    echo 'Nothing To Process';
}
 

}


public function sendReminders() {

  
    $reminderSettings = $this->NotificationJob->getActiveReminders();
  
    foreach ($reminderSettings as $reminder) {
        // Get the time difference for the reminder (e.g., 24, 36, 48 hours)
        $hoursBefore = $reminder->time;

        // Fetch appointments or events matching the reminder criteria
        $appointments = $this->NotificationJob->getAppointmentsBefore($hoursBefore);
        if($reminder->reminder == 'upcomming_appointment'){
            foreach ($appointments as $appointment) {
                // Prepare notification message
                if(!empty($appointment->patient_id)){
                    $patient= $this->NotificationJob->retrieve_data_unique_row('tbl_patients','patient_id',$appointment->patient_id);
                }
    
                // $message = $this->prepareNotificationMessage($reminder->reminder, $appointment);
    
                // Send notification based on the selected channel (SMS or WhatsApp)
                if ($reminder->type == 'sms') {
                  
                    $sms = $this->prepareSMSMessage($reminder->reminder, $appointment);
                 
                 $this->sendSMS($appointment->app_patient_contact, $sms);
                } 
                // elseif ($reminder->notification_channel == 'whatsapp') {
                //     $this->sendWhatsApp($appointment->phone, $message);
                // }
            }
        }else if($reminder->reminder == 'birthday'){
            $patient= $this->NotificationJob->getTodayBirthdayPatients();
            foreach ($patient as $item) {
              
                if(!empty($item->mobile)){
                   
                    if ($reminder->type == 'sms') {
                  
                        $sms = $this->prepareSMSMessage('birthday', $item);
                        
                     $this->sendSMS($item->mobile, $sms);
                    } 
                }
            }
           
        }
        
    }
}

public function prepareSMSMessage($event_name,$data){
    $placeholders = array();  // Initialize the placeholders array

    // Define placeholders based on the event type
    switch ($event_name) {
        case 'upcoming_appointment':
            $placeholders = [
                '{PATIENT_NAME}' => $data->app_patient_name,
                '{APPOINTMENT_DATE}' => $data->appointment_date,
                '{APPOINTMENT_TIME}' => $data->appointment_time . '-' . $data->appointment_etime,
            ];
            break;

        case 'birthday':
            $placeholders = [
                '{PATIENT_NAME}' => $data->patient_name,
            ];
            break;

        default:
            // Return a default message if no event matches
            return "Notification from our system.";
    }



    $template= $this->NotificationJob->getActiveTemplate($event_name);
   
    $message_template = $template->template;
    
    $final_message = str_replace(array_keys($placeholders), array_values($placeholders), $message_template);

   return $final_message;
}

private function prepareNotificationMessage($eventType, $appointment) {
    // Customize the notification message based on event type
    switch ($eventType) {
        case 'upcoming_appointment':
            return "Reminder: You have an upcoming appointment on " . $appointment->date_time;
        case 'birthday':
            return "Happy Birthday! We hope you have a great day!";
        default:
            return "Notification from our system.";
    }
}

private function sendSMS($phone, $message) {
    // Logic for sending SMS using a service like Twilio
    // Twilio or any other SMS API integration here
    $response = $this->smsapi->send_sms($phone, $message);
    if($response){
        return true;
    }else{
        return false;
    }
}

private function sendWhatsApp($data,$template_id,$eventName) {

    
    $template_data= $this->prepareTemplate($data,$eventName);
    if(!empty($data->whatsapp_mobile)){
        $phone= '+'.$data->whatsapp_mobile;
        $content_sid = $template_id;
     
       
        $response = $this->twiliowhatsapp->send_template_message($phone, $content_sid, $template_data);
    }else{
        $this->NotificationServicesModel->save_whatsapp_notification_response(json_encode(['response' => ['message'=>'Patient Whatsapp Number is not available']]),'FAILED');
    }
   
    
   
}

private function prepareTemplate($data,$eventType) {
    // Customize the notification message based on event type
    switch ($eventType) {
        case 'create_appointment':
            return $template_data = array(
                           "1" => $data->patient_name, // Ensure these match the variables in your template
                           "2" => $data->patient_name,
                           "3" => $data->app_date,
                           "4" => $data->app_time,
                          
            );
        case 'payment_receive':
            return $template_data = array(
                "PATIENT_NAME" => $data->patient_name, // Ensure these match the variables in your template
                "INVOICE_NUMBER" => '#'.$data->receipt_number,
                "PAY_DATE" => $data->pay_date,
                "AMOUNT" => $data->amount .' QAR',
                "PAYMENT_TYPE" => $data->type,
               );
               case 'queue_token':
                return $template_data = array(
                    "PATIENT_NAME" => $data->patient_name, // Ensure these match the variables in your template
                    "TOKEN_NUMBER" => $data->token_number.'',
                   );
        default:
            return "Notification from our system.";
    }
}

}
