<?php

class ENTController extends MY_Controller
{

    function __construct()
    {
        parent::__construct();

        $this->load->model('admin/CommonModel');
        $this->load->model('admin/Patients/PatientsModel');

        $this->load->library('upload');
    }

    public function index()
    {
        //Commen -------------------------------------
        $loginId = $this->session->userdata('user_Id');
        $data['active_menu'] = 22;
        $data['active_submenu'] = 1;
        $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
        $data['profile'] = $this->CommonModel->profile($loginId);

        $data['dataList'] = $this->PatientsModel->get_dataList();

        $this->load->view('admin/Patients/PatientsList', $data);
    }


    public function save()
    {

        $patient_id = $this->input->post('patient_id');
        $decryptedId = decrypt_and_url_decode($patient_id, $this);
        $patient = $this->PatientsModel->get_patient_details('patient_id', $decryptedId);

        $result['active_menu'] = 15;
        $result['active_submenu'] = 1;

        $treatment_date_general = $this->input->post('treatment_date_general');
        $chief_complaint_general = $this->input->post('chief_complaint_general');
        $subjective_general = $this->input->post('subjective_general');
        $objective_general = $this->input->post('objective_general');
        $assessment_general = $this->input->post('assessment_general');
        $recommendation_general = $this->input->post('recommendation_general');

        $diagnosis_general = $this->input->post('diagnosis_general');

        $diagnosis_id = $this->input->post('general_diagnosis_id');
        $diagnosis_name = $this->input->post('general_diagnosis_name');
        $treatment_name = $this->input->post('general_treatment_name');
        $treatment_id = $this->input->post('general_treatment_id');
        $fees = $this->input->post('orig_price_general');

        $discount = $this->input->post('discount_general');
        $discount_per = $this->input->post('discount_per_general');

        $drug_id = $this->input->post('drug_id_ent');
        $drug_name = $this->input->post('drug_name_ent');
        $drugs_qty = $this->input->post('drugs_qty_ent');
        $meals = $this->input->post('meals_ent');
        $drug_notes = $this->input->post('drug_notes_ent');

        $user_id = $this->session->userdata('user_id');

        $triage_weight = $this->input->post('triage_weight');
        $triage_height = $this->input->post('triage_height');
        $triage_bmi = $this->input->post('triage_bmi');
        $triage_bp = $this->input->post('triage_bp');
        $triage_temperature = $this->input->post('triage_temperature');
        $triage_pulse = $this->input->post('triage_pulse');
        $triage_rr = $this->input->post('triage_rr');
        $note = $this->input->post('note');
        
        $assigned_package = $this->input->post('assigned_package');
        $followup = $this->input->post('followup');

        $treatment_date = $this->input->post('treatment_date');
        $treatment_time = $this->input->post('treatment_time');
        if (is_array($fees)) {
            $total = array_sum($fees);
        }

        if (is_array($fees)) {
            $orig_price_total = array_sum($fees);
        }

        if (is_array($discount)) {
            $total_discount = array_sum($discount);
        }

        $this->db->trans_start();
        try {
            if($followup == 0){
            $treatment_payment_data = array(
                'patient_id'  => $decryptedId,
                'user_id' => $this->loginId,
                'treat_date' => $treatment_date_general,
                'treat_time' => $treatment_time,
                'total' => $orig_price_total,
                'discount' => $total_discount,
                'followup'  => $followup,
                'insurance_type'  => $patient->insurance_type,
                'department_id' => 4
            );

           
        }else{
            $treatment_payment_data = array(
                'patient_id'  => $decryptedId,
                'user_id' => $this->loginId,
                'treat_date' => $treatment_date_general,
                'treat_time' => $treatment_time,
                'total' => 0,
                'discount' => 0,
                'followup'  => $followup,
                'insurance_type'  => $patient->insurance_type,
                'department_id' => 4
            );
        }
        $treatement_payment_id = $this->PatientsModel->insert_data('tbl_treatment_payment', $treatment_payment_data);
            if ($triage_weight != '' || $triage_height != '' || $triage_bmi != '' || $triage_bp != '' || $triage_temperature != '' || $triage_pulse != '' || $triage_rr != '') {

                $newdata = array(
                    'patient_id' => $decryptedId,
                    'create_by' => $this->loginId,
                    'weight' => $triage_weight,
                    'height' => $triage_height,
                    'bmi' => $triage_bmi,
                    'bp' => $triage_bp,
                    'temperature' => $triage_temperature,
                    'pulse' => $triage_pulse,
                    'rr' => $triage_rr,
                    'treatment_id' => $treatement_payment_id
                );
    
                $this->PatientsModel->insert_data('tbl_nurse_triage', $newdata);
            }

            $dental_data = array(
                'chief_complaint_general'  => $chief_complaint_general,
                'subjective_general' => $subjective_general,
                'objective_general' => $objective_general,
                'assessment_general' => $assessment_general,
                'recommendation_general' => $recommendation_general,
                'note' => $note,
                'treatment_payment_id' => $treatement_payment_id ?? 0
            );

            $this->PatientsModel->insert_data('tbl_treat_ent', $dental_data);
            // if($followup == 0){
            for ($i = 0; $i < count($treatment_id); $i++) {

                $newdata = array(
                    'procedure_id' => $treatment_id[$i],
                    'episode_type' => 1,
                    'diagnostise_id' => $diagnosis_id[$i],
                    'fees' => $fees[$i],
                    'discount_qr' => $discount[$i],
                    'discount_per' => $discount_per[$i],
                    'treatement_payment_id' => $treatement_payment_id ?? 0,
                    'aditional_diagnostise_name' => $diagnosis_name[$i],
                    'orig_price' => $fees[$i]
                );

                $this->PatientsModel->insert_data('tbl_episode_payment', $newdata);
            }
        // }

            $files = $_FILES;
			$file_exist = $_FILES['attach_general']['size'];
			$db_attachment = array();
			if (array_filter($file_exist)) {

				$this->load->library('upload');

				$cpt = count($_FILES['attach_general']['name']);
				$config = array();
				$config['upload_path'] = './'.UPLOAD_PATH.'ent/';
				$config['allowed_types'] = '*';
				$config['max_size']      = '*';
				$config['overwrite']     = TRUE;

				$last_id = $this->doctor_retrive->get_last_attachment($pid, '11');
				if (isset($last_id) and $last_id != NULL) {
					$ctr_array = explode("-", $last_id->attachment);
					$j = $ctr_array[1] + 1;
				} else {
					$j = 1;
				}


				for ($i = 0; $i < $cpt; $i++) {
					$_FILES['attach_general']['name'] = $files['attach_general']['name'][$i];
					$_FILES['attach_general']['type'] = $files['attach_general']['type'][$i];
					$_FILES['attach_general']['tmp_name'] = $files['attach_general']['tmp_name'][$i];
					$_FILES['attach_general']['error'] = $files['attach_general']['error'][$i];
					$_FILES['attach_general']['size'] = $files['attach_general']['size'][$i];

					$ext = strtolower(pathinfo($_FILES['attach_general']['name'], PATHINFO_EXTENSION));
					$newfilename = $pid . '-' . $j . '.' . $ext;

					$config['file_name'] = $newfilename;

					$this->upload->initialize($config);

					if (!$this->upload->do_upload('attach_general')) {

						echo $this->upload->display_errors();
					} else {
						array_push($db_attachment, $newfilename);
					}
					$j++;
				}

				if (!empty($db_attachment)) {
					$count_attachment = count($db_attachment);

					for ($i = 0; $i < $count_attachment; $i++) {
						$newdata = array(
							'attachment' => $db_attachment[$i],
							'date' => $treatment_date,
							'user_id' => $user_id,
							'category' => 11,
							'patient_id' => $decryptedId,
							'treat_id' => $treatement_payment_id

						);

						$this->insert_process->get_id_insert('attachment', $newdata);
					}
				}
			}
            if($followup == 2){
                $this->PatientsModel->updateSessions($decryptedId,$assigned_package,4);
                 
                 
              }

            if ($this->db->trans_status() === FALSE) {
                $this->db->trans_rollback();
            } else {
                $this->db->trans_commit();
            }
            $this->session->set_flashdata('success', 'ENT Treatment saved successfully.');
            redirect('admin/Patients/PatientsController/medical_book/' . $patient_id, 'refresh');
        } catch (Exception $e) {
            $this->db->trans_rollback();
            echo $e;
            $this->session->set_flashdata('Error', 'ENT Treatment not saved.');
            redirect('admin/Patients/PatientsController/medical_book/' . $patient_id, 'refresh');
            exit;
        }

        $this->db->trans_complete();
    }

    public function update()
    {

        $patient_id = $this->input->post('patient_id');
        $treatement_payment_id = $this->input->post('treatement_payment_id');
        $decryptedId = decrypt_and_url_decode($patient_id, $this);
        $patient = $this->PatientsModel->get_patient_details('patient_id', $decryptedId);

        $result['active_menu'] = 15;
        $result['active_submenu'] = 1;

        $treatment_date_general = $this->input->post('treatment_date_general');
        $chief_complaint_general = $this->input->post('chief_complaint_general');
        $subjective_general = $this->input->post('subjective_general');
        $objective_general = $this->input->post('objective_general');
        $assessment_general = $this->input->post('assessment_general');
        $recommendation_general = $this->input->post('recommendation_general');

        $diagnosis_general = $this->input->post('diagnosis_general');

        $diagnosis_id = $this->input->post('general_diagnosis_id');
        $diagnosis_name = $this->input->post('general_diagnosis_name');
        $treatment_name = $this->input->post('general_treatment_name');
        $treatment_id = $this->input->post('general_treatment_id');
        $fees = $this->input->post('orig_price_general');

        $discount = $this->input->post('discount_general');
        $discount_per = $this->input->post('discount_per_general');

        $drug_id = $this->input->post('drug_id_ent');
        $drug_name = $this->input->post('drug_name_ent');
        $drugs_qty = $this->input->post('drugs_qty_ent');
        $meals = $this->input->post('meals_ent');
        $drug_notes = $this->input->post('drug_notes_ent');

        $user_id = $this->session->userdata('user_id');

        $triage_weight = $this->input->post('triage_weight');
        $triage_height = $this->input->post('triage_height');
        $triage_bmi = $this->input->post('triage_bmi');
        $triage_bp = $this->input->post('triage_bp');
        $triage_temperature = $this->input->post('triage_temperature');
        $triage_pulse = $this->input->post('triage_pulse');
        $triage_rr = $this->input->post('triage_rr');
        $note = $this->input->post('note');

        $treatment_date = $this->input->post('treatment_date');
        $treatment_time = $this->input->post('treatment_time');
        if (is_array($fees)) {
            $total = array_sum($fees);
        }

        if (is_array($fees)) {
            $orig_price_total = array_sum($fees);
        }

        if (is_array($discount)) {
            $total_discount = array_sum($discount);
        }

        $this->db->trans_start();
        try {
            $treatment_payment_data = array(
                'patient_id'  => $decryptedId,
                'user_id' => $this->loginId,
                'treat_date' => $treatment_date_general,
                'treat_time' => $treatment_time,
                'total' => $orig_price_total,
                'discount' => $total_discount,
                'followup'  => 0,
                'insurance_type'  => $patient->insurance_type,
                'department_id' => 4
            );

            if ($triage_weight != '' || $triage_height != '' || $triage_bmi != '' || $triage_bp != '' || $triage_temperature != '' || $triage_pulse != '' || $triage_rr != '') {

                $newdata = array(
                    'patient_id' => $decryptedId,
                    'create_by' => $this->loginId,
                    'weight' => $triage_weight,
                    'height' => $triage_height,
                    'bmi' => $triage_bmi,
                    'bp' => $triage_bp,
                    'temperature' => $triage_temperature,
                    'pulse' => $triage_pulse,
                    'rr' => $triage_rr,
                    'treatment_id' => $treatement_payment_id
                );
    
                $this->PatientsModel->update_data_where('tbl_nurse_triage', 'treatment_id', $treatement_payment_id, $newdata);
            }

            $dental_data = array(
                'chief_complaint_general'  => $chief_complaint_general,
                'subjective_general' => $subjective_general,
                'objective_general' => $objective_general,
                'assessment_general' => $assessment_general,
                'recommendation_general' => $recommendation_general,
                'note' => $note,
            );


            $this->PatientsModel->update_data_where('tbl_treatment_payment', 'treatement_payment_id', $treatement_payment_id, $treatment_payment_data);
            $this->PatientsModel->update_data_where('tbl_treat_ent', 'treatment_payment_id', $treatement_payment_id, $dental_data);
            $this->PatientsModel->delete_data_where('tbl_episode_payment', 'treatement_payment_id', $treatement_payment_id);

            for ($i = 0; $i < count($treatment_id); $i++) {

                $newdata = array(
                    'procedure_id' => $treatment_id[$i],
                    'episode_type' => 1,
                    'diagnostise_id' => $diagnosis_id[$i],
                    'fees' => $fees[$i],
                    'discount_qr' => $discount[$i],
                    'discount_per' => $discount_per[$i],
                    'treatement_payment_id' => $treatement_payment_id,
                    'aditional_diagnostise_name' => $diagnosis_name[$i],
                    'orig_price' => $fees[$i]
                );

                $this->PatientsModel->insert_data('tbl_episode_payment', $newdata);
            }

            if ($this->db->trans_status() === FALSE) {
                $this->db->trans_rollback();
            } else {
                $this->db->trans_commit();
            }
            $this->session->set_flashdata('success', 'ENT Treatment Updated Successfully.');
            redirect('admin/Patients/PatientsController/medical_book/' . $patient_id, 'refresh');
        } catch (Exception $e) {
            $this->db->trans_rollback();
            echo $e;
            exit;
        }

        $this->db->trans_complete();
    }

    public function edit($treatement_payment_id)
    {
        $decryptedId = decrypt_and_url_decode($treatement_payment_id, $this);
        $data['invoice'] = $this->PatientsModel->retrieve_data_unique_row('tbl_treatment_payment', 'treatement_payment_id', $decryptedId);
        $data['episodes'] = $this->PatientsModel->get_treatment_episodes($decryptedId);
        $data['ent'] = $this->PatientsModel->retrieve_data_unique_row('tbl_treat_ent', 'treatment_payment_id', $decryptedId);
        $data['patient_id'] = $data['invoice']->patient_id;
        $data['treatment_payment_id'] = $decryptedId;

        // print_r($data);die;

        $this->load->view('admin/Modules/ENT/ENTEdit', $data);
    }
}
