<?php

class PrescriptionController extends MY_Controller
{

    function __construct()
    {
        parent::__construct();

        date_default_timezone_set('Asia/Kuwait');

        $this->load->model('admin/CommonModel');
        $this->load->model('admin/Patients/PatientsModel');
        $this->load->model('admin/Prescription/PrescriptionModel');

        $this->load->library('upload');
    }

    public function get_drugs()
    {
        if ($_GET['type'] == 'drug') {

            $name_startsWith = $this->input->get('name_startsWith');
            $drugs = $this->PrescriptionModel->search_drugs($name_startsWith);

            $this->output
                ->set_content_type('application/json')
                ->set_output(json_encode($drugs));
        }
    }

    public function get_auto_complete()
    {
        if ($this->input->get('type') == 'diagnosis') {
            $name_startsWith = $this->input->get('name_startsWith');
            $category_id = $this->input->get('category_id');

            $data = $this->PrescriptionModel->getAutoComplete($name_startsWith, $category_id);

            $this->output
                ->set_content_type('application/json')
                ->set_output(json_encode($data));
        }
    }

    public function get_diagnosis_multi()
    {
        $term = $this->input->get('term');
        $data = $this->PrescriptionModel->getDiagnosisMulti($term);

        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($data));
    }

    public function insert_prescription()
    {
        $drug_id = $this->input->post('drug_id');
        $drugs_qty = $this->input->post('drugs_qty');
        $meals = $this->input->post('meals');
        $drug_notes = $this->input->post('drug_notes');
        $drug_name = $this->input->post('drug_name');
        $patient_id = explode(' - ', $this->input->post('patient_id'));
        $pid = $patient_id[0];
        $diagnostise_id = $this->input->post('diagnosis_auto');

        $date_string = '%Y-%m-%d';
        $curr_date = mdate($date_string);

        $doctor_id = $this->session->userdata('user_Id');

        if ($drug_id) {
            $newdata = [
                'enter_date' => $curr_date,
                'patient_id' => $pid,
                'doctor_id'  => $doctor_id,
                'diagnostise_id' => $diagnostise_id
            ];

            $prescription_main_id = $this->PrescriptionModel->insert_data('tbl_prescription_main', $newdata);

            if (is_array($drug_id)) {
                for ($i = 0; $i < count($drug_id); $i++) {
                    $newdata = [
                        'prescription_id' => $prescription_main_id,
                        'prescription_main_id' => $prescription_main_id,
                        'drug_id' => $drug_id[$i],
                        'drug_name' => $drug_name[$i],
                        'drug_qty' => $drugs_qty[$i],
                        'drug_note' => $drug_notes[$i],
                        'after_before' => $meals[$i],
                        'patient_id' => $pid,   
                        'log_id' => NULL
                    ];

                    $this->PrescriptionModel->insert_data('tbl_prescription', $newdata);
                }
            }
        }

        $user_id = $this->session->userdata('user_Id');
        if (is_array($drug_id)) {
            for ($i = 0; $i < count($drug_id); $i++) {

                for ($x = 6; $x < 9; $x++) {
                    switch ($x) {
                        case 6:
                            $text = $drugs_qty[$i];
                            break;
                        case 7:
                            $text = $meals[$i];
                            break;
                        case 8:
                            $text = $drug_notes[$i];
                            break;
                    }
                    $temp = $this->PrescriptionModel->retrieve_data_unique_row('tbl_auto_complete', 'content', $text);

                    if (!$temp) {

                        $newdata = [
                            'content'  => $text,
                            'category'  => $x,
                            'user_id'  => $user_id,
                            'rating'  => 1,
                        ];

                        $this->PrescriptionModel->insert_data('tbl_auto_complete', $newdata);
                    } else {
                        $this->PrescriptionModel->update_data_where('tbl_auto_complete', 'auto_complete_id', $temp->auto_complete_id, ['rating' => $temp->rating + 1]);
                    }
                }
            }
        }

        $data['alert_msg'] = '';
        $data['error'] = '';
        $data['success'] = 'Prescription has added successfully';
        $this->session->set_flashdata('success', 'Prescription has added successfully.');
        redirect(base_url('index.php/admin/Modules/Prescription/PrescriptionController/print_patient_prescription/' . encrypt_and_url_encode($prescription_main_id, $this) . "/" . encrypt_and_url_encode($pid, $this)));
    }

    public function print_patient_prescription($id, $patient_id)
    {

        $id = decrypt_and_url_decode($id, $this);
        $patient_id = decrypt_and_url_decode($patient_id, $this);

        $data['clinic_info'] = $this->PrescriptionModel->retrieve_data_unique_row('tbl_company');
        $data['prescription'] = $this->PrescriptionModel->single_prescription_list($id);
        $data['prescription_main'] = $this->PrescriptionModel->retrieve_data_unique_row('tbl_prescription_main', 'prescription_main_id', $id);
        $data['doctor_info'] = $this->PrescriptionModel->retrieve_data_unique_row('tbl_employees', 'user_id', $data['prescription_main']->doctor_id);
        $data['patient_info'] = $this->PrescriptionModel->get_patientdata($patient_id);
        $data['patient_id'] = $patient_id;
        $this->load->view('admin/Modules/Prescription/prescriptionEdit', $data);
    }

    public function load_patient_prescriptions($id)
    {

        $draw = $this->input->get('draw');
        $length = $this->input->get('length');
        $start = $this->input->get('start');
        $search = $this->input->get('search')['value'];
        $id = decrypt_and_url_decode($id, $this);

        $records = $this->PrescriptionModel->get_patient_prescription($id);

        $total_records = count($records);

        $response = [
            "draw" => intval($draw),
            "recordsTotal" => $total_records,
            "recordsFiltered" => $total_records,
            "data" => $records
        ];

        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($response));
    }

    public function prescription_delete($prescription_id, $patient_id)
    {
        $prescription_id = decrypt_and_url_decode($prescription_id,$this);
        $patient_id = decrypt_and_url_decode($patient_id,$this);
        $user_id = $this->session->userdata('user_Id');
                
        $this->PrescriptionModel->delete_prescription($prescription_id, $patient_id, $user_id);

        $this->session->set_flashdata('success', 'Prescription deleted successfully.');
        redirect(base_url('index.php/admin/Patients/PatientsController/medical_book/' . encrypt_and_url_encode($patient_id, $this)));
    }
}
