<?php


class FilterController extends MY_Controller
{

    function __construct()
    {
        parent::__construct();

        $this->load->model('admin/Pharmacy/PharmacyModel');
        $this->load->model('admin/Patients/PatientsModel');
        $this->load->model('admin/Payments/PaymentsModel');
        $this->load->model('admin/Reports/ReportsModel','report_retrive');
        $this->load->model('admin/ConsentForm/ConfigurationRetriveModel');
        $this->load->model('admin/Pharmacy/SubModels/inquiry', 'inquiry_model');
        $this->load->model('admin/Pharmacy/SubModels/bill', 'bill_model');
        $this->load->model('admin/Pharmacy/SubModels/financial', 'financial_model');
        $this->load->model('admin/Pharmacy/SubModels/supplier', 'supplier_model');
        $this->load->model('admin/Pharmacy/SubModels/inventory', 'inventory_model');
        $this->load->model('admin/Pharmacy/SubModels/quantity', 'quantity_model');
        $this->load->model('admin/Pharmacy/SubModels/statement', 'statement_model');
        $this->load->model('admin/Pharmacy/SubModels/categories', 'categories_model');
        $this->load->model('admin/Pharmacy/SubModels/items', 'items_model');
        $this->load->model('admin/Pharmacy/SubModels/locations', 'locations_model');
        $this->load->model('admin/Pharmacy/SubModels/pos', 'PosModel');
        $this->load->model('admin/Pharmacy/SubModels/drugsmodel');
   

        $this->load->library('upload');
    }


    public function expire_filters() {
        $data['suppliers'] = $this->report_retrive->retrieve_data('sh_supplier');
        $data['drugs'] = $this->report_retrive->get_items();
        $this->load->view('admin/Pharmacy/Filters/expire_filters',$data);
    }

    public function sales_filters() {
        $data['suppliers'] = $this->report_retrive->retrieve_data('sh_supplier');
        $this->load->view('admin/Pharmacy/Filters/sales_filters',$data);
    }

    public function store_filters() {
        
        $data['drugs'] = $this->report_retrive->get_items();
        $this->load->view('admin/Pharmacy/Filters/store_filters', $data);
    }
    public function transactions_filters() {
        
        $data['payment_methods'] = $this->report_retrive->get_payment_types();
        $this->load->view('admin/Pharmacy/Filters/transaction_filters', $data);
    }   
    public function supplier_filters() {
        
        $data['suppliers'] = $this->report_retrive->retrieve_data('sh_supplier');
        $data['cashiers'] = $this->report_retrive->retrieve_data('tbl_users');
        $data['drugs'] = $this->report_retrive->get_items();
        $this->load->view('admin/Pharmacy/Filters/supplier_filter', $data);
    }   
    public function drug_filters() {
        
        $data['drugs'] = $this->report_retrive->get_items();
        $this->load->view('admin/Pharmacy/Filters/drug_filter', $data);
    }   
    public function profit_filters() {
        $data['suppliers'] = $this->report_retrive->retrieve_data('sh_supplier');
        $data['drugs'] = $this->report_retrive->get_items();
        $this->load->view('admin/Pharmacy/Filters/profit_filter', $data);
    } 
    public function sale_refund_filters() {
        $data['suppliers'] = $this->report_retrive->retrieve_data('sh_supplier');
        $data['drugs'] = $this->report_retrive->get_items();
        $this->load->view('admin/Pharmacy/Filters/sale_refund', $data);
    } 
    public function purchase_refund_filters() {
        $data['suppliers'] = $this->report_retrive->retrieve_data('sh_supplier');
        $data['drugs'] = $this->report_retrive->get_items();
        $this->load->view('admin/Pharmacy/Filters/purchase_refund', $data);
    } 
    public function expiringItems() {
        $data['suppliers'] = $this->report_retrive->retrieve_data('sh_supplier');
        $data['drugs'] = $this->report_retrive->get_items();
        $this->load->view('admin/Pharmacy/Store/expiringTabs', $data);
    } 
    public function expiredItems() {
        $data['suppliers'] = $this->report_retrive->retrieve_data('sh_supplier');
        $data['drugs'] = $this->report_retrive->get_items();
        $this->load->view('admin/Pharmacy/Store/expiredTabs', $data);
    } 
    



}