<?php

class ProductsController extends MY_Controller {

    function __construct() {
        parent::__construct();

        //Commen -------------------------------------
        $this->load->model('admin/CommonModel');
        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');

        $this->load->model('admin/Products/ProductsModel');
    }

    public function index() {
		
        if ($this->session->userdata('user_Id') != '') {

            //Commen -------------------------------------
            $loginId = $this->session->userdata('user_Id');
            $data['active_menu'] = 14;
            $data['active_submenu'] = 3;
            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);
			
			$data['page_count'] = $this->config->item('page_count');
			$data['page'] = 0;
			$data['search_url'] = 'Products/ProductsController/search/';
			$data['form'] = 'submitForm';
			
			$product_name='';
			$data['product_name']=$product_name;
			
			$product_code='';
			$data['product_code']=$product_code; 
			
			$is_new_arrival='';
			$data['is_new_arrival']=$is_new_arrival;
			
			$is_best_seller='';
			$data['is_best_seller']=$is_best_seller;
			
			$is_get_free='';
			$data['is_get_free']=$is_get_free;
			
			self::populate_search_critaria($data);
		 
			$data_list = $this->ProductsModel->getList($product_name,$product_code,$is_new_arrival,$is_best_seller,$is_get_free,$data);
			
			$data['paginationData'] = $data_list;
			$data['dataList']= $data_list;

            $this->load->view('admin/Products/ProductsList', $data);
			
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
		
    }
	
	   public function search($page=0) {
		
        if ($this->session->userdata('user_Id') != '') {

            //Commen -------------------------------------
            $loginId = $this->session->userdata('user_Id');
            $data['active_menu'] = 14;
            $data['active_submenu'] = 3;
            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);
			
			$data['page_count'] = $this->config->item('page_count');
			$data['page'] = $page;
			$data['search_url'] = 'Products/ProductsController/search/';
			$data['form'] = 'submitForm';
			
			$product_name=$this->input->post('product_name');
			$data['product_name']=$product_name;
			
			$product_code=$this->input->post('product_code');
			$data['product_code']=$product_code;
			
			$is_new_arrival=$this->input->post('is_new_arrival');
			$data['is_new_arrival']=$is_new_arrival;
			
			$is_get_free=$this->input->post('is_get_free');
			$data['is_get_free']=$is_get_free;
			
			$is_best_seller=$this->input->post('is_best_seller');
			$data['is_best_seller']=$is_best_seller;
			//print_r($data['product_code']);die;
	
			self::save_search_critaria($data);
			
			
			$data_list = $this->ProductsModel->getList($product_name,$product_code,$is_new_arrival,$is_best_seller,$is_get_free,$data);
			
			$data['paginationData'] = $data_list;
			$data['dataList']= $data_list;

            $this->load->view('admin/Products/ProductsList', $data);
			
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
		
    }
	
	 public function save_search_critaria( $data ) {

        //print_r($data);die;
        $search_data = Array(
            'search_context' => 'SEARCH_Product_Code_And_Product_Code',
            'product_code' => $data[ 'product_code' ],
            'product_name' => $data[ 'product_name' ],
         

        );

        $this->session->set_userdata( 'search_data', $search_data );
    }



   public function populate_search_critaria( & $data ) {

        $search_data = $this->session->userdata( 'search_data' );


        if ( $search_data == null  ||  !array_key_exists ('search_context',$search_data) || $search_data['search_context'] != 'SEARCH_Product_Code_And_Product_Code' ) {
           
            $product_code = "";
            $product_name = "";


            $data[ 'product_code' ] = $product_code;
            $data[ 'product_name' ] = $product_name;
			
            self::save_search_critaria($data);
        } else {
           $product_code =  $search_data[ 'product_code' ];
           $product_name =  $search_data[ 'product_name' ];
   
            $data[ 'product_code' ] = $product_code;
            $data[ 'product_name' ] = $product_name;
        }

       
    }

	
	public function createnew() {
		
        if ($this->session->userdata('user_Id') != '') {

            //Commen -------------------------------------
            $loginId = $this->session->userdata('user_Id');
            $data['active_menu'] = 14;
            $data['active_submenu'] = 3;
            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);
			
			$_id = 0;
			$product_name = '';
			$product_code = '';
			$description = '';
			$additional_description = '';
			$price = '';
			$tag_ids = array();
			$category_ids = array();
			$item_image = 'dist/img/empty.png';
			$is_new_image = 'false';
			$is_active = '';
			$is_new_arrival = '';
			$is_get_free = '';
			$is_best_seller = '';
			$status = 'N/A';
			$updated_datetime = date('Y-m-d');
			
			
			$data['_id'] = $_id;
			$data['product_name'] = $product_name;
			$data['product_code'] = $product_code;
			$data['description'] = $description;
			$data['additional_description'] = $additional_description;
			$data['price'] = $price;
			$data['tag_ids'] = $tag_ids;
			$data['category_ids'] = $category_ids;
			$data['item_image'] = $item_image;
			$data['is_new_image'] = $is_new_image;
			$data['is_active'] = $is_active;
			$data['is_new_arrival'] = $is_new_arrival;
			$data['is_get_free'] = $is_get_free;
			$data['is_best_seller'] = $is_best_seller;
			$data['status'] = $status;
			$data['updated_datetime'] = $updated_datetime;
			
			$data['tags'] = $this->CommonModel->get_tags();
			$data['categories'] = $this->CommonModel->get_categories();
			
			$data['colors'] = $this->CommonModel->get_colors();
			$data['sizes'] = $this->CommonModel->get_sizes();
			
			$data['flavours'] = $this->ProductsModel->get_flavours($_id);
			$data['productImages'] = $this->ProductsModel->get_productImages($_id);

			
            $this->load->view('admin/Products/Products', $data);
			
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
		
    }
	
	public function save() {
		
        if ($this->session->userdata('user_Id') != '') {

            //Commen -------------------------------------
            $loginId = $this->session->userdata('user_Id');
            $data['active_menu'] = 14;
            $data['active_submenu'] = 3;
            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);
			
			$_id = $this->input->post('_id');
			$product_name = $this->input->post('product_name');
			$product_code = $this->input->post('product_code');
			$description = $this->input->post('description');
			$additional_description = $this->input->post('additional_description');
			$price = $this->input->post('price');
			$tag_ids = $this->input->post('ddl_tag_multiple');
			$category_ids = $this->input->post('ddl_categories_multiple');
			$item_image = $this->input->post('item_image');
			//print_r($item_image);die;
			$is_new_image = $this->input->post('is_new_image');
			$is_active = $this->input->post('is_active');
			$is_new_arrival = $this->input->post('is_new_arrival');
			$is_get_free = $this->input->post('is_get_free');
			$is_best_seller = $this->input->post('is_best_seller');
			$status = $this->input->post('status');
			$updated_datetime = $this->input->post('updated_datetime');
			
			
			$data['_id'] = $_id;
			$data['product_name'] = $product_name;
			$data['product_code'] = $product_code;
			$data['description'] = $description;
			$data['additional_description'] = $additional_description;
			$data['price'] = $price;
			$data['tag_ids'] = $tag_ids;
			$data['category_ids'] = $category_ids;
			$data['item_image'] = $item_image;
			$data['is_new_image'] = $is_new_image;
			$data['is_active'] = $is_active;
			$data['is_new_arrival'] = $is_new_arrival;
			$data['is_get_free'] = $is_get_free;
			$data['is_best_seller'] = $is_best_seller;
			$data['status'] = $status;
 
			$data['updated_datetime'] = $updated_datetime;
			
 
			$data['tags'] = $this->CommonModel->get_tags();
			$data['categories'] = $this->CommonModel->get_categories();
			//$data['dataList'] = $this->ProductsModel->getList($product_name,$product_code);
			
			
			//items
			$flavours_details = array();
            $line_id = -1;
			foreach ($_POST as $key => $value) {
                if ((strpos($key, 'grid_flavour_') === 0)) {
                    if ($line_id != explode("_", $key)[3]) {
                        $line_id = explode("_", $key)[3];
						
                        $flavours_details[] = array(
                            'flavour_id' => $this->input->post('grid_flavour_id_' . $line_id),
                            'image_path' => $this->input->post('grid_flavour_image_' . $line_id),
                            'is_new_image' => $this->input->post('grid_flavour_isNewImage_' . $line_id),
                            'flavour_code' => $this->input->post('grid_flavour_code_' . $line_id),
                            'flavour_name' => $this->input->post('grid_flavour_name_' . $line_id),
                            'flavour_price' => $this->input->post('grid_flavour_price_' . $line_id),
                            'gbp_price' => $this->input->post('grid_gbp_price_' . $line_id),
                            'eur_price' => $this->input->post('grid_eur_price_' . $line_id),   
				
							'created_by' => $loginId,  
							'created_datetime' => date('Y-m-d H:i:s')
							
                        );
						
						$this->form_validation->set_rules("grid_flavour_code_".$line_id, "code", 'trim|required');
						$this->form_validation->set_rules("grid_flavour_name_".$line_id, "name", 'trim|required');
						$this->form_validation->set_rules("grid_flavour_price_".$line_id, "price", 'trim|required');
						$this->form_validation->set_rules("grid_gbp_price_".$line_id, "price", 'trim|required');
						$this->form_validation->set_rules("grid_eur_price_".$line_id, "price", 'trim|required');
						
						$flavour_code = $this->input->post('grid_flavour_code_' . $line_id);
						$flavour_name = $this->input->post('grid_flavour_name_' . $line_id);
						$flavour_id = $this->input->post('grid_flavour_id_' . $line_id);
						
						if($_id > 0 ) {
							$is_available_code = self::flavourCodeCheck($flavour_code,$flavour_name,$flavour_id,$_id); //flavour_code should color_id,flavour_name should be size id  
							
							if($is_available_code == 'true'){
								$this->form_validation->set_rules("grid_flavour_code_".$line_id, "code", 'callback_flavourCode_check');
							}
						}
						
                    }
                }
            }
			$data["flavours"] = $flavours_details;
			
			
			//items
			$is_image_available = false;
			$is_defaultImage = false;
			$productImages = array();
            $line_id = -1;
			foreach ($_POST as $key => $value) {
                if ((strpos($key, 'product_images_') === 0)) {
                    if ($line_id != explode("_", $key)[3]) {
                        $line_id = explode("_", $key)[3];
						
						$is_image_available = true;
						$is_default_image = $this->input->post('product_images_isDefaultImage_' . $line_id);
						
                        $productImages[] = array(
                            'id' => $this->input->post('product_images_imageId_' . $line_id),
                            'image_path' => $this->input->post('product_images_imagePath_' . $line_id),
                            'is_default_image' => $is_default_image == 1 ? 1 : 0,
							
                        );
						
						if($is_default_image == 1){
							$is_defaultImage = true;
						}
						
                    }
                }
            }

			
			$data["productImages"] = $productImages;
			
			
			if($tag_ids == null || $tag_ids == '') {
				$this->form_validation->set_rules('tag_ids', 'tag_ids', 'callback_tag_check');
			}
			
			if($category_ids == null || $category_ids == '') {
				$this->form_validation->set_rules('category_ids', 'category_ids', 'callback_category_check');
			}
			
			if($is_image_available == false){
				$this->form_validation->set_rules('product_images', 'product', 'callback_image_check');
			}
			
			if($is_image_available == true && $is_defaultImage == false){
				$this->form_validation->set_rules('product_images', 'product', 'callback_defaultImage_check');
			}
			
			$this->form_validation->set_rules('product_name', 'product name', 'trim|required|callback_name_check');
			$this->form_validation->set_rules('product_code', 'product code', 'required|callback_code_check');
			$this->form_validation->set_rules('description', 'description', 'trim|required');
			$this->form_validation->set_rules('additional_description', 'Additional Description', 'trim|required');
			//$this->form_validation->set_rules('price', 'price', 'trim|required');
			
			$data['colors'] = $this->CommonModel->get_colors();
			$data['sizes'] = $this->CommonModel->get_sizes();
			
			

			if ($this->form_validation->run() == FALSE) {
				
                $this->load->view('admin/Products/Products', $data);
                return;
				
            }
			
			$tags = self::get_tags_text($tag_ids);
			$categories = self::get_categories_text($category_ids);
			
			
			$data_save = array (

				'product_name' => $product_name,
				'product_code' => $product_code,
				'description' => $description,
				'additional_description' => $additional_description,
				'tag_ids' => implode(", ", $tag_ids),
				'category_ids' => implode(", ", $category_ids),
				'tags' => $tags,
				'categories' => $categories,
				'image_path' => '',
				'status' => $status,
				'is_active' => $is_active == 'active' ? 1 : 0,
				'is_new_arrival' => $is_new_arrival == 'new arrival' ? 1 : 0,
				'is_get_free' => $is_get_free == 'get free' ? 1 : 0,
				'is_best_seller' => $is_best_seller == 'best seller' ? 1 : 0,
				
				'created_by' => $loginId,
				'created_datetime' => date('Y-m-d H:i:s'),
				'updated_by' => 0,
				'updated_datetime' => date('Y-m-d H:i:s')

			);
			
			if($_id > 0 ) {
				
				$this->ProductsModel->update($_id,$data_save,$is_new_image,$item_image,$flavours_details,$productImages);
				
			} else {
				
				$this->ProductsModel->save($data_save,$is_new_image,$item_image,$flavours_details,$productImages);
				
			}
			
			
			redirect('admin/Products/ProductsController', 'refresh');

			
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
		
    }
	
	public function edit() {
		
        if ($this->session->userdata('user_Id') != '') {

            //Commen -------------------------------------
            $loginId = $this->session->userdata('user_Id');
            $data['active_menu'] = 14;
            $data['active_submenu'] = 3;
            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);
			
			$_id = base64_decode(urldecode($this->input->post('selected_id')));
			
			if($_id != null && $_id != ''){
			
				$details = $this->ProductsModel->get_details_by_id($_id);
				foreach ($details->result() as $row) {

					$product_name = $row->product_name;
					$product_code = $row->product_code;
					$description = $row->description;
					$additional_description = $row->additional_description;
					$price = $row->price;
					$tag_ids = explode(", ", $row->tag_ids);
					$category_ids = explode(", ", $row->category_ids);
					$item_image = $row->image_path;
					$updated_datetime = $row->updated_datetime;
					$is_new_image = false;
					$is_active = $row->is_active == 1 ? 'active' : '';
					$is_new_arrival = $row->is_new_arrival == 1 ? 'new arrival' : '';
					$is_get_free = $row->is_get_free == 1 ? 'get free' : '';
					$is_best_seller = $row->is_best_seller == 1 ? 'best seller' : '';
					$status = $row->status;

				}

				$data['_id'] = $_id;
				$data['product_name'] = $product_name;
				$data['product_code'] = $product_code;
				$data['description'] = $description;
				$data['additional_description'] = $additional_description;
				$data['price'] = $price;
				$data['tag_ids'] = $tag_ids;
				$data['category_ids'] = $category_ids;
				$data['item_image'] = $item_image;
				$data['updated_datetime'] = $updated_datetime;
				
				$data['is_new_image'] = $is_new_image;
				$data['is_active'] = $is_active;
				$data['is_new_arrival'] = $is_new_arrival;
				$data['is_get_free'] = $is_get_free;
				$data['is_best_seller'] = $is_best_seller;
				$data['status'] = $status;

				$data['tags'] = $this->CommonModel->get_tags();
				$data['categories'] = $this->CommonModel->get_categories();
				$data['flavours'] = $this->ProductsModel->get_flavours($_id);
				$data['productImages'] = $this->ProductsModel->get_productImages($_id);
				//$data['dataList'] = $this->ProductsModel->getList($product_name,$product_code);
			
				$data['colors'] = $this->CommonModel->get_colors();
				$data['sizes'] = $this->CommonModel->get_sizes();
//print_r($data['is_new_arrival']);die;
				$this->load->view('admin/Products/Products', $data);
				
			} else {
				
				redirect('admin/CommenController/page_not_found', 'refresh');
				
			}
			
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
		
    }

    public function delete() {
        
        if ($this->session->userdata('user_Id') != '') {
            
            $_id = base64_decode(urldecode($this->input->post('selected_id')));
			
			if($_id == '' || $_id == null){
				$_id = 0;
			}
			
			
			$this->CommonModel->update_column('tbl_products','product_id',$_id,'is_delete',1);
			
			redirect('admin/Products/ProductsController', 'refresh');
			

        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
        
    }
	
	
	public function get_tags_text($tag_ids) {
		
		$clmn_tags = '';
		
		for ($i = 0; $i < count($tag_ids); $i++) {
			$tags = $this->ProductsModel->get_tag_by_id($tag_ids[$i]);
			foreach ($tags->result() as $row) {
				$tag = $row->tag;
			}
			if($clmn_tags == ''){
				$clmn_tags = $tag;
			} else {
				$clmn_tags = $clmn_tags.", ".$tag;
			}
		}
		
		return $clmn_tags;
		
	}
	
	public function get_categories_text($category_ids) {
		
		$clmn_categories = '';
			
		for ($i = 0; $i < count($category_ids); $i++) {
			$categories = $this->ProductsModel->get_category_by_id($category_ids[$i]);
			foreach ($categories->result() as $row) {
				$category = $row->category;
			}
			if($clmn_categories == ''){
				$clmn_categories = $category;
			} else {
				$clmn_categories = $clmn_categories.", ".$category;
			}
		}
		
		return $clmn_categories;
		
	}
	
	
	//validations
	public function tag_check() {
		
		$this->form_validation->set_message('tag_check', 'Please select tags.');
		return FALSE;
		
    }
	
	public function category_check() {
		
		$this->form_validation->set_message('category_check', 'Please select categories.');
		return FALSE;
		
    }
	
	public function image_check() {
		
		$this->form_validation->set_message('image_check', 'At least one image required.');
		return FALSE;
		
    }
	
	public function defaultImage_check() {
		
		$this->form_validation->set_message('defaultImage_check', 'Please select default image.');
		return FALSE;
		
    }

    public function name_check() {
		
        $this->db->where('product_name', trim($this->input->post('product_name')));
        $this->db->where_not_in('product_id', $this->input->post('_id'));
        $query = $this->db->get('tbl_products');

        if ($query->num_rows() > 0) {
            $this->form_validation->set_message('name_check', 'Product name already exists.');
            return FALSE;
        } else {
            return TRUE;
        }
    }

    public function code_check() {
		
        $this->db->where('product_code', trim($this->input->post('product_code')));
        $this->db->where_not_in('product_id', $this->input->post('_id'));
        $query = $this->db->get('tbl_products');

        if ($query->num_rows() > 0) {
            $this->form_validation->set_message('code_check', 'Product code already exists.');
            return FALSE;
        } else {
            return TRUE;
        }
    } 


    public function flavourCodeCheck($flavour_code,$flavour_name,$flavour_id,$product_id) {//flavour_code should color_id,flavour_name should be size id
		
        $this->db->where('flavour_code', $flavour_code);
        $this->db->where('flavour_name', $flavour_name);
        $this->db->where('product_id', $product_id);
        $this->db->where_not_in('flavour_id', $flavour_id);
        $query = $this->db->get('tbl_flavours');
        //print_r($this->db->last_query());die;

        if ($query->num_rows() > 0) {
            return 'true';
        } else {
            return 'false';
        }
		
    }
	
	public function flavourCode_check() {
		
		$this->form_validation->set_message('flavourCode_check', 'Flavour code already exists..');
		return FALSE;
		
    }

}
