<?php

class ReceiptController extends MY_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('admin/Receipt/ReceiptModel');
        $this->load->model('admin/ConsentForm/ConfigurationRetriveModel');
        $this->load->model('admin/Payments/PaymentsModel');
    }

    public function index($patient_payment_id, $treatment_payment_id = null)
    {

        $data = [];
        // $data['active_menu'] = 22;
        // $data['active_submenu'] = 1;
        $template = $this->ReceiptModel->get_active_template();
        $data['company'] = $this->CommonModel->get_company_info();

        $patient_payment_id = decrypt_and_url_decode($patient_payment_id, $this);
        $treatment_payment_id = decrypt_and_url_decode($treatment_payment_id, $this);

        
        $data['receiptHeader'] = $this->ReceiptModel->get_receipt_header_details($patient_payment_id);
        $data['episodePayments'] = $this->ReceiptModel->get_episode_payments($data['receiptHeader']->treatment_payment_id);
        $data['invoiceData'] = $this->ReceiptModel->get_invoice_data_for_receipt($data['receiptHeader']->treatment_payment_id);
        $data['receipts'] = $this->ReceiptModel->get_receipt_summary($data['receiptHeader']->treatment_payment_id);
        $data['patient_payment_id'] = $patient_payment_id;
        $data['view'] =  'receipt';
        
        $data['treatment_payment_id']=$data['receiptHeader']->treatment_payment_id;
        // return $this->output->set_content_type('application/json')
        // ->set_output(json_encode($data['receiptData']));
       
        $this->load->view('/admin/Invoice/Templates/'.$template.'.php', $data);
    }

    public function insurance_recipt($patient_payment_id, $treatment_payment_id = null)
    {

        $data = [];
        // $data['active_menu'] = 22;
        // $data['active_submenu'] = 1;
        $data['template'] = $this->ReceiptModel->get_active_template();
        $data['company'] = $this->CommonModel->get_company_info();

        $patient_payment_id = decrypt_and_url_decode($patient_payment_id, $this);
        $treatment_payment_id = decrypt_and_url_decode($treatment_payment_id, $this);


        $data['receiptHeader'] = $this->ReceiptModel->get_receipt_header_details($patient_payment_id);
        $data['episodePayments'] = $this->ReceiptModel->get_episode_payments($data['receiptHeader']->treatment_payment_id);
        $data['invoice'] = $this->ReceiptModel->get_invoice_data_for_receipt($data['receiptHeader']->treatment_payment_id);
        $data['receipts'] = $this->ReceiptModel->get_receipt_summary($data['receiptHeader']->treatment_payment_id);
        $data['patient_payment_id'] = $patient_payment_id;
        $data['view'] =  'insurance1Details.php';
        // return $this->output->set_content_type('application/json')
        // ->set_output(json_encode($data['receiptData']));


        $this->load->view('admin/Receipt/receipt1', $data);
    }

    
	public function print_advance($advance_id){

		$data = [];
        $data['template'] = $this->ReceiptModel->get_active_template();
        $data['company'] = $this->CommonModel->get_company_info();

        $advance_id = decrypt_and_url_decode($advance_id, $this);


        $data['receiptHeader'] = $this->ReceiptModel->get_receipt_advance($advance_id);
        $data['view'] =  'advance';
        $data['advance_id'] =  $data['receiptHeader']->advance_id;
        // return $this->output->set_content_type('application/json')
        // ->set_output(json_encode($data['receiptData']));
        // print_r($data['receiptHeader']->patient_id);die;
        $data['total_advance']  = $this->calculate_totals($data['receiptHeader']->patient_id)['total_advance'];
        
        $template = $this->ConfigurationRetriveModel->get_row_data('tbl_invoice_templates','invoice_type','3');
        $data['company'] = $this->CommonModel->get_company_info();

        $this->load->view('/admin/Invoice/Templates/'.$template->template.'.php', $data);

        // $this->load->view('admin/Receipt/receipt1', $data);
	}

    public function print_refund($refund_id){

		$data = [];
        $data['template'] = $this->ReceiptModel->get_active_template();
        $data['company'] = $this->CommonModel->get_company_info();

        $refund_id = decrypt_and_url_decode($refund_id, $this);


        $data['receiptHeader'] = $this->ReceiptModel->get_receipt_refund($refund_id);
        $data['view'] =  'refund';
        $data['refund_id'] =  $data['receiptHeader']->refund_id;
        $data['invoice'] = $this->ReceiptModel->getRefundInvoice($data['receiptHeader']->treatment_payment_id);
        $data['receipts'] = $this->ReceiptModel->get_receipt_summary($data['receiptHeader']->treatment_payment_id);
        // return $this->output->set_content_type('application/json')
        // ->set_output(json_encode($data['receiptData']));
        // print_r($data['receiptHeader']->patient_id);die;
        $data['treatment_payment_id']=$data['receiptHeader']->treatment_payment_id;
        
        $template = $this->ConfigurationRetriveModel->get_row_data('tbl_invoice_templates','invoice_type','3');
        $data['company'] = $this->CommonModel->get_company_info();

        $this->load->view('/admin/Invoice/Templates/'.$template->template.'.php', $data);

        // $this->load->view('admin/Receipt/receipt1', $data);
	}
	
	public function print_voucher($paid_id, $tre_pid){
        $paid_id= decrypt_and_url_decode($paid_id,$this);
        $data['company'] = $this->CommonModel->get_company_info();
      
        $data['paid'] = $this->ReceiptModel->paid_amount($paid_id);
        $data['p_info'] = $this->ReceiptModel->patient_info($tre_pid);
        
        $loginId = $this->session->userdata('user_Id');
       
        $data['cashier'] = $this->ReceiptModel->employee_name($loginId);
        // $data['clinic_info'] = $this->ReceiptModel->get_row('organization');
        // $data['pr_list'] = $this->ReceiptModel->reciept_treatment($tre_pid);
        $data['recipt_date'] = $this->ReceiptModel->reciept_treatment_date_time($tre_pid);
        $data['payment']=$this->ReceiptModel->get_payment($paid_id);
       
      
        $this->load->view('admin/Payments/voucher',$data);
    }


}