<?php

class PageSetupController extends CI_Controller {

    function __construct() {
        parent::__construct();

        //Commen -------------------------------------
        $this->load->model('admin/CommonModel');
        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');

        $this->load->model('admin/Setting/PageSetup/PageSetupModel');
    }

    public function index() {
		
        if ($this->session->userdata('user_Id') != '') {

            //Commen -------------------------------------
            $loginId = $this->session->userdata('user_Id');
            $data['active_menu'] = 20;
            $data['active_submenu'] = 2;
            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);
			
            $data['List'] = $this->PageSetupModel->get_list();
			
			
            $this->load->view('admin/Setting/PageSetup/PageSetupList', $data);
			
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
		
    }
	
	  public function CreateNew() {
        if ($this->session->userdata('user_Id') != '') {
            //Commen -------------------------------------
            $loginId = $this->session->userdata('user_Id');
            $data['active_menu'] = 20;
            $data['active_submenu'] = 2;
            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);


            //Locals =========================================================================
        	$page_component_id = 0;
        	$template_id = 0;
        	$page_id = 0;
			
        	
			
            $data['page_component_id'] = $page_component_id;
            $data['template_id'] = $template_id;
            $data['page_id'] = $page_id;
			
			$data['template'] = $this->PageSetupModel->get_templates();
			$data['page'] = $this->PageSetupModel->get_pages($template_id,$page_component_id);
			$data["dynamicGrid_details"] = $this->PageSetupModel->get_widgets($template_id,$page_component_id);
			
			//print_r($data['brand']);die;
           


            $this->load->view('admin/Setting/PageSetup/PageSetup', $data);
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
    }
	
	
	 public function Change_Template() {
        if ($this->session->userdata('user_Id') != '') {
            //Commen -------------------------------------
            $loginId = $this->session->userdata('user_Id');
            $data['active_menu'] = 20;
            $data['active_submenu'] = 2;
            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);


            //Locals =========================================================================
        	$page_component_id = $this->input->post('page_component_id');
        	$template_id = $this->input->post('template_id');
        	$page_id = $this->input->post('page_id');
			
        	
			
            $data['page_component_id'] = $page_component_id;
            $data['template_id'] = $template_id;
            $data['page_id'] = $page_id;
			
			$data['template'] = $this->PageSetupModel->get_templates();
			$data['page'] = $this->PageSetupModel->get_pages($template_id,$page_component_id);
			$data["dynamicGrid_details"] = $this->PageSetupModel->get_widgets($template_id,$page_component_id);
			
			//print_r($data['brand']);die;
           


            $this->load->view('admin/Setting/PageSetup/PageSetup', $data);
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
    }
	
	  public function save() {
        if ($this->session->userdata('user_Id') != '') {
            //Commen -------------------------------------
            $loginId = $this->session->userdata('user_Id');
            $data['active_menu'] = 20;
            $data['active_submenu'] = 2;
            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);


            //Locals =========================================================================
        	$page_component_id = $this->input->post('page_component_id');
        	$template_id = $this->input->post('template_id');
        	$page_id = $this->input->post('page_id');
			
        	
			
            $data['page_component_id'] = $page_component_id;
            $data['template_id'] = $template_id;
            $data['page_id'] = $page_id;
		
			
			$data['template'] = $this->PageSetupModel->get_templates();
			$data['page'] = $this->PageSetupModel->get_pages($template_id,$page_component_id);
			$data["dynamicGrid_details"] = $this->PageSetupModel->get_widgets($template_id,$page_component_id);
			
	
			$this->form_validation->set_rules( 'template_id', ' Template  ', 'callback_template_check' );
			
			$this->form_validation->set_rules( 'page_id', ' Pages  ', 'callback_page_check' );
			
			$data = self::dynamicGrid_details($data);
			
			
           if ($this->form_validation->run() == FALSE) {
				
                $this->load->view('admin/Setting/PageSetup/PageSetup', $data);
                return;
				
            }

			
			$data_save = array (

				'template_id' => $template_id,
				'page_id' => $page_id
				
			);
			
			 if ($page_component_id > 0) {
				 
				 //print($page_component_id);die;
				 
                $this->PageSetupModel->update($page_component_id,$data_save,$data["dynamicGrid_details"]);
				 
            } else {
				 
                $page_component_id = $this->PageSetupModel->save($data_save,$data["dynamicGrid_details"]);
            }

				redirect('admin/Setting/PageSetup/PageSetupController', 'refresh');
           
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
    }
	
	
		public function Load($page_component_id) {
		
        if ($this->session->userdata('user_Id') != '') {

            //Commen -------------------------------------
            $loginId = $this->session->userdata('user_Id');
            $data['active_menu'] = 20;
            $data['active_submenu'] = 2;
            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);
			
			
			if($page_component_id != null && $page_component_id != ''){
			
				$details = $this->PageSetupModel->get_by_id($page_component_id);
				
				
				
				foreach ($details->result() as $row) {

					$template_id = $row->template_id;
					$page_id = $row->page_id;
					
				}

					$data['page_component_id'] = $page_component_id;
					$data['template_id'] = $template_id;
					$data['page_id'] = $page_id;
					

					//print_r($data['page_id']);die;
				
					$data['template'] = $this->PageSetupModel->get_templates();
					$data['page'] = $this->PageSetupModel->get_pages($template_id,$page_component_id);
					$data["dynamicGrid_details"] = $this->PageSetupModel->get_widgets($template_id,$page_component_id);
					//print_r($data['is_new_arrival']);die;
				
				
				$this->load->view('admin/Setting/PageSetup/PageSetup', $data);
				
			} else {
				
				redirect('admin/CommenController/page_not_found', 'refresh');
				
			}
			
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
		
    }
	
	  public function template_check() {
		
        if (trim($this->input->post('template_id')) == 0) {
            $this->form_validation->set_message('template_check', 'Template required.');
            return FALSE;
        } else {
            return TRUE;
        }
    }  
	
	
		public function page_check() {

			if (trim($this->input->post('page_id')) == 0) {
				$this->form_validation->set_message('page_check', 'Page required.');
				return FALSE;
			} else {
				return TRUE;
			}
		}
	
	public function dynamicGrid_details($data) {
		
		$dynamicGrid_details = array();
		$line_id = -1;
		$dynamicGridKey = 'grid_dynamic_';
		$is_row_available = false;
		foreach ($_POST as $key => $value) {
			if ((strpos($key, $dynamicGridKey ) === 0)) {
				if ($line_id != explode("_", $key)[3]) {
					$line_id = explode("_", $key)[3];
					
					$is_selected = $this->input->post($dynamicGridKey.'isSelected_'.$line_id);
					
						

					$dynamicGrid_details[] = array(

						'is_selected' => $is_selected == 1 ? 1 : 0,
						'widgets_file_name' => $this->input->post($dynamicGridKey.'widgetName_'.$line_id),
						'site_widgets_id' => $this->input->post($dynamicGridKey.'widgetId_'.$line_id),
						'widget_order' => $this->input->post($dynamicGridKey.'widgetOrder_'.$line_id),

					);

					$widget_order = trim($this->input->post($dynamicGridKey.'widgetOrder_'.$line_id));

						
						
					if($is_selected == 1){
						
						$is_row_available = true;
						
						if(strlen(trim($widget_order)) == 0) {
							$this->form_validation->set_rules($dynamicGridKey.'widgetOrder_'.$line_id, $dynamicGridKey.'widgetOrder_'.$line_id, 'callback_gridValidation_check');
						}
						
					}

				}
			}
		}

		$data["dynamicGrid_details"] = $dynamicGrid_details;
		
		//print_r($dynamicGrid_details);die;

		if($is_row_available == false){

			$this->form_validation->set_rules('is_row_available', 'is_row_available', 'callback_rows_check');

		}
		
		return $data;
		
	}
	
	//dynamic grid validation
    public function gridValidation_check() {
		
        $this->form_validation->set_message('gridValidation_check', 'is required.');
		return FALSE;
		
    }
	
    public function rows_check() {
		
        $this->form_validation->set_message('rows_check', 'Required at least one widget.');
		return FALSE;
		
    }
	

}
