<?php

class TransactionController extends MY_Controller
{

    function __construct()
    {
        parent::__construct();
        $this->check_permission($this->session->userdata('user_Id'), 'configurations');
   
        $this->load->model('admin/Setting/Company/CompanyModel');
    }

    public function index(){
        return $this->load->view('admin/SkipCash/Transactions');
    }
    public function getTransactions(){

        $type = $this->input->get('type') ;
        
        $result = $this->CompanyModel->getTransactions($type);

        if (!isset($result) || $result == null) {
            $result = [];
        }
        $total_records = count($result);
        $response = [
           
            "recordsTotal" => $total_records,
            "recordsFiltered" => $total_records,
            "data" => $result
        ];

      
        $this->output
        ->set_content_type('application/json')
        ->set_output(json_encode($response));
    }

    public function Invoice($id){
        $data = $this->CompanyModel->retrieve_data_unique_row('skipcash_transactions','id',$id);

        return $this->load->view('admin/SkipCash/Invoice',$data);
    }
}