<?php

class TagsController extends CI_Controller {

    function __construct() {
        parent::__construct();

        //Commen -------------------------------------
        $this->load->model('admin/CommonModel');
        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');

        $this->load->model('admin/Tags/TagsModel');
    }

    public function index($page=0) {
		
        if ($this->session->userdata('user_Id') != '') {

            //Commen -------------------------------------
            $loginId = $this->session->userdata('user_Id');
            $data['active_menu'] = 14;
            $data['active_submenu'] = 2;
            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);
			
			$data['page_count'] = $this->config->item('page_count');
			$data['page'] = $page;
			$data['search_url'] = 'Tags/TagsController/index/';
			$data['form'] = 'submitForm';
			
			$data['list'] = $this->TagsModel->get_list($data); 
			
			$data['paginationData'] = $data['list'];

            $this->load->view('admin/Tags/TagsList', $data);
			
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
		
    }
	
		public function createnew() {
		
        if ($this->session->userdata('user_Id') != '') {

            //Commen -------------------------------------
            $loginId = $this->session->userdata('user_Id');
            $data['active_menu'] = 14;
            $data['active_submenu'] = 2;
            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);
			
			$_id = 0;
			$tag = '';
			$is_active = '';
			
			$data['_id'] = $_id;
			$data['tag'] = $tag;
			$data['is_active'] = $is_active;
			
            $this->load->view('admin/Tags/Tags', $data);
			
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
		
    }
	
	public function save() {
		
        if ($this->session->userdata('user_Id') != '') {

            //Commen -------------------------------------
            $loginId = $this->session->userdata('user_Id');
            $data['active_menu'] = 14;
            $data['active_submenu'] = 2;
            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);
			
			$_id = $this->input->post('_id');
			$tag = $this->input->post('tag');
			$is_active = $this->input->post('is_active');
			
			$data['_id'] = $_id;
			$data['tag'] = $tag;
			$data['is_active'] = $is_active;
			
			//print_r($data['brand_name']);die;
			$this->form_validation->set_rules('tag', 'Tag', 'trim|required');
			
			
			if ($this->form_validation->run() == FALSE) {
				
                $this->load->view('admin/Tags/Tags', $data);
                return;
				
            }
			
			
			$data_save = array (

				'tag' => $tag,
				'is_active' => $is_active == 'active' ? 1 : 0,
			);
			
			//print_r($data_save);die;
			
			if($_id > 0 ) {
								
				$this->TagsModel->update($_id,$data_save);
				
			} else {
				
				$this->TagsModel->save($data_save);
				
			}
			
			
			redirect('admin/Tags/TagsController', 'refresh');

			
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
		
    }
	
	public function edit() {
		
        if ($this->session->userdata('user_Id') != '') {

            //Commen -------------------------------------
            $loginId = $this->session->userdata('user_Id');
            $data['active_menu'] = 14;
            $data['active_submenu'] = 2;
            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);
			
			$_id = base64_decode(urldecode($this->input->post('selected_id')));
			
			if($_id != null && $_id != ''){
			
				$details = $this->TagsModel->get_details_by_id($_id);
				
		
				foreach ($details->result() as $row) {

					$tag = $row->tag;
					$is_active = $row->is_active == 1 ? 'active' : '';
				}
					//print($item_image);die;
				$data['_id'] = $_id;
				$data['tag'] = $tag;
				$data['is_active'] = $is_active;
				
				$this->load->view('admin/Tags/Tags', $data);
				
			} else {
				
				redirect('admin/CommenController/page_not_found', 'refresh');
				
			}
			
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
		
    }

}
