<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

class MY_Controller extends CI_Controller
{

    public $loginId = null;
    public $user_right = null;
    public $profile = null;

    function __construct()
    {

        parent::__construct();

        error_reporting(E_ERROR | E_PARSE);
        date_default_timezone_set('Asia/Kuwait');

        $this->load->helper('url');
        $this->load->helper('date');
        $this->load->helper('hmate');
        $this->load->helper(array('form', 'url'));
        $this->load->helper('string');
        $this->lang->load('en_lang', 'english');

        $this->load->library('user_agent');
        $this->load->library('form_validation');
        $this->load->library('encryption');

        $this->load->model('admin/CommonModel');
        $this->load->model('admin/Announcement/AnnouncementModel');

        $this->form_validation->set_error_delimiters('', '');

        if ($this->session->userdata('user_Id') == '') {
            redirect('admin/Login/LoginController', 'refresh');
        }

        $this->loginId = $this->session->userdata('user_Id');
        $this->user_right = $this->CommonModel->logged_user_right($this->loginId);
        $this->profile = $this->CommonModel->profile($this->loginId);

        //echo json_encode($this->profile->result());exit;

        // Load announcement
        $available_announcement_list = $this->AnnouncementModel->GetAnnouncementForUserGroups($this->session->userdata('group_id'));
        $available_announcement_list = array_column($available_announcement_list, 'announcement');
        foreach ($available_announcement_list as $key => $announcement) {
            $available_announcement_list[$key] = '<i class="ri-megaphone-line"></i> ' . $announcement;
        }
        $available_announcement_list = implode(' | ', $available_announcement_list);
        $this->session->set_userdata('announcements', $available_announcement_list);
    }

    public function createLog($type, $user_id, $action, $data)
    {
        $newdata = array(
            'type' => $type,
            'user_id' => $user_id,
            'action' => $action,
            'old_data' =>  $data ? json_encode($data) : null
        );
        // $this->db->insert('tbl_logs', $newdata);
    }

    public function logRecord($type, $action, $record_id, $oldData, $newData)
    {
        if ($this->arraysAreDifferent($oldData, $newData)) {
            $newdata = array(
                'type' => $type,
                'user_id' => $this->session->userdata('user_Id'),
                'action' => $action,
                'record_id' => $record_id,
                'old_data' =>  $oldData ? json_encode($oldData) : null,
                'new_data' => $newData ? json_encode($newData) : null
            );
            $this->db->insert('tbl_logs', $newdata);
        }

        
    }

    function prepLogArray($array, $type)
    {

        if ($type == 'appointment') {
            $doctor = $this->CommonModel->get_data_row('tbl_users','user_Id', $array['doctor_id']);
            $patient = $this->CommonModel->get_data_row('tbl_patients','patient_id',$array['patient_id']);
            $status = $this->CommonModel->get_data_row('booking_status','status_id',$array['now_waiting']);
            $resources = $this->CommonModel->get_data_row('tbl_resources','resource_id',$array['resource_id']);
            $nurse = $this->CommonModel->get_data_row('tbl_users','user_Id', $array['nurse_id']);
            
            $data = [
                'Appointment ID' => $array['appointment_id'],
                'Date' => $array['appointment_date'],
                'Start'  => $array['appointment_time'],
                'End'  => $array['appointment_etime'],
                'Doctor' => $doctor->full_name,
                'Note' => $array['note'],
                'SMS Active' => $this->label('sms_active_', $array['sms_active']),
                'SMS Language' => $this->label('sms_lang_' , $array['sms_lang']),
                'Patient' => isset($patient->patient_id) ? $patient->patient_name :  $array['app_patient_name'],
                'Mobile' => isset($patient->mobile) ? $patient->mobile : $array['app_patient_contact'],
                'Qatar ID' => isset($patient->qatar_id) ? $patient->qatar_id :  $array['app_patient_qatar_id'],
                'Status' => $status->status_name,
                // 'Whatsapp mobile' => $array['wa_mobile'],
                // 'Country Code' => $array['wa_code'],
                'Resource' => $resources->resource_name,
                'Nurse' => $nurse->full_name
            ];
        }

        if($type == 'appointment_block'){
            $doctor = $this->CommonModel->get_data_row('tbl_users','user_Id', $array['doctor_id']);
            $resources = $this->CommonModel->get_data_row('tbl_resources','resource_id',$array['resource_id']);
            $data = array(
                'Block Date' => $array['app_block_date'],
                'Block Date End' => $array['app_block_date_to'],
                'Start Time'  => $array['app_block_stime'],
                'End Time'  => $array['app_block_etime'],
                'Remarks' => $array['remarks'],
                'Doctor' => $doctor->full_name,
                'Resource' => $resources->resource_name
            );
        }

        if($type == 'patients'){

        }
        if($type == 'Payment Receipt'){
            $data = array(
                'pay_type' => $array['pay_type'],
                'cash' => $array['cash'],
                'card' => $array['card'],
                'discount' => $array['discount'],
                'category_discount' => $array['category_discount'],
                'company_discount' => $array['company_discount'],
                'coupon_id' => !empty($array['coupon_id']) ? $array['coupon_id'] : 0,
                'coupon_discount' => $array['coupon_discount'],
                'points_discount' => $array['points_discount'],
                'pay_date' => $array['pay_date'],
                'pay_time' => $array['pay_time'],
                'patient_id' => $array['patient_id'],
                'is_insurance' => 0,
                
                'total' => $array['total'],
                'treatment_payment_id' => $array['treatment_payment_id'],
            );
        }
        if($type == 'Invoice'){
            $data = array(
                'discount' => $array['discount'],
                'category_discount' => $array['category_discount'],
                'company_discount' => $array['company_discount'],
                'treat_date' => $array['treat_date'],
                'treat_time' => $array['treat_time'],
                'patient_id' => $array['patient_id'],
                'insurance_type' => $array['insurance_type'],
                'department_id' => $array['department_id'],
                
                'total' => $array['total'],
                'treatement_payment_id' => $array['treatement_payment_id'],
            );
        }

        return $data;
    }

    function label($type,$value){
        $label = $this->lang->line($type.$value);
        return $label == false ?  null : $label;
    }
    

    function arraysAreDifferent($array1, $array2)
    {
        // Check if the arrays have different lengths
        if (count($array1) !== count($array2)) {
            return true;
        }

        // Sort the arrays to ensure order doesn't affect comparison
        sort($array1);
        sort($array2);

        // Compare each element of the arrays
        for ($i = 0; $i < count($array1); $i++) {
            if ($array1[$i] !== $array2[$i]) {
                return true;
            }
        }

        return false;
    }

    public function sendJsonResponse($status, $message, $data = '')
    {
        // Create an associative array for the JSON response
        $response = array(
            'status' => $status,
            'message' => $message,
            'data' => $data,
        );

        // Convert the array to JSON format
        $jsonResponse = json_encode($response);

        // Set the content type to JSON
        header('Content-Type: application/json');

        // Output the JSON response
        echo $jsonResponse;
    }

    public function redirect_back()
    {
        $referrer = $this->agent->referrer();
        redirect($referrer);
    }

    public function is_numeric_check($str)
    {
        if (!is_numeric($str)) {
            $this->form_validation->set_message('is_numeric_check', 'The {field} field must be a number.');
            return false;
        } else {
            return true;
        }
    }

    public function calculate_totals($patient_id)
    {
        $data = [];
        $treatments =  $this->PaymentsModel->getTreatmentPatient($patient_id);
        $recipts =  $this->PaymentsModel->getTreatmentReciptsPatient($patient_id);
        $invoice_discounts = $this->PaymentsModel->getInvoiceDiscounts($patient_id);
        $receipt_discounts = $this->PaymentsModel->getReceiptDiscounts($patient_id);
        $total_refunds = $this->PaymentsModel->getTotalRefunds($patient_id);
        $total_advance = $this->PaymentsModel->getTotalAdvance($patient_id);
        $doctor_discount = 0;
        $gross_total = 0;
        foreach ($treatments as $val) {
            $gross_total += $val->total;
            $doctor_discount += $val->discount;
        }

        


        $paid_total = 0;
        $cashier_discount = 0;
        $company_discount_qar = 0;
        $category_discount_qar = 0;
        $coupon_discount = 0;
        $points_discount = 0;
            
        foreach ($recipts as $value) {
            $paid_total += (int)$value->cash;
            $cashier_discount += $value->discount;
            $company_discount_qar += $value->company_discount;
            $category_discount_qar += $value->category_discount;
            $coupon_discount += $value->coupon_discount;
            $points_discount += $value->points_discount;
        }
        $total_discount = $doctor_discount + $cashier_discount + $company_discount_qar + $category_discount_qar + $coupon_discount + $points_discount;

        $data['net_total'] = number_format($net_total, 2);
        $data['gross_total'] = number_format($gross_total, 2);
        $data['paid_total'] = number_format($paid_total, 2);
        $data['balance'] = number_format($gross_total - $paid_total - $total_discount, 2);
        $data['total_invoice_discount'] = number_format($invoice_discounts, 2);
        $data['total_receipt_discount'] = number_format($receipt_discounts, 2);
        $data['total_discount'] = number_format(($invoice_discounts + $receipt_discounts), 2);
        $data['total_refunds'] = number_format($total_refunds, 2);
        $data['total_advance'] = number_format($total_advance, 2);
        return $data;
    }

    public function rating_name($rate)
    {
        $rating = '';
        switch ($rate) {
            case 0:
                $rating = 'N/A';
                break;
            case 1:
                $rating = 'Excellent';
                break;
            case 2:
                $rating = 'Good';
                break;
            case 3:
                $rating = 'Satisfied';
                break;
            case 4:
                $rating = 'Poor';
                break;
            case 5:
                $rating = 'Bad';
                break;
        }
        return $rating;
    }
}
