<?php
class Migrator extends CI_Model {

    // Define database connections for old and new databases
    public function __construct() {
        parent::__construct();

        // Load the old database connection directly here
        $this->old_db = $this->load->database(array(
            'dsn'      => '',
            'hostname' => 'localhost',
            'username' => 'root',
            'password' => '',
            'database' => 'shmc_old',
            'dbdriver' => 'mysqli',
            'dbprefix' => '',
            'pconnect' => FALSE,
            'db_debug' => TRUE,
            'cache_on' => FALSE,
            'cachedir' => '',
            'char_set' => 'utf8',
            'dbcollat' => 'utf8_general_ci',
            'swap_pre' => '',
            'encrypt'  => FALSE,
            'compress' => FALSE,
            'stricton' => FALSE,
            'failover' => array(),
            'save_queries' => TRUE
        ), TRUE);

        // Load the new database connection (default)
        $this->new_db = $this->load->database(array(
            'dsn'      => '',
            'hostname' => 'localhost',
            'username' => 'root',
            'password' => '',
            'database' => 'new_hmate',
            'dbdriver' => 'mysqli',
            'dbprefix' => '',
            'pconnect' => FALSE,
            'db_debug' => TRUE,
            'cache_on' => FALSE,
            'cachedir' => '',
            'char_set' => 'utf8',
            'dbcollat' => 'utf8_general_ci',
            'swap_pre' => '',
            'encrypt'  => FALSE,
            'compress' => FALSE,
            'stricton' => FALSE,
            'failover' => array(),
            'save_queries' => TRUE
        ), TRUE);
    }

    // Fetch data from the old table
    public function get_old_users() {
        $query = $this->old_db->select('users.*, employee.*, permission.*, 
        doctors.professional_type,
        doctors.doctor_id,
        doctors.professional_type_code,
        doctors.clinic_code,
        doctors.campus_code,
        doctors.org_code,
        doctors.img_file,
        doctors.color_code,
        doctors.stamp,
        doctors.app_status,
        doctors.initial,
        doctors.ord,
        doctors.license_no,
        doctors.specialty_id,

        ')
            ->from('users')
            ->join('employee', 'users.employee_id = employee.employee_id', 'left')
            ->join('permission', 'users.user_id = permission.user_id', 'left')
            ->join('doctors', 'users.user_id = doctors.user_id', 'left')
            
            ->group_by('users.user_id') // Ensure unique users
            ->get();
            
        return $query->result_array();
    }


    public function get_old_appointments($limit = 1000, $offset = 0) {
        $query = $this->old_db->select('appointment.*, doctors.user_id as doctor_id')
            ->from('appointment')
            ->join('doctors', 'appointment.doctor_id = doctors.doctor_id', 'left') // Handle cases where doctor_id may be null
            ->limit($limit, $offset) // Fetch records in batches
            ->get();
    
        return $query->result_array();
    }
    public function get_old_appointments_block($limit = 1000, $offset = 0) {
        $query = $this->old_db->select('appointment_block.*, doctors.user_id as doctor_id')
            ->from('appointment_block')
            ->join('doctors', 'appointment_block.doctor_id = doctors.doctor_id', 'left') // Handle cases where doctor_id may be null
            ->limit($limit, $offset) // Fetch records in batches
            ->get();
    
        return $query->result_array();
    }
    public function get_old_patients($limit = 1000, $offset = 0) {
        $query = $this->old_db->select('patients.*, patient_contact.*')
            ->from('patients')
            ->join('patient_contact', 'patients.patient_id = patient_contact.patient_id', 'left') // Handle cases where doctor_id may be null
            ->limit($limit, $offset) // Fetch records in batches
            ->get();
    
        return $query->result_array();
    }
    public function get_old_derma($limit = 1000, $offset = 0) {
        $query = $this->old_db->select('treat_derma.*, treatment_payment.patient_id')
            ->from('treat_derma')
            ->join('treatment_payment', 'treat_derma.treatment_payment_id = treatment_payment.treatment_payment_id', 'left') // Handle cases where doctor_id may be null
            ->limit($limit, $offset) // Fetch records in batches
            ->get();
    
        return $query->result_array();
    }
    public function get_old_derma_subs($limit = 1000, $offset = 0) {
        $query = $this->old_db->select('treat_derma_subs.*')
            ->from('treat_derma_subs')
            ->limit($limit, $offset) // Fetch records in batches
            ->get();
    
        return $query->result_array();
    }
    public function get_old_countries($limit = 1000, $offset = 0) {
        $query = $this->old_db->select('countries.*')
            ->from('countries')
            
            ->limit($limit, $offset) // Fetch records in batches
            ->get();
    
        return $query->result_array();
    }
    public function get_old_app_info($limit = 1000, $offset = 0) {
        $query = $this->old_db->select('appointment_patient_info.*')
            ->from('appointment_patient_info')
            
            ->limit($limit, $offset) // Fetch records in batches
            ->get();
    
        return $query->result_array();
    }
    public function get_old_conset_data($limit = 1000, $offset = 0) {
        $query = $this->old_db->select('concern_form.*,patients.patient_name')
            ->from('concern_form')
            ->join('patients', 'patients.patient_id = concern_form.patient_id', 'left')
            ->limit($limit, $offset) // Fetch records in batches
            ->get();
    
        return $query->result_array();
    }
    public function get_old_medical($limit = 1000, $offset = 0) {
        $query = $this->old_db->select('patient_medicals.*,patient_sign.filename')
            ->from('patient_medicals')
            ->join('patient_sign', 'patient_sign.patient_medical_id = patient_medicals.patient_medical_id','left') 
            ->group_by('patient_medicals.patient_medical_id')
            ->limit($limit, $offset) // Fetch records in batches
            ->get();
    
        return $query->result_array();
    }
    public function get_old_treatment_payment($limit = 1000, $offset = 0) {
        $query = $this->old_db->select('treatment_payment.*, doctors.user_id as user_id')
            ->from('treatment_payment')
            ->join('doctors', 'treatment_payment.doctor_id = doctors.doctor_id', 'left')
            ->limit($limit, $offset) // Fetch records in batches
            ->get();
    
        return $query->result_array();
    }

    public function get_old_patient_payments($limit = 1000, $offset = 0) {
        $query = $this->old_db->select('patient_payment.treatment_payment_id, 
                                        SUM(patient_payment.discount) as cashier_discount, 
                                        SUM(patient_payment.amount) as paid_amount, 
                                        treatment_payment.total as treatment_total, 
                                        treatment_payment.doctor_discount')
            ->from('patient_payment')
            ->join('treatment_payment', 'treatment_payment.treatment_payment_id = patient_payment.treatment_payment_id', 'left')
            ->group_by('patient_payment.treatment_payment_id') // Group by treatment_payment_id
            ->limit($limit, $offset) // Fetch records in batches
            ->get();
    
        return $query->result_array();
    }
    public function get_old_episode_payments($limit=1000,$offset=0) {
        $query = $this->old_db->select('*')
            ->from('episode_payment')
            ->limit($limit, $offset) 
            ->get();
    
        return $query->result_array();
    }
    public function get_old_treatment_price($limit=1000,$offset=0) {
        $query = $this->old_db->select('*')
            ->from('p_treatment_price')
            ->limit($limit, $offset) 
            ->get();
    
        return $query->result_array();
    }
    public function get_old_docs($limit=1000,$offset=0) {
        $query = $this->old_db->select('*')
            ->from('documents')
            ->limit($limit, $offset) 
            ->get();
    
        return $query->result_array();
    }
    
    public function get_t_payment($id) {
        $query = $this->old_db->select('*')
            ->from('patient_payment')
           ->where('treatment_payment_id',$id)
         
            ->get();
    
        return $query->result_array();
    }
   public function deletePatients($ids_string){

    $sql = "DELETE FROM patients WHERE patient_id IN ($ids_string)";

    // Execute the query
    $result = $this->old_db->query($sql);

    // $sqlApp = "DELETE FROM tbl_appointment WHERE patient_id IN ($ids_string)";
    // $result = $this->old_db->query($sqlApp);


    
    // $sqlApp = "DELETE FROM tbl_treatment_payment WHERE patient_id IN ($ids_string)";
    // $result = $this->old_db->query($sqlApp);

    // $sqlApp = "DELETE FROM tbl_patient_payment WHERE patient_id IN ($ids_string)";
    // $result = $this->old_db->query($sqlApp);


    // Check if rows were affected
    return $this->old_db->affected_rows() > 0;
   }
    public function updateCountryID($table, $name, $new_country_id) {
        // Use the active record to update the country_id
        $this->new_db->set('country_id', $new_country_id);
        $this->new_db->where('country_name',$name);
        $this->new_db->update($table);
      
        if ($this->new_db->affected_rows() > 0) {
            return true; // Return true if update is successful
        } else {
            return false; // Return false if no rows were updated
        }
    }

    // Check if the user exists in the new table
    public function check_new_user($email) {
        $this->new_db->where('email', $email);
        $query = $this->new_db->get('new_users_table');
        return $query->row();
    }

    // Insert a new user into the new table
    public function savenew($table,$data) {
        return $this->new_db->insert($table, $data);
    }
}
