<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

class CouponModel extends CI_Model
{

	function __construct()
	{
		parent::__construct();
		$this->load->database();
	}

    public function save_coupon($data) {
        return $this->db->insert('coupons', $data);
    }

    public function save_loyalty($data) {
        return $this->db->insert('loyalty_programs', $data);
    }
	public function delete_item($id) {
        // Perform the delete query
        $this->db->where('id', $id);
        return $this->db->delete('coupons'); // Replace 'your_table_name' with the actual table name
    }

    public function delete_loyalty($id) {
        // Perform the delete query
        $this->db->where('id', $id);
        return $this->db->delete('loyalty_programs'); // Replace 'your_table_name' with the actual table name
    }

    public function validate_coupon($coupon_code, $user_id, $purchase_amount) {
        // Retrieve the coupon data by code
        $this->db->where('code', $coupon_code);
        $this->db->where('is_active', '1');
        $coupon = $this->db->get('coupons')->row();

        $this->db->where('user_id',$user_id);
        $this->db->where('coupon_id',$coupon->id);
        $redemed_coupon = $this->db->get('user_coupons')->row();

        if ($redemed_coupon) {
            return ['valid' => false, 'message' => 'This coupon has already been redeemed .'];
        }
        // Check if the coupon exists
        if (!$coupon) {
            return ['valid' => false, 'message' => 'Invalid coupon code.'];
        }

        // Check if the coupon is valid for the current date
        $current_date = date('Y-m-d');
        if ($coupon->valid_from > $current_date || $coupon->valid_until < $current_date) {
            return ['valid' => false, 'message' => 'Coupon is not valid for this date.'];
        }

        // Check if the purchase meets the minimum purchase amount
        if ($purchase_amount < $coupon->min_purchase) {
            return ['valid' => false, 'message' => 'Purchase amount does not meet the coupon requirements.Minimum Amount is '.$coupon->min_purchase.' QAR'];
        }

        // Check if the coupon is for all users or selected users
        if ($coupon->applicable_to == 'selected') {
            // Coupon is for selected users only
            $selected_users = json_decode($coupon->users);
            if (!in_array($user_id, $selected_users)) {
                return ['valid' => false, 'message' => 'Coupon is not valid for this Patient.'];
            }
        }

        // If all checks pass, return valid
        return ['valid' => true, 'id'=>$coupon->id, 'discount_type' => $coupon->discount_type,'discount_value' => $coupon->discount_value];
    }

    public function redeem_points($points,$user_id, $purchase_amount,$loyalty_program){
        $this->db->where('id', $loyalty_program);
        $program_data= $this->db->get('loyalty_programs')->row();

        $this->db->where('user_id', $user_id);
        $points_data = $this->db->get('user_loyalty_points')->row();
        $available_points= $points_data->points_balance;
        $last_updated = $points_data->last_updated; // Assuming this is a timestamp or date
        $expired_after = $points_data->expired_after;


        if ($expired_after > 0) {
            // Add expiration months to last_updated
            $expiration_date = date('Y-m-d', strtotime("+$expired_after months", strtotime($last_updated)));
            $current_date = date('Y-m-d');
    
            if ($current_date > $expiration_date) {
                return ['valid' => false, 'message' => 'Points have expired.'];
            }
        }

        if ($available_points <= 0) {
            return ['valid' => false, 'message' => 'Insufficient Points .'];
        }
        if ($points < $program_data->min_points_to_redeem) {
           
            return ['valid' => false, 'message' => 'You can redeem minimum '.$program_data->min_points_to_redeem.' points'];
        }
        if ($program_data->is_active != 1) {
            return ['valid' => false, 'message' => 'Loyalty Program is not activated '];
        }
       

        // If all checks pass, return valid
        return ['valid' => true, 'discount_per_point'=>$program_data->discount_per_point];
    }


}