<?php

class InventoryModel extends CI_Model
{

    function __construct()
    {
        parent::__construct();
        $this->load->database();
    }


    public function get_doctors()
    {
        $this->db->select('tbl_employees.user_id as doctor_id, tbl_employees.doctor_color as color_code, tbl_employees.doctor_type as professional_type, tbl_users.full_name as employee_name, tbl_employees.employee_id');
        $this->db->from('tbl_employees');
        $this->db->join('tbl_users', 'tbl_employees.user_id = tbl_users.user_Id');

        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return FALSE;
        }
    }

    public function stock_list($item_id)
    {
        $this->db->select('tbl_items_list.item_id, tbl_items_list.item_name, tbl_items_list.user_id, tbl_items_list.unit, tbl_items_list.item_type, tbl_item_inventory.quantity, tbl_item_inventory.expiry_date, tbl_item_inventory.location, tbl_item_inventory.item_inventory_id, tbl_users.user_name');
        $this->db->from('tbl_item_inventory');
        $this->db->join('tbl_items_list', 'tbl_items_list.item_id = tbl_item_inventory.item_id', 'left');
        $this->db->join('tbl_users', 'tbl_users.user_id = tbl_items_list.user_id', 'left');
        $this->db->where('tbl_items_list.item_id', $item_id);

        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return FALSE;
        }
    }


    public function stock_history($item_id)
    {
        $this->db->select('*');
        $this->db->from('tbl_item_inventory_history');
        $this->db->join('tbl_item_inventory', 'tbl_item_inventory_history.item_inventory_id = tbl_item_inventory.item_inventory_id', 'left');
        $this->db->where('item_id', $item_id);

        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return FALSE;
        }
    }


    public function item_inventory_invoices($id)
    {
        $this->db->select('*');
        $this->db->from('tbl_item_inventory_invoices');
        $this->db->where('inventory_invoice_id', $id);
        $this->db->order_by('inventory_invoice_id', 'DESC');

        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return FALSE;
        }
    }


    public function item_inventory_invoice_items($id)
    {
        $this->db->select('*, tbl_item_inventory_invoice_items.price as price');
        $this->db->from('tbl_item_inventory_invoice_items');
        $this->db->join('tbl_items_list', 'tbl_item_inventory_invoice_items.item_id = tbl_items_list.item_id', 'left');
        $this->db->join('tbl_units', 'tbl_item_inventory_invoice_items.unit = tbl_units.unit_id', 'left');
        $this->db->where('tbl_item_inventory_invoice_items.item_inventory_invoice_id', $id);

        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return FALSE;
        }
    }

    public function get_supplier_category($category)
    {
        $query = $this->db->query("SELECT tbl_item_inventory_invoice_items.item_id,tbl_items_list.barcode,tbl_items_list.item_name,SUM(tbl_item_inventory_invoice_items.quantity) stock_qty, tbl_units.name unit_name,tbl_units.unit_id,tbl_items_list.price,tbl_item_suppliers.supplier_name,tbl_item_types.* 
					FROM tbl_item_inventory_invoices 
					LEFT JOIN tbl_item_inventory_invoice_items ON tbl_item_inventory_invoices.inventory_invoice_id = tbl_item_inventory_invoice_items.item_inventory_invoice_id 
					LEFT JOIN tbl_items_list ON tbl_item_inventory_invoice_items.item_id = tbl_items_list.item_id 
					LEFT JOIN tbl_units ON tbl_items_list.unit = tbl_units.unit_id 
					LEFT JOIN tbl_item_types ON tbl_items_list.item_type = tbl_item_types.item_type 
					LEFT JOIN tbl_item_suppliers ON tbl_item_inventory_invoices.supplier_id = tbl_item_suppliers.supplier_id 
					WHERE tbl_items_list.item_type = '" . $category . "' 
					GROUP BY tbl_item_inventory_invoice_items.item_id");
        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return FALSE;
        }
    }

    public function get_inventory_item_info($id)
    {
        $this->db->select('*');
        $this->db->from('tbl_item_inventory_invoice_items');
        $this->db->join('tbl_items_list', 'tbl_item_inventory_invoice_items.item_id = tbl_items_list.item_id');
        $this->db->where('tbl_items_list.item_id', $id);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            return FALSE;
        }
    }

    public function get_supplier_items($supplier_id)
    {
        $this->db->select('tbl_item_inventory_invoice_items.item_id, tbl_items_list.barcode, tbl_items_list.item_name, 
    (IFNULL((SELECT SUM(tbl_item_inventory_invoice_items.quantity + tbl_item_inventory_invoice_items.bonus) 
    FROM tbl_item_inventory_invoice_items 
    WHERE tbl_item_inventory_invoice_items.item_id = tbl_items_list.item_id),0) - 
    IFNULL((SELECT SUM(tbl_item_requests_items.quantity) 
    FROM tbl_item_requests_items WHERE tbl_item_requests_items.item_id = tbl_items_list.item_id),0)) as stock_qty,
    tbl_units.name as unit_name, tbl_item_inventory_invoice_items.unit as unit_id, 
    tbl_items_list.price, tbl_item_types.type_name, tbl_item_suppliers.supplier_name');
        $this->db->from('tbl_item_inventory_invoices');
        $this->db->join('tbl_item_inventory_invoice_items', 'tbl_item_inventory_invoices.inventory_invoice_id = tbl_item_inventory_invoice_items.item_inventory_invoice_id', 'left');
        $this->db->join('tbl_items_list', 'tbl_item_inventory_invoice_items.item_id = tbl_items_list.item_id', 'left');
        $this->db->join('tbl_units', 'tbl_items_list.unit = tbl_units.unit_id', 'left');
        $this->db->join('tbl_item_types', 'tbl_items_list.item_type = tbl_item_types.item_type', 'left');
        $this->db->join('tbl_item_suppliers', 'tbl_item_inventory_invoices.supplier_id = tbl_item_suppliers.supplier_id', 'left');
        $this->db->where('tbl_item_inventory_invoices.supplier_id', $supplier_id);
        $this->db->where('tbl_item_inventory_invoice_items.item_id !=', '');
        $this->db->group_by('tbl_item_inventory_invoice_items.item_id');

        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return FALSE;
        }
    }

    public function get_supplier_items_report_billing($supplier_id = 0, $item_id = 0, $from_date = '', $to_date = '')
    {
        $query = $this->db->query("SELECT tbl_item_inventory_invoice_items.item_id, tbl_items_list.barcode, tbl_items_list.item_name, tbl_item_inventory_invoices.ref_no, tbl_item_inventory_invoices.date AS date,
                tbl_item_inventory_invoice_items.quantity stock_qty, 'Billing' AS type, tbl_item_inventory_invoice_items.bonus, tbl_item_inventory_invoices.inventory_invoice_id,
            tbl_units.name AS unit_name, tbl_item_inventory_invoice_items.unit AS unit_id, tbl_item_inventory_invoice_items.price, tbl_item_types.type_name AS type_name, tbl_item_suppliers.supplier_id, tbl_item_suppliers.supplier_name  
                        FROM tbl_item_inventory_invoices 
                        LEFT JOIN tbl_item_inventory_invoice_items ON tbl_item_inventory_invoices.inventory_invoice_id = tbl_item_inventory_invoice_items.item_inventory_invoice_id 
                        LEFT JOIN tbl_items_list ON tbl_item_inventory_invoice_items.item_id = tbl_items_list.item_id 
                        LEFT JOIN tbl_units ON tbl_items_list.unit = tbl_units.unit_id 
                        LEFT JOIN tbl_item_types ON tbl_items_list.item_type = tbl_item_types.item_type 
                        LEFT JOIN tbl_item_suppliers ON tbl_item_inventory_invoices.supplier_id = tbl_item_suppliers.supplier_id 
                        WHERE 1 ".($supplier_id != 0 ? "AND tbl_item_inventory_invoices.supplier_id = '$supplier_id'" : "AND tbl_item_inventory_invoices.supplier_id != ''")
                        .($item_id != 0 ? " AND tbl_item_inventory_invoice_items.item_id = '$item_id'" : "AND tbl_item_inventory_invoice_items.item_id != ''")
                        .($from_date != '' && $to_date != '' ? " AND tbl_item_inventory_invoices.date BETWEEN '$from_date' AND '$to_date'" : ''));

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return FALSE;
        }
    }

    // public function get_supplier_items_report_billing($supplier_id = 0, $item_id = 0, $from_date = '', $to_date = '')
    // {
    //     $this->db->select("tbl_item_inventory_invoice_items.item_id, tbl_items_list.barcode, tbl_items_list.item_name, tbl_item_inventory_invoices.ref_no, tbl_item_inventory_invoices.date AS date,
    //             tbl_item_inventory_invoice_items.quantity stock_qty, 'Billing' AS type, tbl_item_inventory_invoice_items.bonus, tbl_item_inventory_invoices.inventory_invoice_id,
    //         tbl_units.name AS unit_name, tbl_item_inventory_invoice_items.unit AS unit_id, tbl_item_inventory_invoice_items.price, tbl_item_types.type_name AS type_name, tbl_item_suppliers.supplier_id, tbl_item_suppliers.supplier_name");
    //     $this->db->from('tbl_item_inventory_invoices');
    //     $this->db->join('tbl_item_inventory_invoice_items', 'tbl_item_inventory_invoices.inventory_invoice_id = tbl_item_inventory_invoice_items.item_inventory_invoice_id', 'left');
    //     $this->db->join('tbl_items_list', 'tbl_item_inventory_invoice_items.item_id = tbl_items_list.item_id', 'left');
    //     $this->db->join('tbl_units', 'tbl_items_list.unit = tbl_units.unit_id', 'left');
    //     $this->db->join('tbl_item_types', 'tbl_items_list.item_type = tbl_item_types.item_type', 'left');
    //     $this->db->join('tbl_item_suppliers', 'tbl_item_inventory_invoices.supplier_id = tbl_item_suppliers.supplier_id', 'left');
    //     $this->db->where('1');
    //     if ($supplier_id != 0) {
    //         $this->db->where('tbl_item_inventory_invoices.supplier_id', $supplier_id);
    //     } else {
    //         $this->db->where('tbl_item_inventory_invoices.supplier_id !=', '');
    //     }
    //     if ($item_id != 0) {
    //         $this->db->where('tbl_item_inventory_invoice_items.item_id', $item_id);
    //     } else {
    //         $this->db->where('tbl_item_inventory_invoice_items.item_id !=', '');
    //     }
    //     if ($from_date != '' && $to_date != '') {
    //         $this->db->where("tbl_item_inventory_invoices.date BETWEEN '$from_date' AND '$to_date'");
    //     }
    //     $query = $this->db->get();

    //     if ($query->num_rows() > 0) {
    //         return $query->result_array();
    //     } else {
    //         return FALSE;
    //     }
    // }



    public function get_supplier_info($id)
	{
		$query = $this->db->query("SELECT * FROM tbl_item_suppliers WHERE tbl_item_suppliers.supplier_id='".$id."'");

		if($query->num_rows() > 0) {
			return $query->row();
		}else {
			return FALSE;
		}
	}

    public function get_item_info($id)
	{
		$query = $this->db->query("SELECT * FROM tbl_items_list WHERE tbl_items_list.item_id='".$id."'");

		if($query->num_rows() > 0) {
			return $query->row();
		}else {
			return FALSE;
		}
	}

    public function get_doctor_items_report_transfer($doctor_id = 0,$item_id = 0, $from_date = '',$to_date = '', $department = ''){

        $q = "SELECT tbl_item_requests_items.*,
		tbl_items_list.*,
		tbl_item_departments.department_name AS department,
		tbl_item_inventory_invoice_items.out_price,
		tbl_units.name                       AS unit_name,
		tbl_item_requests.date               AS date,
		'Transfer'                       AS type,
		tbl_users.full_name           AS doctor_name
 				FROM   tbl_item_requests_items
						INNER JOIN tbl_item_inventory_invoice_items
								ON tbl_item_inventory_invoice_items.item_inventory_invoice_item_id =
								   tbl_item_requests_items.invoice_item_id
						INNER JOIN tbl_item_requests
								ON tbl_item_requests.request_id = tbl_item_requests_items.request_id
						INNER JOIN tbl_items_list
								ON tbl_item_requests_items.item_id = tbl_items_list.item_id
						INNER JOIN tbl_employees
								ON tbl_employees.user_id = tbl_item_requests.employee_id
                        INNER JOIN tbl_users
                                ON tbl_users.user_Id = tbl_employees.user_id
						INNER JOIN tbl_item_types
								ON tbl_items_list.item_type = tbl_item_types.item_type
						INNER JOIN tbl_units
								ON tbl_items_list.unit = tbl_units.unit_id
						INNER JOIN tbl_item_departments
								ON tbl_item_departments.id = tbl_item_requests.department
 				WHERE  1
			".($doctor_id != 0 ? " AND tbl_item_requests.employee_id LIKE '$doctor_id'" : 'AND tbl_item_requests.employee_id != ""')
            .($item_id != 0 ? " AND tbl_item_requests_items.item_id LIKE '$item_id'" : 'AND tbl_item_requests_items.item_id != ""')
            .($from_date != '' && $to_date != '' ? " AND tbl_item_requests.date BETWEEN '$from_date' AND '$to_date'" : '')
            .($department != 0 ? " AND tbl_item_requests.department LIKE '$department'" : '');

		$query = $this->db->query($q);
			
		if($query->num_rows() > 0)
        {
            return $query->result_array();		
        } else {
            return FALSE;
        }
	}

    public function get_doctors_by_emp($id=-1)
	{
        if($id==-1) {
            $query = $this->db->query("SELECT *FROM tbl_users LEFT JOIN tbl_employees ON tbl_users.user_Id = tbl_employees.user_id ORDER BY full_name ASC");
        }else{
            $query = $this->db->query("SELECT *FROM tbl_users LEFT JOIN tbl_employees ON tbl_users.user_Id = tbl_employees.user_id WHERE tbl_employees.user_id = ".$id." ORDER BY full_name ASC");
        }
		
			if($query->num_rows() > 0)
			{
			    if($id==-1) return $query->result_array();
				else return $query->row();
			} else{
				return FALSE;
			}
	}
    
    public function get_items_report_balance($item_id = 0)
	{
		$query = $this->db->query("SELECT tbl_item_inventory_invoice_items.item_id as item_code,
							tbl_items_list.barcode AS item_barcode,
							tbl_items_list.item_name AS item_name,
							tbl_item_inventory_invoices.date          AS date,
							tbl_item_inventory_invoice_items.quantity AS stock_qty,
							tbl_item_inventory_invoice_items.bonus 	  AS bonus,
							tbl_item_inventory_invoices.inventory_invoice_id,
							tbl_units.name                            AS unit_name,
							tbl_item_inventory_invoice_items.unit     AS unit_id,
							tbl_item_inventory_invoice_items.price    AS price,
							tbl_item_inventory_invoice_items.out_price    AS out_price,
							tbl_item_types.type_name                  AS type_name,
							IFNULL((SELECT SUM(tbl_item_requests_items.quantity) FROM tbl_item_requests_items WHERE tbl_item_requests_items.invoice_item_id = tbl_item_inventory_invoice_items.item_inventory_invoice_item_id),0) as sent_qty
					 FROM   tbl_item_inventory_invoice_items
							LEFT JOIN tbl_item_inventory_invoices
								   ON tbl_item_inventory_invoices.inventory_invoice_id = tbl_item_inventory_invoice_items.item_inventory_invoice_id
							LEFT JOIN tbl_items_list
								   ON tbl_item_inventory_invoice_items.item_id = tbl_items_list.item_id
							LEFT JOIN tbl_units
								   ON tbl_items_list.unit = tbl_units.unit_id
							LEFT JOIN tbl_item_types
								   ON tbl_items_list.item_type = tbl_item_types.item_type
							LEFT JOIN tbl_item_suppliers
								   ON tbl_item_inventory_invoices.supplier_id =
									  tbl_item_suppliers.supplier_id
					 WHERE  1
					".($item_id != 0 ? "  AND tbl_items_list.item_id LIKE '$item_id'" : 'AND tbl_item_inventory_invoice_items.item_id != ""').
                    "ORDER BY tbl_items_list.item_id ASC");

		if($query->num_rows() > 0)
		{
			return $query->result_array();
		} else {
			return FALSE;
		}
	}   
}
