<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

class PatientsModel extends CI_Model
{

	function __construct()
	{
		parent::__construct();
		$this->load->database();
	}

	public function get_dataList()
	{

		$str_quary = "";

		$str_quary .= " select * ";

		$str_quary .= " from tbl_patients ";

		$str_quary .= " join tbl_insurance_types on tbl_insurance_types.insurance_type_id=tbl_patients.insurance_type ";

		$str_quary .= " where deleted = 0";

		$str_quary .= " order by patient_id desc ";

		$query = $this->db->query($str_quary);
		return $query;
	}


	public function save($data, $is_new_image, $imageData)
	{

		$this->db->insert('tbl_brands', $data);
		$_id = $this->db->insert_id();

		if ($is_new_image == 'true') {
			$imagePath = self::save_image(0, $_id, $imageData, 'brand');
		} else {
			$imagePath = $imageData;
		}

		$this->db->set('image_path', $imagePath);
		$this->db->where('brand_id', $_id);
		$this->db->update('tbl_brands');

		return $_id;
	}

	public function update($_id, $data, $is_new_image, $imageData)
	{

		$image_path = $imageData;

		/*Image update*/
		if ($is_new_image == 'true') {

			$image_path = self::save_image(0, $_id, $imageData, 'brand');
		}


		$this->db->set('brand_name', $data["brand_name"]);
		$this->db->set('is_active', $data["is_active"]);
		$this->db->set('image_path', trim($image_path));

		$this->db->where('brand_id', $_id);
		$this->db->update('tbl_brands');
	}

	public function get_details_by_id($_id)
	{

		$str_quary = "";

		$str_quary .= " select * ";
		$str_quary .= " from tbl_brands ";
		$str_quary .= " where tbl_brands.brand_id = " . $_id;

		$query = $this->db->query($str_quary);
		return $query;
	}


	public function save_image($parent_id, $_id, $image, $imageType)
	{

		$falder_path = $this->CommonModel->targetDocumentPath($parent_id, $_id, 'brands', $imageType);
		$image_url = $falder_path . $_id . '.png';

		if (file_exists($image_url)) {
			unlink(trim($image_url));
		}

		$_image = $image;

		$image_parts = explode(";base64,", $_image);
		$image_type_aux = explode("image/", $image_parts[0]);
		$image_type = $image_type_aux[1];
		$image_base64 = base64_decode($image_parts[1]);
		$file = $image_url;

		file_put_contents($file, $image_base64);
		$image_path = $image_url;

		return $image_path;
	}

	public function checkPatientExist($qid)
	{
		$query = $this->db->select('tbl_patients.*')
			->from('tbl_patients')
			->where('qatar_id', $qid)
			->get();

		if ($query->num_rows() > 0) {
			$result = $query->row();
			return $result->patient_id;
		} else {
			return 0;
		}
	}
	public function get_patient_details($column, $searchValue)
	{
		return $this->db->select('tbl_patients.*, tbl_countries.country_name, tbl_insurance_types.insurance_name')
			->from('tbl_patients')
			->join('tbl_countries', 'tbl_patients.nationality = tbl_countries.country_id','left')
			->join('tbl_insurance_types', 'tbl_patients.insurance_type = tbl_insurance_types.insurance_type_id','left')
			->where($column, $searchValue)
			->get()
			->row();
	}

	public function getPackages(){
		return $this->db->select('*')
			->from('packages')
			->get()
			->result();
	}

	public function getUserPackages($id){
		$packages = $this->db->select('packages.*, user_has_package.start_date')
        ->from('packages')
        ->join('user_has_package', 'packages.id = user_has_package.package_id')
		
        ->where('user_has_package.patient_id', $id)
        ->group_by('packages.id')
        ->get()
        ->result_array(); // Get array of packages

    if ($packages) {
        foreach ($packages as &$package) { // Use reference to modify the original array
            // Fetch associated modules for each package
            $modules = $this->db->select('tbl_modules.department_id,tbl_modules.module_name, package_details.sessions,user_attend_sessions.session as attended_sessions')
                ->from('tbl_modules')
                ->join('package_details', 'tbl_modules.department_id = package_details.department_id')
				->join('user_attend_sessions', 'tbl_modules.department_id = user_attend_sessions.department_id','left')
                ->where('package_details.package_id', $package['id'])
                ->get()
                ->result_array();

            // Add the modules as an array within the package
            $package['modules'] = $modules;
        }
    }

    

    return $packages;
	}

	public function insert_patient_document_details($data)
	{
		return $this->db->insert('tbl_patient_attachments', $data);
	}

	public function get_patient_documents($parent_id)
	{
		return $this->db->select('*')
			->from('tbl_patient_attachments')
			->where('patient_id', $parent_id)
			->where('document_type', 0)
			->get()
			->result();
	}
		public function get_patient_consents($parent_id)
	{
		return $this->db->select('tbl_consent_data.*,tbl_consent_forms.consent_name')
			->from('tbl_consent_data')
			->join('tbl_consent_forms', 'tbl_consent_data.consent_type = tbl_consent_forms.consent_id','left')
			->where('patient_id', $parent_id)
			->get()
			->result();
	}

	public function get_logged_doctor($logged_id)
	{
		return $this->db->select('*')
			->from('tbl_employees')
			->where('tbl_employees.user_id', $logged_id)
			->get()
			->row();
	}
	public function getModules(){
		$this->db->select('*');
		$this->db->from('tbl_modules');
		$this->db->where('is_enable', 1);
		$this->db->order_by('is_order', 'ASC'); // Order by id in ascending order
		$query = $this->db->get();
	
		return $query->result_array();
	}
	public function getModulesList(){
		$this->db->select('*');
		$this->db->from('tbl_modules');
		$this->db->where('is_enable', 1);
		$this->db->where('is_module', 1);
		 // Order by id in ascending order
		$query = $this->db->get();
	
		return $query->result_array();
	}

	public function get_modules_by_user($logged_id)
	{
		$this->db->select('*');
		$this->db->from('tbl_modules');
		$this->db->where('is_module', 1);
		if ($logged_id != 0 ) {
			$this->db->where('department_id', $logged_id);
		}
		$query = $this->db->get();
		return $query->result_array();
	}

	public function get_patient_by_details()
	{

		$searchTerm = strtoupper($_GET['name_startsWith']);

		$query = $this->db->query("SELECT * FROM tbl_patients 
		WHERE tbl_patients.patient_id = '" . $searchTerm . "%' 
		OR tbl_patients.mobile LIKE '" . $searchTerm . "%' 
		OR tbl_patients.patient_name LIKE '%" . $searchTerm . "%' 
		OR tbl_patients.backup_id LIKE '%" . $searchTerm . "%' 
		OR tbl_patients.qatar_id LIKE '%" . $searchTerm . "%' 
		ORDER BY tbl_patients.patient_id ASC");

		return $query;
	}

	public function delete_patient($patient_id)
	{
		$this->db->where('patient_id', $patient_id);
		return $this->db->update('tbl_patients', ['deleted' => 1]);
	}

	// public function getTreatmentList($search, $module_id, $patient_id, $length, $start)
	// {
	// 	$str_quary = "";

	// 	$str_quary .= " SELECT 
	// 	tbl_treatment_payment.*,
	// 	GROUP_CONCAT(CONCAT(tbl_insurance_prices.treatment_name,' / ',tbl_insurance_prices.treatment_name_ar)  SEPARATOR '<br>') AS procedure_ids,
	// 	tbl_diagnostise.name,
	// 	tbl_episode_payment.*,
	// 	tbl_users.full_name
	// 	FROM 
	// 		tbl_treatment_payment
	// 	LEFT JOIN 
	// 		tbl_episode_payment ON tbl_treatment_payment.treatement_payment_id = tbl_episode_payment.treatement_payment_id
	// 	LEFT JOIN 
	// 	tbl_diagnostise ON tbl_diagnostise.diagnostise_id = tbl_episode_payment.diagnostise_id
	// 	LEFT JOIN 
	// 	tbl_users ON tbl_users.user_Id = tbl_treatment_payment.user_id
	// 	LEFT JOIN 
	// 	tbl_modules ON tbl_modules.department_id = tbl_treatment_payment.department_id
	// 	LEFT JOIN 
	// 	tbl_insurance_prices ON tbl_insurance_prices.id = tbl_episode_payment.procedure_id";
	// 	$str_quary .= " WHERE tbl_treatment_payment.department_id = " . $module_id . "";
	// 	$str_quary .= " AND tbl_treatment_payment.patient_id = " . $patient_id . "";
	// 	$str_quary .= " GROUP BY 
	// 		tbl_treatment_payment.treatement_payment_id ";

	// 	$query = $this->db->query($str_quary);
	// 	return $query->result();
	// 	// print_r($query->result());die;
	// }

	public function getTreatmentList($search, $module_id, $patient_id, $length, $start)
	{
		$this->db->select('tbl_treatment_payment.*, GROUP_CONCAT(CONCAT(tbl_insurance_prices.treatment_name,\' / \',tbl_insurance_prices.treatment_name_ar) SEPARATOR \'<br>\') AS procedure_ids, GROUP_CONCAT(tbl_episode_payment.aditional_diagnostise_name SEPARATOR \'<br>\') AS name,
		 GROUP_CONCAT(tbl_episode_payment.program SEPARATOR \'<br>\')  AS programs, tbl_episode_payment.*,tbl_treatment_payment.notes, tbl_users.full_name');
		$this->db->from('tbl_treatment_payment');
		$this->db->join('tbl_episode_payment', 'tbl_treatment_payment.treatement_payment_id = tbl_episode_payment.treatement_payment_id', 'left');
		$this->db->join('tbl_diagnostise', 'tbl_diagnostise.diagnostise_id = tbl_episode_payment.diagnostise_id', 'left');
		$this->db->join('tbl_users', 'tbl_users.user_Id = tbl_treatment_payment.user_id', 'left');
		$this->db->join('tbl_modules', 'tbl_modules.department_id = tbl_treatment_payment.department_id', 'left');
		$this->db->join('tbl_insurance_prices', 'tbl_insurance_prices.id = tbl_episode_payment.procedure_id', 'left');

		if ($module_id != '') {
			$this->db->where('tbl_treatment_payment.department_id', $module_id);
		}

		if ($patient_id != '') {
			$this->db->where('tbl_treatment_payment.patient_id', $patient_id);
		}

		$this->db->group_by('tbl_treatment_payment.treatement_payment_id');

		if ($length != -1) {
			$this->db->limit($length, $start);
		}

		if (!empty($search)) {
			//Any serch query
			// $this->db->like('patient_name', $search);
			// $this->db->or_like('patient_id', $search);
		}
	$this->db->order_by('tbl_treatment_payment.created_date','DESC');
		$query = $this->db->get();
		return $query->result();
	}
	
	public function removePackage($patient_id, $package_id)
{
    $this->db->where('patient_id', $patient_id);
    $this->db->where('package_id', $package_id);
    $this->db->delete('user_has_package');
}


	public function getPatientsList($search, $length, $start, $order_column, $order,$patient_mobile,$patient_file)
	{
		$this->db->select('tbl_patients.*, tbl_insurance_types.*, tbl_patients.patient_id as file_no')
			->from('tbl_patients')
			->limit($length, $start)
		
			->join('tbl_insurance_types', 'tbl_patients.insurance_type = tbl_insurance_types.insurance_type_id','left')
			 ->order_by('tbl_patients.patient_id', 'DESC')
			->group_by('tbl_patients.patient_id');
			

		if (!empty($search)) {
			$this->db->group_start();
			$this->db->like('patient_name', $search);
			$this->db->or_like('qatar_id', $search);
		
		
			$this->db->group_end();
		}
	if (!empty($patient_mobile)) {
			$this->db->where('mobile', $patient_mobile);
		}
		if (!empty($patient_file)) {
			$this->db->where('patient_id', $patient_file);
		}

		$this->db->where('tbl_patients.deleted', 0);

		$result = $this->db->get()->result();

		// usort($result, function ($a, $b) {
		// 	return $a->file_no <= $b->file_no;
		// });

		return $result;
	}

	
	public function getPatientsListSelect()
	{
		$this->db->select('*')
			->from('tbl_patients');
		

		$result = $this->db->get()->result();

		// usort($result, function ($a, $b) {
		// 	return $a->file_no <= $b->file_no;
		// });

		return $result;
	}

	public function savePatientMedicalBook($data)
	{
		return $this->db->insert('tbl_patient_medicals', $data);
	}



	public function updatePatientMedicalBook($data, $id)
	{
		$this->db->where('patient_id', $id);
		return $this->db->update('tbl_patient_medicals', $data);
	}
	public function updateSessions($patient_id, $package_id,$department_id)
	{
		$sessions= $this->db->select('*')
		->from('user_attend_sessions')
		->where('patient_id', $patient_id)
		->where('package_id', $package_id)
		->where('department_id', $department_id)
		->get()
		->row();

		if($sessions){
			$this->db->where('patient_id', $patient_id);
			$this->db->where('package_id', $package_id);
			$this->db->where('department_id', $department_id);
			$attend_sessions= (int)$sessions->session;
			$attend_sessions= $attend_sessions+1;
		return  $this->db->update('user_attend_sessions', ['session'=>$attend_sessions]);
		}
		else{
			$data= array(
				'patient_id'=>$patient_id,
				'package_id'=>$package_id,
				'department_id'=>$department_id,
				'session'=>1,
			);
		 	return $this->db->insert('user_attend_sessions', $data);
		}
	}

	public function getPatientHistory($patient_id)
	{
		return $this->db->select('*')
			->from('tbl_patient_medicals')
			->where('patient_id', $patient_id)
			->get()
			->row();
	}

	public function getDoctors()
	{
		return $this->db->select('*')
			->from('tbl_employees')
			->join('tbl_users', 'tbl_employees.user_id = tbl_users.user_Id')
			->where_in('tbl_users.designation_id', array(1))
			->get()
			->result();
	}

	public function getNurses()
	{
		return $this->db->select('*')
			->from('tbl_employees')
			->join('tbl_users', 'tbl_employees.user_id = tbl_users.user_Id')
			->where_in('tbl_users.designation_id', array(2))
			->get()
			->result();
	}

	public function getDoctorById($doctorId)
	{
		return $this->db->select('tbl_users.full_name as employee_name')
			->from('tbl_employees')
			->join('tbl_users', 'tbl_employees.user_id = tbl_users.user_Id')
			->where_in('tbl_users.designation_id', array(1))
			->where('tbl_employees.user_id', $doctorId)
			->get()
			->row();
	}

	public function getNurseById($nurseId)
	{
		return $this->db->select('tbl_users.full_name as employee_name')
			->from('tbl_employees')
			->join('tbl_users', 'tbl_employees.user_id = tbl_users.user_Id')
			->where_in('tbl_users.designation_id', array(2))
			->where('tbl_employees.user_id', $nurseId)
			->get()
			->row();
	}
	
		public function getUserById($userId)
	{
		return $this->db->select('tbl_users.full_name as employee_name')
		    ->from('tbl_users')
			->where('tbl_users.user_id', $userId)
			->get()
			->row();
	}


	public function getPrices($insurance_id = null)
	{
		if (!empty($insurance_id)) {
			$this->db->where('insurance_type_id', $insurance_id);
		}

		return $this->db->select('*')
			->from('tbl_insurance_prices')
			->where('treatment_category', 2)
			->get()
			->result();
	}

	public function getLastTreatment($patient_id)
	{
		return $this->db->select('*')
			->from('tbl_treatment_payment')
			->where('patient_id', $patient_id)
			->get()
			->row();
	}

	// public function createTreatmentLog($data)
	// {
	// 	return $this->db->insert('tbl_tbl_treatment_log', $data);
	// 	if ($this->db->affected_rows() > 0) {
	// 		return $this->db->insert_id();
	// 	} else {
	// 		return false;
	// 	}
	// }

	// public function createTreatment($data)
	// {
	// 	return $this->db->insert('tbl_treatment_payment', $data);
	// 	if ($this->db->affected_rows() > 0) {
	// 		return $this->db->insert_id();
	// 	} else {
	// 		return false;
	// 	}
	// }

	public function createDerma($data)
	{
		return $this->db->insert('tbl_treat_derma', $data);
		if ($this->db->affected_rows() > 0) {
			return $this->db->insert_id();
		} else {
			return false;
		}
	}

	public function get_drugs($type, $nameStartsWith)
	{
		if ($type == 'drug') {
			$nameStartsWith = strtoupper($nameStartsWith);

			$this->db->like('drug_name', $nameStartsWith, 'after');
			$this->db->or_like('drug_id', $nameStartsWith, 'after');
			$this->db->order_by('drug_id', 'ASC');

			$query = $this->db->get('tbl_drugs_list');

			$data = array();
			foreach ($query->result() as $row) {
				array_push($data, $row->drug_id . ' - ' . $row->drug_name);
			}

			return $data;
		}
		return array();
	}

	public function get_treatment_episodes($treatment_id)
	{
		return $this->db->select('*')->from('tbl_episode_payment')
			->join('tbl_insurance_prices', 'tbl_insurance_prices.id=tbl_episode_payment.procedure_id', 'left')
			->where('treatement_payment_id', $treatment_id)
			->get()
			->result_array();
	}

	public function getHistory($patient_id)
	{
		return $this->db->select('*')->from('tbl_patient_medicals')->where('patient_id', $patient_id)->get()->row();
	}

	public function get_nurses()
	{
		return $this->db->select('*')->from('tbl_employees')
			->join('tbl_users', 'tbl_users.user_Id=tbl_employees.user_id')
			->where('employee_type', 2)
			->get()
			->result_array();
	}

	public function getTreatmentCategories()
	{
		return $this->db->select('*')->from('tbl_treatment_category')->get()->result();
	}

	public function get_planofcare($id, $from = '', $to = '')
	{

		$query = $this->db->query("SELECT * FROM tbl_planofcare_main LEFT JOIN tbl_users ON tbl_planofcare_main.doctor_id = tbl_users.user_Id LEFT JOIN tbl_employees ON tbl_users.user_Id = tbl_employees.user_id LEFT JOIN tbl_treatment_category ON tbl_planofcare_main.p_category = tbl_treatment_category.treatment_categorytreatment_category_id WHERE tbl_planofcare_main.patient_id = '$id' " . (($from != '' && $to != '') ? " AND enter_date BETWEEN '$from' AND '$to' " : "") . " ORDER BY tbl_planofcare_main.planofcare_main_id DESC");

		if ($query->num_rows() > 0) {
			return $query->result_array();
		} else {
			return FALSE;
		}
	}
	public function update_data($table, $field, $value, $data)
	{

		$query = $this->db->query("SELECT *FROM $table WHERE $field ='$value'");

		if ($query->num_rows() > 0) {
			$this->db->where($field, $value);
			$this->db->update($table, $data);
			return TRUE;
		} else {
			return FALSE;
		}
	}

	public function get_patient_tret()
	{
		/*$this->db->select('tbl_patients.patient_id, tbl_patients.patient_name, tbl_treatment_log.treatment_date, tbl_treatment_log.doctor_id, tbl_employees.employee_name');
		$this->db->from('tbl_treatment_log');
		$this->db->join('tbl_patient_file', 'tbl_patient_file.file_id = tbl_treatment_log.file_id');
		$this->db->join('patients', 'tbl_patients.patient_id = tbl_patient_file.patient_id');
		$this->db->join('doctors', 'tbl_treatment_log.doctor_id = doctors.doctor_id');
		$this->db->join('employee', 'tbl_employees.employee_id = doctors.employee_id');
		$query = $this->db->get();*/
		//$query = $this->db->query("SELECT tbl_patients.patient_id, tbl_patients.patient_name, tbl_treatment_log.treatment_date, tbl_treatment_log.doctor_id, tbl_employees.employee_name FROM patients LEFT JOIN tbl_patient_file ON tbl_patients.patient_id = tbl_patient_file.patient_id LEFT JOIN tbl_treatment_log ON tbl_patient_file.file_id = tbl_treatment_log.file_id LEFT JOIN doctors ON tbl_treatment_log.doctor_id = doctors.doctor_id LEFT JOIN employee ON tbl_employees.employee_id = doctors.employee_id");
		$query = $this->db->query("SELECT tbl_patients.patient_id, tbl_patients.patient_name, tbl_patients.qatar_id, tbl_patients.sex, tbl_patient_file.file_id, tbl_patients.backup_id FROM tbl_patients LEFT JOIN tbl_patient_file ON tbl_patients.patient_id = tbl_patient_file.patient_id ORDER BY tbl_patients.patient_id DESC LIMIT 100");
		if ($query->num_rows() > 0) {
			return $query->result_array();
		} else {
			return FALSE;
		}
	}
	public function get_profile_main($id)
	{

		$query = $this->db->query("SELECT tbl_patients.patient_id, tbl_patients.patient_name, tbl_patients.dob, tbl_patients.profile_img, tbl_treatment_log.treatment_date, tbl_treatment_log.doctor_id,  TIMESTAMPDIFF(YEAR,tbl_patients.dob,CURDATE()) AS age, tbl_patients.insurance_type, tbl_patients.sex, tbl_patients.qatar_id, tbl_insurance_types.insurance_name,tbl_patients.backup_id,tbl_treatment_log.due, tbl_countries.country_name, tbl_patients.company_id, tbl_company.company_name, tbl_patients.qid_front_image,tbl_patients.member_id,tbl_patients.registerd_date FROM tbl_patients LEFT JOIN tbl_patient_file ON tbl_patients.patient_id = tbl_patient_file.patient_id LEFT JOIN tbl_treatment_log ON tbl_patient_file.file_id = tbl_treatment_log.file_id LEFT JOIN tbl_users ON tbl_treatment_log.doctor_id = tbl_users.user_Id LEFT JOIN tbl_employees ON tbl_employees.user_id = tbl_users.user_Id LEFT JOIN tbl_insurance_types ON tbl_patients.insurance_type = tbl_insurance_types.insurance_type_id LEFT JOIN tbl_countries ON tbl_patients.nationality = tbl_countries.country_id LEFT JOIN tbl_company ON tbl_company.company_id = tbl_patients.company_id WHERE tbl_patients.patient_id ='$id' ORDER BY log_id DESC LIMIT 1");
		if ($query->num_rows() > 0) {
			return $query->result_array();
		} else {
			return FALSE;
		}
	}
	public function get_doctors()
	{

		$query = $this->db->query("SELECT *FROM tbl_users LEFT JOIN tbl_employees ON tbl_users.user_Id = tbl_employees.user_id WHERE tbl_users.designation_id='1' ORDER BY tbl_users.full_name ASC");

		if ($query->num_rows() > 0) {
			return $query->result_array();
		} else {
			return FALSE;
		}
	}
	
	
	public function get_users_by_designation($designation)
	{

		$query = $this->db->query("SELECT *FROM tbl_users LEFT JOIN tbl_employees ON tbl_users.user_Id = tbl_employees.user_id WHERE tbl_users.designation_id='$designation' ORDER BY tbl_users.full_name ASC");

		if ($query->num_rows() > 0) {
			return $query->result_array();
		} else {
			return FALSE;
		}
	}
	
	public function getPatientDiscount($id){
		$this->db->select('discount_category, company_id');
		$this->db->from('tbl_patients');
		$this->db->where('patient_id', $id);
		$patient = $this->db->get()->row();
		
		if (!$patient) {
			return []; // Return an empty array if the patient does not exist
		}
		
		// Get discount categories
		if($patient->discount_category){
			$this->db->select('id, category, discount');
			$this->db->from('discount_category');
			$this->db->where('id', $patient->discount_category);
			
			$discountCategories = $this->db->get()->result_array();
		}else{
			$discountCategories= [];
		}

		 // Mark these as categories
		 foreach ($discountCategories as &$category) {
			$category['type'] = 'category';
		}
		
		if($patient->company_id){
		$this->db->select('company_id, company_name, discount');
		$this->db->from('tbl_companies');
		$this->db->where('company_id', $patient->company_id);
		$companyDiscounts = $this->db->get()->result_array();
		}else{
			$companyDiscounts=[];
		}
		 // Mark these as company discounts
		 foreach ($companyDiscounts as &$discount) {
			$discount['type'] = 'company';
		}
		// Merge both results
		$discounts = array_merge($discountCategories, $companyDiscounts);
		
		return $discounts;
	}
	
	public function retrieve_data($table)
	{

		$query = $this->db->query("SELECT *FROM $table");

		if ($query->num_rows() > 0) {
			return $query->result_array();
		} else {
			return FALSE;
		}
	}
	public function retrieve_data_result($table)
	{

		$query = $this->db->query("SELECT *FROM $table");
			
			if($query->num_rows() > 0)
			{
				return $query->result();
				
			} else{
				return FALSE;
			}
	}


	public function get_row_data($table, $filed_name, $filed_value)
	{

		$query = $this->db->query("SELECT * FROM $table WHERE $filed_name ='$filed_value'");

		if ($query->num_rows() > 0) {
			return $query->row();
		} else {
			return FALSE;
		}
	}

	public function get_last_row($table)
	{

		$query = $this->db->query("SELECT * FROM $table");

		if ($query->num_rows() > 0) {
			return $query->last_row();
		} else {
			return 000;
		}
	}

	public function get_row($table)
	{

		$query = $this->db->query("SELECT * FROM $table");

		if ($query->num_rows() > 0) {
			return $query->row();
		} else {
			return FALSE;
		}
	}
	public function patient_a_planofcare($id)
	{

		$query = $this->db->query("SELECT *FROM tbl_planofcare_main 
		                  LEFT JOIN tbl_planofcare 
		                  ON tbl_planofcare_main.planofcare_main_id = tbl_planofcare.planofcare_main_id 
		                  LEFT JOIN tbl_patients ON tbl_planofcare_main.patient_id = tbl_patients.patient_id 
		                  LEFT JOIN tbl_users ON tbl_planofcare.doctor_id = tbl_users.user_Id 
		                  LEFT JOIN tbl_employees ON tbl_users.user_Id = tbl_employees.user_id
		                  LEFT JOIN p_treatment_price ON p_treatment_price.p_treatment_id = tbl_planofcare.procedure_id
		                  WHERE tbl_planofcare_main.planofcare_main_id = '$id' 
		                  ORDER BY tbl_planofcare.planofcare_id ASC");
		if ($query->num_rows() > 0) {
			return $query->result_array();
		} else {
			return FALSE;
		}
	}
	public function get_insurance($patient_id)
	{

		$query = $this->db->query("SELECT * FROM tbl_patients WHERE tbl_patients.patient_id = '$patient_id'");

		if ($query->num_rows() > 0) {
			return $query->row();
		} else {
			return FALSE;
		}
	}
	public function get_planofcare_treats($id)
	{

		$query = $this->db->query("SELECT *FROM tbl_planofcare
                  LEFT JOIN tbl_insurance_prices ON tbl_insurance_prices.treatment_id  = tbl_planofcare.procedure_id
                  LEFT JOIN tbl_diagnostise ON tbl_diagnostise.diagnostise_id = tbl_planofcare.diagnosis_id
                  -- LEFT JOIN procedure_list ON procedure_list.procedure_id = planofcare.procedure_id
                  WHERE tbl_planofcare.planofcare_main_id = '$id' ");

		if ($query->num_rows() > 0) {
			return $query->result_array();
		} else {
			return FALSE;
		}
	}
	public function retrieve_data_unique($table, $filed_name, $filed_value)
	{

		$query = $this->db->query("SELECT *FROM $table WHERE $filed_name = '$filed_value'");

		if ($query->num_rows() > 0) {
			return $query->result_array();
		} else {
			return FALSE;
		}
	}
	public function get_last_exam($id)
	{
		$query = $this->db->query("SELECT * FROM tbl_examination
                  WHERE patient_id = '$id'
                   ORDER BY exam_id DESC LIMIT 1");

		if ($query->num_rows() > 0) {
			return $query->row();
		} else {
			return FALSE;
		}
	}


	public function getRefferal($patient_id,$reffered_by)
	{
		return $this->db->select('refferals.*, referred_by_user.full_name as cname, GROUP_CONCAT(referred_to_user.full_name SEPARATOR ", ") as toname')
        ->from('refferals')
        ->join('tbl_users as referred_by_user', 'refferals.reffered_by = referred_by_user.user_Id')
        ->join('referred_item_doctors', 'refferals.id = referred_item_doctors.refferal_id', 'left')
        ->join('tbl_users as referred_to_user', 'referred_item_doctors.doctor_id = referred_to_user.user_Id', 'left')
        ->where('refferals.reffered_by', $reffered_by)
		->or_where('referred_item_doctors.doctor_id', $reffered_by)
        ->where('refferals.patient_id', $patient_id)
        ->order_by('refferals.created_at', 'DESC')
        ->group_by('refferals.id') // Group by referral ID to handle multiple doctors
        ->get()
        ->result();
	}
	public function getRefferalDetails($id)
	{

			return $this->db->select('refferals.*, referred_by_user.full_name as cname, GROUP_CONCAT(referred_to_user.full_name SEPARATOR ", ") as toname,patient.patient_name,patient.patient_id')
        ->from('refferals')
        ->join('tbl_users as referred_by_user', 'refferals.reffered_by = referred_by_user.user_Id')
        ->join('referred_item_doctors', 'refferals.id = referred_item_doctors.refferal_id', 'left')
		->join('tbl_patients as patient', 'refferals.patient_id = patient.patient_id')
        ->join('tbl_users as referred_to_user', 'referred_item_doctors.doctor_id = referred_to_user.user_Id', 'left')
        ->where('refferals.id', $id)
      
        ->order_by('refferals.created_at', 'DESC')
        ->group_by('refferals.id') // Group by referral ID to handle multiple doctors
        ->get()
        ->row();
	}
	public function getRefferalDiscussion($id)
	{
		$discussion = $this->db->select('refferal_discussion.*, tbl_users.full_name as user_name')
        ->from('refferal_discussion')
        ->join('tbl_users', 'refferal_discussion.user_id = tbl_users.user_Id')
        ->where('refferal_discussion.refferal_id', $id)
        ->order_by('refferal_discussion.created_at', 'ASC')
        ->get()
        ->result();

		return $discussion;
	}

	public function addDoctorToDiscussion($doctorId, $referredItemId,$loginId){
		$data = [
            'refferal_id' => $referredItemId,
            'doctor_id' => $doctorId
        ];

		$data_discussion = [
            'comment' => 'New Doctor Has Been Added',
            'user_id' =>  $loginId , // Assuming user_id is stored in session
            'created_at' => date('Y-m-d H:i:s'),
			'type'=>'1',
			'refferal_id' => $referredItemId,
        ];
		$this->db->insert('refferal_discussion', $data_discussion);

        // Example using a many-to-many table
        return $this->db->insert('referred_item_doctors', $data);
	}
	public function get_module_by_department_id($department_id) {
		return $this->db->get_where('tbl_modules', array('department_id' => $department_id))->row_array();
	}
	public function get_patient_plan($patient_id,$department_id) {
		$plans = $this->db->select('treatment_plan.*, tbl_users.full_name as doctor_name')
        ->from('treatment_plan')
        ->join('tbl_users', 'treatment_plan.doctor_id = tbl_users.user_Id')
        ->where('treatment_plan.patient_id', $patient_id)
		->where('treatment_plan.department_id', $department_id)
        ->order_by('treatment_plan.created_at', 'ASC')
        ->get()
        ->result();

		return $plans;
	}
	public function get_plan_data($id) {
		$plans = $this->db->select('treatment_plan.*, tbl_users.full_name as doctor_name')
        ->from('treatment_plan')
        ->join('tbl_users', 'treatment_plan.doctor_id = tbl_users.user_Id')
     
		->where('treatment_plan.plan_id', $id)
       
        ->get()
        ->row();

		return $plans;
	}


}
