<?php

use
    DataTables\Editor,
    DataTables\Editor\Field,
    DataTables\Editor\Format,
    DataTables\Editor\Join,
    DataTables\Editor\Upload,
    DataTables\Editor\Validate;
    
class EditorModel extends CI_Model 
{
    private $editorDb = null;
    
    //constructor which loads the CodeIgniter database class (not required)
    public function __construct()   {
        $this->load->database();
    }    
    
    public function init($editorDb)
    {
        $this->editorDb = $editorDb;
    }
    
    public function geTQLMPrice($post)
    {
        Editor::inst( $this->editorDb, 'qlm_price_list' )
        ->fields(
            Field::inst( 'qlm_price_list.qlm_code' ),
            Field::inst( 'qlm_price_list.qlm_treatment_name' )->validator( 'Validate::notEmpty' ),
            Field::inst( 'qlm_price_list.qlm_price' )->validator( 'Validate::notEmpty' ),
            Field::inst( 'qlm_price_list.category_id' )->validator( 'Validate::notEmpty' ),
            Field::inst( 'p_treatment_category.p_treatment_category_name' )
        )
        ->leftJoin( 'p_treatment_category',   'p_treatment_category.p_treatment_category_id',   '=', 'qlm_price_list.category_id' )
        ->pkey('qlm_price_list.qlm_code')
        ->process( $post )
        ->json();    
    }

    public function geTALKOOTPrice($post)
    {
        Editor::inst( $this->editorDb, 'p_alkoot_price' )
        ->fields(
            Field::inst( 'p_alkoot_price.p_alkoot_treatment_id' ),
            Field::inst( 'p_alkoot_price.p_alkoot_treatment_name' )->validator( 'Validate::notEmpty' ),
            Field::inst( 'p_alkoot_price.p_alkoot_treatment_ar' )->validator( 'Validate::notEmpty' ),
            Field::inst( 'p_alkoot_price.alkoot_lqdc_gross' )->validator( 'Validate::notEmpty' ),
            Field::inst( 'p_alkoot_price.p_treatment_category' )->validator( 'Validate::notEmpty' ),
            Field::inst( 'p_treatment_category.p_treatment_category_name' )
        )
        ->leftJoin( 'p_treatment_category',   'p_treatment_category.p_treatment_category_id',   '=', 'p_alkoot_price.p_treatment_category' )
        ->pkey('p_alkoot_price.p_alkoot_treatment_id')
        ->process( $post )
        ->json();      
    }

}