<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

class ProductsModel extends CI_Model {

    function __construct() {
        parent::__construct();
        $this->load->database();
    }
	
	public function getList($product_name,$product_code,$is_new_arrival,$is_best_seller,$is_get_free,$data) {
		
		$limit = $data['page']*$data['page_count'];
		
		$str_quary = "";
		
		$str_quary .= " select * "; 
		$str_quary .= " from tbl_products ";
		$str_quary .= " where tbl_products.is_delete = 0 ";
		
		
		
		if($product_code != '' && $product_code != null){
			
			$str_quary .= "  and tbl_products.product_code like '%".$product_code."%'";
		}
		
		if($product_name != '' && $product_name != null){
			
			$str_quary .= "  and tbl_products.product_name like '%".$product_name."%'";
		}
		
		if($is_new_arrival != '' && $is_new_arrival != null){
			
			$str_quary .= "  and tbl_products.is_new_arrival = 1";
		}
		
		if($is_get_free != '' && $is_get_free != null){
			
			$str_quary .= "  and tbl_products.is_get_free = 1";
		}
		
		if($is_best_seller != '' && $is_best_seller != null){
			
			$str_quary .= "  and tbl_products.is_best_seller = 1";
		}
		
		$str_quary .= " order by product_id desc ";
		
		$str_quary .= " limit ".$limit.",".$data['page_count'];
		
		$query = $this->db->query($str_quary);
        return $query;
		
	}
	
	public function save($data,$is_new_image,$imageData,$flavour_details,$image_details) {
	
		$flavour_price = array_column($flavour_details, 'flavour_price');
		$gbp_price = array_column($flavour_details, 'gbp_price');
		$eur_price = array_column($flavour_details, 'eur_price');
		
		$LKR = min($flavour_price);
		$GBP = min($gbp_price);
		$EUR = min($eur_price);
		
		
        $this->db->insert('tbl_products', $data);
		
        $_id = $this->db->insert_id();
		
		$this->db->set('price' , $LKR); 
		$this->db->set('gbp_price' , $GBP);
		$this->db->set('eur_price' , $EUR);
		$this->db->set('image_path', '');
		$this->db->where('product_id', $_id);
		$this->db->update('tbl_products');
		
		self::save_flavours($_id,$flavour_details);
		self::save_productImages($_id,$image_details);

        return $_id;
		
    }

    public function update($_id,$data,$is_new_image,$imageData,$flavour_details,$image_details) {
		
		$flavour_price = array_column($flavour_details, 'flavour_price');
		$gbp_price = array_column($flavour_details, 'gbp_price');
		$eur_price = array_column($flavour_details, 'eur_price');
		
		$LKR = min($flavour_price);
		$GBP = min($gbp_price);
		$EUR = min($eur_price);
		
		$image_path = $imageData;
		
		
        $this->db->set('product_name', $data["product_name"]);
        $this->db->set('product_code', $data["product_code"]);
        $this->db->set('description', $data["description"]);
        $this->db->set('additional_description', $data["additional_description"]);
        $this->db->set('price' , $LKR);
		$this->db->set('gbp_price' , $GBP);
		$this->db->set('eur_price' , $EUR);
        $this->db->set('tag_ids', $data["tag_ids"]);
        $this->db->set('category_ids', $data["category_ids"]);
        $this->db->set('tags', $data["tags"]);
        $this->db->set('image_path', trim($image_path));
        $this->db->set('categories', $data["categories"]);
        $this->db->set('status', $data["status"]);
        $this->db->set('is_active', $data["is_active"]);
        $this->db->set('is_new_arrival', $data["is_new_arrival"]);
        $this->db->set('is_get_free', $data["is_get_free"]);
        $this->db->set('is_best_seller', $data["is_best_seller"]);
		
        $this->db->set('updated_by', $data["created_by"]);
        $this->db->set('updated_datetime', $data["updated_datetime"]);
		
        $this->db->where('product_id', $_id);
        $this->db->update('tbl_products');
		
		self::save_flavours($_id,$flavour_details);
		self::save_productImages($_id,$image_details);
		
    }
	
	public function save_image($parent_id,$_id,$image,$imageType) {
		
		$falder_path = $this->CommonModel->targetDocumentPath($parent_id,$_id,'products',$imageType);
		$image_url = $falder_path.$_id.'.png';

		if (file_exists($image_url))  
		{ 
			unlink(trim($image_url));
		} 

		$_image = $image;

		$image_parts = explode(";base64,", $_image);
		$image_type_aux = explode("image/", $image_parts[0]);
		$image_type = $image_type_aux[1];
		$image_base64 = base64_decode($image_parts[1]);
		$file = $image_url;

		file_put_contents($file, $image_base64);
		$image_path = $image_url;
		
		return $image_path;
		
	}
	
	public function get_details_by_id($_id) {
		
		$str_quary = "";
		
		$str_quary .= " select * "; 
		$str_quary .= " from tbl_products ";
		$str_quary .= " where tbl_products.product_id = ".$_id;
		
		$query = $this->db->query($str_quary);
        return $query;
		
	}
	
	public function get_flavours($_id) {
		
		$str_quary = "";
		
		$str_quary .= " select * , 'false' as is_new_image"; 
		$str_quary .= " from tbl_flavours ";
		$str_quary .= " where tbl_flavours.product_id = ".$_id;
		
		$query = $this->db->query($str_quary);
        return $query->result_array();
		
	}
	
	public function save_flavours($_id,$flavour_details) {
		
		$this->db->set('is_delete', true);
		
        $this->db->where('product_id', $_id);
        $this->db->update('tbl_flavours');
		
		foreach ($flavour_details as $key => $value) {
			
			$is_update = self::is_available($value['flavour_id'] );
			
			if($is_update == false) {
				
				$data = array(
					
					'flavour_code' => $value['flavour_code'],
					'flavour_name' => $value['flavour_name'],
					'flavour_price' => $value['flavour_price'],
					'gbp_price' => $value['gbp_price'],
					'eur_price' => $value['eur_price'],
					
					'product_id' => $_id,
					'created_by' => $value['created_by'],  
					'created_datetime' => $value['created_datetime'], 
					'updated_by' => 0,   
					'updated_datetime' => $value['created_datetime']

				);
				
				$this->db->insert('tbl_flavours', $data);
        		$id = $this->db->insert_id();
				
				if($value['is_new_image'] == 'true') {
					$imagePath = self::save_image($_id,$id,$value['image_path'],'flavour');
				} else {
					$imagePath = $value['image_path'];
				}
				
				$this->db->set('image_path', $imagePath);
		
        		$this->db->where('flavour_id', $id);
        		$this->db->update('tbl_flavours');
				
			} else {
				
				if($value['is_new_image'] == 'true') {
					$imagePath = self::save_image($_id,$value['flavour_id'],$value['image_path'],'flavour');
				} else {
					$imagePath = $value['image_path'];
				}
				
				
				$this->db->set('flavour_code', $value['flavour_code']);
				$this->db->set('flavour_name', $value['flavour_name']);
				$this->db->set('flavour_price', $value['flavour_price']);
				$this->db->set('gbp_price', $value['gbp_price']);
				$this->db->set('eur_price', $value['eur_price']);
				
				$this->db->set('image_path', $imagePath);
				
				$this->db->set('is_delete', false);
		
        		$this->db->where('flavour_id', $value['flavour_id']);
        		$this->db->update('tbl_flavours');
				
			}
			 
		}
		
		$query = ("Delete from tbl_flavours where is_delete = true and product_id = " . $_id);
		$this->db->query($query);
		
	}
	
	public function is_available($_id ){
		
		$is_available = false;
		
		$str_quary = "";
		
		$str_quary .= " select * ";
		$str_quary .= " from tbl_flavours ";
		$str_quary .= " where tbl_flavours.flavour_id = ".$_id;
		
		$query = $this->db->query($str_quary);
		
		foreach ($query->result() as $row) {
			$is_available = true;
		}
		
		return $is_available;
		
	}
	
	
    public function get_category_by_id($category_id) {
		
		$str_quary = "";
		
		$str_quary .= " select * ";
		$str_quary .= " from tbl_categories ";
		$str_quary .= " where tbl_categories.category_id = ".$category_id;

		$query = $this->db->query($str_quary);
        return $query;
		
    }

    public function get_tag_by_id($tag_id) {
		
		$str_quary = "";
		
		$str_quary .= " select * ";
		$str_quary .= " from tbl_tags ";
		$str_quary .= " where tbl_tags.tag_id = ".$tag_id;

		$query = $this->db->query($str_quary);
        return $query;
		
    }

	
	public function get_productImages($_id) {
		
		$str_quary = "";
		
		$str_quary .= " select * "; 
		$str_quary .= " from tbl_product_images ";
		$str_quary .= " where tbl_product_images.product_id = ".$_id;
		
		$query = $this->db->query($str_quary);
        return $query->result_array();
		
	}
	
	public function save_productImages($_id,$image_details) {
		
		$this->db->set('is_delete', true);
		
        $this->db->where('product_id', $_id);
        $this->db->update('tbl_product_images');
		
		foreach ($image_details as $key => $value) {
			
			if($value['id'] == 0) {
				
				$data = array(
					
					'product_id' => $_id,
					'is_default_image' => $value['is_default_image']
				);
				
				$this->db->insert('tbl_product_images', $data);
        		$id = $this->db->insert_id();
				
				$imagePath = self::save_image($_id,$id,$value['image_path'],'productImage');
				
				if($value['is_default_image'] == 1){
					$this->db->set('image_path', $imagePath);
					$this->db->where('product_id', $_id);
					$this->db->update('tbl_products');
				}
					
				
				$this->db->set('image_path', $imagePath);
        		$this->db->where('id', $id);
        		$this->db->update('tbl_product_images');
				
			} else {
				
				if($value['is_default_image'] == 1){
					$this->db->set('image_path', $value["image_path"]);
					$this->db->where('product_id', $_id);
					$this->db->update('tbl_products');
				}
				
				$this->db->set('is_delete', false);
				$this->db->set('is_default_image', $value['is_default_image']);
		
        		$this->db->where('id', $value['id']);
        		$this->db->update('tbl_product_images');
				
			}
			 
		}
		
		$query = ("Delete from tbl_product_images where is_delete = true and product_id = " . $_id);
		$this->db->query($query);
		
	}
}
