<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

class CompanyModel extends CI_Model {

    function __construct() {
        parent::__construct();
        $this->load->database();
    }

    public function get_list() {
        $query = $this->db->select('*')
                ->from('tbl_company')
                ->get();
        return $query;
    }

    public function save($data,$is_new_image) {
        $this->db->insert('tbl_company', $data);
        $company_id = $this->db->insert_id();

        return $company_id;
    }
    public function saveTransaction($data) {
        $this->db->insert('skipcash_transactions', $data);
        $transaction_id = $this->db->insert_id();

        return $transaction_id;
    }
    public function getTransactions($type){
        $this->db->select('*');
		$this->db->from('skipcash_transactions');
		
	
		if (!empty($type)) {
			$this->db->where('type =', $type);
		}
        $this->db->where('status =', 'Completed');
		
			$this->db->order_by('date', 'DESC');
		
		$query = $this->db->get();
		return $query->result_array();
    }

    public function update($company_id, $data,$is_new_image) {
		
		$image_path = $data["logo"];
		
		/*Image update*/
		if($is_new_image == 'true') {
			
				$falder_path = UPLOAD_PATH.'/'."Images/companylogo";
			$std_image_url = $falder_path.'.png';
			
			if (file_exists($std_image_url))  
			{ 
				unlink(trim($std_image_url));
			} 
			
			$std_image = $image_path;

			$image_parts = explode(";base64,", $std_image);
			$image_type_aux = explode("image/", $image_parts[0]);
			$image_type = $image_type_aux[1];
			$image_base64 = base64_decode($image_parts[1]);
			$file = $std_image_url;

			file_put_contents($file, $image_base64);
			$image_path = $std_image_url;
			
		}
		
		
        $this->db->set('company_name', $data["company_name"]);
        $this->db->set('description', $data["description"]);
        $this->db->set('address', $data["address"]);
        $this->db->set('phone_no', $data["phone_no"]);
        $this->db->set('mobile_no', $data["mobile_no"]);
        $this->db->set('fax', $data["fax"]);
        $this->db->set('email', $data["email"]);
        $this->db->set('web', $data["web"]);
        $this->db->set('logo', $image_path);
		
        $this->db->set('create_user_Id', $data["create_user_Id"]);
        $this->db->set('create_datetime', $data["create_datetime"]);

        $this->db->where('company_id', $company_id);
        $this->db->update('tbl_company');
    }

    

    public function get_by_id() {
        $query = $this->db->select('*')
                ->from('tbl_company')
                ->get();
        return $query->result_array();
    }
}