<!DOCTYPE html>
<html>

<head>
  <meta charset="UTF-8">
  <title> Consent Forms </title>
  <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
  <link rel="stylesheet" href="<?= base_url('css/jquery-ui.css') ?>">


  <?php require_once(APPPATH . "views/admin/header.php"); ?>
  <style type="text/css">
    .ui-autocomplete {
      max-height: 100px;
      overflow-y: auto;
      /* prevent horizontal scrollbar */
      overflow-x: hidden;
      z-index: 5000;
    }

    input[type="text"] {
      width: 255px;
    }

    ;

    /*      body{
        font-family:monospace;
        text-align:center;
      }*/
    #btnSaveSign {
      color: #fff;
      background: #f99a0b;
      padding: 5px;
      border: none;
      border-radius: 5px;
      font-size: 20px;
      margin-top: 10px;
    }

    #signArea,
    #dsignArea,
    #wsignArea {
      width: 304px;
    }

    .sign-container {
      width: 60%;
      margin: auto;
    }

    .sign-preview {
      width: 150px;
      height: 50px;
      border: solid 1px #CFCFCF;
      margin: 10px 5px;
    }

    .tag-ingo {
      font-family: cursive;
      font-size: 12px;
      text-align: left;
      font-style: oblique;
    }

    .loading-spinner {
      width: 30px;
      height: 30px;
      border: 5px solid #48bcff;
      border-radius: 50%;
      border-top-color: #0001;
      display: inline-block;
      animation: loadingspinner .7s linear infinite;
    }

    input.single-line {
      border-bottom: 1px solid #000 !important;
      border: 0;
      border-radius: 0;
      box-shadow: none;
    }

    input.single-line:focus {
      box-shadow: none !important;
      outline: none;
    }

    @keyframes loadingspinner {
      0% {
        transform: rotate(0deg)
      }

      100% {
        transform: rotate(360deg)
      }
    }

    hr {
      border-top: 1px solid #ddd !important;
      margin-bottom: 0px;
    }
  </style>
</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
  <!-- Site wrapper -->


  <!-- Header Navbar: style can be found in header.less -->
  <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

  <!-- =============================================== -->

  <!-- Left side column. contains the sidebar -->
  <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

  <!-- =============================================== -->

  <!-- Right side column. Contains the navbar and content of the page -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        Conset Form
        <small>Read carefully before signing.</small>
      </h1>
      <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
    </section>

    <!-- Main content -->

    <section class="content">
      <div class="row">
        <div class="col-12">
          <div class="box box-solid">
            <div class="box-body">
              <div class="row"> <!-- Form Buttons   -->

                <div class="col-1"> <a href="<?php echo base_url('index.php/admin/ConsentForm/ConsentFormController/consent_list') ?>" class="btn btn-dark btn-sm no-print">
                    <i class="fa fa-chevron-circle-left" aria-hidden="true"></i> Go back </a>
                </div>
                <div class="col-9">
                  <?php if (validation_errors()) { ?>
                    <div class="callout <?php echo $this->config->item('msg_error'); ?> error-msg">
                      <div>
                        <p><i class="icon fa fa-warning"></i>There is a problem that we need to fix.</p>
                      </div>
                    </div>
                  <?php } ?>
                </div>
                <div class="col-2 text-right"></div>
              </div>
            </div>
          </div>
        </div>
      </div>

      <div class="row">
        <div class="col-12">
          <div class="box box-solid" style="margin-bottom: 5px;">
            <div class="box-body">

              <?php
              $success = $this->session->flashdata('success');
              if ($success) { ?>
                <div class="row mb-2">
                  <div class="col-md-12">
                    <div class="callout <?php echo $this->config->item('msg_success'); ?> error-msg">
                      <div>
                        <span><i class="icon fa fa-check"></i><?= $success; ?></span>
                      </div>
                    </div>
                  </div>
                </div>
              <?php } ?>

              <?php
              $error = $this->session->flashdata('error');
              if ($error) { ?>
                <div class="row mb-2">
                  <div class="col-md-12">
                    <div class="callout <?php echo $this->config->item('msg_error'); ?> error-msg">
                      <div>
                        <span><i class="icon fa fa-check"></i><?= $error; ?></span>
                      </div>
                    </div>
                  </div>
                </div>
              <?php } ?>

              <div class="p-3">

                <div class="panel">
                  <div class="panel-body">
                    <form role="form" action="<?= base_url('index.php/admin/ConsentForm/ConsentFormController/insert_to_consents'); ?>" method="post" enctype="multipart/form-data" id="patient_consent_form">

                      <?php echo $content; ?>
                      <input type="hidden" name="patient_id" id="patient_id">
                      <input type="hidden" name="doctor_id" id="doctor_id">
                      <input type="hidden" name="consent_type" id="consent_type" value="<?php echo $consent_type; ?>">
                      <input type="hidden" name="consent_lang" id="consent_lang" value="<?php echo $consent_lang; ?>">
                      <button type="button" class="btn btn-default btn-light btn-sm" id="save"><i class="fa fa-check-circle" aria-hidden="true"></i>Save</button>
                    </form>
                  </div>
                  <div class="row">
                    <div class="col-md-12">
                      <hr>
                      <div class="panel p-2">
                        <div class="panel-heading">
                          <h3 class="panel-title">Consent Forms List</h3>
                        </div>
                        <div class="panel-body">
                          <?php if ($results != FALSE) { ?>
                            <div class="panel panel-default">
                              <div class="panel-body">
                                <div class="row">
                                  <div class="col-md-6 mb-2">
                                    <div class="form-group">
                                      <label for="patient_id">Patient File ID</label>
                                      <input type="text" class="form-control" name="concern_patient_id" id="concern_patient_id">
                                      <span id="search_error1"></span>
                                    </div>
                                    <div class="form-group">
                                      <label for="mobile_num">Patient Mobile Number</label>
                                      <input type="text" class="form-control" name="mobile_num" id="mobile_num" maxlength="8">
                                      <span id="search_error2"></span>
                                    </div>
                                    <button type="button" class="btn btn-default btn-light btn-sm" id="check_concern"><i class="fa fa-search" aria-hidden="true"></i> Search</button>
                                    <button type="reset" class="btn btn-default btn-light  btn-sm" id="clear_concern"><i class="fa fa-refresh" aria-hidden="true"></i> Clear</button>
                                  </div>
                                  <div class="col-md-6">
                                    <div class="form-group">
                                      <label for="patient_name">Patient Name</label>
                                      <input type="text" class="form-control" name="patient_name_search" id="patient_name_search">
                                      <span id="search_error4"></span>
                                    </div>
                                    <div class="form-group">
                                      <label for="q_id">Patient Qatar ID</label>
                                      <input type="text" class="form-control" name="q_id" id="q_id" maxlength="11">
                                      <span id="search_error3"></span>
                                    </div>
                                  </div>
                                </div>

                                <div class="row">
                                  <div class="col-md-12">
                                    <span id="search_patient"></span>
                                  </div>
                                </div>
                              </div>
                            </div>
                            <!-- User table -->
                            <div class="panel-body" style="background-color:#fff;">
                              <div class="table-responsive">
                                <table class="table table-striped table-bordered table-hover" id="dataTables-example">
                                  <thead>
                                    <tr>
                                      <th>Patient</th>
                                      <th>Create Date</th>
                                      <th class="text-center">Action</th>
                                    </tr>
                                  </thead>
                                  <tbody>
                                    <?php foreach ($results as $row) {
                                      $doc = 0;
                                    ?>
                                      <tr class="odd gradeX">
                                        <td><?php echo $row['patient_id'] . '-' . $row['patient_name']; ?></td>
                                        <td><?php echo $row['created_date'] . ' ' . $row['created_time']; ?></td>
                                        <td class="text-center">
                                          <a href="<?= base_url('index.php/admin/ConsentForm/ConsentFormController/view/?lang=' . $row['consent_lang'] . '&type=' . $row['consent_type'] . '&id=' . $row['consent_data_id']) ?>" class="btn btn-light btn-sm" role="button"><i class="fa fa-search" aria-hidden="true"></i> View</a>
                                          <button onclick="confirmDelete('<?= base_url('index.php/admin/ConsentForm/ConsentFormController/delete/?lang=' . $row['consent_lang'] . '&type=' . $row['consent_type'] . '&id=' . $row['consent_data_id']) ?>')" class="btn btn-light btn-sm" role="button"><i class="fa fa-trash" aria-hidden="true"></i> Delete</button>
                                        </td>
                                      </tr>
                                    <?php } ?>
                                  </tbody>
                                </table>
                              </div>
                            </div>
                          <?php } else { ?>
                            <div class="alert alert-danger" role="alert"> Records is not exist</div>
                          <?php } ?>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <div class="modal" id="modal-loading" data-backdrop="static">
              <div class="modal-dialog modal-sm">
                <div class="modal-content">
                  <div class="modal-body text-center">
                    <div class="loading-spinner mb-2"></div>
                    <div>Loading</div>
                  </div>
                </div>
              </div>
            </div>

          </div>
        </div>
      </div>
  </div>

  </section>


  </div>

  <?php require_once(APPPATH . "views/admin/footer.php"); ?>

</body>

</html>
<script>
  $(".patient_idx").autocomplete({
    source: function(request, response) {
      $.ajax({
        url: "<?= base_url('index.php/admin/ConsentForm/ConsentFormController/get_patients'); ?>",
        dataType: "json",
        data: {
          name_startsWith: request.term,
          type: 'patient_id'
        },
        success: function(data) {
          response($.map(data, function(item) {
            var pat_name = item.split(' - ');
            return {
              label: item,
              value: pat_name[1]
            }
          }));
        }
      });
    },
    select: function(event, ui) {
      var patient_id = ui.item.label.split(' - ');

      $('#patient_id').val(patient_id[0]);

      $.ajax({
        url: 'get_patient_details',
        dataType: "json",
        data: {
          patient_id: patient_id[0]
        },
        success: function(response) {
          $('#qid').find('input').val(response.qatar_id)
          $('#dob').find('input').val(response.dob)
          $('#nationality').find('input').val(response.country_name)
          $('#gendar').find('input').val(response.sex)
          $('#patient_id').find('input').val(response.patient_id)
        },
        error: function(error) {
          console.error('Error:', error);
        }
      });
    },
    autoFocus: false,
    minLength: 1
  });

  $(".doctor_idx").autocomplete({
    source: function(request, response) {
      $.ajax({
        url: "<?= base_url('index.php/admin/ConsentForm/ConsentFormController/get_patients_doctor'); ?>",
        dataType: "json",
        data: {
          name_startsWith: request.term,
          type: 'patient_id'
        },
        success: function(data) {

          response($.map(data, function(item) {

            var pat_name = item.split(' | ');

            return {
              label: item,
              value: pat_name[1]
            }
          }));
        }

      });
    },
    select: function(event, ui) {
      var patient_id = ui.item.label.split(' - ');

      $('#doctor_id').val(patient_id[0]);
      //$('input[name=doctor_name]').val(patient_id[1]);
    },
    autoFocus: false,
    minLength: 1
  });

  $(document).ready(function() {
    $('.signArea').signaturePad({
      drawOnly: true,
      drawBezierCurves: true,
      lineTop: 90
    });

    $(".reset_signature").click(function(e) {
      $(this).parent().signaturePad().clearCanvas();
      $(this).parent().find('.img_val').val('')
    });

    $("#save").click(function(e) {
    $(this).attr('disabled', true);  // Disable the button to prevent multiple submissions
    $('#modal-loading').modal('show'); // Show loading modal

    var sign_pads = $('.sign-pad');  // Get all signature pads
    var promises = [];  // Array to hold promises for each signature pad
    var hasSignature = true;
    sign_pads.each(function(index, pad) {
      // Get all signature areas
  
   
        var promise = new Promise(function(resolve, reject) {
            html2canvas([pad], {
                onrendered: function(canvas) {
                    var canvas_img_data = canvas.toDataURL('image/png');
                    var img_data = canvas_img_data.replace(/^data:image\/(png|jpg);base64,/, "");
                    
                    // Set the base64 image data to the corresponding hidden field
                    $(pad).parent().parent().find('.img_val').val(img_data);

                    resolve(); // Resolve the promise when done
                },
                onerror: function(error) {
                  $('#modal-loading').modal('hide');
                    reject(error); // Reject the promise on error
                }
            });
        });
        promises.push(promise);  // Add each promise to the array
    });

    // Use Promise.all to wait for all html2canvas promises to finish
    Promise.all(promises).then(function() {
        // All signature pads have been processed, submit the form
        var error =$('.error').val();
        if(error !=''){
          $('#modal-loading').modal('hide');
          $('#save').attr('disabled', false);
        }
         $('#patient_consent_form').submit();
    }).catch(function(error) {
        // Handle errors
      
        $('#modal-loading').modal('hide');
        $('#save').attr('disabled', false);  // Re-enable the button
    });
});


  });


  $('#check_concern').click(function() {

    if ($("input[name=concern_patient_id]").val()) {
      if ($.isNumeric($("input[name=concern_patient_id]").val())) {
        $.ajax({
          type: "POST",
          url: "<?= base_url('index.php/admin/ConsentForm/ConsentFormController/search_concern_form'); ?>",
          data: {
            search_data: $("input[name=concern_patient_id]").val(),
            type: <?= $_GET['id'] ?>
          },
          cache: false,
          success: function(result) {
            $("#search_error3").hide();
            $("#search_error2").hide();
            $("#search_error1").hide();
            $("#search_error4").hide();

            $("#search_patient").html(result);

          }
        });

      } else {
        var result = '<span class="text-danger">Please enter file number only</span';
        $("#search_error3").hide();
        $("#search_error2").hide();
        $("#search_error4").hide();
        $("#search_error1").show();
        $("#search_error1").html(result);
      }
    } else if ($("input[name=mobile_num]").val()) {
      if ($.isNumeric($("input[name=mobile_num]").val()) && $("input[name=mobile_num]").val().length >= 7) {
        $.ajax({
          type: "POST",
          url: "<?= base_url('index.php/admin/ConsentForm/ConsentFormController/search_concern_form'); ?>",
          data: {
            search_data: $("input[name=mobile_num]").val(),
            type: <?= $_GET['id'] ?>
          },
          cache: false,
          success: function(result) {
            $("#search_error3").hide();
            $("#search_error2").hide();
            $("#search_error1").hide();
            $("#search_error4").hide();

            $("#search_patient").html(result);
          }
        });
      } else {
        var result = '<span class="text-danger">Please enter mobile number and it should be 8 or 7 digital number</span';
        $("#search_error3").hide();
        $("#search_error1").hide();
        $("#search_error4").hide();
        $("#search_error2").show();
        $("#search_error2").html(result);
      }
    } else if ($("input[name=q_id]").val()) {
      if ($.isNumeric($("input[name=q_id]").val()) && $("input[name=q_id]").val().length == 11) {
        $.ajax({
          type: "POST",
          url: "<?= base_url('index.php/admin/ConsentForm/ConsentFormController/search_concern_form'); ?>",
          data: {
            search_data: $("input[name=q_id]").val(),
            type: <?= $_GET['id'] ?>
          },
          cache: false,
          success: function(result) {
            $("#search_error3").hide();
            $("#search_error2").hide();
            $("#search_error1").hide();
            $("#search_error4").hide();

            $("#search_patient").html(result);
          }
        });
      } else {
        var result = '<span class="text-danger">Please enter qatar id and it should be 11 digital number</span';
        $("#search_error1").hide();
        $("#search_error2").hide();
        $("#search_error4").hide();
        $("#search_error3").show();
        $("#search_error3").html(result);
      }
    } else if ($("input[name=patient_name_search]").val()) {
      $.ajax({
        type: "POST",
        url: "<?= base_url('index.php/admin/ConsentForm/ConsentFormController/search_concern_form_byname'); ?>",
        data: {
          search_data: $("input[name=patient_name_search]").val(),
          type: <?= $_GET['id'] ?>
        },
        cache: false,
        success: function(result) {
          $("#search_error3").hide();
          $("#search_error2").hide();
          $("#search_error1").hide();
          $("#search_error4").hide();
          $("#search_patient").html(result);
        }
      });
    } else {
      var result1 = '<span class="text-danger">Please enter file number only</span>';
      var result2 = '<span class="text-danger">Please enter mobile number only</span>';
      var result3 = '<span class="text-danger">Please enter qatar id only</span>';
      var result4 = '<span class="text-danger">Please enter patient name only</span>';
      $("#search_error1").show();
      $("#search_error2").show();
      $("#search_error3").show();
      $("#search_error4").show();
      $("#search_error1").html(result1);
      $("#search_error2").html(result2);
      $("#search_error3").html(result3);
      $("#search_error4").html(result4);
    }

  });



  function confirmDelete(url) {
    Swal.fire({
      title: "Are you sure?",
      text: "You won't be able to revert this!",
      icon: "warning",
      showCancelButton: true,
      confirmButtonColor: "#3085d6",
      cancelButtonColor: "#d33",
      confirmButtonText: "Yes, delete it!"
    }).then((result) => {
      if (result.isConfirmed) {
        // Swal.fire({
        //   title: "Deleted!",s
        //   text: "Your file has been deleted.",
        //   icon: "success"
        // });
        window.location.href = url;
      }
    });
  }
</script>