<!DOCTYPE html>
<html>

<head>
  <meta charset="UTF-8">
  <title> Consent Forms </title>
  <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
  <link rel="stylesheet" href="<?= base_url('css/jquery-ui.css') ?>">


  <?php require_once(APPPATH . "views/admin/header.php"); ?>
  <style type="text/css">
    .ui-autocomplete {
      max-height: 100px;
      overflow-y: auto;
      /* prevent horizontal scrollbar */
      overflow-x: hidden;
      z-index: 5000;
    }

    input[type="text"] {
      width: 255px;
    }

    ;

    /*      body{
        font-family:monospace;
        text-align:center;
      }*/
    #btnSaveSign {
      color: #fff;
      background: #f99a0b;
      padding: 5px;
      border: none;
      border-radius: 5px;
      font-size: 20px;
      margin-top: 10px;
    }

    #signArea,
    #dsignArea,
    #wsignArea {
      width: 304px;
    }

    .sign-container {
      width: 60%;
      margin: auto;
    }

    .sign-preview {
      width: 150px;
      height: 50px;
      border: solid 1px #CFCFCF;
      margin: 10px 5px;
    }

    .tag-ingo {
      font-family: cursive;
      font-size: 12px;
      text-align: left;
      font-style: oblique;
    }

    .loading-spinner {
      width: 30px;
      height: 30px;
      border: 5px solid #48bcff;
      border-radius: 50%;
      border-top-color: #0001;
      display: inline-block;
      animation: loadingspinner .7s linear infinite;
    }

    @keyframes loadingspinner {
      0% {
        transform: rotate(0deg)
      }

      100% {
        transform: rotate(360deg)
      }
    }

    hr {
      border-top: 1px solid #ddd !important;
      margin-bottom: 0px;
    }
  </style>
</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
  <!-- Site wrapper -->


  <!-- Header Navbar: style can be found in header.less -->
  <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

  <!-- =============================================== -->

  <!-- Left side column. contains the sidebar -->
  <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

  <!-- =============================================== -->

  <!-- Right side column. Contains the navbar and content of the page -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        Consents List
      </h1>
      <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
    </section>

    <!-- Main content -->

    <section class="content">




      <div class="row">
        <div class="col-12">
          <div class="box box-info theme_color_bar content_padding">
            <div class="box-body">
              <table id="search_grid" class="table table-bordered table-striped">
                <thead>
                  <tr class="<?php echo $this->config->item('grid_header'); ?>">
                    <th>#</th>
                    <th>Consent Name</th>
                    <th class="text-center">Consent Type</th>
                  </tr>
                </thead>
                <tbody>
                  <?php
                  foreach ($consents_list as $key => $value) :
                  ?>
                    <tr>
                      <td><?= $key+1; ?></td>
                      <td><?= $value['consent_name']; ?></td>
                      <td>
                        <div class="d-flex justify-content-center">
                            <?php  if(!empty($value['en_content'])){ ?>
                            <a class="btn btn-light btn-sm mr-2" href="<?= base_url('index.php/admin/ConsentForm/ConsentFormController/index?lang=en&id=' . $value['consent_id']); ?>">
                              <i class="fa fa-language"></i>
                              <span>English</span>
                            </a>
                            <?php }else{ ?>
                            <a class="btn btn-light btn-sm mr-2 disabled" >
                              <i class="fa fa-language"></i>
                              <span>English</span>
                            </a>
                            <?php } ?>
                               <?php  if(!empty($value['ar_content'])){ ?>
                            <a class="btn btn-light btn-sm" title="Not Available" href="<?= base_url('index.php/admin/ConsentForm/ConsentFormController/index?lang=ar&id=' . $value['consent_id']); ?>">
                              <i class="fa fa-language"></i>
                              <span>Arabic</span>
                            </a>
                              <?php }else{ ?>
                              <a class="btn btn-light btn-sm disabled" title="Not Available">
                              <i class="fa fa-language"></i>
                              <span>Arabic</span>
                            </a>
                               <?php } ?>
                        </div>
                      </td>
                      
                    </tr>
                  <?php
                  endforeach;
                  ?>
                </tbody>
              </table>


            </div>
          </div>
        </div>
      </div>
  </div>
  </section>
  <?php require_once(APPPATH . "views/admin/footer.php"); ?>

</body>

</html>
<script>
  $(".patient_idx").autocomplete({
    source: function(request, response) {
      $.ajax({
        url: "<?= base_url('index.php/admin/ConsentForm/ConsentFormController/get_patients'); ?>",
        dataType: "json",
        data: {
          name_startsWith: request.term,
          type: 'patient_id'
        },
        success: function(data) {
          response($.map(data, function(item) {
            var pat_name = item.split(' - ');
            return {
              label: item,
              value: pat_name[1]
            }
          }));
        }
      });
    },
    select: function(event, ui) {
      var patient_id = ui.item.label.split(' - ');

      $('#patient_id').val(patient_id[0]);
    },
    autoFocus: false,
    minLength: 1
  });

  $(".doctor_idx").autocomplete({
    source: function(request, response) {
      $.ajax({
        url: "<?= base_url('index.php/admin/ConsentForm/ConsentFormController/get_patients_doctor'); ?>",
        dataType: "json",
        data: {
          name_startsWith: request.term,
          type: 'patient_id'
        },
        success: function(data) {

          response($.map(data, function(item) {

            var pat_name = item.split(' | ');

            return {
              label: item,
              value: pat_name[1]
            }
          }));
        }
      });
    },
    select: function(event, ui) {
      var patient_id = ui.item.label.split(' - ');

      $('#doctor_id').val(patient_id[0]);
      //$('input[name=doctor_name]').val(patient_id[1]);
    },
    autoFocus: false,
    minLength: 1
  });

  $(document).ready(function() {
    $('.signArea').signaturePad({
      drawOnly: true,
      drawBezierCurves: true,
      lineTop: 90
    });

    $(".reset_signature").click(function(e) {
      $(this).parent().signaturePad().clearCanvas();
      $(this).parent().find('.img_val').val('')
    });

    $("#save").click(function(e) {
      $(this).attr('disabled', true);
      $('#modal-loading').modal('show');
      var sign_pads = $('.sign-pad');
      var pads_count = 0;
      for (let x = 0; x < sign_pads.length; x++) {
        html2canvas([sign_pads[x]], {
          onrendered: function(canvas) {
            var canvas_img_data = canvas.toDataURL('image/png');
            var img_data = canvas_img_data.replace(/^data:image\/(png|jpg);base64,/, "");
            $(sign_pads[x]).parent().parent().find('.img_val').val(img_data);
          }
        });
        pads_count++;
      }

      setTimeout(() => {
        if (pads_count == sign_pads.length) {
          $('#patient_consent_form').submit();
        } else {
          alert('Error');
        }
      }, 3000);

    });

  });

  $('#check_concern').click(function() {

    if ($("input[name=concern_patient_id]").val()) {
      if ($.isNumeric($("input[name=concern_patient_id]").val())) {
        $.ajax({
          type: "POST",
          url: "<?= base_url('index.php/admin/ConsentForm/ConsentFormController/search_concern_form'); ?>",
          data: {
            search_data: $("input[name=concern_patient_id]").val(),
            type: <?= $_GET['id'] ?>
          },
          cache: false,
          success: function(result) {
            $("#search_error3").hide();
            $("#search_error2").hide();
            $("#search_error1").hide();
            $("#search_error4").hide();

            $("#search_patient").html(result);

          }
        });

      } else {
        var result = '<span class="text-danger">Please enter file number only</span';
        $("#search_error3").hide();
        $("#search_error2").hide();
        $("#search_error4").hide();
        $("#search_error1").show();
        $("#search_error1").html(result);
      }
    } else if ($("input[name=mobile_num]").val()) {
      if ($.isNumeric($("input[name=mobile_num]").val()) && $("input[name=mobile_num]").val().length >= 7) {
        $.ajax({
          type: "POST",
          url: "<?= base_url('index.php/admin/ConsentForm/ConsentFormController/search_concern_form'); ?>",
          data: {
            search_data: $("input[name=mobile_num]").val(),
            type: <?= $_GET['id'] ?>
          },
          cache: false,
          success: function(result) {
            $("#search_error3").hide();
            $("#search_error2").hide();
            $("#search_error1").hide();
            $("#search_error4").hide();

            $("#search_patient").html(result);
          }
        });
      } else {
        var result = '<span class="text-danger">Please enter mobile number and it should be 8 or 7 digital number</span';
        $("#search_error3").hide();
        $("#search_error1").hide();
        $("#search_error4").hide();
        $("#search_error2").show();
        $("#search_error2").html(result);
      }
    } else if ($("input[name=q_id]").val()) {
      if ($.isNumeric($("input[name=q_id]").val()) && $("input[name=q_id]").val().length == 11) {
        $.ajax({
          type: "POST",
          url: "<?= base_url('index.php/admin/ConsentForm/ConsentFormController/search_concern_form'); ?>",
          data: {
            search_data: $("input[name=q_id]").val(),
            type: <?= $_GET['id'] ?>
          },
          cache: false,
          success: function(result) {
            $("#search_error3").hide();
            $("#search_error2").hide();
            $("#search_error1").hide();
            $("#search_error4").hide();

            $("#search_patient").html(result);
          }
        });
      } else {
        var result = '<span class="text-danger">Please enter qatar id and it should be 11 digital number</span';
        $("#search_error1").hide();
        $("#search_error2").hide();
        $("#search_error4").hide();
        $("#search_error3").show();
        $("#search_error3").html(result);
      }
    } else if ($("input[name=patient_name_search]").val()) {
      $.ajax({
        type: "POST",
        url: "<?= base_url('index.php/admin/ConsentForm/ConsentFormController/search_concern_form_byname'); ?>",
        data: {
          search_data: $("input[name=patient_name_search]").val(),
          type: <?= $_GET['id'] ?>
        },
        cache: false,
        success: function(result) {
          $("#search_error3").hide();
          $("#search_error2").hide();
          $("#search_error1").hide();
          $("#search_error4").hide();
          $("#search_patient").html(result);
        }
      });
    } else {
      var result1 = '<span class="text-danger">Please enter file number only</span>';
      var result2 = '<span class="text-danger">Please enter mobile number only</span>';
      var result3 = '<span class="text-danger">Please enter qatar id only</span>';
      var result4 = '<span class="text-danger">Please enter patient name only</span>';
      $("#search_error1").show();
      $("#search_error2").show();
      $("#search_error3").show();
      $("#search_error4").show();
      $("#search_error1").html(result1);
      $("#search_error2").html(result2);
      $("#search_error3").html(result3);
      $("#search_error4").html(result4);
    }

  });

  function confirmDelete(url) {
    Swal.fire({
      title: "Are you sure?",
      text: "You won't be able to revert this!",
      icon: "warning",
      showCancelButton: true,
      confirmButtonColor: "#3085d6",
      cancelButtonColor: "#d33",
      confirmButtonText: "Yes, delete it!"
    }).then((result) => {
      if (result.isConfirmed) {
        // Swal.fire({
        //   title: "Deleted!",s
        //   text: "Your file has been deleted.",
        //   icon: "success"
        // });
        window.location.href = url;
      }
    });
  }
</script>