<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
    <?php require_once(APPPATH . "views/admin/header.php"); ?>

    <style>
        .file-control .dv-image {
            position: relative;
            height: 220px;
            width: 220px;
            background-size: cover;
            background-position: center;
            border-radius: 5px;
            border: 1px solid black;
        }
    </style>

</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
    <!-- Site wrapper -->


    <!-- Header Navbar: style can be found in header.less -->
    <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

    <!-- =============================================== -->

    <!-- Left side column. contains the sidebar -->
    <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

    <!-- =============================================== -->

    <div class="col-md-9">
        <?php if (validation_errors()) { ?>
            <div class="callout <?php echo $this->config->item('msg_error'); ?> error-msg">
                <div>
                    <p><i class="icon fa fa-warning"></i>There is a problem that we need to fix.</p>
                </div>
            </div>
        <?php } ?>
    </div>

    <!-- Right side column. Contains the navbar and content of the page -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1>
                <strong>Doctor<small> - <?php echo ($user_id_val > 0 ? "Edit" : "Create New") ?> Doctor</small></strong>
            </h1>
            <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
        </section>

        <!-- Main content -->
        <?php echo form_open_multipart('admin/Employees/EmployeesController/SaveEmployee'); ?>
        <form id="save_form" name="save_form" role="form" action="<?php echo base_url('index.php/admin/Employees/EmployeesController/SaveEmployee') ?>" method="post">
            <section class="content">
                <div class="row">
                    <div class="col-xs-12 col-12">
                        <div class="box margin-bottom-5px" style="border: none;">
                            <div class="box-body">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="d-flex justify-content-between">
                                            <a href="<?php echo base_url('index.php/admin/Employees/EmployeesController') ?>" class="btn btn-sm btn-dark <?php echo $this->config->item('new_update_back'); ?>" data-toggle="tooltip" data-placement="bottom" title="Back">
                                                <i class="fa fa-chevron-circle-left" aria-hidden="true"></i>
                                                Go Back
                                            </a>

                                            <?php if ($user_id_val == 0 || $edit_employee == 1) { ?>
                                                <button type="submit" href="#" class="btn btn-sm btn-dark <?php echo $this->config->item('save'); ?>">
                                                    <i class="fa fa-check-circle" aria-hidden="true"></i> Save Doctor
                                                </button>
                                            <?php } ?>
                                        </div>
                                    </div>
                                </div>
                            </div><!-- /.box-body -->
                        </div>
                        <div class="box box-info">
                            <div class="box-header">
                                <h3 class="box-title"><strong>General Informations</strong></h3>
                            </div><!-- /.box-header -->
                            <div class="row">
                                <div class="col-md-1"></div>
                                <div class="col-md-5">

                                    <div class="box-body">

                                        <div class="form-group <?php echo form_error("UserName") ? "has-error" : "" ?>">
                                            <label>User Name</label>
                                            <input readonly id="UserName" name="UserName" type="text" value="<?php echo $user_name_val; ?>" type="text" class="form-control" placeholder="Enter ..." />
                                            <label><small><?php echo form_error("UserName"); ?></small></label>
                                        </div>

                                        <div class="form-group <?php echo form_error("employee_code") ? "has-error" : "" ?>">
                                            <label>Doctor Code</label>
                                            <input id="UserName" name="employee_code" type="text" value="<?php echo $employee_code; ?>" type="text" class="form-control" placeholder="Enter ..." />
                                            <label><small><?php echo form_error("employee_code"); ?></small></label>
                                        </div>

                                        <div class="form-group <?php echo form_error("doctor_license") ? "has-error" : "" ?>">
                                            <label>Doctor license</label>
                                            <input id="UserName" name="doctor_license" type="file" style="display:block" type="text" class="form-control" placeholder="Enter ..." />
                                            <label><small><?php echo form_error("doctor_license"); ?></small></label>
                                        </div>
                                    </div>

                                </div>
                                <div class="col-md-5">

                                    <div class="box-body">

                                        <div class="form-group <?php echo form_error("FullName") ? "has-error" : "" ?>">
                                            <label>Full name</label>
                                            <input readonly id="FullName" name="FullName" type="text" value="<?php echo $full_name_val; ?>" type="text" class="form-control" placeholder="Enter ..." />
                                            <label><small><?php echo form_error("FullName"); ?></small></label>
                                        </div>

                                        <div class="form-group <?php echo form_error("doctor_type") ? "has-error" : "" ?>">
                                            <label>Doctor Type</label>
                                            <select class="form-control txtBx_mdl selectpicker" data-live-search="true" id="doctor_type" name="doctor_type">
                                                <?php foreach ($tbl_doctor_types as $value) { ?>

                                                    <option value="<?php echo $value->doctor_types_id ?>" <?php echo $doctor_type == $value->doctor_types_id ? "selected" : "" ?>><?php echo $value->doctor_type ?></option>

                                                <?php } ?>
                                            </select>
                                            <label><small><?php echo form_error("doctor_type"); ?></small></label>
                                        </div>

                                        <div class="form-group <?php echo form_error("department") ? "has-error" : "" ?>">
                                            <label>Department</label>
                                            <select class="form-control txtBx_mdl selectpicker" data-live-search="true" id="department" name="department">
                                                <?php foreach ($tbl_department as $value) {
                                                    if ($value->department_id > 0) { ?>

                                                        <option value="<?php echo $value->department_id ?>" <?php echo $department == $value->department_id ? "selected" : "" ?>><?php echo $value->module_name ?></option>

                                                <?php }
                                                } ?>
                                            </select>
                                            <label><small><?php echo form_error("department"); ?></small></label>
                                        </div>

                                        <div class="form-group <?php echo form_error("doctor_color") ? "has-error" : "" ?>">
                                            <label></label>
                                            <p><B>Select Doctor Color:&nbsp;&nbsp;</B>
                                                <input id="doctor_color" name="doctor_color" type="color" value="<?php echo $doctor_color; ?>" type="text" />
                                            </p>
                                            <label><small><?php echo form_error("doctor_color"); ?></small></label>
                                        </div>

                                        <input type="hidden" runat="server" id="user_Id" name="user_Id" value=" <?php echo $user_id_val; ?> ">

                                    </div>


                                </div>
                            </div>
                        </div><!-- /.box --><!-- /.box-body -->
                        <!-- add image-->


                        <div class="box box-info">
                            <div class="box-header">
                                <h3 class="box-title font-weight-bold">Signature</h3>
                            </div><!-- /.box-header -->
                            <div class="row">
                                <div class="col-md-1"></div>
                                <div class="col-md-4">
                                    <div class="box-body">
                                        <div class="form-group">
                                            <label>Signature</label>
                                            <label class="file-control">
                                                <input type="file" id="fileUploader" name="fileUploader" size="60">
                                                <div class="dv-image">
                                                    <img class="result-image" id="result" name="result" src="
														<?php echo ($user_id_val > 0 ? $doctor_stamp : base_url('dist/img/user.jpg')) ?>">
                                                    <div class="dv-hover center">
                                                        <i class="fa fa-image"></i>
                                                    </div>
                                                </div>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div id="crop-image" class="box-body"></div>
                                    <input hidden="hidden" type="text" runat="server" id="doctor_stamp" name="doctor_stamp" value=" <?php echo $doctor_stamp; ?> " class="txtBx">
                                </div>
                            </div>
                        </div>





                        <div class="box box-info">
                            <!-- <div class="box-header">
                                <h3 class="box-title"><strong>Image</strong></h3>
                            </div> -->
                            <div class="row">
                                <!-- <div class="col-md-1"></div> -->
                                <!-- <div class="col-md-4">
                                    <div class="box-body">
                                        <div class="form-group">
                                            <label>Doctor Stamp</label>
                                            <label class="file-control">
                                                <input type="file" id="fileUploader" name="fileUploader" size="60">
                                                <div class="dv-image">
                                                    <img class="result-image" id="result" name="result" src="
														<?php echo ($user_id_val > 0 ? $doctor_stamp : base_url('dist/img/user.jpg')) ?>">
                                                    <div class="dv-hover center">
                                                        <i class="fa fa-image"></i>
                                                    </div>
                                                </div>
                                            </label>
                                        </div>
                                    </div>
                                </div> -->
                                <div class="col-md-6">
                                    <!-- <div id="crop-image" class="box-body"></div> -->
                                    <input hidden="hidden" type="text" runat="server" id="doctor_stamp" name="doctor_stamp" value=" <?php echo $doctor_stamp; ?> " class="txtBx">
                                    <input hidden="hidden" type="text" id="employee_id" name="employee_id" value=" <?php echo $employee_id; ?> " class="txtBx">
                                    <input hidden="hidden" type="text" id="employee_type" name="employee_type" value="1" class="txtBx">
                                </div>
                            </div>
                        </div>
                    </div><!--/.col (right) -->
                </div> <!-- /.row -->

            </section><!-- /.content -->
        </form>

    </div><!-- /.content-wrapper -->


    <!-- ./wrapper -->

    <?php require_once(APPPATH . "views/admin/footer.php"); ?>

    <script type="text/javascript">
        $(document).ready(function() {

            
            /*image crop */
            function readURL(input) {
                if (input.files && input.files[0]) {
                    var reader = new FileReader();
                    reader.onload = function(e) {

                        document.getElementById('crop-image').innerHTML = "<div class='form-group'><img id='upload_image' src='#' /></div><div class='form-group'><a id='use' class='image-select btn-primary'><i class='fa fa-crop'></i> Crop</a></div>";


                        $('#upload_image').attr('src', e.target.result);
                        var resize = new Croppie($('#upload_image')[0], {
                            viewport: {
                                width: 200,
                                height: 200
                            },
                            boundary: {
                                width: 520,
                                height: 280
                            },
                            showZoomer: false,
                            enableResize: false,
                            enableOrientation: true
                        });

                        $('#use').fadeIn();

                        $('#use').on('click', function() {
                            resize.result('base64').then(function(dataImg) {
                                var data = [{
                                    image: dataImg
                                }, {
                                    name: 'myimgage.jpg'
                                }];

                                // use ajax to send data to php
                                $('#result').attr('src', dataImg);

                                $('#is_new_image').val('true');
                                $('#doctor_stamp').val(dataImg);
                                document.getElementById('crop-image').innerHTML = "";

                            });
                        });

                    }
                    reader.readAsDataURL(input.files[0]);
                }
            }

            $("#fileUploader").change(function() {
                readURL(this);
            });
        });
    </script>

</body>

</html>