<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
    <?php require_once(APPPATH . "views/admin/header.php"); ?>
</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
    <!-- Site wrapper -->


    <!-- Header Navbar: style can be found in header.less -->
    <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

    <!-- =============================================== -->

    <!-- Left side column. contains the sidebar -->
    <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

    <!-- =============================================== -->

    <div class="content-wrapper">
        <section class="content-header">
            <h1>
                <strong>Employees</strong>
            </h1>
            <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
        </section>
        <section class="content">
            <div class="box box-info">
                <div class="box-body">
                    <!-- Nav tabs -->
                    <ul class="nav nav-tabs" role="tablist">
                        <li role="presentation" class="nav-item">
                            <a class="nav-link font-weight-bold active" href="#doctors" aria-controls="doctors" role="tab" data-toggle="tab">Doctors</a>
                        </li>
                        <li role="presentation" class="nav-item">
                            <a class="nav-link font-weight-bold" href="#nurses" aria-controls="nurses" role="tab" data-toggle="tab">Nurses</a>
                        </li>
                        <li role="presentation" class="nav-item">
                            <a class="nav-link font-weight-bold" href="#coordinators" aria-controls="nurses" role="tab" data-toggle="tab">Coordinators</a>
                        </li>
                    </ul>
                    <div class="tab-content">
                        <div role="tabpanel" class="tab-pane active" id="doctors">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="content_padding">
                                        <div class="box-body">
                                            <table class="table table-bordered table-striped search_grid">
                                                <thead>
                                                    <tr class="<?php echo $this->config->item('grid_header'); ?>">
                                                        <th>#</th>
                                                        <th style="width: 40px;"></th>
                                                        <th>Doctor Code</th>
                                                        <th>Username</th>
                                                        <th>Name</th>
                                                        <th class="text-center">Actions</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php foreach ($doctors as $index => $row) { ?>
                                                        <tr>
                                                            <td><?= $index + 1 ?></td>
                                                            <td class="grid_image_td" style="width: 40px;">
                                                                <div class="center">
                                                                    <img style="height: 33px;width: 33px;border-radius: 50%;" src="<?php echo $row->image ?>">
                                                                </div>
                                                            </td>
                                                            <td> <?php echo $row->employee_code; ?></td>
                                                            <td> <?php echo $row->user_name; ?></td>
                                                            <td> <?php echo $row->full_name; ?></td>
                                                            <td class="text-center">
                                                                <div class="text-center">
                                                                <?php if(check_right('edit_employee',$this)) { ?>
                                                                    <a class="btn btn-sm btn-light" data-toggle="tooltip" data-placement="bottom" href="<?php echo site_url('admin/Employees/EmployeesController/Load/') . $row->user_Id; ?>" title="Edit">
                                                                        <i class="fa  fa-edit"></i>
                                                                    </a>
                                                                    <?php } ?>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                    <?php } ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div role="tabpanel" class="tab-pane" id="nurses">
                            <div class="row">
                                <div class="col-xs-12 col-12">
                                    <div class="content_padding">
                                        <div class="box-body">
                                            <table class="table table-bordered table-striped">
                                                <thead>
                                                    <tr class="<?php echo $this->config->item('grid_header'); ?>">
                                                        <th>#</th>
                                                        <th style="width: 40px;"></th>
                                                        <th>Nurses Code</th>
                                                        <th>Username</th>
                                                        <th>Name</th>
                                                        <th>Actions</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php foreach ($nurses as $index => $row) { ?>
                                                        <tr>
                                                            <td><?= $index + 1; ?></td>
                                                            <td class="grid_image_td" style="width: 40px;">
                                                                <div class="center">
                                                                    <img style="height: 33px;width: 33px;border-radius: 50%;" src="<?php echo $row->image ?>">
                                                                </div>
                                                            </td>
                                                            <td> <?php echo $row->employee_code; ?></td>
                                                            <td> <?php echo $row->user_name; ?></td>
                                                            <td> <?php echo $row->full_name; ?></td>
                                                            <td>
                                                                <?php if(check_right('edit_employee',$this)) { ?>
                                                                <div class="center">
                                                                    <a class="btn btn-sm btn-light" data-toggle="tooltip" data-placement="bottom" href="<?php echo site_url('admin/Employees/EmployeesController/LoadNurse/') . $row->user_Id; ?>" title="Edit">
                                                                        <i class="fa fa-edit"></i>
                                                                    </a>
                                                                    <?php } ?>
                                                                </div>

                                                            </td>
                                                        </tr>
                                                    <?php } ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div role="tabpanel" class="tab-pane" id="coordinators">
                            <div class="row">
                                <div class="col-xs-12 col-12">
                                    <div class="content_padding">
                                        <div class="box-body">
                                            <table class="table table-bordered table-striped">
                                                <thead>
                                                    <tr class="<?php echo $this->config->item('grid_header'); ?>">
                                                        <th>#</th>
                                                        <th style="width: 40px;"></th>
                                                        <th>Coordinators Code</th>
                                                        <th>Username</th>
                                                        <th>Name</th>
                                                        <th>Actions</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php foreach ($nurses as $index => $row) { ?>
                                                        <tr>
                                                            <td><?= $index + 1; ?></td>
                                                            <td class="grid_image_td" style="width: 40px;">
                                                                <div class="center">
                                                                    <img style="height: 33px;width: 33px;border-radius: 50%;" src="<?php echo $row->image ?>">
                                                                </div>
                                                            </td>
                                                            <td> <?php echo $row->employee_code; ?></td>
                                                            <td> <?php echo $row->user_name; ?></td>
                                                            <td> <?php echo $row->full_name; ?></td>
                                                            <td>
                                                                <?php if(check_right('edit_employee',$this)) { ?>
                                                                <div class="center">
                                                                    <a class="btn btn-sm btn-light" data-toggle="tooltip" data-placement="bottom" href="<?php echo site_url('admin/Employees/EmployeesController/LoadCordinator/') . $row->user_Id; ?>" title="Edit">
                                                                        <i class="fa fa-edit"></i>
                                                                    </a>
                                                                    <?php } ?>
                                                                </div>

                                                            </td>
                                                        </tr>
                                                    <?php } ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
        </section>
    </div>

    <?php require_once(APPPATH . "views/admin/footer.php"); ?>



</body>

</html>