<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
    <?php require_once(APPPATH . "views/admin/header.php"); ?>
    <?php define('IMG', base_url('Images')); ?>
    <style>
        @media print {
            .show-on-print {
                visibility: visible;
            }

        }

        .datepick-popup {
            z-index: 5000;
        }

        .form-group>.select2-container {
            width: 100% !important;
        }

        .modal-open .datepicker {
            z-index: 9999 !important
        }

        /* The Modal (background) */
        /* Modal Content/Box */
        .modal-lg {
            background-color: #fefefe;
            margin: 15% auto;
            /* 15% from the top and centered */
            border: 1px solid #888;
            width: 150%;
            /* Could be more or less, depending on screen size */
        }

        .select2-container {
            width: 100% !important;
            padding: 0;
        }

        .report_tabs {
            padding: 20px;
        }

        #myModal .modal-dialog {
            -webkit-transform: translate(0, -50%);
            -o-transform: translate(0, -50%);
            transform: translate(0, -50%);
            top: 50%;
            margin: 0 auto;
        }

        .btn-invoices:hover {
            text-decoration: none;
            color: #fff;
        }

        .report-content {
            margin-top: 30px;
        }

        .add-btn {
            margin-top: 24px;
        }

        .quantity {
            width: 55px;
        }

        .nav-tabs {
            border-bottom: none;
        }

        .small-box {
            text-decoration: none;
            color: #444444;
            transition-timing-function: ease-in-out;
            cursor: pointer;
        }

        .small-box:hover {
            text-decoration: none;
            color: #084a6ad9;
        }

        .small-box {
            box-shadow: 0 1px 11px 0px rgba(0, 0, 0, 0.1) !important;
        }

        .inner {
            height: 120px;
        }

        .dashboard_icon {
            color: black;
            font-size: 60px;
        }

        .phrma_dash_num {
            font-weight: 900;
        }

        .selected {
            background: #084a6a !important;
            color: white !important;
        }
    </style>

    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.11.3/css/jquery.dataTables.min.css">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/buttons/2.0.1/css/buttons.dataTables.min.css">
</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
    <!-- Site wrapper -->
    <!-- Header Navbar: style can be found in header.less -->
    <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

    <!-- =============================================== -->

    <!-- Left side column. contains the sidebar -->
    <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

    <!-- =============================================== -->

    <div class="content-wrapper">

        <section class="content-header">
            <h1>
                <strong>Inventory</strong>
            </h1>
            <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
        </section>

        <section class="content">

            <div class="row">
                <div class="col-md-12">
                    <div class="box box-info">
                        <div class="box-header with-border no-print">
                            <h3 class="box-title font-weight-bold">Inventory Dashboard</h3>
                        </div>

                        <div class="box-body">
                            <div class="panel-group" id="accordion">

                                <div class="d-block mb-3">
                                    <div class="panel panel-default">
                                        <div class="panel-body">

                                            <div class="d-flex justify-content-between w-100 no-print nav nav-tabs no-print" role="tablist">

                                                <a href="#ph_items" role="tab" data-toggle="tab" class="btn-overview inventory-tab-button">
                                                    <div style="width:200px">
                                                        <div class="small-box bg-white">
                                                            <div class="inner">
                                                                <div id="l_last_patient_id" class="loader mt-2 ml-4 mb-3"></div>
                                                                <h6 id="last_patient_id" class="phrma_dash_num">&nbsp;</h6>
                                                                <h4 style="font-size:1.5em;">Items</h4>
                                                            </div>
                                                            <div class="icon">
                                                                <i class="ri-capsule-line dashboard_icon"></i>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </a>


                                                <a href="#ph_item_categories" role="tab" data-toggle="tab" class="btn-categories inventory-tab-button">
                                                    <div style="width:200px">
                                                        <div class="small-box bg-white">
                                                            <div class="inner">
                                                                <div id="l_last_patient_id" class="loader mt-2 ml-4 mb-3"></div>
                                                                <h6 id="last_patient_id" class="phrma_dash_num">&nbsp;</h6>
                                                                <h4 style="font-size:1.5em;">Categories</h4>
                                                            </div>
                                                            <div class="icon">
                                                                <i class="ri-box-3-line dashboard_icon"></i>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </a>


                                                <a href="#ph_item_departments" role="tab" data-toggle="tab" class="btn-departments inventory-tab-button">
                                                    <div style="width:200px">
                                                        <div class="small-box bg-white">
                                                            <div class="inner">
                                                                <div id="l_last_patient_id" class="loader mt-2 ml-4 mb-3"></div>
                                                                <h6 id="last_patient_id" class="phrma_dash_num">&nbsp;</h6>
                                                                <h4 style="font-size:1.5em;">Departments</h4>
                                                            </div>
                                                            <div class="icon">
                                                                <i class="ri-hospital-line dashboard_icon"></i>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </a>

                                                <a href="#ph_item_suppliers" role="tab" data-toggle="tab" class="btn-suppliers inventory-tab-button">
                                                    <div style="width:200px">
                                                        <div class="small-box bg-white">
                                                            <div class="inner">
                                                                <div id="l_last_patient_id" class="loader mt-2 ml-4 mb-3"></div>
                                                                <h6 id="last_patient_id" class="phrma_dash_num">&nbsp;</h6>
                                                                <h4 style="font-size:1.5em;">Suppliers</h4>
                                                            </div>
                                                            <div class="icon">
                                                                <i class="ri-user-2-line dashboard_icon"></i>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </a>
                                                <a href="#ph_requests" role="tab" data-toggle="tab" class="btn-location inventory-tab-button">
                                                    <div style="width:200px">
                                                        <div class="small-box bg-white">
                                                            <div class="inner">
                                                                <div id="l_last_patient_id" class="loader mt-2 ml-4 mb-3"></div>
                                                                <h6 id="last_patient_id" class="phrma_dash_num">&nbsp;</h6>
                                                                <h4 style="font-size:1.5em;">Transfer</h4>
                                                            </div>
                                                            <div class="icon">
                                                                <i class="ri-loop-right-line dashboard_icon"></i>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </a>
                                                <a href="#ph_item_invoices" role="tab" data-toggle="tab" class="btn-invoices inventory-tab-button">
                                                    <div style="width:200px">
                                                        <div class="small-box bg-white">
                                                            <div class="inner">
                                                                <div id="l_last_patient_id" class="loader mt-2 ml-4 mb-3"></div>
                                                                <h6 id="last_patient_id" class="phrma_dash_num">&nbsp;</h6>
                                                                <h4 style="font-size:1.5em;">Billing</h4>
                                                            </div>
                                                            <div class="icon">
                                                                <i class="ri-bank-card-line dashboard_icon"></i>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </a>
                                                <a href="#ph_item_reports" role="tab" data-toggle="tab" class="btn-reports inventory-tab-button">
                                                    <div style="width:200px">
                                                        <div class="small-box bg-white">
                                                            <div class="inner">
                                                                <div id="l_last_patient_id" class="loader mt-2 ml-4 mb-3"></div>
                                                                <h6 id="last_patient_id" class="phrma_dash_num">&nbsp;</h6>
                                                                <h4 style="font-size:1.5em;">Reports</h4>
                                                            </div>
                                                            <div class="icon">
                                                                <i class="ri-bar-chart-box-line dashboard_icon"></i>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </a>

                                            </div>

                                            <div class="row">
                                                <?php if (isset($validation_msg) || !empty($this->session->flashdata('errors'))) : ?>
                                                    <div class="col-lg-12">
                                                        <div class="alert alert-danger alert-dismissible" role="alert">
                                                            <button type="button" class="close" data-dismiss="alert">
                                                                <span aria-hidden="true">&times;</span><span class="sr-only">Close</span>
                                                            </button>
                                                            <span class="lead ui-error"><?= validation_errors(); ?></span>
                                                            <span class="lead ui-error"><?= $this->session->flashdata('errors') ?></span>
                                                        </div>
                                                    </div>
                                                <?php endif; ?>

                                                <?php if (isset($success_msg)) : ?>
                                                    <?php if ($success_msg) : ?>
                                                        <div class="col-lg-12">
                                                            <div class="success success-danger success-dismissible" role="success">
                                                                <button type="button" class="close" data-dismiss="success">
                                                                    <span aria-hidden="true">&times;</span><span class="sr-only">Close</span>
                                                                </button>
                                                                <span class="lead ui-error"><?php echo validation_errors(); ?></span>
                                                            </div>
                                                        </div>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                            </div>

                                            <div class="tab-content">
                                                <div class="tab-pane dashboard-tabs" id="ph_items">
                                                    <?php include_once(APPPATH . 'views/admin/Inventory/pharmacy_items.php') ?>
                                                </div>
                                                <div class="tab-pane dashboard-tabs" id="ph_item_categories">
                                                    <?php include_once(APPPATH . 'views/admin/Inventory/pharmacy_item_categories.php') ?>
                                                </div>
                                                <div class="tab-pane dashboard-tabs" id="ph_item_departments">
                                                    <?php include_once(APPPATH . 'views/admin/Inventory/pharmacy_item_departments.php') ?>
                                                </div>
                                                <div class="tab-pane dashboard-tabs" id="ph_item_suppliers">
                                                    <?php include_once(APPPATH . 'views/admin/Inventory/pharmacy_item_suppliers.php') ?>
                                                </div>
                                                <div class="tab-pane dashboard-tabs" id="ph_requests">
                                                    <?php include_once(APPPATH . 'views/admin/Inventory/pharmacy_requests.php') ?>
                                                </div>
                                                <div class="tab-pane dashboard-tabs" id="ph_item_invoices">
                                                    <?php include_once(APPPATH . 'views/admin/Inventory/pharmacy_item_invoices.php') ?>
                                                </div>
                                                <div class="tab-pane dashboard-tabs" id="ph_item_reports">
                                                    <?php include_once(APPPATH . 'views/admin/Inventory/pharmacy_item_reports.php') ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <table id="price_list" class="table table-light table-bordered table-striped"></table>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <?php require_once(APPPATH . "views/admin/footer.php"); ?>
</body>

</html>

<script type="text/javascript" language="javascript" src="https://cdn.datatables.net/1.11.3/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" language="javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/dataTables.buttons.min.js"></script>
<script type="text/javascript" language="javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script type="text/javascript" language="javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
<script type="text/javascript" language="javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
<script type="text/javascript" language="javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.html5.min.js"></script>
<script type="text/javascript" language="javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.print.min.js"></script>

<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script src="<?= base_url('/js/jquery.plugin.js'); ?>"></script>
<script src="<?= base_url('/js/jquery.datepick.js'); ?>"></script>
<script>
    var col = [];
    var mod = '';
    var ent = false;
    var print_header = $('#print_header').html();

    function delMod(id, c) {
        Swal.fire({
            title: "Are you sure?",
            text: "You won't be able to revert this!",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "Yes, delete it!"
        }).then((result) => {
            if (result.isConfirmed) {
                //window.location.href = url;
                $.ajax({
                    url: "<?= base_url('index.php/admin/Inventory/InventoryController/delete_phar_inventory'); ?>",
                    type: "POST",
                    dataType: "json",
                    data: {
                        id: id,
                        mod: c
                    },
                    success: function(data) {
                        location.reload();
                    }
                });
            }
        });

    }

    function store(type, ex, arr) {
        col = arr;
        ent = ex;
        mod = type;
        assign();
        if (type == 'item') {
            getItemInfo(arr[0], ex);
        }
    }

    function assign() {

        switch (mod) {
            case 'item':
                $('#item_code').val(col[0]);
                $('#item_name').val(col[1]);
                $('#item_type option[value="' + col[2] + '"]').prop("selected", true);
                $('#ph_item_unit option[value="' + col[3] + '"]').prop("selected", true);

                $('#barcode').val(col[4]);
                $('#new').val(ent);
                $('#item_code').attr('readonly', ent);
                $('#new').text(ent);
                $('#itemLabel').text('Edit Item');
                break;

            case 'category':
                $('#ph_category_id').val(col[0]);
                $('#category_name').val(col[1]);
                $('#new_category').val(ent);
                $('#categoryLabel').text('Edit Category');
                break;

            case 'supplier':
                $('#ph_supplier_id').val(col[0]);
                $('#supplier_name').val(col[1]);
                $('#new_supplier').val(ent);
                $('#contact_person').val(col[2]);
                $('#number').val(col[3]);
                $('#address').val(col[4]);
                $('#email').val(col[5]);
                $('#payment_type option[value="' + col[6] + '"]').prop("selected", true);
                $('#supplierLabel').text('Edit Supplier');
                break;

            case 'departments':
                $('#ph_department_id').val(col[0]);
                $('#department_name').val(col[1]);
                $('#departmentLabel').text('Edit Department')
                break;
        }
        return col;
    }

    function getItemInfo(id, ex) {
        $.ajax({
            url: "<?= base_url('index.php/admin/Inventory/InventoryController/get_phar_item_info'); ?>",
            type: "POST",
            dataType: "json",
            data: {
                item_id: id
            },
            beforeSend: function() {},
            success: function(data) {
                $('#new').val(ex);
                $('#item_code').val(data[0].item_id);
                $('#barcode').val(data[0].barcode);
                $('#item_name').val(data[0].item_name);
                $('#item_type').val(data[0].item_type);
                $('#item_unit').val(data[0].item_unit);
                $('#description').val(data[0].description);
                $('#price').val(data[0].price);

                $('#item_code').attr('readonly', ent);
            }
        });
    }

    function escape(s) {
        console.log('aaa');
        return ('' + s)
            .replace(/\\/g, '\\\\')
            .replace(/\t/g, '\\t')
            .replace(/\n/g, '\\n')
            .replace(/\u00A0/g, '\\u00A0')
            .replace(/&/g, '\\x26')
            .replace(/'/g, '\\x27')
            .replace(/"/g, '\\x22')
            .replace(/</g, '\\x3C')
            .replace(/>/g, '\\x3E');
    }

    function getItemListAjax(url, target) {
        $.ajax({
            url: url,
            type: "POST",
            dataType: "json",
            data: {},
            beforeSend: function() {},
            success: function(data) {
                row = '';
                var report = '';
                if (target == 'tbl-requests') {
                    var report = 'Requests'
                    for (let i = 0; i < data.length; ++i) {
                        row += '<tr>';
                        row += '<td style="vertical-align: middle;" class="text-center">' + data[i].request_id + '</td>';
                        row += '<td style="vertical-align: middle;" class="text-center">' + data[i].date + '</td>';
                        row += '<td style="vertical-align: middle;" class="text-center">' + data[i].emp_name + '</td>';
                        row += '<td style="vertical-align: middle;" class="text-center">' + data[i].department_name + '</td>';
                        row += '<td style="vertical-align: middle;" class="text-center">' + data[i].user_name + '</td>';
                        row += '<td style="vertical-align: middle;" class="text-center"><button class="btn btn-sm btn-light btn-edit-item" data-toggle="modal" data-target="#requestModal_Edit" onclick="request_update(\'' + data[i].date + '\',\'' + data[i].employee_id + '\',\'' + data[i].request_id + '\',\'' + data[i].department + '\')"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></button>&nbsp;<button class="btn btn-light btn-sm btn-delete" onClick="delMod(\'' + data[i].request_id + '\',\'request\')"><i class="fa fa-trash" aria-hidden="true"></i></button></td>';
                        row += '</tr>';
                    }
                } else if (target == 'tbl-invoices') {
                    var report = 'Billings'
                    inv_url = '<?= base_url("index.php/admin/Inventory/InventoryController/invoice/") ?>';
                    for (let i = 0; i < data.length; ++i) {
                        if (data[i].payment_method == 1) {
                            pm = 'Credit';
                        } else if (data[i].payment_method == 2) {
                            pm = 'Cash';
                        } else {
                            pm = 'Cheque';
                        }

                        row += '<tr>';
                        row += '<td style="vertical-align: middle;" class="text-center">' + data[i].inventory_invoice_id + '</td>';
                        row += '<td style="vertical-align: middle;" class="text-center">' + pm + '</td>';
                        row += '<td style="vertical-align: middle;" class="text-center">' + data[i].date + '</td>';
                        row += '<td style="vertical-align: middle;" class="text-center">' + data[i].supplier_name + '</td>';
                        row += '<td style="vertical-align: middle;" class="text-center"><a href="' + inv_url + '/' + data[i].inventory_invoice_id + '" class="btn btn-light btn-sm"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a>&nbsp;<button class="btn btn-light btn-sm" onClick="delMod(\'' + data[i].inventory_invoice_id + '\',\'invoice\')"><i class="fa fa-trash" aria-hidden="true"></i></button></td>';
                        row += '</tr>';

                    }
                } else if (target == 'tbl-categories') {
                    var report = 'Categories'
                    inv_url = '<?= site_url("pharmacy/invoice/") ?>';
                    for (let i = 0; i < data.length; ++i) {
                        if (data[i].payment_method == 1) {
                            pm = 'Credit';
                        } else if (data[i].payment_method == 2) {
                            pm = 'Cash';
                        } else {
                            pm = 'Cheque';
                        }

                        row += '<tr>';
                        row += '<td style="vertical-align: middle;" class="text-center">' + data[i].inventory_invoice_id + '</td>';
                        row += '<td style="vertical-align: middle;" class="text-center">' + pm + '</td>';
                        row += '<td style="vertical-align: middle;" class="text-center">' + data[i].date + '</td>';
                        row += '<td style="vertical-align: middle;" class="text-center">' + data[i].supplier_name + '</td>';
                        row += '<td style="vertical-align: middle;" class="text-center"><a href="' + inv_url + '/' + data[i].inventory_invoice_id + '" class="btn btn-light btn-sm"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a>&nbsp;<button class="btn btn-light btn-sm" onClick="delMod(\'' + data[i].inventory_invoice_id + '\',\'invoice\')"><i class="fa fa-trash" aria-hidden="true"></i></button></td>';
                        row += '</tr>';

                        $.ajax({
                            url: "<?= base_url('index.php/admin/Inventory/InventoryController/get_phar_invoice_item_list'); ?>",
                            type: "POST",
                            dataType: "json",
                            data: {
                                inv_id: data[i].inventory_invoice_id
                            },
                            beforeSend: function() {},
                            success: function(data) {}
                        })
                    }
                } else {
                    var report = 'Items'
                    for (let i = 0; i < data.length; ++i) {
                        row += '<tr>';
                        row += '<td style="vertical-align: middle;" class="text-center">' + data[i].item_id + '</td>';
                        row += '<td style="vertical-align: middle;" class="text-center">' + (typeof(data[i].barcode) !== 'undefined' ? data[i].barcode : 'n/a') + '</td>';
                        row += '<td style="vertical-align: middle;" class="text-center">' + data[i].item_name + '</td>';

                        color = data[i].qty <= parseInt(data[i].min_qty) ? "#dd4b39" : "#146993";

                        row += '<td id="inventory_qty_warning_' + parseInt(data[i].item_id) + '" style="vertical-align: middle;background-color:' + color + ';color:#fff;font-weight:bold;font-size:1.2em" class="text-center">' + data[i].qty + '</td>';

                        row += `<td class="text-center">
                                    <input type="number" class="form-control text-right inventory_item_min_qty" style="max-width:70px" value="${parseInt(data[i].min_qty)}" current-qty="${parseInt(data[i].qty)}" item-id="${parseInt(data[i].item_id)}" />
                                </td>`;

                        if (target == 'tbl-items')
                            row += '<td style="vertical-align: middle;" class="text-center">' + data[i].type_name + '</td>';
                        else
                            row += '<td style="vertical-align: middle;" class="text-center">' + data[i].expiry_date + '</td>';

                        row += '<td style="vertical-align: middle;" class="text-center">' +
                            '<button class="btn btn-light btn-sm btn-edit-item" data-toggle="modal" data-target="#itemModal" onclick="store(\'item\',true,[\'' + (data[i].item_id).replace(/["']/g, "") + '\',\'' + (data[i].item_name).replace(/["']/g, "") + '\',\'' + data[i].item_type + '\',\'' + data[i].unit + '\'])">' +
                            '<i class="fa fa-pencil-square-o" aria-hidden="true"></i>' +
                            '</button>&nbsp;<button class="btn btn-light btn-sm btn-delete" onClick="delMod(\'' + data[i].item_id + '\',\'item\')">' +
                            '<i class="fa fa-trash" aria-hidden="true"></i>' +
                            '</button>' +
                            '</td>';
                        row += '</tr>';
                    }
                }

                $('#' + target + ' tbody').html(row);
                $('#' + target).DataTable({
                    dom: 'Bfrtip',
                    buttons: [{
                            extend: 'print',
                            autoPrint: true,
                            title: '',
                            exportOptions: {
                                columns: ':not(:last-child)'
                            },
                            customize: function(win) {
                                $(win.document.body).prepend(`<?php print_header($this); ?>`);
                            }
                        },
                        {
                            extend: 'excel',
                            exportOptions: {
                                columns: ':not(:last-child)'
                            }
                        }

                    ],
                    order: [
                        [0, 'desc']
                    ]
                });
            }
        });
    }

    $(document).ready(function() {
        // var url = window.location.href;
        // var activeTab = url.substring(url.indexOf("#") + 1);
        // var activeindex = url.split("#");
        // if (activeindex.length > 1) {
        //     $(".dashboard-tabs").removeClass("active in");
        //     $("#" + activeTab).addClass("active in");
        //     $('a[href="#' + activeTab + '"]').tab('show');
        // }

        $.fn.dataTable.ext.errMode = 'none';

        $('.btn-overview').on('click', function() {
            $('.tab-overview').trigger('click');
        })

        $('.btn-location').on('click', function() {
            $('.tab-location').trigger('click');
        })

        $('.add_btn').on('click', function() {
            var type = $(this).attr('data-control');
            switch (type) {
                case 'item':
                    $('#item_code').val('');
                    $('#item_name').val('');
                    $('#item_type').prop("selected", true);
                    $('#ph_item_unit').prop("selected", true);
                    $('#price').val('');

                    $('#barcode').val('');
                    $('#description').val('');
                    $('#new').val(false);
                    $('#item_code').attr('readonly', false);
                    $('#new').text(false);
                    $('#itemLabel').text('Add Item');
                    break;
                case 'category':
                    $('#ph_category_id').val('');
                    $('#category_name').val('');
                    $('#new_category').val(false);
                    $('#categoryLabel').text('Add Category');
                    break;

                case 'supplier':
                    $('#ph_supplier_id').val('');
                    $('#supplier_name').val('');
                    $('#contact_person').val('');
                    $('#number').val('');
                    $('#address').val('');
                    $('#email').val('');
                    $('#new_supplier').val(false);
                    $('#supplierLabel').text('Add Supplier');
                    break;

                case 'department':
                    $('#ph_department_id').val(0);
                    $('#department_name').val('');
                    $('#departmentLabel').text('Add Department')
                    break;
            }

        })

        $('.select2-container').css("width", "100%");

        $('#item_id').select2({
            placeholder: 'Select Drug...',
            allowClear: true,
            ajax: {
                url: '<?= base_url('index.php/admin/Inventory/InventoryController/get_items_json'); ?>',
                dataType: 'json',
                width: '100%',
                data: function(params) {
                    var queryParameters = {
                        term: params.term,
                        not_all: false
                    }
                    return queryParameters;
                },
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: true
            }
        });

        $('#item_id_add').select2({
            placeholder: 'Select Drug...',
            allowClear: true,
            ajax: {
                url: '<?= base_url('index.php/admin/Inventory/InventoryController/get_items_stock_json'); ?>',
                dataType: 'json',
                width: '100%',
                data: function(params) {
                    var queryParameters = {
                        term: params.term,
                        not_all: $('#request_items_add').val()
                    }
                    return queryParameters;
                },
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: true
            }
        });

        $('#item_id_edit').select2({
            placeholder: 'Select Drug...',
            allowClear: true,
            ajax: {
                url: '<?= base_url('index.php/admin/Inventory/InventoryController/get_items_stock_json'); ?>',
                dataType: 'json',
                width: '100%',
                data: function(params) {
                    var queryParameters = {
                        term: params.term,
                        not_all: $('#request_items_edit').val()
                    }
                    return queryParameters;
                },
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: true
            }
        });

        $('.item_id').select2({
            placeholder: 'Select Drug...',
            allowClear: true,
            ajax: {
                url: '<?= base_url('index.php/admin/Inventory/InventoryController/get_items_json_reports'); ?>',
                dataType: 'json',
                width: '100%',
                data: function(params) {
                    var queryParameters = {
                        term: params.term,
                        not_all: false
                    }
                    return queryParameters;
                },
                processResults: function(data) {
                    console.log(data);
                    return {
                        results: data
                    };
                },
                cache: true
            }
        });

        getItemListAjax("<?= base_url('index.php/admin/Inventory/InventoryController/get_phar_items_list'); ?>", 'tbl-items');
        getItemListAjax("<?= base_url('index.php/admin/Inventory/InventoryController/get_phar_expired_items_list'); ?>", 'tbl-overview-expired');
        getItemListAjax("<?= base_url('index.php/admin/Inventory/InventoryController/get_phar_no_expiry_items_list'); ?>", 'tbl-overview-no-expire');
        getItemListAjax("<?= base_url('index.php/admin/Inventory/InventoryController/get_doctor_requests_list'); ?>", 'tbl-requests');
        getItemListAjax("<?= base_url('index.php/admin/Inventory/InventoryController/get_phar_invoice_list'); ?>", 'tbl-invoices');


        $.ajax({
            url: "<?= base_url('index.php/admin/Inventory/InventoryController/get_phar_category_list'); ?>",
            type: "POST",
            dataType: "json",
            data: {},
            beforeSend: function() {},
            success: function(data) {
                row = '';

                for (let i = 0; i < data.length; ++i) {
                    row += '<tr>';
                    row += '<td style="vertical-align: middle;" class="text-center">' + data[i].item_type + '</td>';
                    row += '<td style="vertical-align: middle;" class="text-center">' + data[i].type_name + '</td>';
                    row += '<td style="vertical-align: middle;" class="text-center"><button class="btn btn-light btn-sm" data-toggle="modal" data-target="#categoryModal" onclick="store(\'category\',true,[\'' + data[i].item_type + '\',\'' + data[i].type_name + '\'])"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></button>&nbsp;<button class="btn btn-light btn-sm btn-delete" onClick="delMod(\'' + data[i].item_type + '\',\'category\')"><i class="fa fa-trash" aria-hidden="true"></i></button></td>';
                    row += '</tr>';
                }

                $('#tbl-categories tbody').html(row);
                initialize_print('#tbl-categories', 'Categories');
            }
        });

        $.ajax({
            url: "<?= base_url('index.php/admin/Inventory/InventoryController/get_phar_department_list'); ?>",
            type: "POST",
            dataType: "json",
            data: {},
            beforeSend: function() {},
            success: function(data) {
                row = '';

                for (let i = 0; i < data.length; ++i) {
                    row += '<tr>';
                    row += '<td style="vertical-align: middle;" class="text-center">' + data[i].id + '</td>';
                    row += '<td style="vertical-align: middle;" class="text-center">' + data[i].department_name + '</td>';
                    row += '<td style="vertical-align: middle;" class="text-center"><button class="btn btn-light btn-sm" data-toggle="modal" data-target="#departmentModal" onclick="store(\'departments\',true,[\'' + data[i].id + '\',\'' + data[i].department_name + '\'])"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></button>&nbsp;<button class="btn btn-light btn-sm btn-delete" onClick="delMod(\'' + data[i].id + '\',\'department\')"><i class="fa fa-trash" aria-hidden="true"></i></button></td>';
                    row += '</tr>';
                }

                $('#tbl-departments tbody').html(row);
                initialize_print('#tbl-departments', 'Departments');
            }
        });

        $.ajax({
            url: "<?= base_url('index.php/admin/Inventory/InventoryController/get_phar_supplier_list'); ?>",
            type: "POST",
            dataType: "json",
            data: {},
            beforeSend: function() {},
            success: function(data) {
                row = '';

                for (let i = 0; i < data.length; ++i) {
                    row += '<tr>';
                    row += '<td style="vertical-align: middle;" class="text-center">' + data[i].supplier_id + '</td>';
                    row += '<td style="vertical-align: middle;" class="text-center">' + data[i].supplier_name + '</td>';
                    row += '<td style="vertical-align: middle;" class="text-center">' + data[i].number + '</td>';
                    row += '<td style="vertical-align: middle;" class="text-center"><button class="btn btn-light btn-sm" data-toggle="modal" data-target="#supplierModal" onclick="store(\'supplier\',true,[\'' + data[i].supplier_id + '\',\'' + data[i].supplier_name + '\',\'' + data[i].contact_person + '\',\'' + data[i].number + '\',\'' + data[i].address + '\',\'' + data[i].email + '\',\'' + data[i].payment_type + '\'])"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></button>&nbsp;<button class="btn btn-light btn-sm btn-delete" onClick="delMod(\'' + data[i].supplier_id + '\',\'supplier\')"><i class="fa fa-trash" aria-hidden="true"></i></button></td>';
                    row += '</tr>';
                }

                $('#tbl-suppliers tbody').html(row);
                initialize_print('#tbl-suppliers', 'Suppliers');
            }
        });

        $('.select-overview').on('change', function() {
            opt = $(this).val();
            url = '';

            if (opt == 1) {
                $('.overview-not-expired').hide();
                $('.overview-expire-soon').show();
                $('.overview-expired').hide();
                $('.overview-no-expire').hide();
            } else if (opt == 2) {
                $('.overview-not-expired').hide();
                $('.overview-expire-soon').hide();
                $('.overview-expired').show();
                $('.overview-no-expire').hide();
            } else if (opt == 3) {
                $('.overview-not-expired').hide();
                $('.overview-expire-soon').hide();
                $('.overview-expired').hide();
                $('.overview-no-expire').show();
            } else if (opt == 4) {
                $('.overview-not-expired').show();
                $('.overview-expire-soon').hide();
                $('.overview-expired').hide();
                $('.overview-no-expire').hide();
            } else {
                alert('No selected.');
            }
        }).trigger('change')

        $('.genrate_report').on('click', function() {
            var type = $(this).attr('data-control');
            var item_id = $('#item_id_' + type).val() == null ? 0 : $('#item_id_' + type).val();
            var from_date = $('#from_date_' + type).val();
            var to_date = $('#to_date_' + type).val();
            var options = {
                supplier_id: $('#supplier_id_report').val(),
                doctor_id: $('#doctor_id_report').val(),
                department: $('#department_report').val(),
                item_id: item_id,
                from_date: from_date,
                to_date: to_date,
            };

            if (from_date != '' && to_date == '') {
                alert('Please select a to date')
                return
            } else if (from_date == '' && to_date != '') {
                alert('Please select a from date')
                return
            }

            $.ajax({
                url: "<?= base_url('index.php/admin/Inventory/InventoryController/get_report_'); ?>" + type,
                type: "POST",
                dataType: "html",
                data: options,
                beforeSend: function() {
                    $('#content-' + type).html('<div class="col-md-12 text-center">Loading...</div>');
                },
                success: function(data) {
                    $('#content-' + type).html(data);
                }
            })
        })

        $('.print_report').on('click', function() {
            var type = $(this).attr('data-control');
            var printContents = $('#report-content-' + type).html();
            var originalContents = $('body').html();
            $('#report-content-' + type).find('table').addClass('compact').css('font-size', 'small');
            $('body').html(`<div class="row"><div class="col-md-12"><?php print_header($this); ?></div></div>` + printContents);
            setTimeout(function() {
                window.print();
                window.location.reload();
            }, 500);
        })

        $('.submit_request').on('click', function() {
            var type = $(this).attr('data-control')
            var elements = $('.calculate_' + type);

            var submit = true;
            for (var i = 0; i < elements.length; i++) {
                var data = $(elements[i]).attr('data-control')
                text = data.split('_'),
                    item_id = text[0],
                    qty = parseInt($(elements[i]).val());
                stock = parseInt(text[2]);

                if (stock < qty) {
                    $('#' + item_id + "_" + type).html('More than stock qty!')
                    submit = false;
                }
                if (0 >= qty) {
                    $('#' + item_id + "_" + type).html('Less than stock qty!')
                    submit = false;
                }
            }

            if (submit) {
                document.getElementById(type + "_form").submit();
            } else {
                return;
            }

        })


        $('.add-btn').on('click', function(transfer_items) {

            var type = $(this).attr('data-control'),
                data = $('#item_id_' + type).select2('data'),
                added_invoice_item_id = data[0].id,
                text = data[0].text.split('||'),
                invoice_id = text[0],
                code = text[1],
                item_barcode = text[2],
                name = text[3],
                stock = text[4].trim();
            price = text[5],

                // console.log(text);

                $("#issue_tbody_" + type).append("<tr>" +
                    "<td>" + invoice_id + "</td>" +
                    "<td>" + code + "</td>" +
                    "<td>" + item_barcode + "</td>" +
                    "<td>" + name + "</td>" +
                    "<td>" +
                    "<input type=\"hidden\" name='invoice_item_id[]' value=" + added_invoice_item_id + " class=\"quantity\">" +
                    "<input type=\"hidden\" name='items[]' value=" + code + " class=\"quantity\">" +
                    "<input type=\"number\" name='quantity[]' min='1' max=" + stock + " data-control='" + added_invoice_item_id + "_" + type + "_" + stock + "' value=\"1\" class='form-control quantity validate_request_qty calculate_" + type + "'>" +
                    "<h6 class='text-danger' id='" + added_invoice_item_id + "_" + type + "'><h6>" +
                    "</td>" +
                    "<td>" + stock + "</td>" +
                    "<td>" + price + "</td>" +
                    "<td>" +
                    "<button type=\"button\" class=\"btn btn-light delete_row\" data-control='" + added_invoice_item_id + "_" + type + "'><i class=\"fa fa-trash\" aria-hidden=\"true\"></i></button>" +
                    "</td>" +
                    "</tr>");

            var selected_items = $('#request_items_' + type).val();
            $('#request_items_' + type).val(selected_items + ',' + added_invoice_item_id);
            $("#item_id_" + type).empty().trigger('change');

            // Need to initiate this function after adding each row.
            validate_request_qty();
        });

    });

    $(document).on('click', '.delete_row', function() {
        $(this).parent().parent().remove();
        var data = $(this).attr('data-control'),
            text = data.split('_')
        invoice_item_id = text[0]
        type = text[1]
        selected_items = $('#request_items_' + type).val(),
            $('#request_items_' + type).val(selected_items.replace(',' + invoice_item_id, ''))
    });

    var tableToExcel = (function() {
        var uri = 'data:application/vnd.ms-excel;base64,',
            template = '<html xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:x="urn:schemas-microsoft-com:office:excel" xmlns="http://www.w3.org/TR/REC-html40"><head><!--[if gte mso 9]><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet><x:Name>{worksheet}</x:Name><x:WorksheetOptions><x:DisplayGridlines/></x:WorksheetOptions></x:ExcelWorksheet></x:ExcelWorksheets></x:ExcelWorkbook></xml><![endif]--><meta http-equiv="content-type" content="text/plain; charset=UTF-8"/></head><body><table>{table}</table></body></html>',
            base64 = function(s) {
                return window.btoa(unescape(encodeURIComponent(s)))
            },
            format = function(s, c) {
                return s.replace(/{(\w+)}/g, function(m, p) {
                    return c[p];
                })
            }
        return function(table, name) {
            if (!table.nodeType) table = document.getElementById(table)
            var ctx = {
                worksheet: name || 'Worksheet',
                table: table.innerHTML
            }
            window.location.href = uri + base64(format(template, ctx))
        }
    })()

    function request_update(date, employee_id, request_id, department) {
        $.ajax({
            url: "<?= base_url('index.php/admin/Inventory/InventoryController/get_doctor_requests_items'); ?>",
            type: "POST",
            dataType: "json",
            data: {
                request_id: request_id
            },
            beforeSend: function() {
                $('#issue_tbody_edit').html('<div class="col-md-12 text-center">Loading...</div>');
            },
            success: function(data) {
                $('#issue_tbody_edit').empty();
                $('#request_items_edit').val(0);

                for (let i = 0; i < data.length; ++i) {
                    $("#issue_tbody_edit").append("<tr>" +
                        "<td>" + data[i].invoice_item_id + "</td>" +
                        "<td>" + data[i].item_id + "</td>" +
                        "<td>" + data[i].barcode + "</td>" +
                        "<td>" + data[i].item_name + "</td>" +
                        "<td>" +
                        "<input type=\"hidden\" name='invoice_item_id[]' value=" + data[i].invoice_item_id + " class=\"quantity\">" +
                        "<input type=\"hidden\" name='items[]' value=" + data[i].item_id + ">" +
                        "<input type=\"text\" name='quantity[]' value=" + data[i].quantity + " data-control=" + data[i].item_id + "_edit_" + (parseInt(data[i].stock_qty) + parseInt(data[i].quantity)) + " class='quantity calculate_edit form-control'>" +
                        "<h6 class='text-danger' id='" + data[i].item_id + "_edit'><h6>" +
                        "</td>" +
                        "<td>" + Number(data[i].item_price).toFixed(2) + "</td>" +
                        "<td>" +
                        "<button type=\"button\" class=\"btn btn-light delete_row\" data-control='" + data[i].invoice_item_id + "_edit'><i class=\"fa fa-trash\" aria-hidden=\"true\"></i></button>" +
                        "</td>" +
                        "</tr>");
                    var selected_items = $('#request_items_edit').val();
                    $('#request_items_edit').val(selected_items + ',' + data[i].invoice_item_id);
                }

            }
        });

        $('#date_edit').val(date);
        $('#doctor_id_edit').val(employee_id);
        $('#request_id_edit').val(request_id);
        $('#request_id_edit').val(request_id);
        $('#department option[value="' + department + '"]').prop("selected", true);
    }

    function initialize_print(target, report) {
        $(target).DataTable({
            dom: 'Bfrtip',
            buttons: [{
                    extend: 'print',
                    autoPrint: true,
                    title: '',
                    exportOptions: {
                        columns: ':not(:last-child)'
                    },
                    customize: function(win) {
                        $(win.document.body).prepend(`<?php print_header($this); ?>`);
                    }
                },
                {
                    extend: 'excel',
                    exportOptions: {
                        columns: ':not(:last-child)'
                    }
                }
            ],
            order: [
                [0, 'desc']
            ]
        });
    }

    // Set selected tab
    $(function() {

        /**
         * Check already set or selected tab, if not set default
         */
        var selected_inventory_tab = localStorage.getItem('selected_inventory_tab');

        if (!selected_inventory_tab) {
            localStorage.setItem('selected_inventory_tab', '#ph_items');
        }

        $(localStorage.getItem('selected_inventory_tab')).addClass('active');

        $(`[href="${localStorage.getItem('selected_inventory_tab')}"]`).find('.small-box').addClass('selected');
        $(`[href="${localStorage.getItem('selected_inventory_tab')}"]`).find('.dashboard_icon').css({
            'color': 'white'
        });

        $('.inventory-tab-button').on('click', function() {
            localStorage.setItem('selected_inventory_tab', $(this).attr('href'));

            Array.from($('.small-box')).forEach(element => {
                $(element).removeClass('selected');
                $(element).find('.dashboard_icon').css({
                    'color': 'black'
                });
            });

            $(this).find('.small-box').addClass('selected');
            $(this).find('.small-box').find('.dashboard_icon').css({
                'color': 'white'
            });
        });
    });

    $(function() {

        $(document).on('keyup change', '.inventory_item_min_qty', function() {
            const item_id = $(this).attr('item-id');
            const item_min_qty = $(this).val();
            const current_qty = $(this).attr('current-qty');

            if (item_min_qty) {
                //console.log(`${item_id}, ${item_min_qty}`);

                $.ajax({
                    url: '<?= base_url('index.php/admin/Inventory/InventoryController/change_min_qty') ?>',
                    method: 'POST',
                    data: {
                        item_id: item_id,
                        item_min_qty: item_min_qty
                    },
                    dataType: 'json',
                    success: function(response) {
                        $(`#inventory_qty_warning_${item_id}`).css({
                            'background-color': parseInt(current_qty) <= parseInt(item_min_qty) ? "#dd4b39" : "#146993"
                        });
                        successNotification('Item minimum qty changed.');
                    },
                    error: function(xhr, status, error) {
                        console.error(status + ': ' + error);
                        errorNotification('Failed to change minium qty!');
                    }
                });


            }

        });

    });

    // Item request max qty validation
    function validate_request_qty() {
        $('.validate_request_qty').on('keyup change', function() {
            const requested_qty = parseInt($(this).val());
            const available_qty = parseInt($(this).attr('max'));
            const minimum_qty = parseInt($(this).attr('min'));

            if (requested_qty > available_qty) {
                $(this).val(available_qty);
                console.log(requested_qty, '>', available_qty);
                errorNotification('You exceeded the quantity more than the stock amount.');
            }

            if (requested_qty < 0) {
                $(this).val(1);
                errorNotification('The requested quantity is less than the minimum required.');
            }



        });
    }
</script>