<div class="modal fade" id="new_store_location_modal" tabindex="-1" role="dialog" aria-labelledby="AddNewStoreLocation" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="AddNewStoreLocation">Locations</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">

        <div class="form-group p-2" style="overflow: hidden;background-color:#084a6a0a;">
          <label for="">New Location</label> <br>
          <input type="text" name="" id="new_inventory_location" class="form-control form-control-sm" placeholder="Ex: AB-1"> <br>
          <button type="button" class="btn btn-sm float-right" id="save_new_inventory_location"><i class="fa fa-check-circle"></i> Save</button>
        </div>

        <div>
          <hr>
        </div>

        <table class="table table-bordered table-striped w-100" id="inventory_item_locations"></table>
      </div>
      <div class="modal-footer">

        <button type="button" class="btn btn-sm" data-dismiss="modal"><i class="fa fa-times-circle"></i> Close</button>
      </div>
    </div>
  </div>
</div>

<div class="row no-print mt-3">
  <div class="col-md-12">

    <div class="btn-group pull-right" role="group">

      <div class="col-md-12">
        <div class="row">
          <div class="col-md-12">
            <div class="d-flex flex-row justify-content-end w-100">
              <button type="button" class="btn btn-dark btn-sm mr-2" data-toggle="modal" data-target="#new_store_location_modal"><i class="fa fa-plus-circle" aria-hidden="true"></i> Item Locations</button>

              <a href="<?= base_url('index.php/admin/Inventory/InventoryController/invoice') ?>" class="btn btn-dark btn-sm mr-2"><i class="fa fa-plus-circle" aria-hidden="true"></i> New Order</a>
              <a href="<?= base_url('index.php/admin/Inventory/InventoryController/restock') ?>" class="btn btn-dark btn-sm"><i class="fa fa-retweet" aria-hidden="true"></i> Restock Items</a>
            </div>
          </div>
        </div>
      </div>

      <div class="modal fade" id="restockModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
          <div class="modal-content">
            <div class="modal-header bg-primary">
              <h5 class="modal-title" id="exampleModalLabel">Restock Items</h5>
              <button type="button" class="close" data-dismiss="modal">&times;</button>
            </div>
            <form role="form" action="<?= base_url('index.php/admin/Inventory/InventoryController/manage_suppliers'); ?>" method="post" enctype="multipart/form-data">
              <div class="modal-body">
                <div class="form-group supplier_name">
                  <label for="supplier_name">Supplier Name</label>
                  <span class="glyphicon glyphicon-asterisk ui-must_remark" aria-hidden="true"></span>
                  <input type="hidden" class="form-control" name="new_supplier" id="new_supplier" value="false">
                  <input type="text" class="form-control" name="supplier_name" id="supplier_name">
                  <input type="hidden" class="form-control" name="ph_supplier_id" id="ph_supplier_id" maxlength="8">
                </div>
              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-light btn-sm " data-dismiss="modal"><i class="fa fa-times-circle" aria-hidden="true"></i> Close</button>
                <button type="submit" class="btn btn-light btn-sm"><i class="fa fa-check-circle" aria-hidden="true"></i> Save</button>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Modal -->
  <div class="modal fade" id="invoiceModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-header bg-primary">
          <h5 class="modal-title" id="exampleModalLabel">Modify Bill
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
          </h5>
          </button>
        </div>
        <form role="form" action="<?= base_url('index.php/admin/Inventory/InventoryController/manage_invoices'); ?>" method="post" enctype="multipart/form-data">
          <div class="modal-body">
            <div class="form-group invoice_name">
              <label for="invoice_name">Bill Name</label>
              <input type="text" class="form-control" name="invoice_name" id="invoice_name">
              <input type="hidden" class="form-control" name="item_type" id="item_type" maxlength="8">
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-light  btn-sm" data-dismiss="modal"><i class="fa fa-times-circle" aria-hidden="true"></i> Close</button>
            <button type="submit" class="btn btn-light btn-sm"><i class="fa fa-check-circle" aria-hidden="true"></i> Save</button>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>
<br>
<div class="row">
  <div class="col-md-12">
    <div class="panel panel-success">
      <div class="panel-heading">
        <h3 class="panel-title">Bill List</h3>
      </div>
      <div class="panel-body" style="background-color:#fff;">
        <div class="table-responsive">
          <table class="table table-striped table-bordered table-hover" id="tbl-invoices">
            <thead>
              <tr>
                <th>Bill ID</th>
                <!-- <th>Ref no</th> -->
                <th>Payment Method</th>
                <th>Date</th>
                <th>Supplier</th>
                <th class="text-center">Action</th>
              </tr>
            </thead>
            <tbody>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>


<script>
  $(document).ready(function() {
    var inventoryLocationsDataTable = $('#inventory_item_locations').DataTable({
      'ajax': {
        'url': '<?= base_url('index.php/admin/Inventory/InventoryController/get_inventory_item_locations'); ?>',
        'type': 'GET',
        'data': function(d) {
          d.insurance = $('#insurance_filter').val();
        }
      },
      'columns': [{
          'data': 'id',
          'title': 'Id'
        },
        {
          'data': 'location',
          'title': 'Location',
        },
        {
          'data': null,
          'title': 'Actions',
          'className': 'text-center',
          'render': function(data, type, row) {
            //var actions = '<button class="btn btn-sm btn-light mr-1" onclick="yourButtonClickFunction(' + row.id + ')"><i class="fa fa-pencil-square-o"></i></button>';
            return `<div class="text-center"><button class="btn btn-sm btn-light" onclick="confirmDeleteGenral('<?= base_url('index.php/admin/Inventory/InventoryController/delete_inventory_location'); ?>/${row.id}')"><i class="fa fa-trash"></i></button></div>`;
          }
        }
      ],

      'serverSide': true,
      'pageLength': 25,
      'lengthMenu': [25],
      'searching': false,
      'paging': false,
      'pagingType': 'full_numbers'
    });

    $('#save_new_inventory_location').on('click', function(e) {

      const location = $('#new_inventory_location').val();

      if(!location) {
        errorNotification('Please enter location.');
        return false;
      }

      $.ajax({
        url: '<?= base_url('index.php/admin/Inventory/InventoryController/create_new_inventory_location'); ?>',
        type: 'POST',
        data: {
          location: location
        },
        success: function(response) {
          successNotification('New location created successfully.');
        },
        error: function(error) {
          console.error('Error:', error);
        }
      });

      $('#new_inventory_location').val('');
      inventoryLocationsDataTable.ajax.reload();
    });


  });
</script>