<!DOCTYPE html>
<html>

<head>
  <meta charset="UTF-8">
  <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
  <?php require_once(APPPATH . "views/admin/header.php"); ?>


  <style>
    .select2-container .select2-selection--single {
      height: 55px;
    }

    .form-group>.select2-container {
      width: 100% !important;
    }

    .panel-success,
    .panel-success>.panel-heading {
      color: #fff;
      background-color: #449d44;
      border-color: #449d44;
    }

  </style>
  <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.11.3/css/jquery.dataTables.min.css">
  <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/buttons/2.0.1/css/buttons.dataTables.min.css">

</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
  <!-- Site wrapper -->
  <!-- Header Navbar: style can be found in header.less -->
  <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

  <!-- =============================================== -->

  <!-- Left side column. contains the sidebar -->
  <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

  <!-- =============================================== -->

  <div class="content-wrapper">

    <section class="content-header">
      <h1>
        <strong>Inventory</strong>
      </h1>
      <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
    </section>

    <section class="content print-remove-top-space">

      <div class="row">
        <div class="col-md-12">
          <?php print_header($this); ?>
        </div>
      </div>

      <div class="row">
        <div class="col-md-12">
          <div class="box box-info">
            <div class="box-header with-border no-print">
              <h3 class="box-title font-weight-bold">Stock</h3>
            </div>

            <div class="box-body">
              <div class="panel-group" id="accordion">
                <div class="d-block mb-3">
                  <div class="panel panel-default">
                    <div class="panel-body">

                      <!-- Content start -->

                      <!-- Load print header here -->

                      <h4 class="page-header ui-page-header"><?= $page_header; ?></h4>

                      <form role="form" id="main" action="<?= base_url('pharmacy/manage_restock'); ?>" method="post" enctype="multipart/form-data" class="form-horizontal">
                        <div class="row no-print">
                          <div class="col-sm-12 col-md-3">
                            <label>Category</label>
                            <select class="form-control" name="category_id" id="category_id">
                              <option>Select Category...</option>
                              <?php foreach ($categories as $category) : ?>
                                <option value="<?= $category['item_type'] ?>" <?= ($header[0]['item_type'] == $category['item_type']) ? "selected" : "" ?>><?= $category['type_name'] ?></option>
                              <?php endforeach; ?>
                            </select><br>
                          </div>
                        </div>

                        <div class="row">
                          <hr>
                          <div class="col-md-12">
                            <div>
                              <strong>Stock List</strong>
                              <button type="button" class="btn btn-dark btn-sm pull-right" onclick="window.print();">
                                <i class="fa fa-print" aria-hidden="true"></i> Print Stocks
                              </button>
                            </div>
                          </div>
                        </div>

                        <div class="row">
                          <div class="col-md-12">
                            <table class="table table-light table-hover display table-striped" id="tbl-stock-items">
                              <thead>
                                <tr>
                                  <td>Code</td>
                                  <td>Item Name</td>
                                  <td>Remaining</td>
                                  <td>Unit</td>
                                  <td>Price</td>
                                  <td class="text-right">Qty</td>
                                  <td class="text-center">Total</td>
                                </tr>
                              </thead>
                              <tbody>
                              </tbody>
                            </table>
                          </div>
                        </div>

                        <div class="row hidden-print">
                          <div class="col-md-12 text-right">
                          </div>
                        </div>

                      </form>

                      <!-- Content end -->

                    </div>
                  </div>
                </div>

                <table id="price_list" class="table table-light table-bordered table-striped"></table>

              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  </div>
  <?php require_once(APPPATH . "views/admin/footer.php"); ?>
</body>

</html>

<script type="text/javascript" language="javascript" src="https://cdn.datatables.net/1.11.3/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" language="javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/dataTables.buttons.min.js"></script>
<script type="text/javascript" language="javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script type="text/javascript" language="javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
<script type="text/javascript" language="javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
<script type="text/javascript" language="javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.html5.min.js"></script>
<script type="text/javascript" language="javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.print.min.js"></script>

<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
  $('#item_id').select2({
    placeholder: 'Select Drug...',
    ajax: {
      url: '<?= base_url('ajax/get_items_json'); ?>',
      dataType: 'json',
      width: '100%',
      data: function(params) {
        var queryParameters = {
          term: params.term,
          not_all: false
        }
        return queryParameters;
      },
      processResults: function(data) {
        return {
          results: data
        };
      },
      cache: true
    }
  });

  row = '';
  itemsArr = [];
  itemArr = [];
  itemQty = [];
  itemUnit = [];
  itemExpiry = [];
  itemLocation = [];

  $('#supplier_id').select2();
  $('#category_id').on('change', function() {
    category_id = $(this).val();
    $.ajax({
      url: "<?= base_url('index.php/admin/Inventory/InventoryController/search_supplier_categories'); ?>",
      type: "POST",
      data: {
        category_id: $(this).val()
      },
      beforeSend: function() {
        // if ($('input name["invoice_id"]').val()) {
        //   $('#tbl-stock-items tbody').empty();
        // }
      },
      success: function(data) {
        $('#tbl-stock-items tbody').html(data);

        $('.view-item-history').on('click', function() {
          code = $(this).data('code').toString();
          code = code.replace(' || ', '');

          $('#item-detail-name').text($(this).data('name'));
          $('#item-detail-code').text(code);
          $('#item-detail-unit').text($(this).data('unit'));
          $('#item-detail-category').text($(this).data('category'));

          $.ajax({
            url: "<?= base_url('pharmacy/search_supplier_history'); ?>",
            type: "POST",
            data: {
              supplier_id: supplier_id,
              item_id: code
            },
            beforeSend: function() {

            },
            success: function(v) {
              $('html, body').animate({
                scrollTop: $("#main").offset().top
              }, 100);

              $('#tbl-transactions tbody').html(v);
            }
          })
        })
      }
    })
  })
</script>