<?php if ($result != FALSE) : ?>
    <div id='report-content-transfer'>
        <?php include(dirname(__FILE__) . '../../blocks/print_header_receipt.php');
        ?>

        <h4 class="visible-print-block col-md-12 text-center"><u>Inventory : Issue Report</u></h4>
        <table class="table">
            <thead>
                <tr>
                    <td width="25%" class="text-center"><span class="visible-print-block col-md-6">Doctor : <b><?= isset($doctor_info->employee_name) ? $doctor_info->employee_name : 'All' ?></b></span></td>
                    <td width="25%" class="text-center"><span class="visible-print-block col-md-6">Department : <b><?= $department != '0' ? $department : 'All' ?></b></span></td>
                    <td width="25%" class="text-center"><span class="visible-print-block col-md-6 ">Item : <b><?= $item_info ? $item_info->item_id . ' - ' . $item_info->item_name : 'All' ?></b></span></td>
                </tr>
            </thead>
        </table>
        <div class="table-responsive">
            <table class="table table-bordered table-hover" id="tbl-transfer">
                <thead>
                    <tr>
                        <th>Request No</th>
                        <th>Date</th>
                        <th>Item</th>
                        <th>Doctor / Department</th>
                        <th>Unit Type</th>
                        <th>Unit Cost</th>
                        <th>Quantity</th>
                        <th>Total Cost</th>
                    </tr>
                </thead>
                <tbody>

                    <?php $total = 0;
                    foreach ($result as $row) :
                        $unit_price = $row['out_price'] * $row['quantity'];
                        $total += $unit_price;

                        echo '<tr>
                    <td>' . $row['request_id'] . '</td>
                    <td width="10%">' . $row['date'] . '</td>
                    <td width="30%">' . $row['item_id'] . ' - ' . $row['item_name'] . '</td>
                    <td width="30%">' . $row['doctor_name'] . '<br>' . $row['department'] . '</td>
                    <td>' . $row['unit_name'] . '</td>
                    <td class="col-md-1">' . number_format($row['out_price'], 2) . '</td>
                    <td>' . $row['quantity'] . '</td>
                    <td class="col-md-1">' . number_format($unit_price, 2) . '</td>
                  </tr>';
                    endforeach;
                    echo '<tr>
                <td colspan="7" class="text-right"><b>TOTAL:</b></td>
                <td class="col-md-1"><b>' . number_format($total, 2) . '</b></td>
            </tr>';
                    ?>
                </tbody>
            </table>
        </div>
    <?php else : ?>
        <div class="col-md-12 text-center">Not found any records</div>
    <?php endif; ?>
    </div>