<div class="row">
            <div class="col-md-12">
              <div class="panel panel-info">
                <div class="panel-heading">
                  <h4 class="panel-title">Add New Case</h4>
                </div>
                <form  id="expire_report" method="post">
                  <div class="panel-body">
                    <div class="row">
                      
                    </div>
                   
                    <div class="spinner spinner-border mx-auto  text-primary" style="display: none;" id="detail_loader"></div>
                  </div>
                </form>
              </div>
            </div>

</div>
<div class="row mt-5" >
    <div class="col-md-12 mx-auto">
        
    <form action="" class="form" id="testForm">
        <div class="row">

        <div class="form-group col-md-3">
                <label for="">Patient File No <span class="text-danger">*</span></label>
                <input type="number" class="file_no" required placeholder="File No" name="file_no"  />
                
            </div>
           
            <div class="form-group col-md-3">
                <label for="">Patient QID <span class="text-danger">*</span></label>
                <input type="number" class="form-control" required placeholder="QID" name="qid" id="qid"  />
                
            </div>

            <div class="form-group col-md-3">
                <label for="">First Name <span class="text-danger">*</span></label>
                <input type="text" class="form-control name" required placeholder="First Name" id="fname" name="first_name"  />
               
            </div>
            <div class="form-group col-md-3">
                <label for="">Middle Name</label> 
                <input type="text" class="form-control qid" placeholder="Middle Name" id="mname" name="middle_name"  />
               
            </div>
            <div class="form-group col-md-3">
                <label for="">Last Name</label>
                <input type="text" class="form-control qid" placeholder="Last Name" id="lname" name="last_name"  />
               
            </div>

            <div class="form-group col-md-3">
                <label for="">Age<span class="text-danger">*</span></label>
                <input type="number" class="form-control qid" required id="age" name="age"  />
                <input type="hidden" name="dob" id="dob" value="" >
            </div>
            <div class="form-group col-md-3">
                <label for="">Gender</label>
               <select name="" class="form-control" id="gender">
               <option value="">--Select Gender--</option>
                <option value="Male">Male</option>
                <option value="Female">Female</option>
                <option value="Other">Other</option>
               </select>
                
            </div>
            <input type="hidden" name="" value="" id="patient_id">
            <div class="form-group col-md-3">
                <label for="nationality">Nationality<span class="text-danger">*</span></label>
                <select class="form-control"  data-live-search="true"  id="nationality" name="nationality" required>
                        <option value="">Select Nationality</option>
                        <?php foreach ($countries as $value): ?>
                            <option <?= ($nationality == $value['country_id']) || (empty($nationality) && $value['country_name'] == 'Qatar') ? 'selected' : '' ?> value="<?= $value['country_id'] ?>">
                                <?= $value['country_code'].' - '.$value['country_name'] ?>
                            </option>
                        <?php endforeach; ?>
                </select>
                
            </div>
            <div class="form-group col-md-3">
            <label for="">Mobile Number</label>
                <input type="number" class="form-control mobile_number" id="mobile_number" name="mobile"  />
            </div>

        </div>
        <hr>
        <div class="row">
        <input type="hidden" name="case_id_existing" id="case_id_existing" value="0" />
           
            <div class="form-group col-md-3">
                <label for="">Select Tests </label>
                <select  class="" name="tests[]" multiple placeholder="Select Test"  id="test"  ></select>
                
            </div>
            
        </div>
        <hr>
      
        <div class="row">
            <div class="col-md-12 d-felx justify-content-end">
                <button class="btn btn-dark"><i class="fa fa-save mr-1"></i>Save</button>
            </div>
        </div>
    </form>
        </div>
</div>

<script>
 
$(document).ready(function(){
       

     

    var patientSelect = null;
    var testSelect = null;
   


    var item_price=0;
    var selectedTests = [];
    function init_patient_select() {
      patientSelect = new TomSelect(".file_no", {
        valueField: 'patient_id',
        labelField: 'name',
        searchField: 'patient_id',
        maxItems: 1,

        preload:true,
        closeAfterSelect:true,
        // Set the "load" property to define the function to fetch data dynamically
        load: function(query, callback) {
          var apiUrl = "<?php echo site_url('admin/Patients/PatientsController/get_patient_fileno?'); ?>name_startsWith=" + encodeURIComponent(query);

          fetch(apiUrl)
            .then(response => response.json())
            .then(data => {
              callback(data);
              var patient_id_check=$('#patient_id_add').val();
             
            if(patient_id_check != 0){
               
                
                selectPatient(patient_id_check);
                $('#detail_loader').show();

            }
            })
            .catch(() => {
              callback();
            });
        },
        render: {
          option: function(item, escape) {
            return '<div>' +
              '<span class="btn btn-sm">' + escape(item.full_name) + '-' +escape(item.patient_id) + '</span>' +
              '</div>';
          },
          item: function(item, escape) {
            return '<div>' +
              '<span class="btn  btn-sm">'+ escape(item.patient_id) +  '</span>' +
              '</div>';
          }
        },
        onItemAdd: function(value, item) {
            console.log('onItemAdd fired'); // Debugging log
            console.log('Selected value:', value); // Debugging log
            console.log('Selected item:', item); // Debugging log

            // Find the selected patient data by id
            var selectedPatient = this.options[value] || { patient_id: value, name: value };
                console.log('Selected patient data:', selectedPatient); //
                showSelectedData(selectedPatient);
            this.blur();
        },
       
      });


    }
   
    function init_test_select() {
        if (testSelect) {
        return;
    }
        testSelect = new TomSelect("#test", {
        valueField: 'id',
        labelField: 'name',
        searchField: ['name','short_name'],
        plugins: ['remove_button'],
        preload:true,
        closeAfterSelect:true,
        // Set the "load" property to define the function to fetch data dynamically
        load: function(query, callback) {
          var apiUrl = "<?php echo site_url('admin/Lab/LabController/get_test?'); ?>name_startsWith=" + encodeURIComponent(query);

          fetch(apiUrl)
            .then(response => response.json())
            .then(data => {
              callback(data);

              var case_id_check=$('#case_id').val();

            if(case_id_check != 0){
                console.log(case_id_check);
                $('#case_id_existing').val(case_id_check);
                load_case_details(case_id_check);

            }
            })
            .catch(() => {
              callback();
            });
        },
        render: {
          option: function(item, escape) {
            return '<div>' +
              '<span class="btn btn-sm">' + escape(item.name) + '-' +escape(item.id) +'-' +escape(item.price)+ 'Qar</span>' +
              '</div>';
          },
          item: function(item, escape) {
            return '<div>' +
              '<span class="btn  btn-sm">'+ escape(item.name) + '-'+ escape(item.price) +'Qar</span>' +
              '</div>';
          }
        },
        onItemAdd: function(value, item) {
  
            // Find the selected patient data by id
            var selectedTest = this.options[value] || { id: value, name: value };
            selectedTest.price = parseFloat(selectedTest.price || 0);
            selectedTests.push(selectedTest);
            var total= calculatePayment(selectedTests);
            if(selectedTests.length <= 0){
                $(".payment-section").hide(250);
            }else{
                $(".payment-section").show(250);
            }

            $('#total').text(total)
            $('#total_first').val(total)
            $('#amount_received').val(total)
            this.blur();
        },
        onItemRemove: function(value, item) {
  
                // Find the selected patient data by id
            var selectedTest = this.options[value] || { id: value, name: value };
            selectedTest.price = parseFloat(selectedTest.price || 0);
            selectedTests = selectedTests.filter(item => item.name !== selectedTest.name);

            var total= calculatePayment(selectedTests);
            $('#total').text(total)
            $('#total_first').val(total)
            $('#amount_received').val(total)
            
            if(selectedTests.length <= 0){
                $(".payment-section").hide(250);
            }else{
                $(".payment-section").show(250);
            }
            this.blur();
            },
       
      });


    }

    init_patient_select();
    init_test_select();

    testSelect.settings.minLength = 1;
    function selectPatient(patient_id_check){
        patientSelect.setValue(patient_id_check)
        $('#patient_id_add').val(0);
    }
  
    function load_case_details(case_id) {
            $.ajax({
                url: '<?= base_url('admin/Lab/LabController/get_tests_by_case/') ?>' + case_id,
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    var selectedTests = data.map(function(test) { return test.id; });
                     testSelect.setValue(selectedTests);
                    console.log('Case details loaded successfully');
                    $('#case_id').val(0);
                    $('#detail_loader').hide();
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    console.log(textStatus, errorThrown);
                    $('#detail_loader').hide();
                }
            });
}

    function showSelectedData(data){
        $("#fname").val(data.fname);
        $("#qid").val(data.name);
        $("#mname").val(data.mname);
        $("#lname").val(data.lname);
        $("#mobile_number").val(data.mobile);

        $("#patient_id").val(data.patient_id);

        $("#age").val(calculateAge(data.dob));
        $("#dob").val(data.dob);
        $("#gender").val(data.sex);
        $("#nationality").val(data.nationality);
    }

    function calculateAge(dob) {
                var dob = new Date(dob);
                var diffMs = Date.now() - dob.getTime();
                var ageDt = new Date(diffMs); 
                return Math.abs(ageDt.getUTCFullYear() - 1970);
    }
    function calculatePayment(items, discountRate = 0) {
        console.log(items);
        var total = 0;
        items.forEach(item => {
            var price = parseFloat(item.price);
            if (!isNaN(price)) {
                total += price;
            }
        });

        if (discountRate > 0 && discountRate <= 100) {
            var discount = total * (discountRate / 100);
            total -= discount;
        }

        return total.toFixed(2);
    }

    

    $('#testForm').submit(function(event) {
        event.preventDefault();
        var total_price = $("#total").text();
        $('#total_final').val(total_price);
       
        var formData = $(this).serialize();
        console.log(formData);
        $.ajax({
            url: '<?php echo base_url("admin/Lab/LabController/saveCase")?>',
            type: 'POST',
            data: formData,
            success: function(response) {
                // Handle the response from the server
                if(response.status == 'success'){
                    
                    successNotification(response.msg);
                    $('#testForm')[0].reset();
                    patientSelect.clear();
                    testSelect.clear();
                    console.log(response.id);
                    // var invoiceUrl = "<?php echo site_url('admin/Invoice/InvoiceController/labInvoice/'); ?>" + response.id +"/"+response.case_id;
                    // window.open(invoiceUrl, '_blank');
                    $('#case_id_existing').val(0);
                }
                // Optionally, reset the form or provide feedback to the user
               
               
            },
            error: function(xhr, status, error) {
                // Handle any errors
                console.error(error);
            }
        });
    });
})
</script>