<div class="row">
            <div class="col-md-12">
              <div class="panel panel-info">
                <div class="panel-heading">
                  <h4 class="panel-title">All Cases</h4>
                </div>
                <form  method="post" id="expire_report">
                  <div class="panel-body">
                    <div class="row">
                      <div class="col-md-4">
                        <div class="form-group">
                          <label>Enter QID / File No</label>
                            <input type="number" name="qid" class="form-control" id="qid">
                        </div>
						</div>
						<div class="col-md-4">
                        <div class="form-group">
                          <label class="from" for="from">From</label>
                          <label class="date" for="date">Date</label>
                          <input type="date" class="form-control" name="from" id="from">
                        </div>
							</div>
						<div class="col-md-4">
                        <div class="form-group">
                          <label for="to">To</label>
                          <input type="date" class="form-control" name="to" id="to">
                        </div>
						</div>
                     
                    </div>
                    <a  class="btn btn-dark cursor-pointer text-white  hidden-print" id="generate">Generate</a>
                    <button type="reset" class="btn btn-light  hidden-print" id="clear">Clear</button>
                  </div>
                </form>
              </div>
            </div>

</div>
<div class="row mt-5" >
    <div class="col-md-12 mx-auto">
        <table id="p_report" class="table table-light table-bordered table-striped">
                        
        </table>
        </div>
</div>

<script>

     $(document).ready(function() {
		// Initialize the DataTable
        var base_url ="<?php echo base_url() ?>";
		dataTable = $('#p_report').DataTable({
			dom: 'lBfrtip',
			buttons: [{
				extend: 'excel',
				title: `All Cases`
			}, {
				extend: 'print',
				autoPrint: true,
				title: `All Cases`,
				exportOptions: {
					columns: ':not(:last-child)'
				},
				customize: function(win) {
					$(win.document.body).prepend(`<?php print_header($this); ?>`);
				}
			}, ],
			'ajax': {
				'url': '<?= site_url('admin/Lab/LabController/get_all_cases'); ?>',
				'type': 'POST',
				'data': function(d) {
					d.qid = $('#qid').val();
					d.from = $('#from').val();
					d.to = $('#to').val();
					d.type = 0;
				}
			},
			'columns': [
				
				{
					'data': 'id',
					'title': 'Case No'
				},
				{
					'data': 'patient_name',
					'title': 'Patient Name.'
				},
				{
					'data': 'qatar_id',
					'title': 'Qatar ID.'
				},
				{
					'data': 'created_at',
					'title': 'Date'
				},
				{
					'data': 'sub_total',
					'title': 'Sub Total'
				},
                {
            'data': 'status',
            'title': 'Status',
            'render': function(data, type, row, meta) {
                if(row.status==0){
                    return '<span class="badge badge-primary">Pending Result</span>';
                }else{
                    return '<span class="badge badge-success">Completed</span>';
                }
               
            }
        },
        {
            'data': '',
            'title': 'Action',
            'render': function(data, type, row, meta) {
                if(row.status==0){
                    return '<div class="d-flex"><a href="LabController/add_result/'+row.id+'" class="btn btn-dark btn-sm mr-1" ><i class="fa fa-plus mr-1"></i>Add Result &nbsp;</a><a href="'+base_url+'admin/Invoice/InvoiceController/labInvoice/'+row.treatment_payment_id+'" class="btn btn-light btn-sm "><i class="fa fa-file-o mr-1"></i>Invoice</a></div>';
                }else{
                    return '<div class="d-flex"><a href="LabController/view_result/'+row.id+'" class="btn btn-light btn-sm mr-1"><i class="fa fa-eye mr-1"></i>View Result</a> <a href="'+base_url+'admin/Invoice/InvoiceController/labInvoice/'+row.treatment_payment_id+'" class="btn btn-light btn-sm"><i class="fa fa-file-o mr-1"></i>Invoice</a></div>';
                }
               
            }
        },
				
				
			],
			'searching': false,
			'serverSide': true,
			'pageLength': 10,
			aLengthMenu: [
				[25, 50, 100, 200, -1],
				[25, 50, 100, 200, "All"]
			],
			'pagingType': 'full_numbers',
			footer:true,
			autoWidth: false

		});



		$('#generate ').on('click', function() {
			dataTable.ajax.reload();
		});
        
        $('#clear').on('click', function() {
            $('#store_report').trigger("reset");
			dataTable.ajax.reload();
		});
	});


</script>