<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Print Test Results</title>
    <link rel="stylesheet" href="  <?php  echo base_url('css/print_result.css') ?>">
    <?php
        $header_size = '';
        $footer_size = '';
        $letter_head_enable='';
        foreach ($print_config as $config) {
            if ($config->config_option == 'letterhead_header_size') {
                $header_size= $config->value;
            }
            if ($config->config_option == 'letterhead_footer_size') {
                $footer_size= $config->value;
            }
            if ($config->config_option == 'letterhead_enable') {
                $letter_head_enable= $config->value;
            }
        }
        ?>
    <style>

        .header-height{
            height: <?php echo $header_size ?>;
            border: 1px dashed darkgray;
            display: flex;
            align-items: center;
            justify-content: center;

        }
        .footer-height{
            height: <?php echo $footer_size ?>;
            border: 1px dashed darkgray;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        	
        @media print {
            body {
                font-family: Arial, sans-serif;
                margin: 0;
                padding: 0;
                
            }

            .letterhead {
                padding: 20px;
                margin: 0;
               
                width: 100%;
                box-sizing: border-box;
            }

            .header, .footer {
                text-align: center;
            }
            .content{
                margin-top: <?php echo $header_size ?>;
                margin-bottom: <?php echo $footer_size ?>;
            }
            

            table {
                width: 100%;
                border-collapse: collapse;
                margin-top: 20px;
            }

            table, th, td {
                border: 1px solid #000;
            }
                    .patient th, .patient td {
            padding: 8px;
            text-align: left !important;
        }

        .result th, .result td {
            padding: 8px;
            text-align: center !important;
        }
           
            .test_name{
                text-align: center;
    font-weight: 600;
    width: 100% !important;
    display: block;
    margin-top: 20px;
    font-size: 24px;
}
            

            .noprint {
                display: none;
            }
        }
    </style>
</head>
<body>
    <div class="sidebar noprint">
        <h4>Print Setting</h4>
        <hr>
        <label for="">Header Height</label>
        <input type="number" class="header_height" value="<?php echo  str_replace('cm','', $header_size); ?>" step="0.1" />
        <br><br>
        <label for="">Footer Height</label>
        <input type="number" class="footer_height" value="<?php echo  str_replace('cm','', $footer_size); ?>" step="0.1" />
        <br><br>
        <label for="">Letter Head</label>
        <input type="checkbox" class="letterhead_enable" value="" <?php if($letter_head_enable ==1){echo 'checked';} ?> />
        <div class="btn-group">

        <button class="btn btn-print" type="button">Print</button>
      
        </div>
       
    </div>
    <div class="letterhead">
        
        <div class="header-height noprint">
            <p>Your letterhead Header Size ( <?php echo $header_size ?> )</p>
        </div>
        <div class="content">
        <table class="patient">
                    <tr>
                        <td><strong>Patient Name : </strong><?php echo $patient->patient_name ?></td>
                        <td><strong>QID : </strong><?php echo $patient->qatar_id ?></td>
                        <td><strong>DOB : </strong><?php echo $patient->dob ?></td>
                    </tr>
                    <tr>
                        <td><strong>Nationality : </strong><?php echo $patient->nationality ?></td>
                        <td><strong>Gender : </strong><?php echo $patient->sex ?></td>
                        <td><strong>Pid : </strong><?php echo $case_id; ?></td>
                        
                    </tr>
                </table>
         
          
            <table class="result">
                <thead>
                    <tr>
                       
                        <th>Investigation</th>
                        <th>Value</th>
                        <th>Reference Range / Normal Value</th>
                        <th>Unit</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($test_params as $test_id => $test_data): ?>
                        <tr>
                           <span class="test_name"><?php echo $test_data['test_name']; ?></span>
                            <?php foreach ($test_data['parameters'] as $param_index => $param): ?>
                                <?php if ($param_index > 0) echo '<tr>'; ?>
                                <td><?php echo $param['param_name']; ?></td>
                                <td><?php echo htmlspecialchars($param['param_value']); ?></td>
                                <td>
                                    <?php 
                                    if ($param['max_value'] && $param['lower_value'] > 0) {
                                        echo $param['lower_value'].'&nbsp;- &nbsp;'.$param['max_value'];
                                    } else {
                                        echo $param['normal_value'] ?? 'NA';
                                    }
                                    ?>
                                </td>
                                <td><?php echo $param['unit_name'] ?></td>
                                <?php if ($param_index > 0) echo '</tr>'; ?>
                            <?php endforeach; ?>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            <p><?php print_r( $test_params[1]['parameters'][0]['remarks'])  ?></p>
            <hr>
        </div>

        <div class="footer-height noprint">
           <p>Your letterhead Fotoer (<?php echo $footer_size ?>)</p> 
        </div>
    </div>
    
</body>
<!-- <script>
    window.addEventListener("load", (event) => {
        window.print();
});
</script> -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js" integrity="sha512-v2CJ7UaYy4JwqLDIrZUI/4hqeoQieOmAZNXBeQyjo21dadnwR+8ZaIJVT8EE2iyI61OV8e6M8PP2/4hpQINQ/g==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script>
        $(document).ready(function() {
            $('.btn-print').click(function(){
                window.print();
            })

            $('.letterhead_enable').change(function() {
                if ($(this).is(':checked')) {
                   
                    changeMarginTop("<?php echo $header_size ?>");
                    changeMarginBottom("<?php echo $header_size ?>");
                    $('.header-height').css('height', "<?php echo $header_size ?>").show();
                    $('.footer-height').css('height', "<?php echo $footer_size ?>").show();

                }else{
                    console.log('ssd');
                    changeMarginTop('0cm');
                    changeMarginBottom('0cm');
                    $('.header-height').css('height', 0).hide();
                    $('.footer-height').css('height', 0).hide();
                }

            })
              
            
            $('.header_height').change(function() {
                var value = $(this).val() + 'cm';

                // Change the height for the screen
                $('.header-height').css('height', value);

                // Change the height for print
                changeMarginTop(value);
               
            });
            $('.footer_height').change(function() {
                var value = $(this).val() + 'cm';

                // Change the height for the screen
                $('.footer-height').css('height', value);

                // Change the height for print
                changeMarginBottom(value);
               
            });


            function changeMarginTop(svalue){
                var styleSheet = document.styleSheets[1];
                var rules = styleSheet.cssRules || styleSheet.rules;
             
                for (var i = 0; i < rules.length; i++) {
                    if (rules[i].media && rules[i].media.mediaText === 'print') {
                        var printRules = rules[i].cssRules || rules[i].rules;
                        
                        for (var j = 0; j < printRules.length; j++) {
                            if (printRules[j].selectorText === '.content') {
                                printRules[j].style.marginTop = svalue;
                            }
                        }
                    }
                }
            }
            function changeMarginBottom(svalue){
                var styleSheet = document.styleSheets[1];
                var rules = styleSheet.cssRules || styleSheet.rules;
             
                for (var i = 0; i < rules.length; i++) {
                    if (rules[i].media && rules[i].media.mediaText === 'print') {
                        var printRules = rules[i].cssRules || rules[i].rules;
                        
                        for (var j = 0; j < printRules.length; j++) {
                            if (printRules[j].selectorText === '.content') {
                                printRules[j].style.marginBottom = svalue;
                            }
                        }
                    }
                }
            }
        });
    </script>
</html>
