<div id="DentalForm" class="p-3">
    <form role="form" action="<?php echo site_url('admin/Modules/Dental/DentalController/save'); ?>" method="post" enctype="multipart/form-data">
        <div class="row">
            <div class="col-12">
                <h4>Create Dental Treatment</h4><br>
            </div>
        </div>
        <div class="row">
            <div class="col-md-6 col-6">
                <div class="form-group <?php echo (form_error('date') == '') ? '' : ' has-error'; ?>">
                    <label for="app_date">Treatment Date</label>
                    <input type="text" class="form-control select_date" name="treatment_date" id="treatment_date" value="<?php echo date("Y-m-d H:i:s"); ?>">
                    <?php echo form_error('date', '<div style="color:red"><em>* ', '</em></div>'); ?>
                </div>
            </div>
            <div class="col-md-6 col-6">
                <div class="form-group <?php echo (form_error('date') == '') ? '' : ' has-error'; ?>">
                    <label for="app_date">Treatment Time</label>
                    <input type="time" class="form-control" name="treatment_time" id="treatment_time" value="<?php echo date("H:i"); ?>">
                    <?php echo form_error('date', '<div style="color:red"><em>* ', '</em></div>'); ?>
                </div>
            </div>
            <input type="hidden" name="" class="selected_color" value="">
            <div class="col-md-12 col-12">
                <input type="hidden" name="attendance" value="1">
                <div class="form-group">
                    <label for="cheif_compalin">Chief Complaint</label>
                    <span class="glyphicon glyphicon-asterisk ui-must_remark" aria-hidden="true"></span>
                    <textarea  class="form-control" name="cheif_compalin" id="cheif_compalin" rows="3"></textarea>
                </div>
                <div class="form-group mt-2">
                    <label for="clinical_finding">Clinical Examination and finding</label>
                    <textarea class="form-control" name="clinical_finding" id="clinical_finding" rows="3"></textarea>
                </div>
                <div class="form-group mt-2">
                    <label for="diagnosis_auto">Enter Diagnosis<span class="text-red" aria-hidden="true">*</span></label>
                    <span class="glyphicon glyphicon-asterisk ui-must_remark" aria-hidden="true"></span>
                    <input  class="multi_diagnosis_free form-control" data-department="1" placeholder="Enter Diagnosis" name="multi_diagnosis_free">
                </div>
                <div class="form-group mt-2">
                    <label for="diagnosis_auto">Select Procedure<span class="text-red" aria-hidden="true">*</span></label>
                    <span class="glyphicon glyphicon-asterisk ui-must_remark" aria-hidden="true"></span>
                    <select id="procedure" class="procedure" data-department="1" placeholder="Select a procedure..." name="procedure"></select>
                </div>
                <div class="form-group">
                    <label for="payment_type">Mark Tooth<span class="text-danger">*</span></label>
                    <select id="color_type" name="color_type" required>
                        <?php
                        $query = $this->db->query("SELECT * FROM tbl_tooth_treat");
                        $result_color = $query->result_array();
                        ?>
                    </select>
                    <label><small><?php echo form_error("payment_type"); ?></small></label>
                </div>

                <?php
                date_default_timezone_set('Asia/Kuwait');
                $date_string = '%Y-%m-%d';
                $curr_date = mdate($date_string);
                ?>
                <!-- <input type="hidden" class="form-control" name="treatment_date" id="treatment_date" value=<?php //echo $curr_date; 
                                                                                                                ?>> -->
                <input type="hidden" class="form-control" name="patient_id" id="patient_id" value="<?php echo  encrypt_and_url_encode( $patient_id,$this); ?>">
                <!-- <input type="hidden" class="form-control" style="z-index: 0 !important;" name="treatment_time" id="treatment_time" class="diag-time" value="<?php //echo date('H:s'); 
                                                                                                                                                                    ?>"> -->
            </div>
            <div class="col-md-6">
            </div>
        </div>
        <!-- <div class="row mt-2">
            <div class="col-md-12 col-12">
                <div class="d-flex flex-wrap">
                    <?php


                    // if ($result_color != FALSE) {
                    //     foreach ($result_color as $value) {
                    // 
                    ?>
                            <div class="col-md-3 col-3 d-flex">
                                <div class="ui-color-box" style="background-color: <?php //echo $value['color']; 
                                                                                    ?>" data-color="<?php //echo $value['color'] . '|' . $value['treatname'] . '|' . $value['full_select']; 
                                                                                                    ?>">
                                </div><small><?php //echo $value['treatname']; 
                                                ?></small>
                            </div>
                    <?php
                    //     }
                    // }
                    // 
                    ?>
                </div>
            </div>
        </div> -->
        <div class="row mt-2">
            <div class="col-md-12 col-12">
                <div class="d-flex flex-wrap" id="selected_colors">

                </div>
            </div>
        </div>
        <br>
        <div class="row">
            <!-- <div class="col-md-12" style="background: #ffffff;">
                <div class="text-center">
                   
                </div>
            </div> -->

            <div class="col-md-12" style="background: #ffffff;">
                <div class="text-center" id="tooth_svg_container">
                    <!-- The SVG will be inserted here by JavaScript -->
                </div>
            </div>
            
            <!-- <div class="col-md-2">
            <div class="checkbox">
                <label>
                    <input type="checkbox" name="multi_option" id="multi_t" class="ui-check" value="1"> Multi Tooth
                </label>
            </div>
        </div> -->
        </div>
        <div class="row">
            <div class="col-md-10">
                <button type="button" class="btn btn-sm btn-dark" id="addRow">
                    <i class="fa fa-plus-circle" aria-hidden="true"></i> Add</button>
            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <hr style="border-top:1px solid #ddd !important">
            </div>
        </div>

        <div class="row">
            <div class="col-md-12 col-12">
                <div class="panel panel-primary">
                    <div class="panel-heading">
                        <h5>Treatment List</h5>
                    </div>
                    <table class="table table-hover display table-striped w-100" id="treatemnts">
                        <thead>
                            <tr>
                                <th>No</th>
                                <th>Primary Diagnosis</th>
                                <th>Treatments</th>
                                <th>Material Type</th>
                                <th>Composit</th>
                                <th class="teethno">Tooth No</th>
                               
                                <th>Discount(QR)</th>
                                <th>Discount(%)</th>
                                <th>Fees</th>
                                <th class="text-center">Actions</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-4">

                <div class="form-group">
                    <label for="lab_test">Post Operative instructions</label>
                    <textarea class="form-control" name="lab_test" id="lab_test" rows="3"></textarea>
                </div>
               
                            
                <div class="form-group">
                    <label for="condition">Treatmen Type</label><br>
                    <div class="followup_div">

                        <label class="radio-inline">
                            <input type="radio" required name="followup" id="followup_0" value="0" class="jq_followup"> New Treatment
                        </label>
                        <br>
                        <label class="radio-inline">
                            <input type="radio" required name="followup" id="followup_1" value="1" class="jq_followup"> FOC
                        </label>
                        <br>
                        <?php if($is_package==1){
                            $desired_module_id=1;
                            include(APPPATH . "views/admin/Modules/packages.php");
                             
                             } ?>
                                

                            
                    </div>
                </div>
                <input name="insurance_current_id" id="insurance_current_id" type="hidden" value="123"> <!-- Replace with actual value -->
                <button type="submit" class="btn btn-sm btn-light" id="private_submit"><i class="fa fa-check-circle" aria-hidden="true"></i> Save</button>
                <button type="reset" class="btn btn-sm btn-light" id="clear"><i class="fa fa-times-circle" aria-hidden="true"></i> Clear</button>
                <button type="button" onclick="window.print()" class="btn btn-sm btn-light" id="clear"><i class="fa fa-print"></i> Print</button>
            </div>
            <div class="col-md-8">
                <div class="form-group">
                    <label for="note">Radiological Request</label>
                    <textarea class="form-control" name="radiological" id="radiological" rows="2"></textarea>
                </div>

                <div class="form-group">
                    <label for="note">Note</label>
                    <textarea class="form-control" name="note" id="note" rows="3"></textarea>
                </div>

            </div>
        </div>
    </form>
</div>

<script>
// Check if the SVG is already stored in localStorage
if (localStorage.getItem('tooth_svg')) {
    // Retrieve from localStorage and insert into the page
    document.getElementById('tooth_svg_container').innerHTML = localStorage.getItem('tooth_svg');
} else {
    // Fetch the SVG content and store it in localStorage
    fetch('<?php echo base_url('admin/Modules/Dental/DentalController/tooth_svg'); ?>')
        .then(response => response.text())
        .then(svgData => {
          
            // Insert the SVG into the page
            // document.getElementById('tooth_svg_container').innerHTML = svgData;
            // Store the SVG in localStorage for future use
            localStorage.setItem('tooth_svg', svgData);
            document.getElementById('tooth_svg_container').innerHTML = localStorage.getItem('tooth_svg');
        })
        .catch(error => console.error('Error fetching SVG:', error));
}
</script>
<script>
    

    if (navigator.cookieEnabled == false) {
		alert('Not work Cookies, please enable cookie');
	}
    $("#color_type").on('change', function(params) {
		var color = $(params.currentTarget.tomselect.activeOption.childNodes[0]).attr('data-color')

		
			var data_color = color;
		     $('.selected_color').val(data_color);
             $('.selected_color_plan').val(data_color);
			var cookie_color = $('.selected_color').val();
            console.log(cookie_color);
           

		
	});
   
    var default_tooth_color = '#ffffffff'
    var selected_tooths = {};
    var counter = 1;

    const tooth_sections = ['O', 'B', 'M', 'D', 'L', 'I', 'F', 'P', 'ROOT', 'SURFACE', 'SURFACE2'];

    function select_tooth(element) {

        let [treatment_color, treatment_name, full_tooth] = $('.selected_color').val().split('|');
        let tooth_id = element.id;
        let tooth_num = tooth_id.split('-')[0];
        full_tooth = parseInt(full_tooth);
        console.log(treatment_color);
        if (full_tooth) {
            for (const tooth_section of tooth_sections) {

                const tooth_section_id = `${tooth_num}-${tooth_section}`;
                const tooth_section_element = document.getElementById(tooth_section_id)

                if (!tooth_section_element) continue;

                tooth_section_element.querySelectorAll('path').forEach(path => path.style.fill = treatment_color);
                selected_tooths[tooth_section_id] = tooth_section_id + "|" + treatment_color + "|" + treatment_name;
            }
        } else {
            element.querySelectorAll('path').forEach(path => path.style.fill = treatment_color);
            selected_tooths[tooth_id] = tooth_id + "|" + treatment_color + "|" + treatment_name;
        }

       
        console.log(selected_tooths, Object.keys(selected_tooths).length);
        draw_list();
    }

    function unselect_tooth(element) {
        let paths = element.querySelectorAll('path');
        paths.forEach(path => {
            path.style.fill = default_tooth_color;
        });

        delete selected_tooths[element.id];

       
        console.log(selected_tooths, Object.keys(selected_tooths).length);
        draw_list();
    }
    var dataTable = $('#treatemnts').DataTable({
            "bFilter": false,
            "paging": false,
            "info": false
        });
    function add_treatment() {

        console.log('Function triggered success..')
        let split_procedure = document.querySelector('select[name=procedure]').value.split(' | ');
        let split_diagnosis = document.querySelector('input[name=multi_diagnosis_free]').value;

        let finalvalue = '';
        let stooth = '';
        let fulltooth = '';

        console.clear();
        console.log(selected_tooths)

        for (let tooth in selected_tooths) {
            console.log(selected_tooths[tooth]);

            stooth = selected_tooths[tooth].split('|');
            finalvalue += stooth[0] + ';';
            fulltooth += selected_tooths[tooth] + ';';
            // Remove tooth hilight color
            let paths = document.getElementById(tooth).querySelectorAll('path');
            paths.forEach(path => {
                path.style.fill = default_tooth_color;
            });
        }

       

        if (split_procedure[1] == undefined) {
            errorNotification('Procedure Required!');
            return;
        }

        let diagnosis = `${split_diagnosis}<input type="hidden" name="treatment_diagnosis[]" value="${split_diagnosis}"><input type="hidden" name="treatment_diagnosis_id[]" value="${split_diagnosis}">`;

        let fprice = Object.keys(selected_tooths).length * split_procedure[3];
       
        dataTable.row.add([
            counter,
            diagnosis,
            split_procedure[2] + '<input type="hidden" name="treat_procedure[]" value="' + split_procedure[0] + '"><input type="hidden" value="" name="treat_extra[]">',
            '<input type="text" size="7" name="treat_type[]" value="" class="treat_type form-control">',
            '<input type="checkbox" name="composit[]" value="composit" />',
            finalvalue + '<input type="hidden" name="treat_teeth[]" value="' + finalvalue + '"><input type="hidden" name="full_teeth[]" value="' + fulltooth + '">',
            '<input type="hidden" class="orgi" name="orig_price[]" value="' + fprice + '"><input type="text" size="7" name="discount[]" value="0" class="form-control discount">',
            '<input type="text" size="7" name="discount_per[]" value="0" class="form-control discount_per">',
            '<input type="text" size="7" value="' + fprice + '" name="treat_fees[]"   class="form-control teeth_price">',
            '<td class="sorting_1"><div class="text-center"><button type="button" class="btn btn-light deleteRow"><i class="fa fa-trash"></i></button></div></td>',
        ]).draw();

        counter++;
        multiDiagnosisSelect.clear();
        initTomSelecs.clear();

        // Clear selected tooth object
        for (let t in selected_tooths) delete selected_tooths[t];
    }

   

    
     
        const add_row_btn = document.getElementById('addRow');

        const context_menu_one = $(document).find('.context-menu-one'); 

            // Loop through the tooth_parts and assign ids based on their 'inkscape:label' attributes
            const tooth_parts = document.getElementsByClassName('tooth-part');
            $(document).on('dblclick', '.context-menu-one', function(e) {
                let cookieData = $('.selected_color').val();
               
                
                if (cookieData == undefined || cookieData == '') {
                    alert("Please select color first.");
                    return;
                } else {
                    select_tooth(this);
                }
            });

            $(document).on('click', '.context-menu-one', function(e) {
                unselect_tooth(this);
            });

      //  add_row_btn.addEventListener('click', add_treatment);
            $(document).on('click','#addRow',function(){
                add_treatment();
            });
   

    function draw_list() {
        var main_content = '';
        var uniqueTitles = {}; 

        for (let drw_tooth in selected_tooths) {
            var title = selected_tooths[drw_tooth].split('|');
            var combination = title[1] + '|' + title[2]; 
            if (!uniqueTitles[combination]) {
                main_content += '<div class="col-md-3 col-3 d-flex">' +
                    '<div class="ui-color-box-large" style="background-color: ' + title[1] + '" ></div>' + title[2] +
                    '</div>';

                uniqueTitles[combination] = true; 
            }
        }

        $('#selected_colors').html(main_content);

    }
</script>