
<div class="row">
    <div class="col-md-12">
        <h4 class="page-header ui-page-header hidden-print">Patient Medical History</h4>
        <form role="form" action="<?= base_url('index.php/admin/Patients/PatientsController/savePatientMedicalBook'); ?>" method="post" enctype="multipart/form-data" id="patient_medical_form">
            <div class="panel panel-default ui-less-border">
                <div class="panel-body">
                    Note: <strong class="text-danger">*</strong><label class="font-weight-bold">All Medical Fields mandatory</label>
                    ملاحظة: <strong class="text-danger">*</strong><label class="font-weight-bold">كل الحقول الزامية</label>

                    <div class="hide_div" style="display: block;">
                        <br><br>
                        <table class="table table-bordered" id="patient-history-tbl">

                            <tbody>
                                <tr>
                                    <td width="50%">
                                        <strong class="text-danger">*</strong><label class="font-weight-bold">Heart Disease: </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="heart_disease_rad" <?= $history->heart_disease_rad == '1' ? 'checked' : null; ?> value="1" class="radio_heart_disease"> Yes
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="heart_disease_rad" <?= $history->heart_disease_rad == '2' ? 'checked' : null; ?> value="2" class="radio_heart_disease"> No
                                        </label>
                                        <input type="text" name="heart_disease" class="hide_input" value="<?= $history->heart_disease ?>">
                                    </td>
                                    <td width="50%" dir="rtl" style="text-align:right">
                                        <strong class="text-danger">*</strong><label class="font-weight-bold">أمراض القلب :</label>
                                        <label class="radio-inline">
                                            <input type="radio" name="heart_disease_rad_ar" <?= $history->heart_disease_rad_ar == '1' ? 'checked' : null; ?> require value="1" class="radio_heart_disease">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; نعم
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="heart_disease_rad_ar" <?= $history->heart_disease_rad_ar == '2' ? 'checked' : null; ?> require value="2" class="radio_heart_disease">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; لا
                                        </label>
                                        <input type="text" name="heart_disease_ar" class="hide_input" value="<?= $history->heart_disease_ar; ?>">
                                    </td>
                                </tr>

                                <tr>
                                    <td>
                                        <strong class="text-danger">*</strong><label class="font-weight-bold">Blood Disease:</label>
                                        <label class="radio-inline">
                                            <input type="radio" name="blood_disease" <?= $history->blood_disease == '1' ? 'checked' : null; ?> value="1" class="radio_blood_disease"> No
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="blood_disease" <?= $history->blood_disease == '2' ? 'checked' : null; ?> value="2" class="radio_blood_disease"> Anemia
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="blood_disease" <?= $history->blood_disease == '3' ? 'checked' : null; ?> value="3" class="radio_blood_disease"> SickleCell Anemia
                                        </label><br>
                                        <label class="font-weight-bold">Others:</label>
                                        <input type="text" name="blood_disease_others" class="form-control" value="<?= $history->blood_disease_others; ?>">
                                    </td>
                                    <td dir="rtl" style="text-align:right">
                                        <strong class="text-danger">*</strong><label class="font-weight-bold">أمراض الدم :</label>
                                        <label class="radio-inline">
                                            <input type="radio" name="blood_disease_ar" <?= $history->blood_disease_ar == '1' ? 'checked' : null; ?> value="1" class="radio_blood_disease">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; لا
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="blood_disease_ar" <?= $history->blood_disease_ar == '2' ? 'checked' : null; ?> value="2" class="radio_blood_disease">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; انيميا
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="blood_disease_ar" <?= $history->blood_disease_ar == '3' ? 'checked' : null; ?> value="3" class="radio_blood_disease">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; انيميا منجلية
                                        </label><br>
                                        <label class="font-weight-bold">أخرى :</label>
                                        <input type="text" name="blood_disease_others_ar" class="form-control" value="<?= $history->blood_disease_others_ar; ?>">
                                    </td>
                                </tr>

                                <tr>
                                    <td>
                                        <strong class="text-danger">*</strong><label class="font-weight-bold">Blood Pressure:</label>
                                        <label class="radio-inline">
                                            <input type="radio" name="blood_pressure" <?= $history->blood_pressure == '1' ? 'checked' : null; ?> value="1" class="radio_blood_pressure"> No.
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="blood_pressure" <?= $history->blood_pressure == '2' ? 'checked' : null; ?> value="2" class="radio_blood_pressure"> Hyper.
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="blood_pressure" <?= $history->blood_pressure == '3' ? 'checked' : null; ?> value="3" class="radio_blood_pressure"> Hypo.
                                        </label>
                                    </td>
                                    <td dir="rtl" style="text-align:right">
                                        <strong class="text-danger">*</strong><label class="font-weight-bold">ضغط الدم :</label>
                                        <label class="radio-inline">
                                            <input type="radio" name="blood_pressure_ar" <?= $history->blood_pressure_ar == '1' ? 'checked' : null; ?> value="1" class="radio_blood_pressure">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; لا
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="blood_pressure_ar" <?= $history->blood_pressure_ar == '2' ? 'checked' : null; ?> value="2" class="radio_blood_pressure">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; ارتفاع
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="blood_pressure_ar" <?= $history->blood_pressure_ar == '3' ? 'checked' : null; ?> value="3" class="radio_blood_pressure">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; انخفاض
                                        </label>
                                    </td>
                                </tr>

                                <tr>
                                    <td>
                                        <strong class="text-danger">*</strong><label class="font-weight-bold">Blood Sugar (Diabetes):</label>
                                        <label class="radio-inline">
                                            <input type="radio" name="blood_sugar" <?= $history->blood_sugar == '1' ? 'checked' : null; ?> value="1" class="radio_blood_sugar"> No
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="blood_sugar" <?= $history->blood_sugar == '2' ? 'checked' : null; ?> value="2" class="radio_blood_sugar"> Hyper.
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="blood_sugar" <?= $history->blood_sugar == '3' ? 'checked' : null; ?> value="3" class="radio_blood_sugar"> Hypo.
                                        </label>
                                    </td>
                                    <td dir="rtl" style="text-align:right">
                                        <strong class="text-danger">*</strong><label class="font-weight-bold">سكري الدم :</label>
                                        <label class="radio-inline">
                                            <input type="radio" name="blood_sugar_ar" <?= $history->blood_sugar_ar == '1' ? 'checked' : null; ?> value="1" class="radio_blood_sugar">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; لا
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="blood_sugar_ar" <?= $history->blood_sugar_ar == '2' ? 'checked' : null; ?> value="2" class="radio_blood_sugar">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; ارتفاع
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="blood_sugar_ar" <?= $history->blood_sugar_ar == '3' ? 'checked' : null; ?> value="3" class="radio_blood_sugar">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; انخفاض
                                        </label>
                                    </td>
                                </tr>

                                <tr>
                                    <td>
                                        <strong class="text-danger">*</strong><label class="font-weight-bold">Respiratory System (Chest):</label>
                                        <label class="radio-inline">
                                            <input type="radio" name="respiratory_system" <?= $history->respiratory_system == '1' ? 'checked' : null; ?> value="1" class="radio_respiratory_system"> No
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="respiratory_system" <?= $history->respiratory_system == '2' ? 'checked' : null; ?> value="2" class="radio_respiratory_system"> Asthma
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="respiratory_system" <?= $history->respiratory_system == '3' ? 'checked' : null; ?> value="3" class="radio_respiratory_system"> TB
                                        </label><br>
                                        <label class="font-weight-bold">Others:</label>
                                        <input type="text" name="respiratory_system_others" class="form-control" value="<?= $history->respiratory_system_others ?>">
                                    </td>
                                    <td dir="rtl" style="text-align:right">
                                        <strong class="text-danger">*</strong><label class="font-weight-bold">الجهاز التنفسي :</label>
                                        <label class="radio-inline">
                                            <input type="radio" name="respiratory_system_ar" <?= $history->respiratory_system_ar == '1' ?: null; ?> value="1" class="radio_respiratory_system">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; لا
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="respiratory_system_ar" <?= $history->respiratory_system_ar == '2' ?: null; ?> value="2" class="radio_respiratory_system">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; ربو
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="respiratory_system_ar" <?= $history->respiratory_system_ar == '3' ?: null; ?> value="3" class="radio_respiratory_system">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; سل
                                        </label><br>
                                        <label class="font-weight-bold">أخرى :</label>
                                        <input type="text" name="respiratory_system_others_ar" class="form-control" value="<?= $history->respiratory_system_others_ar; ?>">
                                    </td>
                                </tr>

                                <tr>
                                    <td>
                                        <strong class="text-danger">*</strong><label class="font-weight-bold">Digestive System:</label>
                                        <label class="radio-inline">
                                            <input type="radio" name="digestive_system" <?= $history->digestive_system == '1' ? 'checked' : null; ?> value="1" class="radio_digestive_system"> No
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="digestive_system" <?= $history->digestive_system == '2' ? 'checked' : null; ?> value="2" class="radio_digestive_system"> Ulcer
                                        </label>
                                        <label class="font-weight-bold">Others:</label>
                                        <input type="text" name="digestive_system_others" class="form-control" value="<?= $history->digestive_system_others; ?>">
                                    </td>
                                    <td dir="rtl" style="text-align:right">
                                        <strong class="text-danger">*</strong><label class="font-weight-bold">الجهاز الهضمي :</label>
                                        <label class="radio-inline">
                                            <input type="radio" name="digestive_system_ar" <?= $history->digestive_system_ar == '1' ? 'checked' : null; ?> value="1" class="radio_digestive_system">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; لا
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="digestive_system_ar" <?= $history->digestive_system_ar == '2' ? 'checked' : null; ?> value="2" class="radio_digestive_system">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; قرحة
                                        </label>
                                        <label class="font-weight-bold">أخرى :</label>
                                        <input type="text" name="digestive_system_others_ar" class="form-control" value="<?= $history->digestive_system_others_ar; ?>">
                                    </td>
                                </tr>

                                <tr>
                                    <td>
                                        <strong class="text-danger">*</strong><label class="font-weight-bold">Liver Diseases:</label>
                                        <label class="radio-inline">
                                            <input type="radio" name="liver_disease" <?= $history->liver_disease == '1' ? 'checked' : null; ?> value="1" class="radio_liver_disease"> No
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="liver_disease" <?= $history->liver_disease == '2' ? 'checked' : null; ?> value="2" class="radio_liver_disease"> Hepatitis
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="liver_disease" <?= $history->liver_disease == '3' ? 'checked' : null; ?> value="3" class="radio_liver_disease"> G6PD
                                        </label><br>
                                        <label class="font-weight-bold">Others:</label>
                                        <input type="text" name="liver_disease_others" class="form-control" value="<?= $history->liver_disease_others; ?>">
                                    </td>
                                    <td dir="rtl" style="text-align:right">
                                        <strong class="text-danger">*</strong><label class="font-weight-bold">أمراض الكبد :</label>
                                        <label class="radio-inline">
                                            <input type="radio" name="liver_disease_ar" <?= $history->liver_disease_ar == '1' ? 'checked' : null; ?> value="1" class="radio_liver_disease">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; لا
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="liver_disease_ar" <?= $history->liver_disease_ar == '2' ? 'checked' : null; ?> value="2" class="radio_liver_disease">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; التهاب الكبد الوبائي
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="liver_disease_ar" <?= $history->liver_disease_ar == '3' ? 'checked' : null; ?> value="3" class="radio_liver_disease">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; يرقان
                                        </label><br>
                                        <label class="font-weight-bold">أخرى :</label>
                                        <input type="text" name="liver_disease_others_ar" class="form-control" value="<?= $history->liver_disease_others_ar; ?>">
                                    </td>
                                </tr>

                                <tr>
                                    <td>
                                        <strong class="text-danger">*</strong><label class="font-weight-bold">Joint Diseases:</label>
                                        <label class="radio-inline">
                                            <input type="radio" name="joint_disease_rad" <?= $history->joint_disease_rad == '1' ? 'checked' : null; ?> value="1" class="radio_joint_disease"> Yes
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="joint_disease_rad" <?= $history->joint_disease_rad == '2' ? 'checked' : null; ?> value="2" class="radio_joint_disease"> No
                                        </label>
                                        <input type="text" name="joint_disease" class="hide_input" value="<?= $history->joint_disease; ?>">
                                    </td>
                                    <td dir="rtl" style="text-align:right">
                                        <strong class="text-danger">*</strong><label class="font-weight-bold">أمراض المفاصل :</label>
                                        <label class="radio-inline">
                                            <input type="radio" name="joint_disease_rad_ar" <?= $history->joint_disease_rad_ar == '1' ? 'checked' : null; ?> value="1" class="radio_joint_disease">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; نعم
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="joint_disease_rad_ar" <?= $history->joint_disease_rad_ar == '2' ? 'checked' : null; ?> value="2" class="radio_joint_disease">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; لا
                                        </label>
                                        <input type="text" name="joint_disease_ar" class="hide_input" value="<?= $history->joint_disease_ar; ?>">
                                    </td>
                                </tr>

                                <tr>
                                    <td>
                                        <strong class="text-danger">*</strong><label class="font-weight-bold">Hereditary Defects:</label>
                                        <label class="radio-inline">
                                            <input type="radio" name="hereditary_defects_rad" <?= $history->hereditary_defects_rad == '1' ? 'checked' : null ?> value="1" class="radio_heredity_defects"> Yes
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="hereditary_defects_rad" <?= $history->hereditary_defects_rad == '2' ? 'checked' : null ?> value="2" class="radio_heredity_defects"> No
                                        </label>
                                        <input type="text" name="hereditary_defects" class="hide_input" value="<?= $history->hereditary_defects; ?>">
                                    </td>
                                    <td dir="rtl" style="text-align:right">
                                        <strong class="text-danger">*</strong><label class="font-weight-bold">أمراض أو خلل وراثي :</label>
                                        <label class="radio-inline">
                                            <input type="radio" name="hereditary_defects_rad_ar" <?= $history->hereditary_defects_rad_ar == '1' ? 'checked' : null ?> value="1" class="radio_heredity_defects">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; نعم
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="hereditary_defects_rad_ar" <?= $history->hereditary_defects_rad_ar == '2' ? 'checked' : null ?> value="2" class="radio_heredity_defects">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; لا
                                        </label>
                                        <input type="text" name="hereditary_defects_ar" class="hide_input" value="<?= $history->hereditary_defects_ar; ?>">
                                    </td>
                                </tr>

                                <tr>
                                    <td>
                                        <strong class="text-danger">*</strong><label class="font-weight-bold">Congenital Defects</label><br><label class="font-weight-bold">/Abnormalities or Diseases:</label><br>
                                        <label class="radio-inline">
                                            <input type="radio" name="congenital_defects_rad" <?= $history->congenital_defects_rad == '1' ? 'checked' : null; ?> value="1" class="radio_congenital_defects"> Yes
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="congenital_defects_rad" <?= $history->congenital_defects_rad == '2' ? 'checked' : null; ?> value="2" class="radio_congenital_defects"> No
                                        </label>
                                        <input type="text" name="congenital_defects" class="hide_input" value="<?= $history->congenital_defects; ?>">
                                    </td>
                                    <td dir="rtl" style="text-align:right">
                                        <strong class="text-danger">*</strong><label class="font-weight-bold">أمراض أو خلل خلقي :</label>
                                        <label class="radio-inline">
                                            <input type="radio" name="congenital_defects_rad_ar" <?= $history->congenital_defects_rad_ar == '1' ? 'checked' : null; ?> value="1" class="radio_congenital_defects">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; نعم
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="congenital_defects_rad_ar" <?= $history->congenital_defects_rad_ar == '2' ? 'checked' : null; ?> value="2" class="radio_congenital_defects">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; لا
                                        </label>
                                        <input type="text" name="congenital_defects_ar" class="hide_input" value="<?= $history->congenital_defects_ar; ?>">
                                    </td>
                                </tr>

                                <tr>
                                    <td>
                                        <strong class="text-danger">*</strong><label class="font-weight-bold">Epilepsy:</label>
                                        <label class="radio-inline">
                                            <input type="radio" name="epilepsy_rad" <?= $history->epilepsy_rad == '1' ? 'checked' : null; ?> value="1" class="radio_epilepsy"> Yes
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="epilepsy_rad" <?= $history->epilepsy_rad == '2' ? 'checked' : null; ?> value="2" class="radio_epilepsy"> No
                                        </label>
                                        <input type="text" name="epilepsy" class="hide_input" value="<?= $history->epilepsy; ?>">
                                    </td>
                                    <td dir="rtl" style="text-align:right">
                                        <strong class="text-danger">*</strong><label class="font-weight-bold">صرع :</label>
                                        <label class="radio-inline">
                                            <input type="radio" name="epilepsy_rad_ar" <?= $history->epilepsy_rad_ar == '1' ? 'checked' : null; ?> value="1" class="radio_epilepsy">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; نعم
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="epilepsy_rad_ar" <?= $history->epilepsy_rad_ar == '2' ? 'checked' : null; ?> value="2" class="radio_epilepsy">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; لا
                                        </label>
                                        <input type="text" name="epilepsy_ar" class="hide_input" value="<?= $history->epilepsy_ar; ?>">
                                    </td>
                                </tr>

                                <tr>
                                    <td>
                                        <strong class="text-danger">*</strong><label class="font-weight-bold">Infectious Diseases:</label>
                                        <label class="radio-inline">
                                            <input type="radio" name="infectious_rad" <?= $history->infectious_rad == '1' ? 'checked' : null; ?> value="1" class="radio_infectious"> Yes
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="infectious_rad" <?= $history->infectious_rad == '2' ? 'checked' : null; ?> value="2" class="radio_infectious"> No
                                        </label>
                                        <input type="text" name="infectious" class="hide_input" value="<?= $history->infectious; ?>">
                                    </td>
                                    <td dir="rtl" style="text-align:right">
                                        <strong class="text-danger">*</strong><label class="font-weight-bold">أمراض معدية :</label>
                                        <label class="radio-inline">
                                            <input type="radio" name="infectious_rad_ar" <?= $history->infectious_rad_ar == '1' ? 'checked' : null; ?> value="1" class="radio_infectious">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; نعم
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="infectious_rad_ar" <?= $history->infectious_rad_ar == '2' ? 'checked' : null; ?> value="2" class="radio_infectious">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; لا
                                        </label>
                                        <input type="text" name="infectious_ar" class="hide_input" value="<?= $history->infectious_ar; ?>">
                                    </td>
                                </tr>

                                <tr>
                                    <td>
                                        <strong class="text-danger">*</strong><label class="font-weight-bold">AIDS:</label>
                                        <label class="radio-inline">
                                            <input type="radio" name="aids_rad" <?= $history->aids_rad == '1' ? 'checked' : null; ?> value="1" class="radio_aids"> Yes
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="aids_rad" <?= $history->aids_rad == '2' ? 'checked' : null; ?> value="2" class="radio_aids"> No
                                        </label>
                                        <input type="text" name="aids" class="hide_input" value="<?= $history->aids; ?>">
                                    </td>
                                    <td dir="rtl" style="text-align:right">
                                        <strong class="text-danger">*</strong>
                                        <label class="font-weight-bold">نقصان المناعة المكتسبة (الأيدز):</label>
                                        <label class="radio-inline">
                                            <input type="radio" name="aids_rad_ar" <?= $history->aids_rad_ar == '1' ? 'checked' : null; ?> value="1" class="radio_aids">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; نعم
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="aids_rad_ar" <?= $history->aids_rad_ar == '2' ? 'checked' : null; ?> value="2" class="radio_aids">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; لا
                                        </label>
                                        <input type="text" name="aids_ar" class="hide_input" value="<?= $history->aids_ar; ?>">
                                    </td>
                                </tr>

                                <tr>
                                    <td>
                                        <strong class="text-danger">*</strong><label class="font-weight-bold">Endocrine System:</label>
                                        <label class="radio-inline">
                                            <input type="radio" name="endocrine_system_rad" <?= $history->endocrine_system_rad == '1' ? 'checked' : null; ?> value="1" class="radio_endocrine_system"> Yes
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="endocrine_system_rad" <?= $history->endocrine_system_rad == '2' ? 'checked' : null; ?> value="2" class="radio_endocrine_system"> No
                                        </label>
                                        <input type="text" name="endocrine_system" class="hide_input" value="<?= $history->endocrine_system; ?>">
                                    </td>
                                    <td dir="rtl" style="text-align:right">
                                        <strong class="text-danger">*</strong><label class="font-weight-bold">الغدد الصماء :</label>
                                        <label class="radio-inline">
                                            <input type="radio" name="endocrine_system_rad_ar" <?= $history->endocrine_system_rad_ar == '1' ? 'checked' : null; ?> value="1" class="radio_endocrine_system">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; نعم
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="endocrine_system_rad_ar" <?= $history->endocrine_system_rad_ar == '2' ? 'checked' : null; ?> value="2" class="radio_endocrine_system">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; لا
                                        </label>
                                        <input type="text" name="endocrine_system_ar" class="hide_input" value="<?= $history->endocrine_system_ar; ?>">
                                    </td>
                                </tr>

                                <tr>
                                    <td>
                                        <strong class="text-danger">*</strong><label class="font-weight-bold">Drug Allergy:</label>
                                        <label class="radio-inline">
                                            <input type="radio" name="drug_allergy_rad" <?= $history->drug_allergy_rad == '1' ? 'checked' : null; ?> value="1" class="radio_drug_allergy"> Yes
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="drug_allergy_rad" <?= $history->drug_allergy_rad == '2' ? 'checked' : null; ?> value="2" class="radio_drug_allergy"> No
                                        </label>
                                        <input type="text" name="drug_allergy" class="hide_input" value="<?= $history->drug_allergy; ?>">
                                    </td>
                                    <td dir="rtl" style="text-align:right">
                                        <strong class="text-danger">*</strong><label class="font-weight-bold">حساسية من بعض الأدوية :</label>
                                        <label class="radio-inline">
                                            <input type="radio" name="drug_allergy_rad_ar" <?= $history->drug_allergy_rad_ar == '1' ? 'checked' : null; ?> value="1" class="radio_drug_allergy">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; نعم
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="drug_allergy_rad_ar" <?= $history->drug_allergy_rad_ar == '2' ? 'checked' : null; ?> value="2" class="radio_drug_allergy">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; لا
                                        </label>
                                        <input type="text" name="drug_allergy_ar" class="hide_input" value="<?= $history->drug_allergy_ar; ?>">
                                    </td>
                                </tr>

                                <tr>
                                    <td>
                                        <strong class="text-danger">*</strong><label class="font-weight-bold">Previous Operations:</label>
                                        <label class="radio-inline">
                                            <input type="radio" name="previous_operation_rad" <?= $history->previous_operation_rad == '1' ? 'checked' : null; ?> value="1" class="radio_previous_operation"> Yes
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="previous_operation_rad" <?= $history->previous_operation_rad == '2' ? 'checked' : null; ?> value="2" class="radio_previous_operation"> No
                                        </label>
                                        <input type="text" name="previous_operation" class="hide_input" value="<?= $history->previous_operation; ?>">
                                    </td>
                                    <td dir="rtl" style="text-align:right">
                                        <strong class="text-danger">*</strong><label class="font-weight-bold">عمليات جراحية سابقة :</label>
                                        <label class="radio-inline">
                                            <input type="radio" name="previous_operation_rad_ar" <?= $history->previous_operation_rad_ar == '1' ? 'checked' : null; ?> value="1" class="radio_previous_operation">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; نعم
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="previous_operation_rad_ar" <?= $history->previous_operation_rad_ar == '2' ? 'checked' : null; ?> value="2" class="radio_previous_operation">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; لا
                                        </label>
                                        <input type="text" name="previous_operation_ar" class="hide_input" value="<?= $history->previous_operation_ar; ?>">
                                    </td>
                                </tr>

                                <tr>
                                    <td>
                                        <strong class="text-danger">*</strong><label class="font-weight-bold">Current Medications:</label>
                                        <label class="radio-inline">
                                            <input type="radio" name="current_medication_rad" <?= $history->current_medication_rad == '1' ? 'checked' : null; ?> value="1" class="radio_current_medication"> Yes
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="current_medication_rad" <?= $history->current_medication_rad == '2' ? 'checked' : null; ?> value="2" class="radio_current_medication"> No
                                        </label>
                                        <input type="text" name="current_medication" class="hide_input" value="<?= $history->current_medication; ?>">
                                    </td>
                                    <td dir="rtl" style="text-align:right">
                                        <strong class="text-danger">*</strong><label class="font-weight-bold">علاجات حالية :</label>
                                        <label class="radio-inline">
                                            <input type="radio" name="current_medication_rad_ar" <?= $history->current_medication_rad_ar == '1' ? 'checked' : null; ?> value="1" class="radio_current_medication">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; نعم
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="current_medication_rad_ar" <?= $history->current_medication_rad_ar == '2' ? 'checked' : null; ?> value="2" class="radio_current_medication">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; لا
                                        </label>
                                        <input type="text" name="current_medication_ar" class="hide_input" value="<?= $history->current_medication_ar; ?>">
                                    </td>
                                </tr>

                                <tr>
                                    <td>
                                        <strong class="text-danger">*</strong><label class="font-weight-bold">Smoking:</label>
                                        <label class="radio-inline">
                                            <input type="radio" name="smoking_rad" <?= $history->smoking_rad == '1' ? 'checked' : null; ?> value="1" class="radio_smoking"> Yes
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="smoking_rad" <?= $history->smoking_rad == '2' ? 'checked' : null; ?> value="2" class="radio_smoking"> No
                                        </label>
                                        <input type="text" name="smoking" class="hide_input" value="<?= $history->smoking; ?>">
                                    </td>
                                    <td dir="rtl" style="text-align:right">
                                        <strong class="text-danger">*</strong><label class="font-weight-bold">التدخين :</label>
                                        <label class="radio-inline">
                                            <input type="radio" name="smoking_rad_ar" <?= $history->smoking_rad_ar == '1' ? 'checked' : null; ?> value="1" class="radio_smoking">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; نعم
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="smoking_rad_ar" <?= $history->smoking_rad_ar == '2' ? 'checked' : null; ?> value="2" class="radio_smoking">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; لا
                                        </label>
                                        <input type="text" name="smoking_ar" class="hide_input" value="<?= $history->smoking_ar; ?>">
                                    </td>
                                </tr>

                                <tr>
                                    <td>
                                        <strong class="text-danger">*</strong><label class="font-weight-bold">Have you ever stayed in hospital:</label>
                                        <label class="radio-inline">
                                            <input type="radio" name="stayed_hospital" <?= $history->stayed_hospital == '1' ? 'checked' : null; ?> value="1" class="radio_stayed_hospital"> Yes
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="stayed_hospital" <?= $history->stayed_hospital == '2' ? 'checked' : null; ?> value="2" class="radio_stayed_hospital"> No
                                        </label><br>
                                        <label class="font-weight-bold">If Yes, Specify:</label>
                                        <input type="text" name="stayed_hospital_specify" class="form-control" value="<?= $history->stayed_hospital_specify; ?>">
                                    </td>
                                    <td dir="rtl" style="text-align:right">
                                        <strong class="text-danger">*</strong><label class="font-weight-bold">هل سبق ونمت بالمستشفى :</label>
                                        <label class="radio-inline">
                                            <input type="radio" name="stayed_hospital_ar" <?= $history->stayed_hospital_ar == '1' ? 'checked' : null; ?> value="1" class="radio_stayed_hospital">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; نعم
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="stayed_hospital_ar" <?= $history->stayed_hospital_ar == '2' ? 'checked' : null; ?> value="2" class="radio_stayed_hospital">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; لا
                                        </label><br>
                                        <label class="font-weight-bold">إذا كانت الإجابة نعم أذكر السبب :</label>
                                        <input type="text" name="stayed_hospital_specify_ar" class="form-control" value="<?= $history->stayed_hospital_specify_ar; ?>">
                                    </td>
                                </tr>

                                <tr>
                                    <td>
                                        <label class="font-weight-bold">For Women only:</label>
                                        <label class="radio-inline">
                                            <input type="radio" name="for_women" <?= $history->for_women == '2' ? 'checked' : null; ?> value="2" class="radio_women"> Pregnant
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="for_women" <?= $history->for_women == '3' ? 'checked' : null; ?> value="3" class="radio_women"> Lactating
                                        </label><br>
                                        <label class="font-weight-bold">Previous Miscarriage</label>
                                        <label class="radio-inline">
                                            <input type="radio" name="previous_miscarriage_rad" <?= $history->previous_miscarriage_rad == '1' ? 'checked' : null; ?> value="1"> Yes
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="previous_miscarriage_rad" <?= $history->previous_miscarriage_rad == '2' ? 'checked' : null; ?> value="2"> No
                                        </label>
                                        <input type="text" name="previous_miscarriage" class="hide_input" value="<?= $history->previous_miscarriage; ?>"><br>
                                        <label class="font-weight-bold">Are you planing an getting pregnant soon?</label>
                                        <label class="radio-inline">
                                            <input type="radio" name="pregnant" <?= $history->pregnant == '1' ? 'checked' : null; ?> value="1"> Yes
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="pregnant" <?= $history->pregnant == '2' ? 'checked' : null; ?> value="2"> No
                                        </label>
                                    </td>
                                    <td dir="rtl" style="text-align:right">
                                        <label class="font-weight-bold">للنساء فقط :</label>

                                        <label class="radio-inline">
                                            <input type="radio" name="for_women_ar" <?= $history->for_women_ar == '2' ? 'checked' : null; ?> value="2" class="radio_women">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; حمل
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="for_women_ar" <?= $history->for_women_ar == '3' ? 'checked' : null; ?> value="3" class="radio_women">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; إرضاع
                                        </label><br>
                                        <label class="font-weight-bold">إجهاضات سابقة</label>
                                        <label class="radio-inline">
                                            <input type="radio" name="previous_miscarriage_rad_ar" <?= $history->previous_miscarriage_rad_ar == '1' ? 'checked' : null; ?> value="1">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; نعم
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="previous_miscarriage_rad_ar" <?= $history->previous_miscarriage_rad_ar == '2' ? 'checked' : null; ?> value="2">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; لا
                                        </label>
                                        <input type="text" name="previous_miscarriage_ar" class="hide_input" value="<?= $history->previous_miscarriage_ar; ?>"><br>
                                        <label class="font-weight-bold"> هل تخططين للحمل في الوقت الحاضر؟ </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="pregnant_ar" <?= $history->pregnant_ar == '1' ? 'checked' : null; ?> value="1">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; نعم
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="pregnant_ar" <?= $history->pregnant_ar == '2' ? 'checked' : null; ?> value="2">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; لا
                                        </label>
                                    </td>
                                </tr>


                            </tbody>
                        </table>
    <br>
                        <div class="row mt-2 mb-2">
                            <div class="col-sm-12 col-md-3 mx-auto">
                                <div class="signArea">
                                    <span><strong>Patient Signature</strong></span>
                                    <div class="sig sigWrapper current" style="height: auto; display: block;">
                                        <div class="typed"></div>
                                        <canvas class="sign-pad" id="sign-pad" width="300" height="100"></canvas>
                                    </div>
                                    <input type="hidden" name="patient_signature" id="signature_img" class="signature_img" value="">
                                    <button type="button" id="reset_signature" class="btn btn-sm btn-light mt-1 reset_signature"><i class="fa fa-refresh "></i> Reset signature</button>
                                </div>
                              
                                <?php
                                        // Assuming $history->patient_signature contains the BLOB data from the database
                                        if ($history->patient_signature) {
                                            // Assuming the image is a PNG (adjust the MIME type as necessary, e.g., image/jpeg for JPEG images)
                                            $imageType = 'image/png'; // Change this if it's a different format like 'image/jpeg'
                                            echo '<img src="data:' . $imageType . ';base64,' . $history->patient_signature . '" alt="Patient Signature">';
                                        } else {
                                            echo 'No signature available';
                                        }
                                ?>
                                <input type="hidden" id="old_signature" name="old_signature" value="<?= $history->patient_signature ?>">
                               
                              
                            </div>
                        </div>

                        
                        <!-- <div class="checkbox no-print">
                            <label class="font-weight-bold">
                                <input type="checkbox" value="1" name="waiting_alert"> Send Waiting Alert
                            </label>
                        </div> -->

                        <button type="button" class="btn btn-sm btn-light" id="save_medical"><i class="fa fa-check-circle" aria-hidden="true"></i> Save</button>
                        <!-- <input type="hidden" name="patient_signature" id="patient_signature"> -->
                        <input type="hidden" name="patient_id" id="patient_id" value="<?= encrypt_and_url_encode($patient_id, $this); ?>">

                    </div>

                </div>
            </div>
        </form>
    </div>
</div>

<script>
     $('.signArea').signaturePad({
      drawOnly: true,
      drawBezierCurves: true,
      lineTop: 90
    });

    $(".reset_signature").click(function(e) {
      $(this).parent().signaturePad().clearCanvas();
      $(this).parent().find('.img_val').val('')
    });
    
     

    var toastMixin = Swal.mixin({
        toast: true,
        icon: 'success',
        title: 'General Title',
        animation: false,
        position: 'top-right',
        showConfirmButton: false,
        timer: 3000,
        timerProgressBar: true,
        didOpen: (toast) => {
            toast.addEventListener('mouseenter', Swal.stopTimer)
            toast.addEventListener('mouseleave', Swal.resumeTimer)
        }
    });

    $(document).ready(function() {


        $('.hide_input').hide();

        $('input[name=aids_rad]').on('change click', function() {
            if (this.value == 1) {
                $('input[name=aids]').show();
            } else {
                $('input[name=aids]').hide();
            }
        });

        $('input[name=endocrine_system_rad]').on('change click', function() {
            if (this.value == 1) {
                $('input[name=endocrine_system]').show();
            } else {
                $('input[name=endocrine_system]').hide();
            }
        });

        $('input[name=drug_allergy_rad]').on('change click', function() {
            if (this.value == 1) {
                $('input[name=drug_allergy]').show();
            } else {
                $('input[name=drug_allergy]').hide();
            }
        });

        $('input[name=previous_operation_rad]').on('change click', function() {
            if (this.value == 1) {
                $('input[name=previous_operation]').show();
            } else {
                $('input[name=previous_operation]').hide();
            }
        });

        $('input[name=current_medication_rad]').on('change click', function() {
            if (this.value == 1) {
                $('input[name=current_medication]').show();
            } else {
                $('input[name=current_medication]').hide();
            }
        });

        // $('input[name=smoking_rad]').on('change click', function () {
        //   if(this.value==1){
        //     $('input[name=smoking]').show();
        //   }else{
        //     $('input[name=smoking]').hide();
        //   }
        // });

        $('input[name=joint_disease_rad]').on('change click', function() {
            if (this.value == 1) {
                $('input[name=joint_disease]').show();
            } else {
                $('input[name=joint_disease]').hide();
            }
        });

        $('input[name=hereditary_defects_rad]').on('change click', function() {
            if (this.value == 1) {
                $('input[name=hereditary_defects]').show();
            } else {
                $('input[name=hereditary_defects]').hide();
            }
        });

        $('input[name=congenital_defects_rad]').on('change click', function() {
            if (this.value == 1) {
                $('input[name=congenital_defects]').show();
            } else {
                $('input[name=congenital_defects]').hide();
            }
        });

        // $('input[name=epilepsy_rad]').on('change click', function () {
        //   if(this.value==1){
        //     $('input[name=epilepsy]').show();
        //   }else{
        //     $('input[name=epilepsy]').hide();
        //   }
        // });

        $('input[name=infectious_rad]').on('change click', function() {
            if (this.value == 1) {
                $('input[name=infectious]').show();
            } else {
                $('input[name=infectious]').hide();
            }
        });

        $('input[name=heart_disease_rad]').on('change click', function() {
            if (this.value == 1) {
                $('input[name=heart_disease]').show();
            } else {
                $('input[name=heart_disease]').hide();
            }
        });

        $('input[name=aids_rad_ar]').on('change click', function() {
            if (this.value == 1) {
                $('input[name=aids_ar]').show();
            } else {
                $('input[name=aids_ar]').hide();
            }
        });

        $('input[name=endocrine_system_rad_ar]').on('change click', function() {
            if (this.value == 1) {
                $('input[name=endocrine_system_ar]').show();
            } else {
                $('input[name=endocrine_system_ar]').hide();
            }
        });

        $('input[name=drug_allergy_rad_ar]').on('change click', function() {
            if (this.value == 1) {
                $('input[name=drug_allergy_ar]').show();
            } else {
                $('input[name=drug_allergy_ar]').hide();
            }
        });

        $('input[name=previous_operation_rad_ar]').on('change click', function() {
            if (this.value == 1) {
                $('input[name=previous_operation_ar]').show();
            } else {
                $('input[name=previous_operation_ar]').hide();
            }
        });

        $('input[name=current_medication_rad_ar]').on('change click', function() {
            if (this.value == 1) {
                $('input[name=current_medication_ar]').show();
            } else {
                $('input[name=current_medication_ar]').hide();
            }
        });

        // $('input[name=smoking_rad_ar]').on('change click', function () {
        //   if(this.value==1){
        //     $('input[name=smoking_ar]').show();
        //   }else{
        //     $('input[name=smoking_ar]').hide();
        //   }
        // });

        $('input[name=joint_disease_rad_ar]').on('change click', function() {
            if (this.value == 1) {
                $('input[name=joint_disease_ar]').show();
            } else {
                $('input[name=joint_disease_ar]').hide();
            }
        });

        $('input[name=hereditary_defects_rad_ar]').on('change click', function() {
            if (this.value == 1) {
                $('input[name=hereditary_defects_ar]').show();
            } else {
                $('input[name=hereditary_defects_ar]').hide();
            }
        });

        $('input[name=congenital_defects_rad_ar]').on('change click', function() {
            if (this.value == 1) {
                $('input[name=congenital_defects_ar]').show();
            } else {
                $('input[name=congenital_defects_ar]').hide();
            }
        });

        // $('input[name=epilepsy_rad_ar]').on('change click', function () {
        //   if(this.value==1){
        //     $('input[name=epilepsy_ar]').show();
        //   }else{
        //     $('input[name=epilepsy_ar]').hide();
        //   }
        // });

        $('input[name=infectious_rad_ar]').on('change click', function() {
            if (this.value == 1) {
                $('input[name=infectious_ar]').show();
            } else {
                $('input[name=infectious_ar]').hide();
            }
        });

        $('input[name=heart_disease_rad_ar]').on('change click', function() {
            if (this.value == 1) {
                $('input[name=heart_disease_ar]').show();
            } else {
                $('input[name=heart_disease_ar]').hide();
            }
        });

        $('input[name=previous_miscarriage_rad]').on('change click', function() {
            if (this.value == 1) {
                $('input[name=previous_miscarriage]').show();
            } else {
                $('input[name=previous_miscarriage]').hide();
            }
        });

        $('input[name=previous_miscarriage_rad_ar]').on('change click', function() {
            if (this.value == 1) {
                $('input[name=previous_miscarriage_ar]').show();
            } else {
                $('input[name=previous_miscarriage_ar]').hide();
            }
        });

    });

    $("#save_medical").click(function(e) {
        var sign_pads = $('.sign-pad');
     
        html2canvas(sign_pads, {
          onrendered: function(canvas) {
            var canvas_img_data = canvas.toDataURL('image/png');
            var img_data = canvas_img_data.replace(/^data:image\/(png|jpg);base64,/, "");
            $('.signature_img').val(img_data);
            var img_val= $('.signature_img').val();
            var old_img= $('#old_signature').val();
            if(img_val=='' && old_img == ''){
            errorNotification('Patient Signature is required')
            }else{
            $("#save_medical").closest('form').submit();
            }
          }
          
        });
        
      
        //
    });

    $(function (){
        const list = $('#history-list');
        let tds = $('#patient-history-tbl td');
        tds = Array.from(tds);
        
        for(td of tds) {
            const label = $($(td).find('label')[0]).text()
            const value = $($(td).find('input:checked').parent()).text();
            const other = $($(td).find('input:text')).val();
            
            if(value.trim() == '') continue;
            list.append(`<li class="bg-light pt-1 pb-1 mb-1"><strong>${label}</strong> ${value.trim()} ${other ? `(${other})` : ''}</li>`);
            $('#show-alert').css({'display':'block'});
        }
    });
</script>