<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <title>Patient</title>
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
	<script src="<?php echo base_url('js/Marker2.js') ?>"></script>
    <?php require_once(APPPATH . "views/admin/header.php"); ?>
    <script>
          let sourceImage, targetRoot,targetFace,targetFaceFiller,targetBody, maState,faceState,fillerState,bodyState;

// save references to the original image and its parent div (positioning root)
function setSourceImage(source) {
  sourceImage = source;
  targetRoot = source.parentElement;
}
    </script>
</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
    <!-- Site wrapper -->

    <!-- Header Navbar: style can be found in header.less -->
    <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

    <!-- =============================================== -->

    <!-- Left side column. contains the sidebar -->
    <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

    <!-- =============================================== -->

    <!-- Right side column. Contains the navbar and content of the page -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1>
                &nbsp;Edit Plastic Surgery Treatment
            </h1>
            <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
        </section>

        <!-- Main content -->
        <section class="content">

            <div class="row mb-2">
                <div class="col-md-12">
                    <div class="box margin-bottom-5px" style="border: none;">
                        <div class="box-body">
                            <div class="d-flex justify-content-start">
                                <a href="<?php echo base_url('index.php/admin/Patients/PatientsController/medical_book/') . encrypt_and_url_encode($patient_id, $this) ?>" class="btn btn-dark btn-sm"><i class="fa fa-chevron-circle-left" aria-hidden="true"></i> Go Back</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <?php print_header($this); ?>
            <form role="form" action="<?php echo site_url('admin/Modules/PlasticSurgery/PlasticSurgeryController/update'); ?>" method="post" enctype="multipart/form-data" id="ent_submit">
                <?php
                date_default_timezone_set('Asia/Kuwait');
                $date_string = '%Y-%m-%d';
                $curr_date = mdate($date_string);
                ?>
                <input type="hidden" class="form-control" name="treatment_date" id="treatment_date" value=<?php echo $curr_date; ?>>
                <input type="hidden" class="form-control" name="patient_id" id="patient_id" value="<?php echo encrypt_and_url_encode($patient_id, $this); ?>">
                <input type="hidden" class="form-control" style="z-index: 0 !important;" name="treatment_time" id="treatment_time" class="diag-time" value="<?php echo date('H:s'); ?>">
                <input type="hidden" class="form-control" name="treatement_payment_id" id="treatement_payment_id" class="diag-time" value="<?php echo $treatment_payment_id; ?>">

                <?php
                date_default_timezone_set('Asia/Kuwait');
                $date_string = '%Y-%m-%d';
                $curr_date = mdate($date_string);

                $query = $this->db->query("SELECT * FROM tbl_nurse_triage WHERE treatment_id = '$treatment_payment_id' AND treatment_id = '$treatment_payment_id' ORDER BY triage_id DESC LIMIT 1");
                $details = $query->row();

                if ($details) {

                    $weight = $details->weight;
                    $height = $details->height;
                    $bmi = $details->bmi;
                    $bp = $details->bp;
                    $temperature = $details->temperature;
                    $pulse = $details->pulse;
                    $rr = $details->rr;
                } else {

                    $weight = "";
                    $height = "";
                    $bmi = "";
                    $bp = "";
                    $temperature = "";
                    $pulse = "";
                    $rr = "";
                }
                ?>


                <div class="box  box-info">
                    <div class="box-body">

                        <div class="row">
                            <div class="col-12">

                                <form role="form" action="<?= base_url('index.php/admin/Modules/PlasticSurgery/PlasticSurgeryController/save'); ?>" method="post" enctype="multipart/form-data">
                                    <?php
                                    date_default_timezone_set('Asia/Kuwait');
                                    $date_string = '%Y-%m-%d';
                                    $curr_date = mdate($date_string);

                                    $query = $this->db->query("SELECT * FROM tbl_nurse_triage WHERE treatment_id = '$treatment_payment_id' AND patient_id = '$patient_id' ORDER BY triage_id DESC LIMIT 1");
                                    $details = $query->row();

                                    $weight = isset($details->weight) ? $details->weight : "";
                                    $height = isset($details->height) ? $details->height : "";
                                    $bmi = isset($details->bmi) ? $details->bmi : "";
                                    $bp = isset($details->bp) ? $details->bp : "";
                                    $temperature = isset($details->temperature) ? $details->temperature : "";
                                    $pulse = isset($details->pulse) ? $details->pulse : "";
                                    $rr = isset($details->rr) ? $details->rr : "";
                                    ?>
                                    <input type="hidden" class="form-control" name="treatment_date" id="treatment_date" value=<?php echo $curr_date; ?>>
                                    <input type="hidden" class="form-control" name="patient_id" id="patient_id" value="<?php echo encrypt_and_url_encode($patient_id, $this); ?>">
                                    <input type="hidden" class="form-control" style="z-index: 0 !important;" name="treatment_time" id="c" class="diag-time" value="<?php echo date('H:s'); ?>">
                                    <input type="hidden" class="form-control" name="treatement_payment_id" id="treatement_payment_id" class="diag-time" value="<?php echo $treatment_payment_id; ?>">
                                    <input type="hidden" class="form-control" name="treatement_payment_id" id="treatement_payment_id" class="diag-time" value="<?php echo $treatment_payment_id; ?>">
                                    <input type="hidden" id="plastic_up_image" name="plastic_up_image" value="<?php echo $plastic->mark_iname; ?>">

                                   

                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group <?php echo (form_error('date') == '') ? '' : ' has-error'; ?>">
                                                <label for="app_date">Treatment Date</label>
                                                <input type="text" class="form-control treatment_date" name="treatment_date_plas_surg" id="treatment_date_plas_surg" value="<?php echo $invoice->treat_date; ?>">
                                                <?php echo form_error('date', '<div style="color:red"><em>* ', '</em></div>'); ?>
                                            </div>
                                            <div class="row">
                                            <div class="form-group col-6">
                                                <label for="lab_test">Past / Present Medical / Surgical History</label>
                                                <textarea class="form-control" name="chief_complaint_plas_surg" id="chief_complaint_plas_surg" rows="3"><?php echo   !empty($plastic->chief_complaint_plas_surg) ? $plastic->chief_complaint_plas_surg : $tdetails->chief_complain; ?></textarea>
                                            </div>
                                            <div class="form-group col-6">
                                                <label for="lab_test">Assessment / Examination</label>
                                                <textarea class="form-control" name="subjective_plas_surg" id="subjective_plas_surg" rows="3"><?php echo
                                                !empty( $plastic->subjective_plas_surg) ?  $plastic->subjective_plas_surg : $tdetails->subjective; ?></textarea>
                                            </div>
                                            </div>
                                            <div class="row">
                                            <div class="form-group col-6">
                                                <label for="lab_test">Diagnosis</label>
                                                <textarea class="form-control" name="objective_plas_surg" id="objective_plas_surg" rows="3"><?php echo 
                                                $plastic->objective_plas_surg; ?></textarea>
                                            </div>
                                            <div class="form-group col-6">
                                                <label for="lab_test">Plan / Management</label>
                                                <textarea class="form-control" name="assessment_plas_surg" id="assessment_plas_surg" rows="3"><?php echo
                                                !empty($plastic->assessment_plas_surg) ?  $plastic->assessment_plas_surg :  $tdetails->assessment; ?></textarea>
                                            </div>
                                            </div>
                                            
                                            

                                            <div class="form-group">
                                                <input type="hidden" name="check_plastic_surg" id="check_plastic_surg" value="0">
                                                <input type="hidden" name="counter_plsurgery" id="counter_plsurgery" value="1">
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <label>Mark Area</label>
                                                        </div>

                                                       
                                                        <div style="width: 100%; height: 522px; margin: 0 auto;">
                                            <p><i class="fa fa-info"></i> Please click on image to mark areas</p>
                                           

                                                    <div style="position: relative; display: flex; flex-direction: column; align-items: center; padding-top: 50px;">
                                                    <!-- we are putting a copy of the original image under the result image so it's always annotation-free -->
                                                    <img src="<?php echo base_url('Images/body_full.png') ?>" class="body_image" style="max-width: 600px;" onload="setSourceImage(this);" />
                                                    <img src="<?php echo base_url('Images/body_full.png') ?>" class="body_image2" style="max-width:  600px; position: absolute;" onclick="showMarkerArea(this);" />
                                                </div>
                                                <button type="button" class="btn btn-light btn-sm body_reset_1" id="body_reset_1"> Reset</button>
                                                
                                            </div>

                                                        <div class="form-group">
                                                            <label>Plastic Surgery</label>
                                                            <textarea class="form-control" name="pl_remark" id="pl_remark_plastic" rows="2"><?php echo $plastic->pl_remark; ?></textarea>
                                                            <input type="hidden" class="form-control" name="imagepath-plastic" id="imagepath_plastic">
                                                        </div>
                                                    </div>

                                                </div>

                                            </div>

                                            <div class="form-group">
                                                <label for="procedure">Select Procedure</label>
                                                <select class="procedure" data-department="1" placeholder="Select a procedure..." name="procedure_plas_surg" id="procedure_plas_surg"></select>
                                            </div>


                                            <div class="row">
                                                <div class="col-md-10">
                                                    <button type="button" class="btn btn-dark btn-sm" id="addRow_plas_surg"><i class="fa fa-plus-circle"></i> Add</button>
                                                </div>
                                            </div>
                                            <br>
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <div class="panel panel-primary">
                                                        <div class="panel-heading">
                                                            <h5>Treatment List</h5>
                                                        </div>
                                                        <table class="table table-hover display table-striped w-100" id="treatemnts_plas_surg">
                                                            <thead>
                                                                <tr>
                                                                    <th>No</th>
                                                                    <th>Procedure</th>
                                                                    <th>Discount(QR)</th>
                                                                    <th>Discount(%)</th>
                                                                    <th>Fees</th>
                                                                    <th class="text-center">Actions</th>
                                                                </tr>
                                                            </thead>
                                                            <?php
                                                            // print_r($episodes);die;
                                                            foreach ($episodes as $index => $value1) {
                                                                echo "<tr>
                                        <td>" . (++$index) . "</td>
                                        <td>" . $value1['treatment_name'] . "<input type='hidden' name='plas_surg_treatment_name[]' value='" . $value1['treatment_name'] . "'><input type='hidden' name='plas_surg_treatment_id[]' value='" . $value1['procedure_id'] . "'></td>

                                        <td class='hidden-print'><span class='hide-input'><input type='hidden' size='7' name='orig_price_plas_surg[]' value='" . $value1['fees'] . "'><input type='text' size='7' name='discount_plas_surg[]' value='" . $value1['discount_qr'] . "' class='discount_plas_surg form-control'></span></td>

                                        <td class='hidden-print'><span class='hide-input'><input type='text' size='7' name='discount_per_plas_surg[]' value='" . $value1['discount_per'] . "' class='discount_per_plas_surg form-control'></span></td>

                                        <td class='hidden-print'><span class='hide-input'><input type='text' size='7' name='fees_plas_surg[]' value='" . ($value1['fees'] - $value1['discount_qr']) . "' class='fees_plas_surg form-control'></span></td>
                                        <td><div class='text-center'><button type='button' class='btn btn-light deleteRow_plas_surg'><i class='fa fa-trash'></i></button></div></td>
                                        </tr>";
                                                                $ctr++;
                                                            }


                                                            ?>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- <div class="row">
                    <div class="col-md-12">
                        <div class="panel panel-success">
                            <div class="panel-heading">Prescription</div><br>
                            <div class="row">

                                <div class="col-md-12 input_fields_wrap_plas_surg">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="drugs">Select Drugs</label>
                                                <input type="text" class="form-control drugs" name="drugs_plas_surg" id="drugs_plas_surg">
                                            </div>
                                        </div>
                                        <div class="col-md-1">
                                            <div class="form-group">
                                                <label for="drugs">QTY</label>
                                                <input type="text" class="form-control" name="drug_qty_plas_surg" id="drug_qty_plas_surg">
                                            </div>
                                        </div>
                                        <div class="col-md-2">
                                            <div class="form-group">
                                                <label for="meal">Meal</label></br>
                                                <label class="radio-inline">
                                                    <input type="radio" name="meal_plas_surg" id="meal_plas_surg" value="1"> After
                                                </label>
                                                <label class="radio-inline">
                                                    <input type="radio" name="meal_plas_surg" id="meal_plas_surg" value="2"> Before
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-md-5">
                                            <div class="form-group">
                                                <label for="drugs">Description</label>
                                                <div class="input-group">
                                                    <input type="text" class="form-control" name="drug_note_plas_surg" id="drug_note_plas_surg">
                                                    <span class="input-group-addon">
                                                        <button type="button" class="btn btn-success btn-xs add_field_button_plas_surg" id="add_drug_plas_surg">+</button>
                                                        <button type="button" class="btn btn-warning btn-xs clear_field_plas_surg" id="clear_field_plas_surg">x</button>
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div> -->

                                    <label for="attachment">Attachment</label>
                                    <div class="input-group">
                                        <span class="input-group-btn">
                                            <span class="btn btn-default btn-file">
                                                Browse&hellip; <input type="file" multiple name="attach_plas_surg[]">
                                            </span>
                                        </span>
                                        <input type="text" class="form-control" readonly>
                                    </div><br>
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <!-- <button type="submit" class="btn btn-primary">Save</button> -->
                                                <button type="submit" class="btn btn-light btn-sm"><i class="fa fa-check-circle" aria-hidden="true"></i> Update</button>
                                                <button type="reset" class="btn btn-light btn-sm" id="clear"><i class="fa fa-times-circle" aria-hidden="true"></i> Clear</button>
                                            </div>
                                        </div>
                                    </div>

                                </form>

                            </div>
                        </div>
                    </div>
                </div>


        </section>
    </div>
    <?php require_once(APPPATH . "views/admin/footer.php"); ?>


</body>
<script>
    function showMarkerArea(target) {
      const markerArea = new markerjs2.MarkerArea(sourceImage);
      markerArea.availableMarkerTypes = markerArea.ALL_MARKER_TYPES;
      markerArea.settings.displayMode = 'popup';
      markerArea.uiStyleSettings.clearButtonVisible = true;
    //   markerArea.addEventListener("render", (event) => (target.src = event.dataUrl));

    markerArea.targetRoot = targetRoot;
      markerArea.addEventListener('render', (event) => {
            target.src = event.dataUrl; // Update image with markers
            maState = event.state;
            // Set the data URL to the hidden input field
            $('input[name=imagepath-plastic]').val(event.dataUrl);
        });
    
      markerArea.show();
      if (maState) {
  markerArea.restoreState(maState);
}
      
    }
    $('.body_reset_1').click(function(){
        console.log('reset');
        $('input[name=imagepath-plastic]').val('');
        $('.body_image').attr('src','<?php echo base_url('Images/body_full.png') ?>');
        $('.body_image2').attr('src','<?php echo base_url('Images/body_full.png') ?>');
    });
    var counter = <?= count($episodes) + 1; ?>

    $(document).ready(function() {
        var procedureElements = document.querySelectorAll('.procedure');

        var procedureCount = procedureElements.length;

        for (var i = 0; i < procedureCount; i++) {
            var currentElement = procedureElements[i];
            var departmentId = currentElement.getAttribute('data-department');
            initTomSelectProcedres(currentElement, departmentId);
        }

        var diagnosisElements = document.querySelectorAll('.multi_diagnosis');
        var diagnosisCount = diagnosisElements.length;

        for (var i = 0; i < diagnosisCount; i++) {
            var currentElement = diagnosisElements[i];
            var departmentId = currentElement.getAttribute('data-department');
            initTomSelectDiagnosis(currentElement, departmentId);
        }

    });

    $('.drugs').on("focus", function() {
        $(this).autocomplete({
            source: function(request, response) {
                $.ajax({
                    url: "<?= base_url('index.php/admin/Modules/Dermatology/DermatologyController/get_drugs'); ?>",
                    dataType: "json",
                    data: {
                        name_startsWith: request.term,
                        type: 'drug'
                    },
                    success: function(data) {
                        response($.map(data, function(item) {
                            return {
                                label: item,
                                value: item
                            }
                        }));
                    }
                });
            },
            autoFocus: false,
            minLength: 2
        });
    });

    function initTomSelectProcedres(selector, departmentId) {
        var initTomSelecs = new TomSelect(selector, {
            valueField: 'id',
            labelField: 'name',
            searchField: 'name',
            load: function(query, callback) {
                var apiUrl = "<?php echo site_url('admin/CommenController/get_procedures?p=');
                                echo $patient_id . '&' ?>t=" + departmentId + "&q=" + encodeURIComponent(query);

                fetch(apiUrl)
                    .then(response => response.json())
                    .then(data => {
                        callback(data);
                    })
                    .catch(() => {
                        callback();
                    });
            },
            render: {
                option: function(item, escape) {
                    return '<div>' +
                        '<span class="btn btn-sm">' + escape(item.name) + '</span>' +
                        '</div>';
                },
                item: function(item, escape) {
                    return '<div>' +
                        '<span class="btn  btn-sm">' + escape(item.name) + '</span>' +
                        '</div>';
                }
            },
        });

        initTomSelecs.settings.minLength = 2;
    }

    function initTomSelectDiagnosis(selector, departmentId) {
        var multiDiagnosisSelect = new TomSelect(selector, {
            valueField: 'id',
            labelField: 'name',
            searchField: 'name',
            load: function(query, callback) {
                var apiUrl = "<?php echo site_url('admin/CommenController/get_diagnosis?'); ?>t=" + departmentId + "&q=" + encodeURIComponent(query);

                fetch(apiUrl)
                    .then(response => response.json())
                    .then(data => {
                        callback(data);
                    })
                    .catch(() => {
                        callback();
                    });
            },
            render: {
                option: function(item, escape) {
                    return '<div>' +
                        '<span class="btn btn-sm">' + escape(item.name) + '</span>' +
                        '</div>';
                },
                item: function(item, escape) {
                    return '<div>' +
                        '<span class="btn btn-sm">' + escape(item.name) + '</span>' +
                        '</div>';
                }
            },
        });

        multiDiagnosisSelect.settings.minLength = 2;
    }

    var b = $('#treatemnts_plas_surg').DataTable({
        "bFilter": false,
        "paging": false,
        "info": false
    });

    $('#addRow_plas_surg').on('click', function() {
        // if($("#diagnosis_plas_surg").val() === "") {
        //      alert('Diagnosis is required.');
        //       return false;

        //   }

        // var split_diagnosis = $('input[name=diagnosis_plas_surg]').val().split(', ');
        // var primary_diagnosis = $('input[name=diagnosis_plas_surg]').val().split(' - ');
        // var diag_name = "";
        // $.each( split_diagnosis, function( index, value ){
        //   if(value){
        //     var temp = value.split(' - ');
        //     diag_name += temp[1]+ ",";
        //   }
        // });

        var split_treatment = $('select[name=procedure_plas_surg]').val().split(' | ');

        // if ($('input[name=diagnosis_plas_surg]').val().indexOf('-') == -1){
        //   var diagnosis = $('input[name=diagnosis_plas_surg]').val()+'<input type="hidden" name="plas_surg_diagnosis_name[]" value="'+$('input[name=diagnosis_plas_surg]').val()+'"><input type="hidden" name="plas_surg_diagnosis_id[]" value="">';
        // } else {
        //   var diagnosis = diag_name+'<input type="hidden" name="plas_surg_diagnosis_name[]" value="'+diag_name+'"><input type="hidden" name="plas_surg_diagnosis_id[]" value="'+primary_diagnosis[0]+'">';
        // }
        var treat_plas_surg = split_treatment[1] + '<input type="hidden" name="plas_surg_treatment_name[]" value="' + split_treatment[1] + '"><input type="hidden" name="plas_surg_treatment_id[]" value="' + split_treatment[0] + '">';

        b.row.add([
                counter,
                treat_plas_surg,
                '<input type="hidden" name="orig_price_plas_surg[]" value="' + split_treatment[3] + '"><input type="text" size="7" name="discount_plas_surg[]" value="0" class="discount_plas_surg form-control">',
                '<input type="text" size="7" name="discount_per_plas_surg[]" value="0" class="discount_per_plas_surg form-control">',
                '<input type="text" name="fees_plas_surg[]" size="7" value="' + split_treatment[3] + '" class="fees_plas_surg form-control">',
                '<div class="text-center"><button type="button" class="btn btn-light deleteRow_plas_surg"><i class="fa fa-trash" aria-hidden="true"></i></button></div>',
            ])
            .draw();

        counter++;
    });

    $('body').on("click", ".deleteRow_plas_surg", function(e) {
        b.row($(this).parents('tr')).remove().draw();
        return false;
    });
    var limit_discount= Number("<?php echo get_discount_limt($this) ?? '' ?>");

    $('body').on('keyup', '.discount_plas_surg', function() {
        this_td = $(this).closest('td'),
            orig_price = $(this).prev('input').val(),
            dis_per_td = this_td.next('td');
        discount_per = $(dis_per_td).find('input').val(),
            fees_td = dis_per_td.next('td');
        fees = $(fees_td).find('input').val(),
            discount = Number($(this).val()).toFixed(2);
            var dis_per =Number((discount * 100 / orig_price).toFixed(2));
                if(limit_discount !=''){
                if(dis_per > limit_discount){
                    
                    showdialog('Authorization Error' ,'Discount percentage exceeds the allowed limit of ' + limit_discount + '%.')
                    dis_per = limit_discount
                    discount =((dis_per * orig_price) / 100).toFixed(2);

                    $(this).val(discount);
                }
            }
                //discount
                

            dis_per_td.find('input').val(dis_per); //discount_per
      
        fees_td.find('input').val(Number(orig_price - discount).toFixed(2)); //fees
    });

    $('body').on('keyup', '.discount_per_plas_surg', function() {
        this_td = $(this).closest('td'),
            dis_td = this_td.prev('td'),
            orig_price = $(dis_td).find('input').val(),
            discount = $(dis_td).find('input').next().val(),
            fees_td = this_td.next('td');
        fees = $(fees_td).find('input').val(),
            discount_per = Number($(this).val()).toFixed(2);
                        if(limit_discount !=''){
            if (discount_per > limit_discount) {
                showdialog('Authorization Error' ,'Discount percentage exceeds the allowed limit of ' + limit_discount + '%.')
            $(this).val(limit_discount); // Optionally, reset the value to the limit
            discount_per = limit_discount; // Update discount_per to the limit value
            }
            }
        dis_td.find('input').next().val(Number((discount_per * orig_price) / 100).toFixed(2)); //discount
        fees_td.find('input').val(Number(orig_price - (discount_per * orig_price / 100)).toFixed(2));
    });

    $('body').on('keyup', '.fees_plas_surg', function() {
        this_td = $(this).closest('td'),
            dis_per_td = this_td.prev('td');
        discount_per = $(dis_per_td).find('input').val(),
            dis_td = dis_per_td.prev('td'),
            orig_price = $(dis_td).find('input').val(),
            discount = $(dis_td).find('input').next().val(),
            fees = Number($(this).val()).toFixed(2);

        dis_td.find('input').next().val(Number(orig_price - fees).toFixed(2)); //discount
        dis_per_td.find('input').val(Number((1 - (fees / orig_price)) * 100).toFixed(2)); //discount_per
    });

    var plastic_up_image = $("#plastic_up_image").val();
    console.log(plastic_up_image);
    var b_image=$('.body_image');
    var b_image2=$('.body_image2');

    // img.src = '<?= base_url("./Images/body_full.png"); ?>';
    if (plastic_up_image === '' || typeof plastic_up_image === 'undefined') {
        b_image.src = '<?= base_url("./Images/body_full.png"); ?>';
        b_image2.src = '<?= base_url("./Images/body_full.png"); ?>';
    } else {
        b_image.attr('src','<?= base_url('uploads/'.DOMAIN.'/plastic/marks/') . $plastic->mark_iname; ?>')
        b_image2.attr('src','<?= base_url('uploads/'.DOMAIN.'/plastic/marks/') . $plastic->mark_iname; ?>');
    }

    function getMousePos(canvas, evt) {
        var rect = canvas.getBoundingClientRect();
        return {
            x: evt.clientX - rect.left,
            y: evt.clientY - rect.top
        };
    }

    function drawImage() {
        ctx.setTransform(scale, 0, 0, scale, originX, originY);
        ctx.clearRect(-originX / scale, -originY / scale, el.width / scale, el.height / scale);
        ctx.drawImage(img, 0, 0, 580, 522);
        drawMarksAndTexts();
    }

    function drawMarksAndTexts() {
        // Redraw all marks
        marks.forEach(function(mark) {
            drawMark(mark.x, mark.y);
        });

        // Redraw all text annotations
        texts.forEach(function(text) {
            drawText(text.text, text.x, text.y);
        });
    }

    function addMark(x, y) {
        marks.push({ x: x, y: y });
        drawMark(x, y);
    }

    function drawMark(x, y) {
        ctx.fillStyle = "rgba(255, 0, 0, 0.6)"; // Semi-transparent red
        ctx.beginPath();
        ctx.arc(x, y, 2, 0, 2 * Math.PI);
        ctx.fill();
    }

    function removeMark(x, y) {
        marks = marks.filter(function(mark) {
            return !(Math.abs(mark.x - x) < 5 && Math.abs(mark.y - y) < 5);
        });
        drawImage();
    }

    function addText(text, x, y) {
        texts.push({ text: text, x: x, y: y });
        drawText(text, x, y);
    }

    function drawText(text, x, y) {
        ctx.fillStyle = "Black";
        ctx.font = "14px Arial";
        ctx.textAlign = "center";
        ctx.fillText(text, x, y);
    }





   

    function getMousePos(el, evt) {
        var rect = el.getBoundingClientRect();
        return {
            x: evt.clientX - rect.left,
            y: evt.clientY - rect.top
        };
    }
</script>

</html>