<!DOCTYPE html>
<html>

<head>
  <meta charset="UTF-8">
  <title>Patient</title>
  <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>

  <?php require_once(APPPATH . "views/admin/header.php"); ?>

</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
  <!-- Site wrapper -->

  <!-- Header Navbar: style can be found in header.less -->
  <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

  <!-- =============================================== -->

  <!-- Left side column. contains the sidebar -->
  <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

  <!-- =============================================== -->

  <!-- Right side column. Contains the navbar and content of the page -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        &nbsp;Edit Surgery Details
      </h1>
      <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
    </section>

    <!-- Main content -->
    <section class="content">

      <div class="row mb-2">
        <div class="col-md-12">
          <div class="box margin-bottom-5px" style="border: none;">
            <div class="box-body">
              <div class="d-flex justify-content-start">
                <a href="<?php echo base_url('index.php/admin/Patients/PatientsController/medical_book/') . encrypt_and_url_encode($patient_id, $this) ?>" class="btn btn-dark btn-sm"><i class="fa fa-chevron-circle-left" aria-hidden="true"></i> Go Back</a>
              </div>
            </div>
          </div>
        </div><!-- /.box-body -->
      </div>

      <?php print_header($this); ?>
      <form role="form" action="<?php echo site_url('admin/Modules/Surgical/SurgicalController/update'); ?>" method="post" enctype="multipart/form-data" id="ent_submit">
        <?php
        date_default_timezone_set('Asia/Kuwait');
        $date_string = '%Y-%m-%d';
        $curr_date = mdate($date_string);
        ?>
        <!-- <input type="hidden" class="form-control" name="treatment_date" id="treatment_date" value=<?php echo $curr_date; ?>> -->
        <input type="hidden" class="form-control" name="patient_id" id="patient_id" value="<?php echo encrypt_and_url_encode($patient_id, $this); ?>">
        <!-- <input type="hidden" class="form-control" style="z-index: 0 !important;" name="treatment_time" id="treatment_time" class="diag-time" value="<?php echo date('H:s'); ?>"> -->
        <input type="hidden" class="form-control" name="treatement_payment_id" id="treatement_payment_id" class="diag-time" value="<?php echo $treatment_payment_id; ?>">


        <div class="box  box-info">
          <div class="box-body">

            <div class="form-group p-3">
              <div class="row">
                <div class="col-12">
                  <h4><b>Surgical</b></h4>
                  <hr>
                </div>
                <div class="col-12">
                  <div class="row">
                    <div class="col-6">
                      <div class="form-group">
                        <div class="form-group <?php echo (form_error('operation_date') == '') ? '' : ' has-error'; ?>">
                          <label for="app_date">Operation Note</label>
                          <textarea class="form-control" id="operation_note" name="operation_note"><?php print_r($surgery_details->operation_note); ?></textarea>
                          <?php echo form_error('operation_note', '<div style="color:red"><em>* ', '</em></div>'); ?>
                        </div>
                      </div>
                    </div>
                    <div class="col-3">
                      <div class="form-group">
                        <div class="form-group <?php echo (form_error('operation_date') == '') ? '' : ' has-error'; ?>">
                          <label for="app_date">Operation Date</label>
                          <input type="text" class="form-control select_date" name="operation_date" id="operation_date" value="<?php echo $surgery_details->operation_date ?>">
                          <?php echo form_error('operation_date', '<div style="color:red"><em>* ', '</em></div>'); ?>
                        </div>
                      </div>
                    </div>
                    <div class="col-3">
                      <div class="form-group <?php echo (form_error('operation_time') == '') ? '' : ' has-error'; ?>">
                        <label for="app_date">Operation Time</label>
                        <input type="time" class="form-control " name="operation_time" id="operation_time" value="<?php echo date("h:i", strtotime($surgery_details->operation_time)); ?>">
                        <?php echo form_error('operation_time', '<div style="color:red"><em>* ', '</em></div>'); ?>
                      </div>
                    </div>
                    <div class="col-3">
                      <div class="form-group <?php echo (form_error('operation_status') == '') ? '' : ' has-error'; ?>">
                        <label for="app_date">Operation Status</label>
                        <select class="form-control" name="operation_status" id="operation_status">
                          <option value="1" <?php echo $surgery_details->operation_status == 1 ? 'selected' : '' ?>>In PreOp</option>
                          <option value="2" <?php echo $surgery_details->operation_status == 2 ? 'selected' : '' ?>>OK Transfer</option>
                          <option value="3" <?php echo $surgery_details->operation_status == 3 ? 'selected' : '' ?>>In OR</option>
                          <option value="4" <?php echo $surgery_details->operation_status == 4 ? 'selected' : '' ?>>In Facility</option>
                        </select>
                        <?php echo form_error('operation_status', '<div style="color:red"><em>* ', '</em></div>'); ?>
                      </div>
                    </div>
                    <div class="col-3">
                      <div class="form-group <?php echo (form_error('room') == '') ? '' : ' has-error'; ?>">
                        <label for="app_date">Room</label>
                        <select class="form-control" name="room" id="room">
                          <?php foreach ($rooms as $key => $value) { ?>
                            <option value="<?php echo $value["id"]; ?>" <?php echo $surgery_details->room == $value["id"] ? 'selected' : '' ?>><?php echo $value["room_name"]; ?></option>
                          <?php } ?>
                        </select>
                        <?php echo form_error('room', '<div style="color:red"><em>* ', '</em></div>'); ?>
                      </div>
                    </div>
                    <div class="col-3">
                      <div class="form-group <?php echo (form_error('duration') == '') ? '' : ' has-error'; ?>">
                        <label for="app_date">Expected Duration</label>
                        <input type="text" class="form-control" name="duration" id="duration" value="<?php echo $surgery_details->duration ?>">
                        <?php echo form_error('duration', '<div style="color:red"><em>* ', '</em></div>'); ?>
                      </div>
                    </div>
                    <div class="col-3">
                      <div class="form-group <?php echo (form_error('stay') == '') ? '' : ' has-error'; ?>">
                        <label for="app_date">Expected Stay</label>
                        <input type="text" class="form-control" name="stay" id="stay" value="<?php echo $surgery_details->stay ?>">
                        <?php echo form_error('stay', '<div style="color:red"><em>* ', '</em></div>'); ?>
                      </div>
                    </div>
                    <div class="col-3">
                      <div class="form-group <?php echo (form_error('admission_time') == '') ? '' : ' has-error'; ?>">
                        <label for="app_date">Admission Time</label>
                        <input type="time" class="form-control" name="admission_time" id="admission_time" value="<?php echo date("h:i", strtotime($surgery_details->admission_time)); ?>">
                        <?php echo form_error('admission_time', '<div style="color:red"><em>* ', '</em></div>'); ?>
                      </div>
                    </div>
                    <div class="col-3">
                      <div class="form-group <?php echo (form_error('anesthisia_type') == '') ? '' : ' has-error'; ?>">
                        <label for="app_date">Anesthisia Type</label>
                        <select class="form-control" name="anesthisia_type" id="anesthisia_type">
                          <option value="1" <?php echo $surgery_details->anesthisia_type == 1 ? "selected" : '' ?>>General</option>
                          <option value="2" <?php echo $surgery_details->anesthisia_type == 2 ? "selected" : '' ?>>Sedation</option>
                          <option value="3" <?php echo $surgery_details->anesthisia_type == 3 ? "selected" : '' ?>>Regional</option>
                          <option value="4" <?php echo $surgery_details->anesthisia_type == 4 ? "selected" : '' ?>>Local</option>
                        </select>
                        <?php echo form_error('anesthisia_type', '<div style="color:red"><em>* ', '</em></div>'); ?>
                      </div>
                    </div>
                    <div class="col-3">
                      <div class="form-group <?php echo (form_error('start_time') == '') ? '' : ' has-error'; ?>">
                        <label for="app_date">Start Time</label>
                        <input type="time" class="form-control" name="start_time" id="start_time" value="<?php echo date("h:i", strtotime($surgery_details->start_time)); ?>">
                        <?php echo form_error('start_time', '<div style="color:red"><em>* ', '</em></div>'); ?>
                      </div>
                    </div>
                    <div class="col-3">
                      <div class="form-group <?php echo (form_error('end_time') == '') ? '' : ' has-error'; ?>">
                        <label for="app_date">End Time</label>
                        <input type="time" class="form-control" name="end_time" id="end_time" value="<?php echo date("h:i", strtotime($surgery_details->end_time)); ?>">
                        <?php echo form_error('end_time', '<div style="color:red"><em>* ', '</em></div>'); ?>
                      </div>
                    </div>
                    <div class="col-3">
                      <div class="form-group <?php echo (form_error('operation') == '') ? '' : ' has-error'; ?>">
                        <label for="app_date">Operation Duration</label>
                        <input type="text" class="form-control" name="operation" id="operation" value="<?php echo $surgery_details->operation ?>">
                        <?php echo form_error('operation', '<div style="color:red"><em>* ', '</em></div>'); ?>
                      </div>
                    </div>
                    <div class="col-3">
                      <div class="form-group <?php echo (form_error('asistant') == '') ? '' : ' has-error'; ?>">
                        <label for="app_date">Asistant</label>
                        <select class="form-control" name="asistant">
                          <?php foreach ($nurses as $key => $value) { ?>
                            <option value="<?php echo $value["user_id"]; ?>" <?php echo $surgery_details->asistant == $value["asistant"] ? 'selected' : '' ?>><?php echo $value["full_name"]; ?></option>
                          <?php } ?>
                        </select>
                        <?php echo form_error('asistant', '<div style="color:red"><em>* ', '</em></div>'); ?>
                      </div>
                    </div>
                    <div class="col-3">
                      <div class="form-group <?php echo (form_error('discharge_date') == '') ? '' : ' has-error'; ?>">
                        <label for="app_date">Discharge Date</label>
                        <input type="text" class="form-control select_date" name="discharge_date" id="discharge_date" value="<?php echo $surgery_details->discharge_date ?>">
                        <?php echo form_error('discharge_date', '<div style="color:red"><em>* ', '</em></div>'); ?>
                      </div>
                    </div>
                    <div class="col-3">
                      <div class="form-group <?php echo (form_error('discharge_time') == '') ? '' : ' has-error'; ?>">
                        <label for="app_date">Discharge Time</label>
                        <input type="time" class="form-control" name="discharge_time" id="discharge_time" value="<?php echo date("h:i", strtotime($surgery_details->discharge_time)) ?>">
                        <?php echo form_error('discharge_time', '<div style="color:red"><em>* ', '</em></div>'); ?>
                      </div>
                    </div>
                    <div class="col-12 pt-3">
                      <div class="form-group">
                        <h5><b>Patient Vitals</b></h5>
                        <hr>
                      </div>
                    </div>
                    <div class="col-1">
                      <div class="form-group">
                        <label>B.P</label>
                      </div>
                    </div>
                    <div class="col-1">
                      <input type="text" class="form-control vitals" id="bp_1" name="bp_1">
                    </div>
                    <div class="col-1">
                      <input type="text" class="form-control vitals" id="bp_2" name="bp_2">
                    </div>
                    <div class="col-1">
                      <label>Pulse</label>
                    </div>
                    <div class="col-1">
                      <input type="text" class="form-control vitals" id="pulse" name="pulse">
                    </div>
                    <div class="col-1">
                      <label>Temp.</label>
                    </div>
                    <div class="col-1">
                      <input type="text" class="form-control vitals" placeholder="ºC" id="tempc" name="tempc">
                    </div>
                    <div class="col-1">
                      <input type="text" class="form-control vitals" placeholder="ºF" id="tempf" name="tempf">
                    </div>
                    <div class="col-1">
                      <label>G.R.B.S</label>
                    </div>
                    <div class="col-1">
                      <input type="text" class="form-control vitals" placeholder="mg/dl" id="grbs" name="grbs">
                    </div>
                    <div class="col-1">
                      <label>R.R</label>
                    </div>
                    <div class="col-1">
                      <input type="text" class="form-control vitals" id="rr" name="rr">
                    </div>
                    <div class="col-1">
                      <label>Height</label>
                    </div>
                    <div class="col-1">
                      <input type="text" class="form-control vitals" id="height" name="height">
                    </div>
                    <div class="col-1">
                      <div style="width:100%"></div>
                    </div>
                    <div class="col-1">
                      <label>Weight</label>
                    </div>
                    <div class="col-1">
                      <input type="text" class="form-control vitals" id="weight" name="weight">
                    </div>
                    <div class="col-1">
                      <label>O<sub>2</sub> Saturation</label>
                    </div>
                    <div class="col-1">
                      <input type="text" class="form-control vitals" id="saturation" name="saturation">
                    </div>
                  </div>
                </div>
              </div>

              <div class="row pt-2">
                <div class="col-6">
                  <div class="form-group">
                    <div class="form-group <?php echo (form_error('bmi') == '') ? '' : ' has-error'; ?>">
                      <label for="app_date">BMI</label>
                      <input type="text" class="form-control " name="bmi" id="bmi">
                      <?php echo form_error('bmi', '<div style="color:red"><em>* ', '</em></div>'); ?>
                    </div>
                  </div>
                </div>
                <div class="col-6">
                  <div class="form-group">
                    <div class="form-group <?php echo (form_error('notes') == '') ? '' : ' has-error'; ?>">
                      <label for="app_date">Notes</label>
                      <input type="text" class="form-control " name="notes" id="notes" value="">
                      <?php echo form_error('notes', '<div style="color:red"><em>* ', '</em></div>'); ?>
                    </div>
                  </div>
                </div>
                <div class="col-12">
                  <div class="form-group">
                    <label for="drugs">Select Allergies</label>
                    <input type="text" class="multi_diagnosis" name="diagnosis_vitals_surg" id="diagnosis_vitals_surg">
                  </div>
                </div>
              </div>

              <div class="row pt-3">
                <div class="col-12">
                  <button type="button" class="btn btn-sm btn-dark" id="addRow_vitals_surgical"><i class="fa fa-plus-circle"></i> Add Vital</button>
                </div>
              </div>
            </div>

            <div class="row p-3">
              <div class="col-12">
                <div class="panel panel-primary">
                  <div class="panel-heading">
                    <h5>
                      Patient Vitals List
                    </h5>
                  </div>
                  <table class="table table-hover display table-striped w-100" id="vitals_surg">
                    <thead>
                      <tr>
                        <th>No</th>
                        <th>Time</th>
                        <th>B.P</th>
                        <th>Pulse</th>
                        <th>Tempeture</th>
                        <th>G.R.B.S</th>
                        <th>R.R</th>
                        <th>Height</th>
                        <th>Weight</th>
                        <th>O<sub>2</sub> Saturation</th>
                        <th>BMI</th>
                        <th>Allergies</th>
                        <th>Notes</th>
                        <th class="text-center">Actions</th>
                      </tr>
                    </thead>
                    <?php foreach (json_decode($surgical->surgery_vitals) as $key => $vit) { ?>
                      <tr class="odd">
                        <td><?php echo (++$key) ?></td>
                        <td><?php echo $vit->time; ?><input type="hidden" name="time[]" value="<?php echo $vit->time; ?>"></td>
                        <td><?php echo $vit->bp_1; ?>/<?php echo $vit->bp_2; ?><input type="hidden" name="bp_1[]" value="<?php echo $vit->bp_1; ?>"><input type="hidden" name="bp_2[]" value="<?php echo $vit->bp_2; ?>"></td>
                        <td><?php echo $vit->pulse; ?><input type="hidden" name="pulse[]" value="<?php echo $vit->pulse; ?>"></td>
                        <td><?php echo $vit->tempc; ?>ºC/<?php echo $vit->tempf; ?>ºF<input type="hidden" name="tempc[]" value="<?php echo $vit->tempc; ?>"><input type="hidden" name="tempf[]" value="<?php echo $vit->tempf; ?>"></td>
                        <td><?php echo $vit->grbs; ?><input type="hidden" name="grbs[]" value="<?php echo $vit->grbs; ?>"></td>
                        <td><?php echo $vit->rr; ?><input type="hidden" name="rr[]" value="<?php echo $vit->rr; ?>"></td>
                        <td><?php echo $vit->height; ?><input type="hidden" name="height[]" value="<?php echo $vit->height; ?>"></td>
                        <td><?php echo $vit->weight; ?><input type="hidden" name="weight[]" value="<?php echo $vit->weight; ?>"></td>
                        <td><?php echo $vit->bmi; ?><input type="hidden" name="bmi[]" value="<?php echo $vit->bmi; ?>"></td>
                        <td><?php echo $vit->saturation; ?><input type="hidden" name="saturation[]" value="<?php echo $vit->saturation; ?>"></td>
                        <td><?php echo $vit->surg_vitals_diagnosis_name; ?><input type="hidden" name="surg_vitals_diagnosis_name[]" value="<?php echo $vit->surg_vitals_diagnosis_name; ?>"><input type="hidden" name="surg_vitals_diagnosis_id[]" value="<?php echo $vit->surg_vitals_diagnosis_id; ?>"></td>
                        <td><input type="hidden" name="notes[]" value="<?php echo $vit->notes; ?>"></td>
                        <td>
                          <div class="text-center"><button type="button" class="btn btn-light deleteRow_vital"><i class="fa fa-trash" aria-hidden="true"></i></button></div>
                        </td>
                      </tr>
                    <?php } ?>
                  </table>
                </div>
              </div>
            </div>


            <div class="form-group p-3">
              <div class="row">
                <div class="col-12">
                  <div class="form-group">
                    <h5><b>Procedures</b></h5>
                    <hr>
                  </div>
                </div>
              </div>
              <div class="row">
                <div class="col-12">
                  <div class="form-group">
                    <label for="drugs">Select Diagnosis</label>
                    <input type="text" class="multi_diagnosis" name="diagnosis_surgical" id="diagnosis_surgical">
                  </div>
                </div>
              </div>
              <div class="row">
                <div class="col-12">
                  <div class="form-group">
                    <label for="procedure">Select Procedure</label>
                    <select class="procedure" data-department="8" name="procedure_surgical" id="procedure_surgical">
                    </select>
                  </div>
                </div>
              </div>
              <div class="row pt-3">
                <div class="col-12">
                  <button type="button" class="btn btn-sm btn-dark" id="addRow_surgical"><i class="fa fa-plus-circle"></i> Add Procedure</button>
                </div>
              </div>
            </div>

            <div class="row mt-2 p-3">
              <div class="col-12">
                <div class="panel panel-primary">
                  <div class="panel-heading">
                    <h5>
                      Procedures List
                    </h5>
                  </div>
                  <table class="table table-hover display table-striped w-100" id="treatemnts_ent">
                    <thead>
                      <tr>
                        <th>No</th>
                        <th>Diagnosis</th>
                        <th>Procedure</th>
                        <th>Discount(QR)</th>
                        <th>Discount(%)</th>
                        <th>Fees</th>
                        <th class="text-center">Actions</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php
                      foreach ($episodes as $index => $value1) {
                        echo "<tr>
                                        <td>" . (++$index) . "</td>
                                        <td>" . $value1['aditional_diagnostise_name'] . "<input type='hidden' name='general_diagnosis_name[]' value='" . $value1['aditional_diagnostise_name'] . "'><input type='hidden' name='general_diagnosis_id[]' value='" . $value1['diagnostise_id'] . "'></td>
                                        <td>" . $value1['treatment_name'] . "<input type='hidden' name='general_treatment_name[]' value='" . $value1['treatment_name'] . "'><input type='hidden' name='general_treatment_id[]' value='" . $value1['procedure_id'] . "'></td>

                                        <td class='hidden-print'><span class='hide-input'><input type='hidden' size='7' name='orig_price_surgical[]' value='" . $value1['fees'] . "'><input type='text' size='7' name='discount_surgical[]' value='" . $value1['discount_qr'] . "' class='discount_general form-control'></span></td>

                                        <td class='hidden-print'><span class='hide-input'><input type='text' size='7' name='discount_per_surgical[]' value='" . $value1['discount_per'] . "' class='discount_per_general form-control'></span></td>

                                        <td class='hidden-print'><span class='hide-input'><input type='text' size='7' name='fees_general[]' value='" . ($value1['fees'] - $value1['discount_qr']) . "' class='fees_general form-control'></span></td>
                                        <td><button type='button' class='btn btn-light deleteRow_general'><i class='fa fa-trash' aria-hidden='true'></i></button></td>
                                        </tr>";
                        $ctr++;
                      }
                      ?>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>


            <div class="row p-3">
              <div class="col-12">
                <div class="form-group">
                  <label for="drugs">Procedures Note</label>
                  <textarea type="text" class="form-control note" name="note" id="note"><?= $surgical->note ?></textarea>
                </div>
              </div>
            </div>

            <div class="row">
                    <div class="col-md-4">
                        <label for="attachment">Attachment</label>
                        <div class="input-group hide-input">
                            <span class="input-group-btn">
                                <span class="btn btn-default btn-file">
                                    <label for="attach_surgical" style="margin: 0px;">Browse</label>&hellip;<input type="file" multiple id="attach_surgical" name="attach_surgical[]">
                                </span>
                            </span>
                            <input type="text" class="form-control" readonly>
                        </div>
                    </div>
                </div>

            <div class="row mt-2">
              <div class="col-md-12">
                <span id="attach" class="hide-text hidden-print">
                  <?php if ($attachment != FALSE) : ?>
                    <h4>Attachments</h4>
                    <table class="table table-bordered">
                      <thead>
                        <th>#</th>
                        <th>Attachment</th>
                        <th class="text-center">Actions</th>
                      </thead>
                      <tbody>
                          <?php foreach ($attachment as $index => $val_attach) : ?>
                            <tr><td><?= ++$index; ?></td>
                            <td><?= $val_attach['document']; ?></td>
                            <td>
                              <div class="d-flex flex-row justify-content-center">
                                <a class="btn btn-sm btn-light mr-1" href="<?= base_url(''.UPLOAD_PATH.'surgery/' . $val_attach['document']); ?>" id="single_1" title="View">
                                  <i class="fa fa-eye" aria-hidden="true"></i>

                                </a>
                                <a class="btn btn-sm btn-light mr-1" href="<?= base_url(''.UPLOAD_PATH.'surgery/' . $val_attach['document']); ?>" download title="Download">
                                  <i class="fa fa-cloud-download" aria-hidden="true"></i>
                                </a>
                                <a class="btn btn-sm btn-light" href="javascript:void(0);" onclick="confirmDeleteGenral('<?= base_url('index.php/admin/Modules/Surgical/SurgicalController/delete_surgical_attachment/' . encrypt_and_url_encode($val_attach['id'], $this)) ?>');" title="Delete">
                                  <i class="fa fa-trash" aria-hidden="true"></i>
                                </a>
                              </div>
                            </td></tr>
                          <?php endforeach; ?>
                      </tbody>
                    </table>
                  <?php endif; ?>
                </span>
              </div>
            </div>

            <div class="row p-3">
              <div class="col-12">
                <div class="panel panel-success">
                  <div class="panel-heading">
                    <h5><b>
                        Prescriptions
                      </b></h5>
                  </div><br>
                  <div class="row">
                    <div class="col-md-3">
                      <div class="form-group">
                        <label for="drugs">Select Drugs</label>
                        <input type="text" class="form-control drugs" name="drugs_surg" id="drugs_surg">
                      </div>
                    </div>
                    <div class="col-md-3">
                      <div class="form-group">
                        <label for="drugs">Doses</label>
                        <input type="text" class="form-control surg_doses_auto" name="drug_qty_surg" id="drug_qty_surg">
                      </div>
                    </div>
                    <div class="col-md-3">
                      <div class="form-group">
                        <label for="meal">Frequency</label><br>
                        <input type="text" class="form-control surg_frequency_auto" name="drug_meal_surg" id="drug_meal_surg">
                      </div>
                    </div>
                    <div class="col-md-3">
                      <div class="form-group">
                        <label for="drugs">Duration(Days)</label>
                        <div class="input-group">
                          <input type="text" class="form-control surg_duration_auto" name="drug_note_surg" id="drug_note_surg">
                          <span class="input-group-addon">
                            <button type="button" class="btn btn-light btn-xs add_field_button_surg" id="add_drug_surg">+</button>
                            <button type="button" class="btn btn-danger btn-xs clear_field_surg" id="clear_field_surg">x</button>
                          </span>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="input_fields_wrap_surg">
                    <?php foreach (json_decode($surgical->prescription) as $key => $vit) { ?>
                      <div class="row drug_details">
                        <div class="col-md-3">
                          <div class="form-group">
                            <input type="text" class="form-control drugs" name="drug[]" value="<?php echo $vit->drug_name_surg ?>" id="drugs" disabled="">
                            <input type="hidden" name="drug_name_surg[]" value="<?php echo $vit->drug_name_surg ?>">
                            <input type="hidden" name="drug_id_surg[]" value="<?php echo $vit->drug_id_surg ?>">
                            <input type="hidden" class="form-control drugs" name="bill_items_id_surg[]" value="<?php echo $vit->bill_items_id_surg ?>" id="drugs">
                          </div>
                        </div>
                        <div class="col-md-3">
                          <div class="form-group">
                            <input type="text" class="form-control" name="drugs_qty_surg[]" value="<?php echo $vit->drugs_qty_surg ?>" id="drug_qty_surg" disabled="">
                            <input type="hidden" class="form-control" name="drugs_qty_surg[]" value="<?php echo $vit->drugs_qty_surg ?>" id="drug_qty_surg">
                          </div>
                        </div>
                        <div class="col-md-3">
                          <div class="form-group">
                            <input type="text" class="form-control" name="meals_surg[]" value="<?php echo $vit->meals_surg ?>" id="meal_surg" disabled="">
                            <input type="hidden" class="form-control" name="meals_surg[]" value="<?php echo $vit->meals_surg ?>" id="meal_surg">
                          </div>
                        </div>
                        <div class="col-md-3">
                          <div class="form-group">
                            <div class="input-group">
                              <input type="text" class="form-control" name="drug_notes_surg[]" value="<?php echo $vit->drug_notes_surg ?>" id="drug_note_surg" disabled="">
                              <input type="hidden" class="form-control" name="drug_notes_surg[]" value="<?php echo $vit->drug_notes_surg ?>" id="drug_note_surg">
                              <span class="input-group-addon">
                                <button type="button" class="btn btn-danger btn-xs remove_field_surg" id="remove_drug_surg">-</button>
                              </span>
                            </div>
                          </div>
                        </div>
                      </div>
                    <?php } ?>
                  </div>
                </div>
              </div>
            </div>



            <div class="form-group p-3">
              <label for="note">Prescription Note</label>
              <textarea class="form-control" name="note_con" id="note_con" rows="3"><?= $surgical->note_con ?></textarea>
            </div>

            <div class="row mt-2 p-3">
              <div class="col-12">
                <div class="form-group">
                  <button type="submit" class="btn btn-light btn-sm"><i class="fa fa-check-circle"></i> Save</button>
                  <button type="reset" class="btn btn-light btn-sm" id="clear"><i class="fa fa-times-circle" aria-hidden="true"></i> Clear</button>
                </div>
              </div>
            </div>



            <!-- <div class="row">
            <div class="col-12">
              <div class="panel panel-success">
                <div class="panel-heading">Prescription</div><br>
                <div class="row">
                  <div class="col-md-3">
                    <div class="form-group">
                      <label for="drugs">Select Drugs</label>
                      <input type="text" class="form-control drugs" name="drugs_ent" id="drugs_ent">
                    </div>
                  </div>
                  <div class="col-md-3">
                    <div class="form-group">
                      <label for="drugs">Doses</label>
                      <input type="text" class="form-control ent_doses_auto" name="drug_qty_ent" id="drug_qty_ent">
                    </div>
                  </div>
                  <div class="col-md-3">
                    <div class="form-group">
                      <label for="meal">Frequency</label><br>
                      <input type="text" class="form-control ent_frequency_auto" name="drug_meal_ent" id="drug_meal_ent">
                    </div>
                  </div>
                  <div class="col-md-3">
                    <div class="form-group">
                      <label for="drugs">Duration(Days)</label>
                      <div class="input-group">
                        <input type="text" class="form-control ent_duration_auto" name="drug_note_ent" id="drug_note_ent">
                        <span class="input-group-addon">
                          <button type="button" class="btn btn-light btn-xs add_field_button_ent" id="add_drug_ent">+</button>
                          <button type="button" class="btn btn-danger btn-xs clear_field_ent" id="clear_field_ent">x</button>
                        </span>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="input_fields_wrap_ent"></div>
              </div>
            </div>
          </div> -->
            <!-- <div class="form-group">
    <label for="note">Note</label>
    <textarea class="form-control" name="note_con" id="note_con" rows="3"></textarea>
  </div> -->


          </div>
        </div>


    </section>
    <?php require_once(APPPATH . "views/admin/footer.php"); ?>


</body>
<script>
  var counter = <?= count($episodes) + 1; ?>;
  var counter_vitals = <?= count(json_decode($surgical->surgery_vitals)) + 1; ?>;

  $(document).ready(function() {
    var procedureElements = document.querySelectorAll('.procedure');

    var procedureCount = procedureElements.length;

    for (var i = 0; i < procedureCount; i++) {
      var currentElement = procedureElements[i];
      var departmentId = currentElement.getAttribute('data-department');
      initTomSelectProcedres(currentElement, departmentId);
    }

    var diagnosisElements = document.querySelectorAll('.multi_diagnosis');
    var diagnosisCount = diagnosisElements.length;

    for (var i = 0; i < diagnosisCount; i++) {
      var currentElement = diagnosisElements[i];
      var departmentId = currentElement.getAttribute('data-department');
      initTomSelectDiagnosis(currentElement, departmentId);
    }

  });

  $('.drugs').on("focus", function() {
    $(this).autocomplete({
      source: function(request, response) {
        $.ajax({
          url: "<?= base_url('index.php/admin/Modules/Dermatology/DermatologyController/get_drugs'); ?>",
          dataType: "json",
          data: {
            name_startsWith: request.term,
            type: 'drug'
          },
          success: function(data) {
            response($.map(data, function(item) {
              return {
                label: item,
                value: item
              }
            }));
          }
        });
      },
      autoFocus: false,
      minLength: 2
    });
  });

  function initTomSelectProcedres(selector, departmentId) {
    var initTomSelecs = new TomSelect(selector, {
      valueField: 'id',
      labelField: 'name',
      searchField: 'name',
      load: function(query, callback) {
        var apiUrl = "<?php echo site_url('admin/CommenController/get_procedures?p=');
                      echo encrypt_and_url_encode($patient_id, $this) . '&' ?>t=" + departmentId + "&q=" + encodeURIComponent(query);

        fetch(apiUrl)
          .then(response => response.json())
          .then(data => {
            callback(data);
          })
          .catch(() => {
            callback();
          });
      },
      render: {
        option: function(item, escape) {
          return '<div>' +
            '<span class="btn btn-sm">' + escape(item.name) + '</span>' +
            '</div>';
        },
        item: function(item, escape) {
          return '<div>' +
            '<span class="btn  btn-sm">' + escape(item.name) + '</span>' +
            '</div>';
        }
      },
    });

    initTomSelecs.settings.minLength = 2;
  }

  function initTomSelectDiagnosis(selector, departmentId) {
    var multiDiagnosisSelect = new TomSelect(selector, {
      valueField: 'id',
      labelField: 'name',
      searchField: 'name',
      load: function(query, callback) {
        var apiUrl = "<?php echo site_url('admin/CommenController/get_diagnosis?'); ?>t=" + departmentId + "&q=" + encodeURIComponent(query);

        fetch(apiUrl)
          .then(response => response.json())
          .then(data => {
            callback(data);
          })
          .catch(() => {
            callback();
          });
      },
      render: {
        option: function(item, escape) {
          return '<div>' +
            '<span class="btn btn-sm">' + escape(item.name) + '</span>' +
            '</div>';
        },
        item: function(item, escape) {
          return '<div>' +
            '<span class="btn btn-sm">' + escape(item.name) + '</span>' +
            '</div>';
        }
      },
    });

    multiDiagnosisSelect.settings.minLength = 2;
  }
  var treatemnts_ent = $("#treatemnts_ent").DataTable({
    bFilter: false,
    paging: false,
    info: false,
  });

  $("#addRow_surgical").on("click", function() {
    // if($("#diagnosis_general").val() === "") {
    //      alert('Diagnosis is required.');
    //       return false;

    //   }

    if ($("#procedure_surgical").val() == "-1") {
      alert("Procedure is required.");
      return false;
    }

    var split_diagnosis = $("input[name=diagnosis_surgical]").val().split(",");
    var primary_diagnosis = $("input[name=diagnosis_surgical]").val().split(" - ");
    var diag_name = "";
    $.each(split_diagnosis, function(index, value) {
      if (value) {
        
        var temp = value.split(" - ");
        diag_name += temp[1] + ",";
      }
    });

    var split_treatment = $("select[name=procedure_surgical]").val().split(" | ");
    

    if ($("input[name=diagnosis_surgical]").val().indexOf("-") == -1) {
      var diagnosis =
        $("input[name=diagnosis_surgical]").val() +
        '<input type="hidden" name="general_diagnosis_name[]" value="' +
        $("input[name=diagnosis_surgical]").val() +
        '"><input type="hidden" name="general_diagnosis_id[]" value="">';
    } else {
      var diagnosis =
        diag_name +
        '<input type="hidden" name="general_diagnosis_name[]" value="' +
        diag_name +
        '"><input type="hidden" name="general_diagnosis_id[]" value="' +
        primary_diagnosis[0] +
        '">';
    }
    var treat_general =
      split_treatment[1] +
      '<input type="hidden" name="general_treatment_name[]" value="' +
      split_treatment[1] +
      '"><input type="hidden" name="general_treatment_id[]" value="' +
      split_treatment[0] +
      '">';

    treatemnts_ent.row
      .add([
        counter,
        diagnosis,
        treat_general,
        '<input type="hidden" name="orig_price_surgical[]" value="' +
        split_treatment[2] +
        '"><input type="text" size="7" name="discount_surgical[]" value="0" class="discount_general form-control">',
        '<input type="text" size="7" name="discount_per_surgical[]" value="0" class="discount_per_general form-control">',
        '<input type="text" name="fees_general[]" size="7" value="' +
        split_treatment[2] +
        '" class="fees_general form-control">',
        '<div class="text-center"><button type="button" class="btn btn-light deleteRow_general"><i class="fa fa-trash" aria-hidden="true"></i></button></div>',
      ])
      .draw();

    counter++;
  });

  $("body").on("click", ".deleteRow_general", function(e) {
    treatemnts_ent.row($(this).parents("tr")).remove().draw();
    return false;
  });

  //ent prescription
  var max_fields = 10; //maximum input boxes allowed
  var wrapper_ent = $(".input_fields_wrap_ent"); //Fields wrapper
  var add_button_ent = $(".add_field_button_ent"); //Add button ID

  var x = 1; //initlal text box count
  $(add_button_ent).on("click", function(e) {
    //on add input button click
    var drug = $("input[name=drugs_ent]").val().split(" - ");
    var drug_qty = $("input[name=drug_qty_ent]").val();
    var meal = $("input[name=drug_meal_ent]").val();
    var drug_note = $("input[name=drug_note_ent]").val();

    if ($('input[name=drugs_ent]').val().length === 0) {
      alert("Please select drugs");
      return false;
    }

    if ($("input[name=drugs_ent]").val().indexOf("-") == -1) {
      var diagnosis =
        '<input type="text" class="form-control drugs" name="drug[]" value="' +
        drug[0] +
        '" id="drugs" disabled>' +
        '<input type="hidden" class="form-control drugs" name="drug_name_ent[]" value="' +
        drug[0] +
        '"><input type="hidden" class="form-control drugs" name="drug_id_ent[]" value=""><input type="hidden" class="form-control drugs" name="bill_items_id_ent[]" value="" id="drugs">';
    } else {
      var diagnosis =
        '<input type="text" class="form-control drugs" name="drug[]" value="' +
        drug[1] +
        '" id="drugs" disabled>' +
        '<input type="hidden" name="drug_name_ent[]" value="' +
        drug[1] +
        '"><input type="hidden" name="drug_id_ent[]" value="' +
        drug[0] +
        '"><input type="hidden" class="form-control drugs" name="bill_items_id_ent[]" value="' +
        drug[2] +
        '" id="drugs">';
    }

    var treat =
      '<div class="row drug_details">\
          <div class="col-md-3">\
            <div class="form-group">' +
      diagnosis +
      '</div>\
          </div>\
          <div class="col-md-3">\
            <div class="form-group">\
               <input type="text" class="form-control" name="drugs_qty_ent[]" value="' +
      drug_qty +
      '" id="drug_qty_ent" disabled>\
               <input type="hidden" class="form-control" name="drugs_qty_ent[]" value="' +
      drug_qty +
      '" id="drug_qty_ent" >\
            </div>\
          </div>\
          <div class="col-md-3">\
            <div class="form-group">\
              <input type="text" class="form-control" name="meals_ent[]" value="' +
      meal +
      '" id="meal_ent" disabled>\
              <input type="hidden" class="form-control" name="meals_ent[]" value="' +
      meal +
      '" id="meal_ent">\
            </div>\
          </div>\
          <div class="col-md-3">\
            <div class="form-group">\
              <div class="input-group">\
                <input type="text" class="form-control" name="drug_notes_ent[]" value="' +
      drug_note +
      '" id="drug_note_ent" disabled>\
                <input type="hidden" class="form-control" name="drug_notes_ent[]" value="' +
      drug_note +
      '" id="drug_note_ent">\
                <span class="input-group-addon">\
                <button type="button" class="btn btn-danger btn-xs remove_field_ent" id="remove_drug_ent">-</button>\
                </span>\
              </div>\
            </div>\
        </div>\
      </div>';

    $(wrapper_ent).append(treat);

    var drug = $("input[name=drugs_ent]").val("");
    var drug_qty = $("input[name=drug_qty_ent]").val("");
    var drug_note = $("input[name=drug_note_ent]").val("");
    var drug_meal = $("input[name=drug_meal_ent]").val("");
    // var drug_meal = $('input[name=meal_ent]').prop('checked', false);

    return false;
  });

  $(wrapper_ent).on("click", ".remove_field_ent", function(e) {
    //user click on remove text
    $(this).closest(".drug_details").remove();
    return false;
  });

  $(".clear_field_ent").on("click", function(e) {
    var drug = $("input[name=drugs_ent]").val("");
    var drug_qty = $("input[name=drug_qty_ent]").val("");
    var drug_note = $("input[name=drug_note_ent]").val("");
    var drug_meal = $("input[name=meal_ent]").prop("checked", false);
    return false;
  });



  $('body').on('keyup', '.discount_general', function() {
    this_td = $(this).closest('td'),
      orig_price = $(this).prev('input').val(),
      dis_per_td = this_td.next('td');
    discount_per = $(dis_per_td).find('input').val(),
      fees_td = dis_per_td.next('td');
    fees = $(fees_td).find('input').val(),
      discount = Number($(this).val()).toFixed(2);

    dis_per_td.find('input').val(Number((discount * 100 / orig_price))); //discount_per
    fees_td.find('input').val(Number(orig_price - discount).toFixed(2)); //fees
  });

  $('body').on('keyup', '.discount_per_general', function() {
    this_td = $(this).closest('td'),
      dis_td = this_td.prev('td'),
      orig_price = $(dis_td).find('input').val(),
      discount = $(dis_td).find('input').next().val(),
      fees_td = this_td.next('td');
    fees = $(fees_td).find('input').val(),
      discount_per = Number($(this).val()).toFixed(2);

    dis_td.find('input').next().val(Number((discount_per * orig_price) / 100).toFixed(2)); //discount
    fees_td.find('input').val(Number(orig_price - (discount_per * orig_price / 100)).toFixed(2));
  });

  $('body').on('keyup', '.fees_general', function() {
    this_td = $(this).closest('td'),
      dis_per_td = this_td.prev('td');
    discount_per = $(dis_per_td).find('input').val(),
      dis_td = dis_per_td.prev('td'),
      orig_price = $(dis_td).find('input').val(),
      discount = $(dis_td).find('input').next().val(),
      fees = Number($(this).val()).toFixed(2);

    dis_td.find('input').next().val(Number(orig_price - fees).toFixed(2)); //discount
    dis_per_td.find('input').val(Number((1 - (fees / orig_price)) * 100).toFixed(2)); //discount_per
  });



  var vitals_surg = $("#vitals_surg").DataTable({
    bFilter: false,
    paging: false,
    info: false,
  });

  $("#addRow_vitals_surgical").on("click", function() {
    

    var split_diagnosis = $("input[name=diagnosis_vitals_surg]").val().split(",");
    var primary_diagnosis = $("input[name=diagnosis_vitals_surg]")
      .val()
      .split(" | ");
    var diag_name = "";
    $.each(split_diagnosis, function(index, value) {
      if (value) {
        var temp = value.split(" - ");
        diag_name += temp[1] + ",";
      }
    });

    var inputs = $(".vitals");
    var row = [];
    inputs.each(function() {
      var inputName = $(this).attr("name");
      row[inputName] = $(this).val();
    });
    row["bmi"] = $("#bmi").val();
    row["notes"] = $("#notes").val();

    const now = new Date();

    const hours = now.getHours();
    const minutes = now.getMinutes();
    const seconds = now.getSeconds();

    const currentTime = moment().format('HH:mm:ss');

    if ($("input[name=diagnosis_vitals_surg]").val().indexOf("-") == -1) {
      var diagnosis =
        $("input[name=diagnosis_vitals_surg]").val() +
        '<input type="hidden" name="surg_vitals_diagnosis_name[]" value="' +
        $("input[name=diagnosis_vitals_surg]").val() +
        '"><input type="hidden" name="surg_vitals_diagnosis_id[]" value="">';
    } else {
      var diagnosis =
        diag_name +
        '<input type="hidden" name="surg_vitals_diagnosis_name[]" value="' +
        diag_name +
        '"><input type="hidden" name="surg_vitals_diagnosis_id[]" value="' +
        primary_diagnosis[0] +
        '">';
    }

    vitals_surg.row
      .add([
        counter_vitals,
        currentTime + '<input type="hidden" name="time[]" value="' + currentTime + '">',
        row["pulse"] +
        '<input type="hidden" name="bp_1[]" value=' +
        row["bp_1"] +
        '><input type="hidden" name="bp_2[]" value=' +
        row["bp_2"] +
        ">",
        row["pulse"] +
        '<input type="hidden" name="pulse[]" value=' +
        row["pulse"] +
        ">",
        row["tempc"] +
        "ºC/" +
        row["tempf"] +
        'ºF<input type="hidden" name="tempc[]" value=' +
        row["tempc"] +
        '><input type="hidden" name="tempf[]" value=' +
        row["tempf"] +
        ">",
        row["grbs"] +
        '<input type="hidden" name="grbs[]" value=' +
        row["grbs"] +
        ">",
        row["rr"] + '<input type="hidden" name="rr[]" value=' + row["rr"] + ">",
        row["height"] +
        '<input type="hidden" name="height[]" value=' +
        row["height"] +
        ">",
        row["weight"] +
        '<input type="hidden" name="weight[]" value=' +
        row["weight"] +
        ">",
        row["bmi"] + '<input type="hidden" name="bmi[]" value=' + row["bmi"] + ">",
        row["saturation"] +
        '<input type="hidden" name="saturation[]" value=' +
        row["saturation"] +
        ">",
        diagnosis,
        row["notes"] +
        '<input type="hidden" name="notes[]" value=' +
        row["notes"] +
        ">",
        '<div class="text-center"><button type="button" class="btn btn-light deleteRow_vital"><i class="fa fa-trash" aria-hidden="true"></i></button></div>',
      ])
      .draw();
    counter_vitals++;
  });


  $("body").on("click", ".deleteRow_vital", function(e) {
    vitals_surg.row($(this).parents("tr")).remove().draw();
    return false;
  });

  $("body").on("click", ".deleteRow_surgical", function(e) {
    treatemnts_surg.row($(this).parents("tr")).remove().draw();
    return false;
  });

  //ent prescription
  var max_fields = 10; //maximum input boxes allowed
  var wrapper_surg = $(".input_fields_wrap_surg"); //Fields wrapper
  var add_button_surg = $(".add_field_button_surg"); //Add button ID

  var x = 1; //initlal text box count
  $(add_button_surg).on("click", function(e) {
    //on add input button click
    var drug = $("input[name=drugs_surg]").val().split(" - ");
    var drug_qty = $("input[name=drug_qty_surg]").val();
    var meal = $("input[name=drug_meal_surg]").val();
    var drug_note = $("input[name=drug_note_surg]").val();

    if ($("input[name=drugs_surg]").val().length === 0) {
      alert("Please select drugs");
      return false;
    }

    if ($("input[name=drugs_surg]").val().indexOf("-") == -1) {
      var diagnosis =
        '<input type="text" class="form-control drugs" name="drug[]" value="' +
        drug[0] +
        '" id="drugs" disabled>' +
        '<input type="hidden" class="form-control drugs" name="drug_name_surg[]" value="' +
        drug[0] +
        '"><input type="hidden" class="form-control drugs" name="drug_id_surg[]" value=""><input type="hidden" class="form-control drugs" name="bill_items_id_surg[]" value="" id="drugs">';
    } else {
      var diagnosis =
        '<input type="text" class="form-control drugs" name="drug[]" value="' +
        drug[1] +
        '" id="drugs" disabled>' +
        '<input type="hidden" name="drug_name_surg[]" value="' +
        drug[1] +
        '"><input type="hidden" name="drug_id_surg[]" value="' +
        drug[0] +
        '"><input type="hidden" class="form-control drugs" name="bill_items_id_surg[]" value="' +
        drug[2] +
        '" id="drugs">';
    }

    var treat =
      '<div class="row drug_details">\
            <div class="col-md-3">\
              <div class="form-group">' +
      diagnosis +
      '</div>\
            </div>\
            <div class="col-md-3">\
              <div class="form-group">\
                 <input type="text" class="form-control" name="drugs_qty_surg[]" value="' +
      drug_qty +
      '" id="drug_qty_surg" disabled>\
                 <input type="hidden" class="form-control" name="drugs_qty_surg[]" value="' +
      drug_qty +
      '" id="drug_qty_surg" >\
              </div>\
            </div>\
            <div class="col-md-3">\
              <div class="form-group">\
                <input type="text" class="form-control" name="meals_surg[]" value="' +
      meal +
      '" id="meal_surg" disabled>\
                <input type="hidden" class="form-control" name="meals_surg[]" value="' +
      meal +
      '" id="meal_surg">\
              </div>\
            </div>\
            <div class="col-md-3">\
              <div class="form-group">\
                <div class="input-group">\
                  <input type="text" class="form-control" name="drug_notes_surg[]" value="' +
      drug_note +
      '" id="drug_note_surg" disabled>\
                  <input type="hidden" class="form-control" name="drug_notes_surg[]" value="' +
      drug_note +
      '" id="drug_note_surg">\
                  <span class="input-group-addon">\
                  <button type="button" class="btn btn-danger btn-xs remove_field_surg" id="remove_drug_surg">-</button>\
                  </span>\
                </div>\
              </div>\
          </div>\
        </div>';

    $(wrapper_surg).append(treat);

    var drug = $("input[name=drugs_surg]").val("");
    var drug_qty = $("input[name=drug_qty_surg]").val("");
    var drug_note = $("input[name=drug_note_surg]").val("");
    var drug_meal = $("input[name=drug_meal_surg]").val("");
    // var drug_meal = $('input[name=meal_surg]').prop('checked', false);

    return false;
  });

  $(wrapper_surg).on("click", ".remove_field_surg", function(e) {
    //user click on remove text
    $(this).closest(".drug_details").remove();
    return false;
  });

  $(".clear_field_surg").on("click", function(e) {
    var drug = $("input[name=drugs_surg]").val("");
    var drug_qty = $("input[name=drug_qty_surg]").val("");
    var drug_note = $("input[name=drug_note_surg]").val("");
    var drug_meal = $("input[name=meal_surg]").prop("checked", false);
    return false;
  });

  $(document).ready(function() {
    jQuery(function() {
      weight = $('#weight');
      height = $('#height');
      bmi = $('#bmi');

      weight.on('input', function() {
        bmi.val((weight.val() / (height.val() * 2)).toFixed(2));
      })

      height.on('input', function() {
        bmi.val((weight.val() / (height.val() * 2)).toFixed(2));
      })
    });
  });
</script>

</html>