<!DOCTYPE html>
<html>

<head>
	<meta charset="UTF-8">
	<title>Patient</title>
	<meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>

	<!--image crop-->
	<link href="<?php echo base_url('plugins/croppie/croppie.css') ?>" rel="stylesheet" type="text/css" />
	<script src="<?php echo base_url('plugins/croppie/croppie.js') ?>" type="text/javascript"></script>
	<!-- <link href="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.css" rel="stylesheet" type="text/css" /> -->
	<!-- <script src="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.js"></script> -->

	<?php require_once(APPPATH . "views/admin/header.php"); ?>

	<style>
		hr {
			border-top: 1px solid #ddd !important;
			margin-bottom: 35px;
		}

		.uploadIcon {
			font-size: 5em !important;
			color: #084a6a;
		}

		@keyframes blink {
			0% {
				opacity: 0.5;
			}

			50% {
				opacity: 1;
			}

			100% {
				opacity: 0.5;
			}
		}

		.uploadLable {
			cursor: pointer;
			padding: 10px;
			cursor: pointer;
			animation: blink 1s infinite;
		}
	</style>

</head>


<body class="<?php echo $this->config->item('theme'); ?> fixed">
	<!-- Patient document upload modal -->
	<div class="modal fade" id="uploadPatientDocumentModal" tabindex="-1" role="dialog" aria-labelledby="uploadPatientDocumentModalLabel" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title" id="uploadPatientDocumentModalLabel">Upload New Document</h5>
					<button type="button" class="close" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					</button>
				</div>
				<div class="modal-body">
					<form id="fileUploadForm" class="text-center" enctype="multipart/form-data" action="<?php echo base_url('index.php/admin/Patients/PatientsController/uploadPatientDocuments') ?>" method="POST">
						<input type="hidden" name="patientId" value="<?= encrypt_and_url_encode($patient_id, $this) ?>">
						<i class="fa fa-cloud-upload uploadIcon" aria-hidden="true"></i>
						<div class="form-group">
							<label for="patientDocument" class="uploadLable">Choose a file</label>
							<?php if (form_error("patientDocument")) : ?>
								<br><label><small class="text-danger"><?= form_error("patientDocument"); ?></small></label>
								<script>
									$(document).ready(function() {
										$("#uploadPatientDocumentModal").modal("show");
									});
								</script>
							<?php endif; ?>
							<input type="file" class="form-control" name="patientDocument" id="patientDocument" accept=".pdf, .doc, .docx">
							<div class="form-group <?php echo form_error("documentName") ? "has-error" : "" ?>">
								<label for="document_name">Document Name</label>
								<input type="text" class="form-control" name="documentName" id="document_name" <?= $document_name; ?>>
								<label><small class="text-danger"><?= form_error("documentName"); ?></small></label>
							</div>
						</div>
					</form>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-light btn-sm" onclick="$('#fileUploadForm').submit()"><i class="fa fa-check-circle" aria-hidden="true"></i> Upload</button>
					<button type="button" class="btn btn-light btn-sm" data-dismiss="modal"><i class="fa fa-times-circle" aria-hidden="true"></i> Close</button>
				</div>
			</div>
		</div>
	</div>

	<!-- Site wrapper -->

	<!-- Header Navbar: style can be found in header.less -->
	<?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

	<!-- =============================================== -->

	<!-- Left side column. contains the sidebar -->
	<?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

	<!-- =============================================== -->

	<!-- Right side column. Contains the navbar and content of the page -->
	<div class="content-wrapper">
		<!-- Content Header (Page header) -->
		<section class="content-header">
			<h1>
				Patient <small style="color: #084a6a;" class="font-weight-bold"><?= $patient_name; ?> | since <?= $registerd_date; ?></small>
			</h1>
			<?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
		</section>

		<!-- Main content -->
		<section class="content">

			<div class="row">
				<div class="col-12">
					<div class="box box-solid">
						<div class="box-body">
							<div class="row">
								<div class="col-12">
									<div class="d-flex w-100 justify-content-between">
										<a href="<?php echo base_url('index.php/admin/Patients/PatientsController') ?>" class="btn btn-dark btn-sm"><i class="fa fa-chevron-circle-left" aria-hidden="true"></i> Go back</a>

										<?php
										$success = $this->session->flashdata('success');
										if ($success) { ?>
											<div class="col-md-9">
												<div class="callout <?php echo $this->config->item('msg_success'); ?> error-msg">
													<div>
														<span><i class="icon fa fa-check"></i><?= $success; ?></span>
													</div>
												</div>
											</div>
										<?php } ?>

										<button class="btn btn-dark btn-sm" id="generatePdf">
											<i class="fa fa-file-pdf-o mr-1" aria-hidden="true"></i> Generate PDF
										</button>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>

			<div class="row">
				<div class="col-12 col-md-8">
					<div class="row">
						<div class="col-12 col-md-8" id="print">
							<div class="box box-info" style="margin-bottom: 5px;">
								<div class="box-body">
									<div class="row">
										<div class="col-12">
											<h4>Patient Details</h4>
											<hr>
										</div>
									</div>
									<div class="row">
										<div class="col-12 col-md-6">
											<small><strong>
													<i class="fa fa-user-circle" aria-hidden="true"></i>
													Name</strong></small>
											<h4><?= $patient_name; ?></h4>
										</div>
										<div class="col-12 col-md-6">
											<small class="d-block"><strong>
													<i class="fa fa-calendar-check-o" aria-hidden="true"></i>
													Registration Date</strong></small>
											<span><?= $registerd_date; ?></span>
										</div>
									</div>

									<div class="row mt-2">
										<div class="col-12 col-md-6">
											<small class="d-block"><strong>
													<i class="fa fa-id-card" aria-hidden="true"></i>
													Qatar ID</strong></small>
											<span><?= $qatar_id; ?></span>
										</div>
										<div class="col-12 col-md-6">
											<small class="d-block"><strong>
													<i class="fa fa-id-card" aria-hidden="true"></i>
													Passport/Alternative Number</strong></small>
											<span><?= $passport_number; ?></span>
										</div>
									</div>

									<div class="row mt-2">
										<div class="col-12 col-md-6">
											<small class="d-block"><strong>
													<i class="fa fa-id-card-o" aria-hidden="true"></i>
													Guardian's ID</strong></small>
											<span><?= $guardian_id; ?></span>
										</div>
										<div class="col-12 col-md-6">
											<small class="d-block"><strong>
													<i class="fa fa-globe" aria-hidden="true"></i>
													Country of Residence </strong></small>
											<span><?= $country_name; ?></span>
										</div>
									</div>

									<div class="row mt-2">
										<div class="col-12 col-md-6">
											<small class="d-block"><strong>
													<i class="fa fa-birthday-cake" aria-hidden="true"></i>
													Date Of Birth</strong></small>
											<span><?= $dob; ?> (Age: <?= (new DateTime())->diff(new DateTime($dob))->y; ?>)</span>
										</div>
										<div class="col-12 col-md-6">
											<small class="d-block"><strong>
													<i class="fa fa-globe" aria-hidden="true"></i>
													Nationality</strong></small>
											<span><?= $nationality; ?></span>
										</div>
									</div>

									<div class="row mt-2">
										<div class="col-12 col-md-6">
											<small class="d-block"><strong>
													<i class="fa fa-mobile" aria-hidden="true"></i>
													Mobile Number</strong></small>
											<span><?= $mobile; ?></span>
										</div>
										<div class="col-12 col-md-6">
											<small class="d-block"><strong>
													<i class="fa fa-mobile" aria-hidden="true"></i>
													Second Mobile Number</strong></small>
											<span><?= $second_mobile; ?></span>
										</div>
									</div>

									<div class="row mt-2">
										<div class="col-12 col-md-6">
											<small class="d-block"><strong>
													<i class="fa fa-phone-square" aria-hidden="true"></i>
													Emergency Contact Number</strong></small>
											<span><?= $emergency_mobile; ?></span>
										</div>
										<div class="col-12 col-md-6">
											<small class="d-block"><strong>
													<i class="fa fa-envelope" aria-hidden="true"></i>
													Email</strong></small>
											<span><?= $email; ?></span>
										</div>
									</div>

									<div class="row mt-2">
										<div class="col-12 col-md-6">
											<small class="d-block"><strong>
													<i class="fa fa-location-arrow" aria-hidden="true"></i>
													Zone</strong></small>
											<span><?= $zone; ?></span>
										</div>
										<div class="col-12 col-md-6">
											<small class="d-block"><strong>
													<i class="fa fa-road" aria-hidden="true"></i>
													Street</strong></small>
											<span><?= $street; ?></span>
										</div>
									</div>

									<div class="row mt-2">
										<div class="col-12 col-md-6">
											<small class="d-block"><strong>
													<i class="fa fa-building" aria-hidden="true"></i>
													Building</strong></small>
											<span><?= $building; ?></span>
										</div>
										<div class="col-12 col-md-6">
											<small class="d-block"><strong>
													<i class="fa fa-medkit" aria-hidden="true"></i>
													Insurance Type </strong></small>
											<span><?= $insurance_name; ?></span>
										</div>
									</div>

									<div class="row mt-2">
										<div class="col-12 col-md-6">
											<small class="d-block"><strong>Category</strong></small>
											<span><?= $category; ?></span>
										</div>
										<div class="col-12 col-md-6">
											<small class="d-block"><strong>
													<i class="fa fa-male" aria-hidden="true"></i>
													<i class="fa fa-female" aria-hidden="true"></i>
													Gender</strong></small>
											<span><?= $sex; ?></span>
										</div>
									</div>

									<div class="row mt-2">
										<div class="col-12 col-md-6">
											<small class="d-block"><strong>
													<i class="fa fa-diamond" aria-hidden="true"></i>
													Marital Status</strong></small>
											<span><?= $marital; ?></span>
										</div>
										<div class="col-12 col-md-6">
											<small class="d-block"><strong>
													<i class="fa fa-ban" aria-hidden="true"></i>
													Black List</strong></small>
											<span><?= (int)$black ? '<span class="badge badge-danger">Yes</span>' : '<span class="badge badge-success">No</span>'; ?></span>
										</div>
									</div>

									<div class="row mt-2">
										<div class="col-12">
											<hr>
											<small class="d-block"><strong>
													<i class="fa fa-sticky-note" aria-hidden="true"></i>
													Note</strong></small>
											<span><?= $note; ?></span>
										</div>
									</div>

								</div>
							</div>
						</div>
						<div class="col-12 col-md-4">
							<div class="row">
								<div class="box box-info" style="margin-bottom: 5px;">
									<div class="box-body">
										<div class="row">
											<div class="col-12">
												<h4>Last Measurements</h4>
												<hr>
											</div>
										</div>
										<div class="row pl-3">
											<div class="col-12">
												<table>
													<?php if(isset($triage[0])){ ?>
													<tr>
														<td>
															<i class="fa fa-heartbeat mr-3 text-success" aria-hidden="true"></i>
														</td>
														<td>
															<strong class="mr-3"><?= $triage[0]['bp']?></strong>
														</td>
														<td>
															<span class="text-muted">b.p.m</span>
														</td>
													</tr>
													<tr>
														<td>
															<i class="fa fa-heart text-danger" aria-hidden="true"></i>
														</td>
														<td>
															<strong class="mr-3"><?= $triage[0]['pulse']?></strong>
														</td>
														<td>
															<span class="text-muted">mmHg</span>
														</td>
													</tr>
													<tr>
														<td>
															<i class="fa fa-balance-scale text-primary" aria-hidden="true"></i>
														</td>
														<td>
															<strong class="mr-3"><?= $triage[0]['weight']?></strong>
														</td>
														<td>
															<span class="text-muted">kg</span>
														</td>
													</tr>
													<tr>
														<td>
															<i class="fa fa-arrows-v" aria-hidden="true"></i>
														</td>
														<td>
															<strong class="mr-3"><?= $triage[0]['height']?></strong>
														</td>
														<td>
															<span class="text-muted">cm</span>
														</td>
													</tr>
													<?php } ?>
												</table>
											</div>
										</div>

									</div>
								</div>
							</div>
							<div class="row">
								<div class="box box-info" style="margin-bottom: 5px;">
									<div class="box-body">
										<div class="row">
											<div class="col-12">
												<h4>Patient Statistic</h4>
												<select name="" id="" class="form-control form-control-sm">
													<?php
													$currentYear = (int)date('Y');
													for ($i = $currentYear; $i >= ($currentYear - 10); $i--) :
													?>
														<option value="<?= $i ?>"><?= $i ?></option>
													<?php endfor; ?>
												</select>
												<hr>
											</div>
										</div>
										<div class="row pl-3">
											<div class="col-12">
												<!-- <canvas id="donutChart" style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas> -->
												<canvas id="donutChart" width="250" height="250"></canvas>
											</div>
										</div>

									</div>
								</div>
							</div>
						</div>
					</div>

					<div class="row">
						<div class="col-12">
							<div class="box box-info" style="margin-bottom: 5px;">
								<div class="box-body">
									<div class="row">
										<div class="col-12">
											<div class="d-flex justify-content-between">
												<h4>File & Documents</h4>
												<button class="btn btn-dark btn-sm" id="uploadDocumentBtn" data-toggle="modal" data-target="#uploadPatientDocumentModal">
													<i class="fa fa-cloud-upload" aria-hidden="true"></i> Upload New Documents
												</button>
											</div>
											<hr>
											<div class="row">
												<?php foreach ($documents as $document) : ?>
													<?php
													$uploadPath = './'.UPLOAD_PATH.'' . md5($document->patient_id);
													$filePath = $uploadPath . '/' . $document->document;
													$fileExtension = (pathinfo($filePath, PATHINFO_EXTENSION));
													$preview = null;
													switch ($fileExtension) {
														case 'pdf':
															$preview = '<i class="fa fa-file-pdf-o text-danger mr-2" style="font-size:1.5em;" aria-hidden="true"></i>';
															break;

														case 'docx':
														case 'doc':
															$preview = '<i class="fa fa-file-word-o text-primary mr-2" style="font-size:1.5em;" aria-hidden="true"></i>';
															break;

														case 'txt':
															$preview = '<i class="fa fa-file-text mr-2" style="font-size:1.5em;" aria-hidden="true"></i>';
															break;

														case 'xlsx':
														case 'csv':
															$preview = '<i class="fa fa-file-excel-o text-success mr-2" style="font-size:1.5em;" aria-hidden="true"></i>';
															break;

														case 'jpg':
														case 'jpeg':
														case 'png':
														case 'gif':
															$preview = '<i class="fa fa-file-image-o mr-2 text-warning" style="font-size:1.5em;" aria-hidden="true"></i>';
															break;

														default:
															$preview = "File type not supported.";
															break;
													}

													?>
													<div class="col-sm-3 mt-1">
														<div class="card">
															<div class="card-body">
																<h6 class="card-title"><?= $preview; ?><?= $document->name; ?></h6>
																<a href="<?= base_url('index.php/admin/Patients/PatientsController/downloadFile/' . encrypt_and_url_encode($document->patient_id, $this) . '/' . $document->document) ?>" class="btn btn-light btn-sm" target="_blank "><i class="fa fa-cloud-download" aria-hidden="true"></i> Download</a>
															</div>
														</div>
													</div>
												<?php endforeach; ?>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>

				<div class="col-12 col-md-4">
					<div class="box box-info" style="margin-bottom: 5px;">
						<div class="box-body">
							<div class="row">
								<div class="col-12">
									<h4>Last Visits</h4>
									<hr>
								</div>
							</div>

							<div class="row p-2">
								<div class="col-md-12" style="    max-height: 60vh;overflow-y: auto;overflow-x: hidden;">
									<?php foreach($visits as $row) : ?>
										<div class="row mt-1">
											<div class="col-12">
												<div class="border rounded p-2">
													<h6>#<?= date('Y', strtotime($row->treat_date)) ?></h6>
													<table class="w-100">
														<tbody>
															<tr>
																<td><strong>Doctor</strong></td>
																<td><span><?=$row->full_name?></span></td>
																<td><strong>Time</strong></td>
																<td><span><?=$row->treat_date?></span></td>
															</tr>
															<tr>
																<td><strong>Total</strong></td>
																<td><span><?=$row->total?></span></td>
																<td><strong>Department</strong></td>
																<td><span><?=$row->total?></span></td>
															</tr>
															<tr>
																<td><strong>Date</strong></td>
																<td class="text-left"><span><?= date('d/m/Y', strtotime($row->treat_date)) ?></span></td>
															</tr>
														</tbody>
													</table>
												</div>
											</div>
										</div>
									<?php endforeach; ?>
								</div>
							</div>

						</div>
					</div>
				</div>
			</div>


		</section>

	</div>

	<!-- ./wrapper -->


	<?php require_once(APPPATH . "views/admin/footer.php"); ?>


</body>

</html>

<script>
	$(document).ready(function() {});
	var donutChartCanvas = $('#donutChart').get(0).getContext('2d');
	var donutData = {
		labels: ['Visits', 'Treatments', 'Paid', 'Pending Paiments'],
		datasets: [{
			data: [700, 500, 400, 600],
			backgroundColor: ['#f56954', '#00a65a', '#f39c12', '#00c0ef'],
		}]
	};
	var donutOptions = {
		maintainAspectRatio: false,
		responsive: true,
	};
	var donutChart = new Chart(donutChartCanvas, {
		type: 'doughnut',
		data: donutData,
		options: donutOptions
	});
</script>

<script src="https://cdn.jsdelivr.net/npm/dompurify@2.3.3/dist/purify.min.js"></script>
<script src="https://html2canvas.hertzen.com/dist/html2canvas.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script>
	function generatePDF() {
		window.jsPDF = window.jspdf.jsPDF;
		const pdf = new jsPDF('p', 'pt', 'a4');

		const content = document.getElementById('print');
		const removeElements = content.getElementsByTagName('i');

		for (i = 0; i < removeElements.length; i++) {
			//removeElements[i].removeAttribute('class');
			removeElements[i].style.display = 'none';
		}

		pdf.html(content, {
			callback: function(pdf) {
				pdf.save('<?= str_replace(' ', '_', strtolower($patient_name)) . date('Ymdhis'); ?>.pdf');

				for (i = 0; i < removeElements.length; i++) {
					removeElements[i].style.display = 'inline-block';
				}
			}
		});

	}
	document.getElementById('generatePdf').addEventListener('click', generatePDF);
</script>