<?php

  if ($profile != FALSE) {
    foreach ($profile as $row) {
      $gender = $row['sex'];
      $insurance_id = $row['insurance_type_id'];
    }
  }
?>

<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="apple-touch-icon" sizes="57x57" href="<?php echo IMG.'/favicon/apple-icon-57x57.png';?>">
    <link rel="apple-touch-icon" sizes="60x60" href="<?php echo IMG.'/favicon/apple-icon-60x60.png';?>">
    <link rel="apple-touch-icon" sizes="72x72" href="<?php echo IMG.'/favicon/apple-icon-72x72.png';?>">
    <link rel="apple-touch-icon" sizes="76x76" href="<?php echo IMG.'/favicon/apple-icon-76x76.png';?>">
    <link rel="apple-touch-icon" sizes="114x114" href="<?php echo IMG.'/favicon/apple-icon-114x114.png';?>">
    <link rel="apple-touch-icon" sizes="120x120" href="<?php echo IMG.'/favicon/apple-icon-120x120.png';?>">
    <link rel="apple-touch-icon" sizes="144x144" href="<?php echo IMG.'/favicon/apple-icon-144x144.png';?>">
    <link rel="apple-touch-icon" sizes="152x152" href="<?php echo IMG.'/favicon/apple-icon-152x152.png';?>">
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo IMG.'/favicon/apple-icon-180x180.png';?>">
    <link rel="icon" type="image/png" sizes="192x192"  href="<?php echo IMG.'/favicon/android-icon-192x192.png';?>">
    <link rel="icon" type="image/png" sizes="32x32" href="<?php echo IMG.'/favicon/favicon-32x32.png';?>">
    <link rel="icon" type="image/png" sizes="96x96" href="<?php echo IMG.'/favicon/favicon-96x96.png';?>">
    <link rel="icon" type="image/png" sizes="16x16" href="<?php echo IMG.'/favicon/favicon-16x16.png';?>">
    <link rel="manifest" href="/manifest.json">
    <meta name="msapplication-TileColor" content="#ffffff">
    <meta name="msapplication-TileImage" content="/ms-icon-144x144.png">
    <meta name="theme-color" content="#ffffff">
    <title>Billing</title>
    <link rel="icon" href="<?php echo IMG.'/favicon.ico';?>">
    <!-- Bootstrap -->
    <link href="<?php echo CSS.'/bootstrap.css';?>" rel="stylesheet">
    <!-- Auto Complete -->
    <link href="<?php echo CSS.'/jquery-ui.min.css';?>" rel="stylesheet">
    <!-- Table Data-->
    <link href="<?php echo LIB.'/dataTables/dataTables.bootstrap.css';?>" rel="stylesheet">
    <!-- Custom -->
    <link href="<?php echo CSS.'/custom.css';?>" rel="stylesheet">
    <style type="text/css">
      .ui-autocomplete {
        max-height: 100px;
        overflow-y: auto;
        /* prevent horizontal scrollbar */
        overflow-x: hidden;
         z-index: 5000;
      }
    </style>
  </head>
  <body>
    <!-- Fixed navbar -->
    <?php include('nav_bar.php'); ?>

    <div class="container theme-showcase" role="main">
      <div class="jumbotron" style="background-color:#9CD0E8;">
      <!-- login plate -->
          <?php include('login_plate.php') ?>

        <h4 class="page-header ui-page-header">Billing</h4>
          <!-- Chart -->
          <form id="myForm"  action="<?php $this->load->helper('url'); echo site_url('payment/bill_make'); ?>" method="post">
          <div class="row">
            <div class="col-md-12">
              <div class="panel panel-default">
                <div class="panel-body">
                  <input type="hidden" name="patient_id" value="<?php echo $patient_id; ?>">
                  <div class="input_fields_wrap_procedure">
                    <div class="row">
                      <div class="col-md-8">   

                      <div class="form-group">
                        <label for="doctor_id">Select Department</label>
                        <select class="form-control" name="dept_id" id="dept_id">
                          <option value="-1">Choose</option>
                          <option value="1">Dental</option>
                          <option value="2">Derma</option>
                          <option value="11">ENT</option>
                          <!--<option value="7">General Medical</option>-->
                          <!--<option value="8">Gynecology</option>-->
                          <option value="9">Laboratory</option>
                          <option value="4">Plastic Surgery</option>
                        </select>                    
                      </div>


                      <div class="form-group">
                        <label for="doctor_id">Select Doctor</label>
                        <select class="form-control" name="doctor_id" id="doctor_id">
                          <option value="-1">Choose</option>
                          <?php if ($doctor_list != FALSE) {
                          foreach ($doctor_list as $value) {
                          ?>   
                               <option value="<?php echo $value['doctor_id']; ?>"><?php echo $value['employee_name'].' ( '.$value['professional_type'].' )';?></option>
                          <?php }}else{ ?>
                               <option>Records Not Found</option>
                          <?php }?>
                        </select>                    
                      </div>




                        <div class="form-group">
                          <label for="lab_test">Price list</label>
                          <div class="input-group">
                            <input type="text" class="form-control procedures" name="billing_list" id="billing_list">
                                   <input type="hidden" class="form-control ss" name="check" value="0" >
                              <span class="input-group-addon">
                                <button type="button" class="btn btn-success btn-xs add_field_button_billing" id="add_drug">+</button>
                              </span>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div> 

    <div class="row">
        <div class="col-xs-12">
          <div class="panel panel-primary">
            <div class="panel-heading">Treatment List</div>
            <table class="table table-hover display table-striped orig" id="treatments_billing_list" width="100%">
              <thead>
                <tr>
                  <td></td>
                  <td>Procedure</td>
                  <td width="10%">Discount(QR)</td>
                  <td width="10%">Discount(%)</td>
                  <td width="10%">Fees</td>
                </tr>
              </thead>
            </table>
          </div>
        </div>
      </div>
<div class="row">
  <div class="col-xs-11" style="text-align: right">
    <label>GROSS AMOUNT : </label>
  </div>
  <div class="col-xs-1">
    <strong id="gross_amount">0.00</strong>
  </div>
</div>
<div class="row">
  <div class="col-xs-11" style="text-align: right">
    <label>DISCOUNT : </label>
  </div>
  <div class="col-xs-1">
    <strong id="discount_amount">0.00</strong>
  </div>
</div>
<div class="row">
  <div class="col-xs-11" style="text-align: right">
    <label>NET AMOUNT : </label>
  </div>
  <div class="col-xs-1">
    <strong id="net_amount">0.00</strong>
  </div>
</div>



                        <button type="submit" class="btn btn-default btn-primary" id="invoice">Make Invoice</button>
                </div>
              </div>
            </div>
          </div>
        </form>
      </div>
    </div>

    <!-- jQuery (necessary for Bootstrap's JavaScript plugins) -->
    <!--<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>-->
    <script src="<?php echo JS.'/jquery-2.1.1.min.js';?>"></script>
    <!-- Include all compiled plugins (below), or include individual files as needed -->
    <script src="<?php echo JS.'/bootstrap.min.js';?>"></script>    
    <!-- Auto Complete Ajax-->
    <script src="<?php echo JS.'/jquery-ui.min.js';?>"></script>
    <script src="<?php echo JS.'/jquery.autocomplete.multiselect.js';?>"></script>
    <!-- Data Table -->
    <script src="<?php echo(LIB.'/dataTables/jquery.dataTables.js'); ?>"></script>
    <script src="<?php echo(LIB.'/dataTables/dataTables.bootstrap.js'); ?>"></script>
    <script type="text/javascript">

      $('.procedures').on("focus", function(){
            $(this).autocomplete({
                source: function( request, response ) {
                  $.ajax({
                    url : "<?php $this->load->helper('url'); echo site_url('doctor_process/get_procedures_billing'); ?>",
                    dataType: "json",
                data: {
                   name_startsWith: request.term,
                   type: 'diagnosis',
                   gender: '<?php echo $gender; ?>',
                   insurance_id: '<?php echo $insurance_id; ?>'
                },
                success: function( data ) {
                   response( $.map( data, function( item ) {
                    return {
                      label: item,
                      value: item
                    }
                  }));
                }
                  });
                },
                autoFocus: false,
                minLength: 1        
          });
        });


        $('#myForm').submit(function () {
          if($('#treatments_billing_list tr').parent().siblings(":first").text() == "No data available in table"){
            alert("Add treatment details");
            return false;
          }else{
            $(this).submit();
          }
        });

var counter = 1;
  var a = $('#treatments_billing_list').DataTable({"bFilter": false, "paging": false, "info":false});
 var add_button_billing      = $(".add_field_button_billing"); 

 $(add_button_billing).on('click', function(e){
    
     
    var split_treatment = $('input[name=billing_list]').val().split(' | ');
   
     var treat_billing = split_treatment[1]+'<input type="hidden" name="billing_treatment_name[]" value="'+split_treatment[1]+'"><input type="hidden" name="billing_treatment_id[]" value="'+split_treatment[3]+'">';

      a.row.add( [
          '<button type="button" class="btn btn-danger btn-xs deleteRow_tre_billing">x</button>',
          // diagnosis,
          treat_billing,
         '<input type="hidden" name="orig_price_billing[]" value="'+split_treatment[2]+'" class="orig_price_lab"><input type="text" size="7" name="discount_billing[]" value="0" class="discount_billing discount_lab">',
          '<input type="text" size="7" name="discount_per_billing[]" value="0" class="discount_per_billing discount_per_lab">',
          '<input type="text" name="fees_billing[]" size="7" value="'+split_treatment[2]+'" class="fees_billing fees_lab">'
       ] )

      .draw();

      counter++;
      $('#billing_list').val("");
      calcu_fee();
  });

  $('body').on("click",".deleteRow_tre_billing", function(e){
     a.row($(this).parents('tr')).remove().draw();
     calcu_fee();
     return false;
  });

  $('#bl_button').click(function() {
    if($('#billing_list').val()!=""){
      alert("Please click the + button to save billing");
      return false;
    }
    if( $("input[name='billing_treatment_id[]']").length === 0 ){
      alert("Please Add Billing");
      return false;
    }
    $('#billing_form').submit();
  });

function calcu_fee(){
  var total_gross=0;
  var total_discount=0;
  var total_fees=0;
    $('.orig_price_lab').each(function() {     
      total_gross += parseFloat($(this).val());                     
    }); 
    $('.discount_lab').each(function() {     
      total_discount += parseFloat($(this).val());                     
    });
    $('.fees_lab').each(function() {     
      total_fees += parseFloat($(this).val());                     
    });
  $('#gross_amount').html(total_gross.toFixed(2));
  $('#discount_amount').html(total_discount.toFixed(2));
  $('#net_amount').html(total_fees.toFixed(2));
}

$('body').on('keyup', '.discount_billing', function () {
    this_td = $(this).closest('td'),
    orig_price = $(this).prev('input').val(),
    dis_per_td = this_td.next('td');
    discount_per = $(dis_per_td).find('input').val(),
    fees_td = dis_per_td.next('td');
    fees = $(fees_td).find('input').val(),
    discount = Number($(this).val()).toFixed(2);

    dis_per_td.find('input').val(Number((discount * 100 / orig_price))); //discount_per
    fees_td.find('input').val(Number(orig_price - discount).toFixed(2)); //fees
    calcu_fee();
});

$('body').on('keyup', '.discount_per_billing', function () {
    this_td = $(this).closest('td'),
    dis_td = this_td.prev('td'),
    orig_price = $(dis_td).find('input').val(),
    discount = $(dis_td).find('input').next().val(),
    fees_td = this_td.next('td');
    fees = $(fees_td).find('input').val(),
    discount_per = Number($(this).val()).toFixed(2);

    dis_td.find('input').next().val(Number((discount_per * orig_price) / 100).toFixed(2)); //discount
    fees_td.find('input').val(Number(orig_price - (discount_per * orig_price / 100)).toFixed(2));
    calcu_fee();
});

$('body').on('keyup', '.fees_billing', function () {
    this_td = $(this).closest('td'),
    dis_per_td = this_td.prev('td');
    discount_per = $(dis_per_td).find('input').val(),
    dis_td = dis_per_td.prev('td'),
    orig_price = $(dis_td).find('input').val(),
    discount = $(dis_td).find('input').next().val(),
    fees = Number($(this).val()).toFixed(2);

    dis_td.find('input').next().val(Number(orig_price - fees).toFixed(2)); //discount
    dis_per_td.find('input').val(Number((1 - (fees / orig_price)) * 100).toFixed(2)); //discount_per
    calcu_fee();
});
    </script>
  </body>
</html>