<div class="row">
            <div class="col-md-12">
              <div class="panel panel-info">
                <div class="panel-heading">
                  <h4 class="panel-title">Sale Refund Report</h4>
                </div>
                <form  id="profit_report" method="post">
                  <div class="panel-body">
                    <div class="row">
                      
							
                            <div class="col-md-3">
                        <div class="form-group">
                          <label class="from" for="from">From</label>
                          <label class="date" for="date">Date</label>
                          <input type="date" class="form-control" name="from" id="from">
                        </div>
                        
                        </div>
                        <div class="col-md-3">
                        <div class="form-group">
                          <label for="to">To</label>
                          <input type="date" class="form-control" name="to" id="to">
                        </div>
                            </div>
                      </div>
                    </div>
                   
                    <button type="reset" class="btn  btn-dark hidden-print" id="clear">Clear</button>
                  </div>
                </form>
              </div>
            </div>

</div>
<div class="row mt-5" >
    <div class="col-md-12 mx-auto">
        <table id="p_report" class="table table-light table-bordered table-striped">
                
		
		<tfoot>
    <tr>
        <th></th>
        <th></th>
        <th></th>
        <th></th>
        <th></th>
        <th></th>
      
       
    </tr>
</tfoot>
        </table>
        </div>
</div>

<script>

function displayContent() {
        var dateFrom = $('#from').val();
        var dateTo = $('#to').val();
        console.log(dateFrom);
        var suppliers = $('#suppliers').val();
        $.ajax({
            url: "<?php $this->load->helper('url'); echo site_url('/admin/Reports/ReportsController/get_p_expiring_report'); ?>",
            type: 'post',
            data: {from:dateFrom, to:dateTo, suppliers:suppliers},
            success: function (result) {
                 $('#content').html(result);
            },
        });
     }
     $(document).ready(function() {
		// Initialize the DataTable
		dataTable = $('#p_report').DataTable({
			dom: 'lBfrtip',
			buttons: [{
				extend: 'excel',
				title: `Sale Refund Report`
			}, {
				extend: 'print',
				autoPrint: true,
				title: `Sale Refund Report`,
				exportOptions: {
					columns: ':not(:last-child)'
				},
				customize: function(win) {
					$(win.document.body).prepend(`<?php print_header($this); ?>`);
				}
			}, ],
			'ajax': {
				'url': '<?= site_url('admin/Reports/ReportsController/get_p_refund_report'); ?>',
				'type': 'POST',
				'data': function(d) {
					
					d.from = $('#from').val();
					d.to = $('#to').val();
					
				}
			},
			'columns': [
			
				
				{ "data": "return_sale_id", "title": "Refund No." },
				{ "data": "drug_name", "title": "Drug Name" },
				{ "data": "return_date", "title": "Date" },
				{ "data": "qty", "title": "Quantity" },
               
                { "data": "loos_price", "title": "Sell" },
                { "data": "price", "title": "Total Amount" },
			
				
			],
			'footerCallback': function(row, data, start, end, display) {
        var api = this.api();

	
	

				
          totalCredit = api
                .column(5, { page: 'current'} )
                .data()
                .sum();

	
        $(api.column(5).footer() ).html(
        "<h5>Total Amount : <b>"+ totalCredit + "</b></h5>");

    },
					
			'searching': false,
			'serverSide': true,
			'pageLength': 10,
			aLengthMenu: [
				[25, 50, 100, 200, -1],
				[25, 50, 100, 200, "All"]
			],
			
			footer:true,
			autoWidth: false

		});



		$('#from,#to ').on('change', function() {
			dataTable.ajax.reload();
		});
        $('#clear').on('click', function() {
            $('#profit_report').trigger("reset");
			dataTable.ajax.reload();
		});
	});


</script>