<div class="row">
            <div class="col-md-12">
              <div class="panel panel-info">
                <div class="panel-heading">
                  <h4 class="panel-title">Store Report</h4>
                </div>
                <form  method="post" id="expire_report">
                  <div class="panel-body">
                    <div class="row">
                      <div class="col-md-4">
                        <div class="form-group">
                          <label>Select Drug</label>
                          <select class="form-control" id="drug">
                          <option value="-1">All</option>
                            <?php if(isset($drugs) AND $drugs != NULL){ foreach($drugs as $val){ ?>
                                <option value="<?php echo $val['drug_id']; ?>"><?php echo $val['drug_name']; ?></option>
                            <?php }} ?>
                          </select>
                        </div>
						</div>
						<div class="col-md-4">
                        <div class="form-group">
                          <label class="from" for="from">From</label>
                          <label class="date" for="date">Date</label>
                          <input type="date" class="form-control" name="from" id="from">
                        </div>
							</div>
						<div class="col-md-4">
                        <div class="form-group">
                          <label for="to">To</label>
                          <input type="date" class="form-control" name="to" id="to">
                        </div>
						</div>
                     
                    </div>
                    
                    <button type="reset" class="btn btn-dark  hidden-print" id="clear">Clear</button>
                  </div>
                </form>
              </div>
            </div>

</div>
<div class="row mt-5" >
    <div class="col-md-12 mx-auto">
        <table id="p_report" class="table table-light table-bordered table-striped">
                        
        </table>
        </div>
</div>

<script>

     $(document).ready(function() {
		// Initialize the DataTable
		dataTable = $('#p_report').DataTable({
			dom: 'lBfrtip',
			buttons: [{
				extend: 'excel',
				title: `Store Report`
			}, {
				extend: 'print',
				autoPrint: true,
				title: `Store Report`,
				exportOptions: {
					columns: ':not(:last-child)'
				},
				customize: function(win) {
					$(win.document.body).prepend(`<?php print_header($this); ?>`);
				}
			}, ],
			'ajax': {
				'url': '<?= site_url('admin/Reports/ReportsController/get_drugs_list'); ?>',
				'type': 'POST',
				'data': function(d) {
					d.drug = $('#drug').val();
					d.from = $('#from').val();
					d.to = $('#to').val();
				}
			},
			'columns': [
				{
            'data': 'bill_id',
            'title': 'Bill No.',
            'render': function(data, type, row, meta) {
                return '<a href="PharmacyController/receive_bill_view_print/' + data + '" target="_blank">' + data + '</a>';
            }
        },
				{
					'data': 'batch',
					'title': 'Batch No'
				},
				{
					'data': 'x_date',
					'title': 'Bill Date.'
				},
				{
					'data': 'drug_name',
					'title': 'Drug Name.'
				},
				{
					'data': 'receive_quantity',
					'title': 'Quantity'
				},
				{
					'data': 'cost',
					'title': 'Cost'
				},
				{
					'data': 'bonus',
					'title': 'Bonus'
				},
				{
					'data': 'unit_type',
					'title': 'Unit Type'
				},
				{
					'data': 'amount',
					'title': 'Amount'
				},
				
			],
			'searching': false,
			'serverSide': true,
			'pageLength': 10,
			aLengthMenu: [
				[25, 50, 100, 200, -1],
				[25, 50, 100, 200, "All"]
			],
			'pagingType': 'full_numbers',
			footer:true,
			autoWidth: false

		});



		$('#drug, #from,#to ').on('change', function() {
			dataTable.ajax.reload();
		});
        $('#clear').on('click', function() {
            $('#store_report').trigger("reset");
			dataTable.ajax.reload();
		});
	});


</script>