<?php
//--------------------------------------======================+
// File name   : example_001.php
// Begin       : 2008-03-04
// Last Update : 2013-05-14
//
// Description : Example 001 for TCPDF class
//               Default Header and Footer
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Nicola Asuni
//               Tecnick.com LTD
//               www.tecnick.com
//               info@tecnick.com
//--------------------------------------======================+

/**
 * Creates an example PDF TEST document using TCPDF
 * @package com.tecnick.tcpdf
 * @abstract TCPDF - Example: Default Header and Footer
 * @author Nicola Asuni
 * @since 2008-03-04
 */

// Include the main TCPDF library (search for installation path).
require_once('././tcpdf_new/tcpdf.php');

// Extend the TCPDF class to create custom Header and Footer
class MYPDF extends TCPDF {

    //Page header
    // public function Header() {
    //     // Logo
        
    //     // Set font
    //     $this->SetY(15);
    //     $this->SetFont('helvetica', '', 8);
    //     // Title
    //     $this->Cell(0, -10, '', 100, false, 'C', 0, '', 100, false, 'T', 'M');
    // }
    public function Footer() {
        // Position at 15 mm from bottom
        $this->SetY(-15);
        // Set font
        $this->SetFont('helvetica', 'I', 8);
        // Page number
        $this->Cell(0, 10, 'Page '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }

}
$ctr=0;
foreach ($sell_items as $value) {
  $ctr++;
}
$height = 95;
$new_height = $height+($ctr*5);

// create new PDF document
$custom_layout = array('73', $new_height);
// $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, $custom_layout, true, 'UTF-8', false);
$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);




$pdf->AddPage();


$pdf->SetFont('aealarabiya', '', 8);
date_default_timezone_set('Asia/Kuwait');
$date = date('d/m/Y');
$time = date('h:i:s A');

// Arabic and English content
// $htmlcontent2 = '<span color="#0000ff">This is Arabic "العربية" Example With TCPDF.</span>';
// $pdf->WriteHTML($htmlcontent2, true, 0, true, 0);

$date = date('d/m/Y');
$time = date('h:i:s A');
$query = $this->db->query("SELECT *,sh_receive_bill_items.quantity as qty
FROM sh_receive_bill_items
LEFT JOIN sh_drugs
ON sh_receive_bill_items.item_id = sh_drugs.drug_id
WHERE bill_id = $bill_id");
$result =  $query->result_array();


$tbl = '
<div class=" row">
<div class="col-md-4">
  <b>Bill No : </b>'. $bill[0]["bill_id"].'
</div>
<div class="col-md-4">
  <b>Supplier Name : </b>'. $bill[0]["supplier_name"] .'
</div>
<div class="col-md-4">
  <b>Invoice Number : </b>'. $bill[0]["invoice_no"].'</div>
<div class="col-md-4">
  <b>Receive Date : </b>'. $bill[0]["bill_date"].'
</div>

</div>
<style>
    table .title {
        font-style: italic small-caps bold 12px/30px Georgia, serif;
    }
    .border-b {
        border-bottom: 1px solid #eeee;
       
    }
</style>
<table width="100%" class="table_details"  cellspacing="0" cellpadding="4" >
                <tr class="top-bottom-line" style="border:1px solid black">
                  <td class="text-spacing"><b>No</b></td>
                  <td><b>Item Name</b></td>
                  <td><b>Batch No.</b></td>
                  <td><b>Expiry Date</b></td>
                  <td><b>Quantity</b></td>
                  <td><b>Extra Amount</b></td>
                  <td><b>Unit Amount</b></td>
                  <td><b>Unit Type</b></td>
                  <td><b>Total Amount</b></td>
                </tr>
                   ';
                
                   foreach ($result as $value) {
                    $tbl .= '
                                <tr>
                                  <td class="text-spacing border-b">'. $ctr.'</td>
                                  <td class="border-b">'.$value['drug_name'].'</td>
                                  <td class="border-b">'. $value['batch'] .'</td>
                                  <td class="border-b">'. $value['x_date'] .'</td>
                                  <td class="border-b">'. $value['qty'] .'</td>
                                  <td class="border-b">'. $value['bonus'] .'</td>
                                  <td class="border-b">'. $value['cost'] .'</td>
                                  <td class="border-b">'. $value['unit_type'].'</td>
                                  <td class="text-right border-b">'. number_format($value['qty']*$value['cost'],2).'</td>
                                </tr>';
                
                    $grand_total += $value['qty']*$value['cost'];
                    $ctr++;
                }
                
                $tbl .= '
             
                <tr>
                  <td colspan="7"></td>
                  <td class="text-right"><b>Total:</b></td>
                  <td class="border-b text-right">'. number_format($grand_total,2).' QAR</td>
                </tr>
                <tr>
                  <td colspan="7"></td>
                  <td class="text-right"><b>Discount:</b></td>
                  <td class="text-right border-b">'. number_format($discount,2).' QAR</td>
                </tr>
                <tr>
                  <td colspan="7"></td>
                  <td class="text-right"><b>Grand Total:</b></td>
                  <td class="border-b text-right">'. number_format($grand_total,2).' QAR</td>
                </tr>
                <tr>
                  <td colspan="4">&nbsp;</td>
                </tr>
                <tr>
                  <td colspan="7" class="details">In Words: 
                  <?php
                  $tot = explode(".",$grand_total);
                  if(isset($tot[1])){
                    echo convert_number_to_words($grand_total)." Dirhams";
                  }else{
                    echo convert_number_to_words($grand_total)." Qatari Riyals And Zero Dirhams";
                  }
                  ?>
                  </td>
                </tr>
              </table>
';
$content = str_replace('{{_INVOICE_CONTENT_}}',$tbl,$invoice_template);

$pdf->writeHTML($content, true, false, false, false, '');
// ---------------------------------------------------------

//Close and output PDF document
$pdf->Output('example_018.pdf', 'I');

//--------------------------------------======================+
// END OF FILE
//--------------------------------------======================+
