<div class="row">
            <div class="col-md-12">
              <div class="panel panel-info">
                <div class="panel-heading">
                  <h4 class="panel-title">Expiring Items</h4>
                </div>
                <form  method="post" id="supplier_report">
                  <div class="panel-body">
                    <div class="row">
                      <div class="col-md-4">
                        <div class="form-group">
                          <label>Select Status</label>
                          <select class="form-control" id="status">
						  <option value="-1">All</option>
                          <option value="1">Expired</option>
                          <option value="2">Expiring</option>
                            
                          </select>
                        </div>
						</div>
						
                     
                    </div>
                    
                  
                  </div>
                </form>
              </div>
            </div>

</div>
<div class="row mt-5" >
    <div class="col-md-12 mx-auto">
        <table id="p_report" class="table table-light table-bordered table-striped">
                        
        </table>
        </div>
</div>

<script>

     $(document).ready(function() {
		// Initialize the DataTable
		dataTable = $('#p_report').DataTable({
			dom: 'lBfrtip',
			buttons: [{
				extend: 'excel',
				title: `Drug Sale Report`
			}, {
				extend: 'print',
				autoPrint: true,
				title: `Drug Sale Report`,
				exportOptions: {
					columns: ':not(:last-child)'
				},
				customize: function(win) {
					$(win.document.body).prepend(`<?php print_header($this); ?>`);
				}
			}, ],
			'ajax': {
				'url': '<?= site_url('admin/Pharmacy/PharmacyController/expiring'); ?>',
				'type': 'POST',
				'data': function(d) {
					d.status = $('#status').val();
					
				}
			},
			'columns': [
				{
					'data': 'bill_id',
					'title': 'Bill ID'
				},
                {
					'data': 'supplier_name',
					'title': 'Supplier Name'
				},
				{
					'data': 'batch',
					'title': 'Batch Number'
				},
                
                {
					'data': 'drug_name',
					'title': 'Drug Name'
				},
				{
					'data': 'qty',
					'title': 'Quantity'
				},
				{
					'data': 'x_date',
					'title': 'Expiry Date'
				},
				{
					'data': 'diff',
					'title': 'Remaining days'
				},
				{ 
            'data': null,
            'title': 'Actions',
            'render': function(data, type, row, meta) {
                if(row.diff =="Expired"){
                    return `<button class="btn btn-dark btn-xs" data-id="${row.drug_id}" id="moveExpirybtn" >Move To Expired</button>`;
                }else{
                    return null;
                }
               
            }
        }
				
			],
			'searching': false,
			'serverSide': true,
			'pageLength': 10,
			aLengthMenu: [
				[25, 50, 100, 200, -1],
				[25, 50, 100, 200, "All"]
			],
			'pagingType': 'full_numbers',
			footer:true,
			autoWidth: false

		});



		$('#status ').on('change', function() {
			dataTable.ajax.reload();
		});
      
       
        $(document).on('click','#moveExpirybtn',function(){
            var id = $(this).data('id');
            confirmGeneral(function(){
                $.ajax({
                    url : "<?php echo base_url(); ?>index.php/admin/Pharmacy/PharmacyController/moveExpired/" +id,
                    type: "POST",
                    dataType: "JSON",
                    success: function(data)
                    {
                        //if success reload ajax table
                        // $('#modal_form').modal('hide');
                        dataTable.ajax.reload()
                        successNotification('Item Moved To Expired Inventory');
                    },
                    error: function (jqXHR, textStatus, errorThrown)
                    {
                        alert('Error deleting data');
                    }
                });
            });
        })

	});


</script>