<!DOCTYPE html>
<html>

<head>
  <meta charset="UTF-8">
  <title> Payments List </title>
  <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>

  <!--image crop-->
  <link href="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.css" rel="stylesheet" type="text/css" />
  <script src="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.js"></script>


  <link href="<?php echo base_url('js/Services/Pharmacy/lib/css/jquery.dataTables.min.css'); ?>" rel="stylesheet">
  <link href="<?php echo base_url('js/Services/Pharmacy/lib/css/buttons.dataTables.min.css'); ?>" rel="stylesheet">
  <link href="<?php echo base_url('js/Services/Pharmacy/lib/css/select.dataTables.min.css'); ?>" rel="stylesheet">
  <link href="<?php echo base_url('js/Services/Pharmacy/lib/css/editor.dataTables.min.css'); ?>" rel="stylesheet">

  <?php require_once(APPPATH . "views/admin/header.php"); ?>
  <style>
    .small-box {
			text-decoration: none;
			color: #444444;
      transition-timing-function: ease-in-out;
      cursor: pointer;
		}

    .small-box:hover {
			text-decoration: none;
			color: #084a6ad9;
		}
    
    .small-box {
      box-shadow: 0 1px 11px 0px rgba(0, 0, 0, 0.1) !important;
    }

    .inner{
      height: 120px;
    }

    .dashboard_icon{
      color:#084a6a;
      font-size: 50px;
    }

    .DTED_Lightbox_Content{
      border: none!important;
    }

    .DTED_Lightbox_Content .DTE .DTE_Header{
      background-color: #084a6a!important;
      color: white;
      height: 58px!important;
    }
    .DTED_Lightbox_Content .DTE .DTE_Footer{
      background-color: none!important;
    }
  </style>
</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
  <!-- Site wrapper -->


  <!-- Header Navbar: style can be found in header.less -->
  <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

  <!-- =============================================== -->

  <!-- Left side column. contains the sidebar -->
  <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

  <!-- =============================================== -->

  <!-- Right side column. Contains the navbar and content of the page -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    
    <section class="content-header">
            <h1><a href="<?php echo base_url('index.php/admin/Pharmacy/PharmacyController') ?>" class="btn btn-sm btn-dark"><i class="fa fa-angle-left"></i> Back</a>
                &nbsp;<strong>Pharmacy </strong><small>- Add/Edit Items</small>
            </h1>
            <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
        
        </section>

      <section class="content">
        <!--buttons-->


        <!--//buttons-->

        <div class="box box-info">
            <div class="row">
                <div class="col-md-6 p-3">
                <form method="post" action="<?php echo site_url('admin/Pharmacy/PharmacyController/return_bill'); ?>">
                    <div class="form-group">
                        <input type="text" placeholder="Search Bill" name="search" id="bill_choose"  class="form-control ui-autocomplete-input" />
                        <button type="submit" class="btn btn-dark mt-3"><i class="ri-search-line"> </i> Search </button>
                    </div>
                </form>
                </div>
            </div>
        </div>
        <div class="box box-info ">
        <?php if ($result) { ?>
                            <div class="panel-body" style="background-color:#fff;">
                                <div class="row col-lg-12">
                                    <div class="col-md-3">Bill No.: <p id="bill_id"><?php echo $bill_id; ?></p></div>
                                    <div class="col-md-3">Bill Date.: <p id="bill_date"><?php echo $bill_date; ?></p></div>
                                    <div class="col-md-3">Payment: <p id="payment"><?php echo $payment; ?></p></div>
                                    <div class="col-md-3">Patient Type: <p id="patient"><?php echo $patient; ?></p></div>
                                </div>

                                <div class="table-responsive">

                                    <table class="table table-striped table-bordered table-hover" id="dataTables-employee">
                                        <thead>
                                            <tr>
                                                <th>No</th>
                                                <th>Item Name</th>
                                                <th>Batch No.#</th>
                                                <th>Quantity</th>
                                                <th>Return Quantity</th>
                                                <th>Sell Price</th>
                                                <th>Total Amount</th>
                                            </tr>
                                        </thead>
                                        <tbody id="tbody">
                                            <?php
                                            $x = 0;
                                            foreach ($bill_items as $value) {
                                                $loose_active = $this->ConfigurationRetriveModel->get_row_data('sh_drugs', 'drug_id', $value['item_id']);
                                                $x++;
                                                echo '<tr id="row' . $x . '">
                                                <td><input name="item" class="form-control" value="' . $value['item_id'] . '-' . $value['batch'] . '" type="checkbox"></td>
                                                <td>' . $value['item_name'] . '</td>
                                                <td>' . $value['batch'] . '</td>
                                                <td >' . $value['qty'] . '</td>
                                                 <td ><input type="text" class="form-control return_qty" value="0">';
                                                  if ($loose_active->loose_active !=0) {
                                                    echo "<strong class='text-danger'>Must enter total loose amount</strong></td>";
                                                  }
                                                echo '<td>' . $value['price'] . '</td>
                                                <td>' . ($value['price'] * $value['qty']) . '</td>
                                            </tr>';
                                            }
                                            ?>
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <th colspan="6">Net Total:</th>
                                                <th><?php echo $bill_amount; ?></th>
                                            </tr>                                            
                                            <tr color="red">
                                                <th colspan="6">Amount to Pay Back:</th>
                                                <th id="total">0</th>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        <?php } ?>
        </div>
        <div>
                        <?php if ($result && $payment != 'Not Paid') { ?>
                            <div class="col-sm-3">
                                <form id="refund" method="post" action="<?php echo site_url('admin/Pharmacy/PharmacyController/return_bill'); ?>">
                                    <button id="pay_back" type="submit" disabled="true" class="btn btn-success">Pay Back</button>                                    
                                </form>
                            </div>
                        <?php } ?>
                    </div>

          <div class="box-body d-none">
            
          <table id="example" class="display responsive" cellspacing="0" width="100%">
                            <thead>
                                <tr>
                                    <th>Drug Name</th>
                                    <th>Category</th>
                                    <th>Location</th>
                                    <th>Brand</th>
                                    <th>Barcode</th>
                                    <th>OB</th>
                                    <th>Current Quantity</th>
                                    <th>Sell Price</th>
                                    <th>Min. Avalability</th>
                                    <th>Action</th>
                                    <th>Max Expiration</th>
                                    <th>Status</th>
                                    <th>Drug Code</th>
                                </tr>
                            </thead>
                        </table>

            
          </div>
          <!-- /.box-body -->
        </div>

      </section>


    </form>

  </div>

  <!-- ./wrapper -->


  <?php require_once(APPPATH . "views/admin/footer.php"); ?>
	<script src="<?php echo base_url('js/Services/Pharmacy/pos.js') ?>" type="text/javascript"></script>
    <script src="<?php echo base_url('js/Services/Pharmacy/posBill.js') ?>" type="text/javascript"></script>


</body>
<script>
    function delete_bill(id)
        {
            confirmDelete(function(){
                $.ajax({
                    url : "<?php echo base_url(); ?>index.php/admin/Pharmacy/PharmacyController/ajax_delete_bill/" +id,
                    type: "POST",
                    dataType: "JSON",
                    success: function(data)
                    {
                        //if success reload ajax table
                        // $('#modal_form').modal('hide');
                        reload_table();
                        successNotification('Purchase Statement Deleted');
                    },
                    error: function (jqXHR, textStatus, errorThrown)
                    {
                        alert('Error deleting data');
                    }
                });
            })
            
                // ajax delete data to database
              

            
        }
        function update_total() {
            var net_total = Number(0);
            $("#tbody tr").each(function (i) {
                var $tds = $(this).find('td'),
                        qty = Number($tds.eq(4).find('input').val()),
                        price = Number($tds.eq(5).text()).toFixed(2);
                net_total += (qty * price);
            });
            $("#total").text(net_total);
            if (net_total !== 0) {
                $("#pay_back").prop("disabled", false);
            } else {
                $("#pay_back").prop("disabled", true);
            }
        }
        $(".return_qty").on("change", function () {
            var tds = $(this).closest('td'),
                    qty_td = tds.prev('td'),
                    batch_td = qty_td.prev('td'),
                    item_td = batch_td.prev('td'),
                    checkbox_td = item_td.prev('td'),
                    checkbox = checkbox_td.find('input'),
                    qty = Number(qty_td.text()),
                    ret = $(this).val();
            if (ret.match(/\d?/) && Number(ret) <= qty && Number(ret) > 0) {
                checkbox.prop('checked', true);
                update_total();
            } else {
                checkbox.prop('checked', false);
                $(this).val('0');
                update_total();
            }
        });
        $("#refund").submit(function () {
            var bill_id = $("<input>").attr({"type": "hidden", "name": "bill"}).val($("#bill_id").html()),
                    amount = $("<input>").attr({"type": "hidden", "name": "amount"}).val($("#total").text());
            $("#tbody tr").each(function (i) {
                var $tds = $(this).find('td'),
                        checkbox = $tds.eq(0).find('input'),
                        qty = $tds.eq(4).find('input').val(),
                        price = $tds.eq(5).text();
                if (checkbox.prop('checked')) {
                    var id_batch = checkbox.val(),
                            id_batch_array = id_batch.split("-"),
                            id = id_batch_array[0],
                            batch = id_batch_array[1],
                            item_input = $("<input>").attr({"type": "hidden", "name": "items[]"}).val(id),
                            batch_input = $("<input>").attr({"type": "hidden", "name": "batch[]"}).val(batch),
                            quantity_input = $("<input>").attr({"type": "hidden", "name": "quantity[]"}).val(qty),
                            sell_price = $("<input>").attr({"type": "hidden", "name": "price[]"}).val(price);
                    $('#refund').append(item_input);
                    $('#refund').append(batch_input);
                    $('#refund').append(quantity_input);
                    $('#refund').append(sell_price);
                }
            });
            $('#refund').append(bill_id);
            $('#refund').append(amount);
            return true;
        });
    </script>

</html>