<!DOCTYPE html>
<html>

<head>
	<meta charset="UTF-8">
	<meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
	<?php require_once(APPPATH . "views/admin/header.php"); ?>
</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
	<!-- Site wrapper -->


	<!-- Header Navbar: style can be found in header.less -->
	<?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

	<!-- =============================================== -->

	<!-- Left side column. contains the sidebar -->
	<?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

	<!-- =============================================== -->

	<!-- Right side column. Contains the navbar and content of the page -->
	<div class="content-wrapper">
		<!-- Content Header (Page header) -->
		<section class="content-header">
			<h1>
				<strong>Daily Collecion Report</strong>
			</h1>
			<?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
		</section>
		<!-- Main content -->
		<section class="content">
			<div class="row">
				<div class="col-md-12">
					<div class="box box-info">
						<div class="box-header with-border">
							<h3 class="box-title font-weight-bold">Daily Collection</h3>
						</div>

						<div class="box-body">
							<div class="panel-group" id="accordion">

								<div class="d-block mb-3">
									<div class="row" id="filters">
									    <div class="col-12 col-md-3">
											<div class="form-group">
												<label for="receptionist">Sales User</label>
												<select name="receptionist" id="receptionist">
													<option value="0">All</option>
													<?php foreach ($sales_persons as $index => $sales_person) : ?>
														<option value="<?= $sales_person->user_Id; ?>"><?= $sales_person->full_name; ?></option>
													<?php endforeach; ?>
												</select>
											</div>
										</div>
										<div class="col-12 col-md-3">
											<div class="form-group">
												<label for="doctor">Doctor</label>
												<select name="doctor" id="doctor">
													<option value="0">All</option>
													<?php foreach ($doctors as $index => $doctor) : ?>
														<option value="<?= $doctor->user_Id; ?>"><?= $doctor->full_name; ?></option>
													<?php endforeach; ?>
												</select>
											</div>
										</div>
										<div class="col-12 col-md-3">
											<div class="form-group">
												<label for="date">Date</label>
												<input type="date" class="form-control" name="date" id="date" placeholder="Date" value="<?php echo date('Y-m-d') ?>">
											</div>
										</div>
										<div class="col-12 col-md-3 hide">
											<div class="form-group">
												<label for="date_to">Date To</label>
												<input type="date" class="form-control" name="date_to" id="date_to" placeholder="Date To" value="<?php echo date('Y-m-d') ?>">
											</div>
										</div>
									</div>

								</div>

								<table id="price_list" class="table table-light table-bordered table-striped">
								</table>

							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
	</div><!-- /.content-wrapper -->
	<!-- ./wrapper -->
	<?php require_once(APPPATH . "views/admin/footer.php"); ?>
</body>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>

</html>

<script type="text/javascript">
	$("#year_std").datepicker({
		minViewMode: 2,
		autoclose: true,
		format: 'yyyy'
	}).datepicker('update', '<?php echo date('Y'); ?>');
	var dataTable = undefined;
	$(document).ready(function() {
		// Initialize the DataTable
		dataTable = $('#price_list').DataTable({
			dom: 'lBfrtip',
			buttons: [{
				extend: 'excel',
				title: `Daily Collection Report`
			}, {
				extend: 'print',
				autoPrint: true,
				title: `Daily Collection Report`,
				customize: function(win) {
					$(win.document.body).prepend(`<?php echo print_header($this); ?>`);
					var filterData = '<div class="filter-data d-flex ml-3">';

					$('#filters .form-group').each(function() {
						var label = $(this).find('label').text().trim();
						var value;
						var inputElement = $(this).find('select, input');

						if (inputElement.is('select')) {
							value = inputElement.find('option:selected').text();
						} else if (inputElement.is('input[type="date"]')) {
							value = inputElement.val();
						}


						filterData += '<p class="ml-2 mr-2"><strong>' + label + ':</strong> ' + value + '</p>';
					});

					filterData += '</div>';

					$(win.document.body).find('h1').after(filterData);

					$(win.document.body).find('h1').css({
						'font-size': '20px',
						'text-align': 'center',
						"font-weight": "700"
					});

					$(win.document.body).find('table').css({
						'margin-left': '20px',
						'margin-right': '10px',
						"width": "95%",
						"font-size": "12px",
						'table-layout': 'auto'
					});
					$(win.document.body).find('table th').css({
						"font-size": "12px",
					});

				}

			}, ],
			'ajax': {
				'url': '<?= site_url('admin/Reports/ReportsController/dailyCollectionList'); ?>',
				'type': 'GET',
				'data': function(d) {
					d.receptionist = $('#receptionist').val();
					d.date = $('#date').val();
					d.date_to = $('#date_to').val();
					d.doctor = $('#doctor').val();
				}
			},
			'columns': [{
					'data': 'patient_payment_id',
					'title': 'Receipt No.'
				},
				{
					'data': 'treatment_no',
					'title': 'Invoice No.'
				},
				{
					'data': 'patient_id',
					'title': 'File No.'
				},
				{
					'data': 'pay_date',
					'title': 'Date'
				},
				{
					'data': 'full_name',
					'title': 'Doctor'
				},
				{
					'data': 'patient_name',
					'title': 'Patient'
				},
				{
					'data': 'procedure_ids',
					'title': 'Procedure&nbsp;Code'
				},
				{
					'data': 'insurance_name',
					'title': 'Insurance'
				},
				{
					'data': 'type_name',
					'title': 'Payment Type'
				},
				{
					'data': 'gross',
					'title': 'Gross Amount'
				},
				{
					'data': 'all_discount',
					'title': 'Discount'
				},
				{
					'data': 'net_total',
					'title': 'Net Total'
				},
				{
					'data': 'total_paid',
					'title': 'Paid Amount'
				},
				{
					'data': 'insurance_amount',
					'title': 'Net Claim'
				},
				{
					'data': 'cashier',
					'title': 'Cashier'
				},
			],
			'searching': false,
			'serverSide': false,
			'paging':false

		});



		$('#receptionist, #date, #date_to, #doctor').on('change', function() {
			dataTable.ajax.reload();
		});
	});
</script>

<script>
	var settings = {};
	new TomSelect('#receptionist', settings);
	new TomSelect('#doctor', settings);

	
</script>