<!DOCTYPE html>
<html>

<head>
	<meta charset="UTF-8">
	<meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
	<?php require_once(APPPATH . "views/admin/header.php"); ?>

</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
	<!-- Site wrapper -->


	<!-- Header Navbar: style can be found in header.less -->
	<?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

	<!-- =============================================== -->

	<!-- Left side column. contains the sidebar -->
	<?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

	<!-- =============================================== -->

	<!-- Right side column. Contains the navbar and content of the page -->
	<div class="content-wrapper">
		<!-- Content Header (Page header) -->
		<section class="content-header">
			<h1>
				<strong>Sales Report</strong>
			</h1>
			<?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
		</section>
		<!-- Main content -->
		<section class="content">
			<div class="row">
				<div class="col-md-12">
					<div class="box box-info">
						<div class="box-header with-border">
							<h3 class="box-title font-weight-bold">Sales Income</h3>
						</div>

						<div class="box-body">
							<div class="panel-group" id="accordion">

								<div class="d-block mb-3">
									<div class="row" id="filters">
										<div class="col-12 col-md-3">
											<div class="form-group">
												<label for="payment_type">Payment Type</label>
												<select name="payment_type" id="payment_type">
													<option value="-1">All</option>
													<option value="0">Insurance</option>
													<?php foreach ($payment_types as $index => $type) : ?>
														<option value="<?= $type->type_id; ?>"><?= $type->type_name; ?></option>
													<?php endforeach; ?>
												</select>
											</div>
										</div>
										<div class="col-12 col-md-3">
											<div class="form-group">
												<label for="date_from">Date From</label>
												<input type="date" class="form-control" name="date_from" id="date_from" placeholder="Date From" value="<?php echo date('Y-m-d') ?>">
											</div>
										</div>
										<div class="col-12 col-md-3">
											<div class="form-group">
												<label for="date_to">Date To</label>
												<input type="date" class="form-control" name="date_to" id="date_to" placeholder="Date To" value="<?php echo date('Y-m-d') ?>">
											</div>
										</div>
									</div>
								</div>

								<table id="price_list" class="table table-light table-bordered table-striped"></table>

							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
	</div><!-- /.content-wrapper -->
	<!-- ./wrapper -->
	<?php require_once(APPPATH . "views/admin/footer.php"); ?>
</body>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>

</html>

<script type="text/javascript">
	$(document).ready(function() {
		// Initialize the DataTable
		var dataTable = $('#price_list').DataTable({
			dom: 'Blfrtip',
			buttons: [{
				extend: 'excel',
				title: `Sales Report`
			}, {
				extend: 'print',
				autoPrint: true,
				title: `Sales Report`,
				customize: function(win) {
					$(win.document.body).prepend(`<?php echo print_header($this); ?>`);
					var filterData = '<div class="filter-data d-flex ml-3">';

					$('#filters .form-group').each(function() {
						var label = $(this).find('label').text().trim();
						var value;
						var inputElement = $(this).find('select, input');

						if (inputElement.is('select')) {
							value = inputElement.find('option:selected').text();
						} else if (inputElement.is('input[type="date"]')) {
							value = inputElement.val();
						}


						filterData += '<p class="ml-2 mr-2"><strong>' + label + ':</strong> ' + value + '</p>';
					});

					filterData += '</div>';

					$(win.document.body).find('h1').after(filterData);

					$(win.document.body).find('h1').css({
						'font-size': '20px',
						'text-align': 'center',
						"font-weight": "700"
					});

					$(win.document.body).find('table').css({
						'margin-left': '20px',
						'margin-right': '10px',
						"width": "95%",
						"font-size": "12px",
						'table-layout': 'auto'
					});
					$(win.document.body).find('table th').css({
						"font-size": "12px",
					});
				}

			}, ],
			'ajax': {
				'url': '<?= site_url('admin/Reports/ReportsController/SalesList'); ?>',
				'type': 'GET',
				'data': function(d) {
					d.payment_type = $('#payment_type').val();
					d.date_from = $('#date_from').val();
					d.date_to = $('#date_to').val();
				}
			},
			'columns': [{
					'data': 'treatement_payment_id',
					'title': 'Invoice No'
				},
				{
					'data': 'patient_payment_ids',
					'title': 'Recipts'
				},
				{
					'data': 'patient_id',
					'title': 'File No'
				},
				{
					'data': 'patient_name',
					'title': 'Patient'
				},
				{
					'data': null,
					'title': 'Payment Type',
					'render': function(data, type, row, meta) {
						if (row['pay_type'] == 0) {
							return 'Insurance'
						} else if (row['pay_type'] > 0) {
							let str = row['payment_type'];

							let paymentTypes = str.split(' & ');

							let uniquePaymentTypes = paymentTypes.filter((value, index, self) => {
								return self.indexOf(value) === index;
							});

							let uniqueStr = uniquePaymentTypes.join(' & ');
							return uniqueStr;

						} else if (row['pay_type'] == -2) {
							return null;
						} else {
							return 'N/A';
						}
					}
				},
				{
					'data': 'procedure_ids',
					'title': 'Treatment Name'
				},
				{
					'data': 'invoice_amount',
					'title': 'Amount'
				},
				{
					'data': 'all_discount',
					'title': 'Discount'
				},
				{
					'data': 'net_total',
					'title': 'Net Total'
				},
				{
					'data': 'paid_amount',
					'title': 'Paid Amount'
				},
				{
					'data': 'treat_date',
					'title': 'Treatment Date'
				},
			],
			'searching': false,
			'serverSide': true,
			'paging': false
		});

		$('#insurance_type, #payment_type, #date_from, #date_to').on('keyup change', function() {
			dataTable.ajax.reload();

			// var sumColumn = dataTable.column(1).data().reduce(function(a, b) {
			// 	return a + b;
			// }, 0);

			// dataTable.row.add(['Total: ', sumColumn]).draw();
		});
	});
</script>
<script>
	var settings = {};
	new TomSelect('#payment_type', settings);
</script>