<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
    <?php require_once(APPPATH . "views/admin/header.php"); ?>

    <style>
        .dataTables_info {
            display: none !important;
        }
    </style>
</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
    <!-- Site wrapper -->


    <!-- Header Navbar: style can be found in header.less -->
    <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

    <!-- =============================================== -->

    <!-- Left side column. contains the sidebar -->
    <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

    <!-- =============================================== -->

    <!-- Right side column. Contains the navbar and content of the page -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1>
                <strong>Treatment Wise Report</strong>
            </h1>
            <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-md-12">
                    <div class="box box-info">
                        <div class="box-header with-border">
                            <h3 class="box-title"></h3>
                        </div>

                        <div class="box-body">
                            <div class="panel-group" id="accordion">

                                <div class="d-block mb-3">
                                    <div class="row" id="filters">

                                        <div class="col-12 col-md-2">
                                            <div class="form-group">
                                                <label for="insurance_type">Insurance Type</label>
                                                <select name="insurance_type" id="insurance_type">
                                                   <option value="0">All</option>
                                                    <?php foreach ($insurance_types as $index => $type) : ?>
                                                        <option value="<?= $type->insurance_type_id; ?>"><?= $type->insurance_name; ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-12 col-md-2">
                                            <div class="form-group">
                                                <label for="department">Department</label>
                                                <select name="department" id="department">
                                                    <option value="0">All</option>
                                                    <?php foreach ($departments as $index => $department) : ?>
                                                        <option value="<?= $department->department_id; ?>"><?= $department->module_name; ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-12 col-md-2">
                                            <div class="form-group">
                                                <label for="procedure">Procedure</label>
                                                <select name="procedure" id="procedure">
                                                    <option value="0">All</option>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-12 col-md-2">
                                            <div class="form-group">
                                                <label for="payment_type">Payment Type</label>
                                                <select name="payment_type" id="payment_type">
                                                    <option value="0">All</option>
                                                    <?php foreach ($payment_types as $index => $type) : ?>
                                                        <option value="<?= $type['type_id']; ?>"><?= $type['type_name']; ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-12 col-md-2">
                                            <div class="form-group">
                                                <label for="date_from">Date From</label>
                                                <input type="date" class="form-control" value="<?php echo date('Y-m-d') ?>" name="date_from" id="date_from" placeholder="Date From">
                                            </div>
                                        </div>

                                        <div class="col-12 col-md-2">
                                            <div class="form-group">
                                                <label for="date_to">Date To</label>
                                                <input type="date" class="form-control" value="<?php echo date('Y-m-d') ?>" name="date_to" id="date_to" placeholder="Date To">
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <table id="treatment-wise-report" class="table table-light table-bordered table-striped"></table>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div><!-- /.content-wrapper -->
    <!-- ./wrapper -->
    <?php require_once(APPPATH . "views/admin/footer.php"); ?>
</body>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>

</html>

<script type="text/javascript">
    $(document).ready(function() {
        // Initialize the DataTable
        var dataTable = $('#treatment-wise-report').DataTable({
            dom: 'lBfrtip',
            buttons: [{
                extend: 'excel',
                title: `Treatment Wise Report`
            }, {
                extend: 'print',
                autoPrint: true,
                title: `Treatment Wise Report`,
                customize: function(win) {
                    $(win.document.body).prepend(`<?php echo print_header($this); ?>`);
                    var filterData = '<div class="filter-data d-flex ml-3">';

                    $('#filters .form-group').each(function() {
                        var label = $(this).find('label').text().trim();
                        var value;
                        var inputElement = $(this).find('select, input');

                        if (inputElement.is('select')) {
                            value = inputElement.find('option:selected').text();
                        } else if (inputElement.is('input[type="date"]')) {
                            value = inputElement.val();
                        }


                        filterData += '<p class="ml-2 mr-2"><strong>' + label + ':</strong> ' + value + '</p>';
                    });

                    filterData += '</div>';

                    $(win.document.body).find('h1').after(filterData);

                    $(win.document.body).find('h1').css({
                        'font-size': '20px',
                        'text-align': 'center',
                        "font-weight": "700"
                    });

                    $(win.document.body).find('table').css({
                        'margin-left': '20px',
                        'margin-right': '10px',
                        "width": "95%",
                        "font-size": "12px",
                        'table-layout': 'auto'
                    });
                    $(win.document.body).find('table th').css({
                        "font-size": "12px",
                    });
                }

            }, ],
            'ajax': {
                'url': '<?= site_url('admin/Reports/ReportsController/getTreatmentWiseReport'); ?>',
                'type': 'GET',
                'data': function(d) {
                    d.insurance_id = $('#insurance_type').val();
                    d.procedure = $('#procedure').val();
                    d.payment_type = $('#payment_type').val();
                    d.date_from = $('#date_from').val();
                    d.date_to = $('#date_to').val();
                    d.department_id = $('#department').val();
                }
            },
            'columns': [{
                    'data': null,
                    'title': '#',
                    'orderable': false,
                    'searchable': false,
                    'render': function(data, type, row, meta) {
                        return meta.row + 1;
                    }
                },
                {
                    'data': 'treatement_payment_id',
                    'title': 'Invoice No'
                },
                {
                    'data': 'department_name',
                    'title': 'Department'
                },
                {
                    'data': 'patient_name',
                    'title': 'Patinet'
                },
                {
                    'data': 'treat_date',
                    'title': 'Treatment Date'
                },
                    {
    'data': null,
    'title': 'Procedure',
    'render': function(data, type, row, meta) {
        // Split the concatenated values by comma
        var ids = row.insurance_price_ids ? row.insurance_price_ids.split(',') : [];
        var names = row.treatment_names ? row.treatment_names.split(',') : [];
        
        // Combine the ids and names into a single string
        var combined = '';
        for (var i = 0; i < ids.length; i++) {
            combined += ids[i] + ' | ' + (names[i] || '') + '<br>';
        }

        // Return the combined result
        return combined;
    }
},
                {
                    'data': null,
                    'title': 'Payment Type',
                    'render': function(data, type, row, meta) {
                        console.log(row, data);
                        return row.type_name == null ? 'Insurance' : row.type_name
                    }
                },
                {
                    'data': null,
                    'title': 'Paid',
                    'render': function(data, type, row, meta) {
                        console.log(row, data);
                        return row.type_name == null ? row.insurance_amount : row.cash
                    }
                },
                {
                    'data': 'total',
                    'title': 'Price'
                },
                {
                    'data': 'doctor',
                    'title': 'Doctor'
                }
            ],
            'searching': false,
            'serverSide': true,
			'paging': false
        });

        $('#insurance_type, #procedure, #payment_type, #date_from, #date_to, #department').on('keyup change', function() {
            dataTable.ajax.reload();
        });

    });


    var settings = {};
    var insurance_type = new TomSelect('#insurance_type', settings);
    var procedure = new TomSelect('#procedure', settings);
    var payment_type = new TomSelect('#payment_type', settings);
    var departments = new TomSelect('#department', settings);

    $('#insurance_type, #department').on('change', function(e) {

        $.ajax({
            url: "<?= base_url('index.php/admin/Reports/ReportsController/getInsurancePrices'); ?>",
            method: "POST",
            dataType: "json",
            data: {
                insurance_id: $('#insurance_type').val(),
                department_id: $('#department').val()
            },
            success: function(response) {

                if (procedure) {
                    procedure.destroy();
                }

                const treatments = response.data;
                $('#procedure').empty();
                $('#procedure').append('<option value="0">All</option>');

                for (let t of treatments) {
                    console.log(t);
                    $('#procedure').append(`<option value="${t.id}">${t.id} | ${t.treatment_name} | ${t.treatment_name_ar}</option>`);
                }

                procedure = new TomSelect('#procedure', settings);
            },
            error: function(xhr, status, error) {
                console.error(xhr, status, error);
            }
        });
    });
</script>