<!DOCTYPE html>
<html>
    <head>
        <meta charset="UTF-8">
        <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
        <?php require_once(APPPATH . "views/admin/header.php"); ?>
    </head>
    <body class="<?php echo $this->config->item('theme'); ?> fixed">
        <!-- Site wrapper -->


        <!-- Header Navbar: style can be found in header.less -->
        <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

        <!-- =============================================== -->

        <!-- Left side column. contains the sidebar -->
        <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

        <!-- =============================================== -->

        <!-- Right side column. Contains the navbar and content of the page -->
        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section class="content-header">
                <h1>
                    Company
                    <small>Create/Edit Company</small>
                </h1>
                <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
            </section>

            <!-- Main content -->
            <section class="content">
                <div class="row">
                    <div class="col-xs-12">
                        <div class="box margin-bottom-5px box-warning">
                            <div class="box-body">
                                <div class="row">
                                    <div class="col-md-10"></div>
                                    <div class="col-md-2">
                                        <a href="<?php echo base_url('index.php/admin/Setting/Company/CompanyController/CreateNew') ?>" class="btn btn-block btn-social <?php echo $this->config->item('add_new'); ?>">
                                            <i class="fa fa-plus"></i> New item
                                        </a>
                                    </div>
                                </div>	
                            </div><!-- /.box-body -->
                        </div>
                        <div class="box box-info">
                            <div class="box-body">
                                <table id="search_grid" class="table table-bordered table-striped">
                                    <thead>
                                        <tr class="<?php echo $this->config->item('grid_header'); ?>">
                                            <th class="hide">#</th>
                                            <th>Company name</th>
                                            <th>Mobile no</th>
                                            <th>Phone no</th>
                                            <th>Email</th>
                                            <th class="col_10"></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                           <?php foreach ($List->result() as $row) { ?>
                                            <tr>
                                                <td class="hide"><?php echo $row->company_id; ?></td>
                                                <td><?php echo $row->company_name; ?></td>
                                                <td><?php echo $row->mobile_no; ?></td>
                                                <td><?php echo $row->phone_no; ?></td>
                                                <td><?php echo $row->email; ?></td>
                                                <td class="col_10">

                                                    <a class="btn btn-social-icon btn-instagram btn-grid" 
                                                       data-toggle="tooltip" data-placement="bottom" 
                                                       href="<?php echo site_url('admin/Setting/Company/CompanyController/Load/') . $row->company_id; ?>"
                                                       title="Edit"><i class="fa  fa-edit"></i></a>
                                                </td>

                                            </tr>
                                            <?php } ?>
                                    </tbody>

                                </table>
                            </div><!-- /.box-body -->
                        </div><!-- /.box -->
                    </div><!-- /.col -->
                </div><!-- /.row -->
            </section>

        </div><!-- /.content-wrapper -->
        <!-- ./wrapper -->
        <?php require_once(APPPATH . "views/admin/footer.php"); ?>

    </body>
</html>


