<div class="row">
    <div class="panel panel-default">
        <div class="panel-body">
            <table class="table table-striped table-bordered table-hover" id='table-messages'>
                <thead>
                    <th>Template Name</th>
                    <th>Actions</th>
                </thead>
                <tbody>
                    <?php foreach ($templates as $value) { ?>
                        <tr>
                            <td id="<?= $value['id'] ?>_title"><?= ucwords(str_replace('_', ' ', $value['name'])) ?>
                                <input type='hidden' id="<?= $value['id'] ?>_message" value='<?= $value['message'] ?>'>
                                <input type='hidden' id="<?= $value['id'] ?>_message_ar" value='<?= $value['message_ar'] ?>'>
                            </td>
                            <td>
                                <button class="btn btn-primary btn-primary btn-xs" onclick="msg_edit(<?php echo $value['id'] ?>);">
                                    Edit
                                </button>
                            </td>
                        </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<div class="modal fade" id="modal_message" tabindex="-1" role="dialog" aria-labelledby="modal_message">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>Modify Template</h4>
            </div>
            <div class="modal-body">
                <form action="<?php $this->load->helper('url');
                                echo site_url('configuration/save_message'); ?>" method="post">

                    <div class="form-group">
                        <label for="popup_tre_code" id="app_date">Template Name</label>
                        <input type="text" class="form-control" readonly name="popup_temp_name" id="popup_temp_name">
                        <input type="hidden" class="form-control" name="popup_temp_id" id="popup_temp_id">
                    </div>

                    <div class="form-group">
                        <label for="popup_tre_name" id="app_date">Message Content</label>
                        <textarea style='height: 150px;' class="form-control" name="popup_msg_content" id="popup_msg_content"></textarea>
                    </div>
                    <div class="form-group">
                        <label for="popup_tre_name" id="app_date">Message Content (Arabic)</label>
                        <textarea style='height: 150px;' class="form-control" dir='rtl' name="popup_msg_content_ar" id="popup_msg_content_ar"></textarea>
                    </div>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-primary">Update changes</button>
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
            </form>
        </div>
    </div>
</div>

<script>
    function msg_edit(id) {
        var title = $(' #' + id + '_title').text();
        var message = $('#' + id + '_message').val();
        var message_ar = $('#' + id + '_message_ar').val();

        $('#popup_temp_name').val(title);
        $('#popup_msg_content').val(message);
        $('#popup_msg_content_ar').val(message_ar);
        $('#popup_temp_id').val(id);
        $('#modal_message').modal({
            keyboard: false
        });
    }
</script>